/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;

public class CSSPanelUI
extends BasicPanelUI {
    private static final Logger LOGGER = Logger.getLogger(CSSPanelUI.class.getName());
    private static ComponentUI ui_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JPanel);
        LOGGER.entering(CSSPanelUI.class.getName(), "createUI");
        if (ui_ != null) return ui_;
        Class<CSSPanelUI> clazz = CSSPanelUI.class;
        synchronized (CSSPanelUI.class) {
            if (ui_ != null) return ui_;
            ui_ = new CSSPanelUI();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ui_;
        }
    }

    @Override
    public void installUI(JComponent component) {
        LOGGER.entering(CSSPanelUI.class.getName(), "installUI");
        super.installUI(component);
        if (component.getClientProperty("css_element") == null) {
            component.putClientProperty("css_element", "body");
        }
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        if (component.getClientProperty("css_class") != null && component.getBorder() == null) {
            component.setBorder(new CSSBorder());
            component.setOpaque(false);
        }
        BackgroundInfo info = CSS.getInfo(component);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Background.updateComponentProperties(component, info);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            Color c = info.background;
            Color cc = component.getBackground();
            if (c != null && !c.equals(cc) && (cc == null || cc instanceof UIResource)) {
                component.setBackground(c);
            }
            super.paint(g, component);
        }
    }
}

