/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.ZoomedIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import sun.swing.SwingUtilities2;

public class CSSMenuUI
extends BasicMenuUI {
    private static final Logger LOGGER = Logger.getLogger(CSSMenuUI.class.getName());
    private MouseListener mouseListener = null;
    private final JComponent component_;
    private Icon icon = null;
    private JComponent ulDropdown = new JComponent(){};
    private JComponent liDropdown = new JComponent(){};
    private JComponent ulNav = new JComponent(){};
    private BackgroundInfo info;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JMenu);
        LOGGER.entering(CSSMenuUI.class.getName(), "createUI");
        return new CSSMenuUI(component);
    }

    protected CSSMenuUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSMenuUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorder());
        component.setOpaque(false);
        UIDefaults defaults = UIManager.getDefaults();
        this.icon = new ZoomedIcon(defaults.getIcon("icon-chevron-down"));
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    JMenu menuTemp = (JMenu)mouseEvent.getSource();
                    if (!menuTemp.getPopupMenu().isShowing()) {
                        menuTemp.putClientProperty("css_hover", Boolean.TRUE);
                    }
                    menuTemp.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    JMenu menuTemp = (JMenu)mouseEvent.getSource();
                    menuTemp.putClientProperty("css_hover", Boolean.FALSE);
                    menuTemp.repaint();
                }
            };
            this.component_.addMouseListener(this.mouseListener);
        }
    }

    private void prepareComponent(JComponent component) {
        component.putClientProperty("css_element", "a");
        component.putClientProperty("css_class", "dropdown-toggle");
        component.putClientProperty("css_parent", this.liDropdown);
        this.liDropdown.putClientProperty("css_element", "li");
        this.liDropdown.putClientProperty("css_class", "dropdown");
        this.liDropdown.putClientProperty("css_parent", this.ulNav);
        this.ulNav.putClientProperty("css_element", "ul");
        this.ulNav.putClientProperty("css_class", "nav nav-pills");
        ((AbstractButton)this.component_).setHorizontalTextPosition(2);
        ((JMenu)this.component_).setIcon(this.icon);
    }

    private void prepareComponentAsMenuItem(JComponent component) {
        component.putClientProperty("css_element", "a");
        component.putClientProperty("css_parent", this.liDropdown);
        this.liDropdown.putClientProperty("css_element", "li");
        this.liDropdown.putClientProperty("css_class", "");
        this.liDropdown.putClientProperty("css_parent", this.ulDropdown);
        this.ulDropdown.putClientProperty("css_element", "ul");
        this.ulDropdown.putClientProperty("css_class", "dropdown-menu active");
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        if (component.getParent() instanceof JMenuBar) {
            ButtonModel model = ((JMenu)component).getModel();
            if (model.isArmed() || this.component_ instanceof JMenu && model.isSelected()) {
                this.liDropdown.putClientProperty("css_class", "dropdown open");
            } else {
                this.liDropdown.putClientProperty("css_class", "dropdown");
            }
        }
        if (component.getParent() instanceof JMenuBar) {
            this.prepareComponent(component);
        } else {
            this.prepareComponentAsMenuItem(component);
        }
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        ButtonModel model = ((JMenu)this.component_).getModel();
        if (this.component_.getParent() instanceof JMenuBar && (model.isArmed() || menuItem instanceof JMenu && model.isSelected())) {
            this.liDropdown.putClientProperty("css_class", "dropdown open");
        } else {
            this.liDropdown.putClientProperty("css_class", "dropdown");
        }
        this.info = CSS.getInfo(this.component_);
        Background.paint(this.info, g, 0, 0, menuWidth, menuHeight);
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            this.liDropdown.putClientProperty("css_class", "dropdown open");
        } else {
            this.liDropdown.putClientProperty("css_class", "dropdown");
        }
        this.info = CSS.getInfo(this.component_);
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)menuItem, g);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        g.setColor(this.info.foreground);
        if (!menuItem.isEnabled()) {
            Color fg = g.getColor();
            fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), fg.getAlpha() / 2);
            g.setColor(fg);
        }
        Background.addFontRenderingHints((Graphics2D)g, menuItem);
        SwingUtilities2.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        if (component.getParent() instanceof JMenuBar) {
            this.prepareComponent(component);
        } else {
            this.prepareComponentAsMenuItem(component);
        }
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

