/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import sun.swing.SwingUtilities2;

public class CSSMenuItemUI
extends BasicMenuItemUI {
    private static final Logger LOGGER = Logger.getLogger(CSSMenuItemUI.class.getName());
    private final JComponent component_;
    private JComponent li = new JComponent(){};
    private JComponent ulDropdown = new JComponent(){};
    private BackgroundInfo info_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JMenuItem);
        LOGGER.entering(CSSMenuItemUI.class.getName(), "createUI");
        return new CSSMenuItemUI(component);
    }

    protected CSSMenuItemUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        JMenuItem menuItem = (JMenuItem)component;
        component.putClientProperty("css_element", "a");
        component.putClientProperty("css_parent", this.li);
        this.li.putClientProperty("css_element", "li");
        this.li.putClientProperty("css_class", "");
        this.li.putClientProperty("css_parent", this.ulDropdown);
        this.ulDropdown.putClientProperty("css_element", "ul");
        this.ulDropdown.putClientProperty("css_class", "dropdown-menu active");
        this.ulDropdown.putClientProperty("css_parent", menuItem.getParent());
        LOGGER.entering(CSSMenuItemUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorder());
        component.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        ButtonModel model = this.menuItem.getModel();
        if (model.isArmed() || this.menuItem instanceof JMenu && model.isSelected()) {
            this.li.putClientProperty("css_class", "active");
        } else {
            this.li.putClientProperty("css_class", "");
        }
        this.info_ = CSS.getInfo(component);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Background.updateComponentProperties(component, this.info_);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, this.info_, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, this.info_.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Background.paint(this.info_, g, 0, 0, menuWidth, menuHeight);
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)menuItem, g);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        g.setColor(menuItem.getForeground());
        if (!menuItem.isEnabled()) {
            Color fg = g.getColor();
            fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), fg.getAlpha() / 2);
            g.setColor(fg);
        }
        SwingUtilities2.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

