/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalMenuBarUI;

public class CSSMenuBarUI
extends MetalMenuBarUI {
    private static final Logger LOGGER = Logger.getLogger(CSSMenuBarUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JMenuBar);
        LOGGER.entering(CSSMenuBarUI.class.getName(), "createUI");
        return new CSSMenuBarUI(component);
    }

    protected CSSMenuBarUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSMenuBarUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorder());
        component.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        BackgroundInfo info = CSS.getInfo(component);
        Background.updateComponentProperties(component, info);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

