/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorderResource;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.CSSFontIcon;
import com.ge.med.iungo.laf.CSSButtonUI;
import com.ge.med.iungo.laf.CSSCheckBoxMenuItemUI;
import com.ge.med.iungo.laf.CSSCheckBoxUI;
import com.ge.med.iungo.laf.CSSComboBoxUI;
import com.ge.med.iungo.laf.CSSEditorPaneUI;
import com.ge.med.iungo.laf.CSSFormattedTextFieldUI;
import com.ge.med.iungo.laf.CSSLabelUI;
import com.ge.med.iungo.laf.CSSListUI;
import com.ge.med.iungo.laf.CSSMenuBarUI;
import com.ge.med.iungo.laf.CSSMenuItemUI;
import com.ge.med.iungo.laf.CSSMenuUI;
import com.ge.med.iungo.laf.CSSPanelUI;
import com.ge.med.iungo.laf.CSSPasswordFieldUI;
import com.ge.med.iungo.laf.CSSPopupMenuUI;
import com.ge.med.iungo.laf.CSSProgressBarUI;
import com.ge.med.iungo.laf.CSSRadioButtonMenuItemUI;
import com.ge.med.iungo.laf.CSSRadioButtonUI;
import com.ge.med.iungo.laf.CSSScrollPaneUI;
import com.ge.med.iungo.laf.CSSSeparatorUI;
import com.ge.med.iungo.laf.CSSTabbedPaneUI;
import com.ge.med.iungo.laf.CSSTableHeaderUI;
import com.ge.med.iungo.laf.CSSTableUI;
import com.ge.med.iungo.laf.CSSTextAreaUI;
import com.ge.med.iungo.laf.CSSTextFieldUI;
import com.ge.med.iungo.laf.CSSTextPaneUI;
import com.ge.med.iungo.laf.CSSToggleButtonUI;
import com.ge.med.iungo.laf.CSSToolTipUI;
import com.ge.med.iungo.laf.ThemeFactory;
import com.ge.med.iungo.util.Configuration;
import cz.vutbr.web.css.CSSException;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public abstract class CSSLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger_ = Logger.getLogger(CSSLookAndFeel.class.getName());
    private static final String CSS_ELEMENT = "css_element";
    protected transient MetalTheme csstheme;
    public static final String OVERRIDING_STYLESHEET = "overrides";

    public CSSLookAndFeel(URL css) throws CSSException, IOException {
        this(css, null);
    }

    public CSSLookAndFeel(URL css, URL cssSerialized) throws CSSException, IOException {
        ArrayList<CSS.StyleSheetURL> cssList = new ArrayList<CSS.StyleSheetURL>();
        cssList.add(new CSS.StyleSheetURL(css, cssSerialized));
        String overrides = Configuration.get(OVERRIDING_STYLESHEET, null);
        if (overrides != null && !overrides.isEmpty()) {
            try {
                cssList.add(new CSS.StyleSheetURL(new URL("file", "", 0, overrides, CSS.getURLStreamHandler())));
            }
            catch (MalformedURLException e) {
                logger_.log(Level.SEVERE, "Bad value for configuration property \"overrides\".", e);
            }
        }
        CSS.loadStyleSheet(cssList);
        this.csstheme = ThemeFactory.getThemeInstance();
    }

    @Override
    public String getName() {
        return "GEHC CSS";
    }

    @Override
    public String getID() {
        return "CSS";
    }

    @Override
    public String getDescription() {
        return "GE Healthcare CSS Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = super.getDefaults();
        this.initCSSClassDefaults(table);
        this.initCSSComponentDefaults(table);
        this.initIconDefaults(table);
        return table;
    }

    private void initIconDefaults(UIDefaults table) {
        for (final String cssClass : CSSFontIcon.getIconNames()) {
            UIDefaults.LazyValue iconDefault = new UIDefaults.LazyValue(){

                @Override
                public Object createValue(UIDefaults table) {
                    return new CSSFontIcon(cssClass);
                }
            };
            UIDefaults.LazyValue iconLarge = new UIDefaults.LazyValue(){

                @Override
                public Object createValue(UIDefaults table) {
                    return new CSSFontIcon(cssClass + " icon-large");
                }
            };
            table.put(cssClass, iconDefault);
            table.put(cssClass + " icon-default", iconDefault);
            table.put(cssClass + " icon-large", iconLarge);
        }
    }

    protected void initCSSClassDefaults(UIDefaults table) {
        Object[] uiDefaults = new Object[]{"ButtonUI", CSSButtonUI.class.getName(), "CheckBoxUI", CSSCheckBoxUI.class.getName(), "FormattedTextFieldUI", CSSFormattedTextFieldUI.class.getName(), "MenuBarUI", CSSMenuBarUI.class.getName(), "MenuUI", CSSMenuUI.class.getName(), "MenuItemUI", CSSMenuItemUI.class.getName(), "CheckBoxMenuItemUI", CSSCheckBoxMenuItemUI.class.getName(), "RadioButtonMenuItemUI", CSSRadioButtonMenuItemUI.class.getName(), "RadioButtonUI", CSSRadioButtonUI.class.getName(), "ToggleButtonUI", CSSToggleButtonUI.class.getName(), "PopupMenuUI", CSSPopupMenuUI.class.getName(), "ProgressBarUI", CSSProgressBarUI.class.getName(), "ScrollPaneUI", CSSScrollPaneUI.class.getName(), "SeparatorUI", CSSSeparatorUI.class.getName(), "PopupMenuSeparatorUI", CSSSeparatorUI.class.getName(), "TabbedPaneUI", CSSTabbedPaneUI.class.getName(), "TextAreaUI", CSSTextAreaUI.class.getName(), "TextFieldUI", CSSTextFieldUI.class.getName(), "PasswordFieldUI", CSSPasswordFieldUI.class.getName(), "TextPaneUI", CSSTextPaneUI.class.getName(), "EditorPaneUI", CSSEditorPaneUI.class.getName(), "LabelUI", CSSLabelUI.class.getName(), "ListUI", CSSListUI.class.getName(), "ToolTipUI", CSSToolTipUI.class.getName(), "ComboBoxUI", CSSComboBoxUI.class.getName(), "TableUI", CSSTableUI.class.getName(), "TableHeaderUI", CSSTableHeaderUI.class.getName(), "PanelUI", CSSPanelUI.class.getName()};
        table.putDefaults(uiDefaults);
    }

    protected void initCSSComponentDefaults(UIDefaults table) {
        CSSBorderResource border = new CSSBorderResource();
        JComponent body = new JComponent(){};
        body.putClientProperty(CSS_ELEMENT, "body");
        BackgroundInfo info = CSS.getInfo(body);
        JComponent textarea = new JComponent(){};
        textarea.putClientProperty(CSS_ELEMENT, "textarea");
        BackgroundInfo taInfo = CSS.getInfo(textarea);
        JComponent blockquote = new JComponent(){};
        JComponent paragraph = new JComponent(){};
        blockquote.putClientProperty(CSS_ELEMENT, "blockquote");
        paragraph.putClientProperty("css_parent", blockquote);
        paragraph.putClientProperty(CSS_ELEMENT, "p");
        BackgroundInfo pInfo = CSS.getInfo(paragraph);
        Color background = info.background;
        Color foreground = info.foreground;
        Font font = info.font;
        Font pFont = pInfo.font;
        Font taFont = taInfo.font;
        Object[] uiDefaults = new Object[]{"Button.border", border, "Label.border", border, "ProgressBar.border", border, "TextField.border", border, "FormattedTextField.border", border, "PasswordField.border", border, "List.border", border, "Table.border", border, "Table.scrollPaneBorder", border, "ScrollPane.border", border, "Button.font", font, "ToggleButton.font", font, "RadioButton.font", font, "CheckBox.font", font, "ColorChooser.font", font, "ComboBox.font", font, "Label.font", font, "List.font", font, "MenuBar.font", font, "MenuItem.font", font, "RadioButtonMenuItem.font", font, "CheckBoxMenuItem.font", font, "Menu.font", font, "PopupMenu.font", font, "OptionPane.font", font, "Panel.font", font, "ProgressBar.font", font, "ScrollPane.font", font, "Viewport.font", font, "Slider.font", font, "Spinner.font", pFont, "TabbedPane.font", font, "Table.font", font, "TableHeader.font", font, "TextField.font", font, "FormattedTextField.font", font, "PasswordField.font", pFont, "TextArea.font", taFont, "TextPane.font", font, "EditorPane.font", font, "TitledBorder.font", font, "ToolBar.font", font, "ToolTip.font", font, "Tree.font", font, "ToggleButton.background", background, "RadioButton.background", background, "CheckBox.background", background, "ColorChooser.background", background, "ComboBox.background", background, "Desktop.background", background, "Label.background", background, "MenuBar.background", background, "MenuItem.background", background, "RadioButtonMenuItem.background", background, "CheckBoxMenuItem.background", background, "Menu.background", background, "PopupMenu.background", background, "OptionPane.background", background, "Panel.background", background, "ProgressBar.background", background, "Separator.background", background, "ScrollPane.background", background, "Viewport.background", background, "Slider.background", background, "Spinner.background", background, "SplitPane.background", background, "TabbedPane.background", background, "TextField.background", background, "FormattedTextField.background", background, "PasswordField.background", background, "TextArea.background", background, "TextPane.background", background, "EditorPane.background", background, "ToolBar.background", background, "ToolTip.background", background, "Tree.background", background, "Button.foreground", foreground, "ToggleButton.foreground", foreground, "RadioButton.foreground", foreground, "CheckBox.foreground", foreground, "ColorChooser.foreground", foreground, "ComboBox.foreground", foreground, "Label.foreground", foreground, "MenuBar.foreground", foreground, "MenuItem.foreground", foreground, "RadioButtonMenuItem.foreground", foreground, "CheckBoxMenuItem.foreground", foreground, "Menu.foreground", foreground, "PopupMenu.foreground", foreground, "OptionPane.foreground", foreground, "Panel.foreground", foreground, "ProgressBar.foreground", foreground, "Separator.foreground", foreground, "ScrollPane.foreground", foreground, "Viewport.foreground", foreground, "Slider.foreground", background, "Spinner.foreground", background, "TabbedPane.foreground", foreground, "TextField.foreground", foreground, "FormattedTextField.foreground", foreground, "PasswordField.foreground", foreground, "TextArea.foreground", foreground, "TextPane.foreground", foreground, "EditorPane.foreground", foreground, "ToolBar.foreground", foreground, "ToolTip.foreground", foreground, "Tree.foreground", foreground, "TextField.caretForeground", foreground, "PasswordField.caretForeground", foreground, "FormattedTextField.caretForeground", foreground, "TextArea.caretForeground", foreground, "TextPane.caretForeground", foreground, "EditorPane.caretForeground", foreground, "List.background", background, "List.selectionBackground", foreground, "List.foreground", foreground, "List.selectionForeground", foreground, "Table.background", background, "Table.selectionBackground", foreground, "Table.focusCellBackground", foreground, "TableHeader.background", background, "Table.foreground", foreground, "Table.selectionForeground", background, "Table.focusCellForeground", background, "TableHeader.foreground", background};
        table.putDefaults(uiDefaults);
    }

    @Override
    public void initialize() {
        if (this.csstheme != null) {
            CSSLookAndFeel.setCurrentTheme(this.csstheme);
        }
        super.initialize();
    }
}

