/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.laf.CSSTableUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class CSSListUI
extends BasicListUI {
    private static final Logger LOGGER = Logger.getLogger(CSSListUI.class.getName());
    private final JComponent component_;
    private JComponent ul_ = new JComponent(){};
    private JComponent li_ = new JComponent(){};
    private CSSBorder border_ = new CSSBorder();
    private int mouseCell_ = -1;
    private MouseAdapter mouseAdapter_ = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent me) {
            JList list = (JList)CSSListUI.this.component_;
            int mouseCell = CSSListUI.this.locationToIndex(list, me.getPoint());
            if (mouseCell != CSSListUI.this.mouseCell_) {
                Rectangle dirty = CSSListUI.this.getCellBounds(list, mouseCell != -1 ? mouseCell : CSSListUI.this.mouseCell_, CSSListUI.this.mouseCell_ != -1 ? CSSListUI.this.mouseCell_ : mouseCell);
                CSSListUI.this.mouseCell_ = mouseCell;
                if (dirty != null) {
                    CSSListUI.this.component_.repaint(dirty);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (CSSListUI.this.mouseCell_ != -1) {
                Rectangle dirty = CSSListUI.this.getCellBounds((JList)CSSListUI.this.component_, CSSListUI.this.mouseCell_, CSSListUI.this.mouseCell_);
                CSSListUI.this.mouseCell_ = -1;
                if (dirty != null) {
                    CSSListUI.this.component_.repaint(dirty);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (CSSListUI.this.mouseCell_ != -1) {
                Rectangle dirty = CSSListUI.this.getCellBounds((JList)CSSListUI.this.component_, CSSListUI.this.mouseCell_, CSSListUI.this.mouseCell_);
                CSSListUI.this.mouseCell_ = -1;
                if (dirty != null) {
                    CSSListUI.this.component_.repaint(dirty);
                }
            }
        }
    };

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JList);
        LOGGER.entering(CSSListUI.class.getName(), "createUI");
        return new CSSListUI(component);
    }

    protected CSSListUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void uninstallUI(JComponent component) {
        LOGGER.entering(CSSTableUI.class.getName(), "uninstallUI");
        component.removeMouseListener(this.mouseAdapter_);
        component.removeMouseMotionListener(this.mouseAdapter_);
        super.uninstallUI(component);
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSListUI.class.getName(), "installUI");
        super.installUI(component);
        component.remove(this.rendererPane);
        this.rendererPane = new CellRendererPane(){
            private boolean painting_ = false;

            @Override
            public void addImpl(Component c, Object constraints, int index) {
                if (!this.painting_ && c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setOpaque(false);
                    jc.setBorder(CSSListUI.this.border_);
                    jc.putClientProperty("css_element", "a");
                    jc.putClientProperty("css_parent", CSSListUI.this.li_);
                    int w = jc.getWidth();
                    int h = jc.getHeight();
                    boolean selected = false;
                    boolean rollover = false;
                    CSSListUI.this.li_.putClientProperty("css_class", selected ? "active" : "");
                    CSSListUI.this.li_.putClientProperty("css_hover", rollover);
                    jc.putClientProperty("css_hover", rollover);
                    String cacheKey = "?" + System.identityHashCode(jc) + "|" + selected + "|" + rollover + "|" + w + "x" + h + "|" + System.identityHashCode(this);
                    jc.putClientProperty("css_cacheKey", cacheKey);
                }
                super.addImpl(c, constraints, index);
            }

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setOpaque(false);
                    jc.setBorder(CSSListUI.this.border_);
                    jc.putClientProperty("css_element", "a");
                    jc.putClientProperty("css_parent", CSSListUI.this.li_);
                    JList list = (JList)CSSListUI.this.component_;
                    int row = list.locationToIndex(new Point(x, y));
                    boolean selected = list.isSelectedIndex(row);
                    boolean rollover = row == CSSListUI.this.mouseCell_;
                    CSSListUI.this.li_.putClientProperty("css_class", selected ? "active" : "");
                    CSSListUI.this.li_.putClientProperty("css_hover", rollover);
                    jc.putClientProperty("css_hover", rollover);
                    String cacheKey = "" + System.identityHashCode(jc) + "|" + selected + "|" + rollover + "|" + w + "x" + h + "|" + jc.getBackground() + jc.getForeground() + "|" + System.identityHashCode(this);
                    jc.putClientProperty("css_cacheKey", cacheKey);
                }
                this.painting_ = true;
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
                this.painting_ = false;
            }
        };
        component.add(this.rendererPane);
        component.addMouseListener(this.mouseAdapter_);
        component.addMouseMotionListener(this.mouseAdapter_);
        if (component.getClientProperty("css_element") == null) {
            component.putClientProperty("css_element", "ul");
        }
        if (component.getClientProperty("css_class") == null) {
            component.putClientProperty("css_class", "nav-list");
        }
        this.li_.putClientProperty("css_element", "li");
        this.li_.putClientProperty("css_parent", this.ul_);
        this.ul_.putClientProperty("css_element", "ul");
        this.ul_.putClientProperty("css_id", "stackedTabList");
        this.ul_.putClientProperty("css_class", "nav nav-list");
        component.putClientProperty("css_listparent", this.ul_);
        component.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        assert (component == this.component_);
        BackgroundInfo info = CSS.getInfo(component);
        Background.updateComponentProperties(component, info);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

