/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.border.CSSBorderResource;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLabelUI;
import sun.swing.SwingUtilities2;

public class CSSLabelUI
extends BasicLabelUI {
    private static final Logger LOGGER = Logger.getLogger(CSSLabelUI.class.getName());
    private static ComponentUI ui_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JLabel);
        LOGGER.entering(CSSLabelUI.class.getName(), "createUI");
        if (ui_ != null) return ui_;
        Class<CSSLabelUI> clazz = CSSLabelUI.class;
        synchronized (CSSLabelUI.class) {
            if (ui_ != null) return ui_;
            ui_ = new CSSLabelUI();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ui_;
        }
    }

    @Override
    public void installUI(JComponent component) {
        LOGGER.entering(CSSLabelUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorderResource());
        LookAndFeel.installProperty(component, "opaque", Boolean.FALSE);
        JLabel before = new JLabel(){

            @Override
            public void updateUI() {
            }
        };
        before.putClientProperty("css_relative", component);
        before.putClientProperty("css_pseudo", Boolean.TRUE);
        before.putClientProperty("css_before", Boolean.TRUE);
        component.putClientProperty("css_pseudo_before", before);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        BackgroundInfo info = CSS.getInfo(component);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Background.updateComponentProperties(component, info);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            Font font = component.getFont();
            if (info.font != null && font instanceof UIResource && !info.font.equals(font)) {
                component.setFont(info.font);
            }
            Background.addFontRenderingHints((Graphics2D)g, component);
            super.paint(g, component);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        BackgroundInfo info = CSS.getInfo(component);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            Font font = component.getFont();
            if (info.font != null && font instanceof UIResource && !info.font.equals(font)) {
                component.setFont(info.font);
            }
            size = super.getPreferredSize(component);
        }
        return size;
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = l.getDisplayedMnemonicIndex();
        Color fg = l.getForeground();
        fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), fg.getAlpha() / 2);
        g.setColor(fg);
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY);
    }
}

