/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;

public class CSSEditorPaneUI
extends BasicEditorPaneUI {
    private static final Logger LOGGER = Logger.getLogger(CSSEditorPaneUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JEditorPane);
        LOGGER.entering(CSSEditorPaneUI.class.getName(), "createUI");
        return new CSSEditorPaneUI(component);
    }

    protected CSSEditorPaneUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSEditorPaneUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorder());
        component.setOpaque(false);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

