/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.ZoomedIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class CSSComboBoxUI
extends MetalComboBoxUI {
    private static final Logger logger_ = Logger.getLogger(CSSComboBoxUI.class.getName());
    private FocusListener focusListener_ = null;
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JComboBox);
        logger_.entering(CSSComboBoxUI.class.getName(), "createUI");
        return new CSSComboBoxUI(component);
    }

    protected CSSComboBoxUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, hasFocus && !this.isPopupVisible(this.comboBox), false);
        this.currentValuePane.paintComponent(g, c, null, bounds.x, bounds.y, bounds.width, bounds.height, c instanceof JPanel);
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){
            {
                JComponent select = new JComponent(){};
                select.putClientProperty("css_element", "select");
                BackgroundInfo info = CSS.getInfo(select);
                this.setBackground(new Color(info.background.getRGB()));
            }

            @Override
            protected int getPopupHeightForRowCount(int maxRowCount) {
                Insets insets;
                Border border;
                int minRowCount = Math.min(maxRowCount, this.comboBox.getItemCount());
                int height = 0;
                ListCellRenderer<Object> renderer = this.list.getCellRenderer();
                Object value = null;
                CellRendererPane rendererPane = null;
                try {
                    rendererPane = (CellRendererPane)this.list.getComponent(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                for (int i = 0; i < minRowCount; ++i) {
                    value = this.list.getModel().getElementAt(i);
                    Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
                    if (rendererPane != null) {
                        rendererPane.add(c);
                    }
                    height += c.getPreferredSize().height;
                    if (rendererPane == null) continue;
                    rendererPane.remove(c);
                }
                if (height == 0) {
                    height = this.comboBox.getHeight();
                }
                if ((border = this.scroller.getViewportBorder()) != null) {
                    insets = border.getBorderInsets(null);
                    height += insets.top + insets.bottom;
                }
                if ((border = this.scroller.getBorder()) != null) {
                    insets = border.getBorderInsets(null);
                    height += insets.top + insets.bottom;
                }
                return height;
            }
        };
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        logger_.entering(CSSComboBoxUI.class.getName(), "installUI");
        super.installUI(component);
        LookAndFeel.installProperty(component, "opaque", Boolean.FALSE);
        component.setOpaque(false);
        component.setBorder(new CSSBorder());
        component.putClientProperty("css_class", "btn");
        component.putClientProperty("css_element", "select");
        component.putClientProperty("css_attribute_multiple", "");
        this.padding = new Insets(0, 0, 0, 0);
        component.remove(this.currentValuePane);
        this.currentValuePane = new CellRendererPane(){
            private boolean painting_ = false;

            private void update(Component c) {
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setBorder(null);
                    jc.setOpaque(false);
                }
                Font crFont = c.getFont();
                Font cbFont = CSSComboBoxUI.this.component_.getFont();
                if (cbFont != null && crFont instanceof UIResource && !cbFont.equals(crFont)) {
                    c.setFont(cbFont);
                }
                Color crFG = c.getForeground();
                Color cbFG = CSSComboBoxUI.this.component_.getForeground();
                if (cbFG != null && crFG instanceof UIResource && !cbFG.equals(crFG)) {
                    c.setForeground(cbFG);
                }
            }

            @Override
            public void addImpl(Component c, Object constraints, int index) {
                if (!this.painting_) {
                    this.update(c);
                }
                super.addImpl(c, constraints, index);
            }

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                this.update(c);
                this.painting_ = true;
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
                this.painting_ = false;
            }
        };
        component.add(this.currentValuePane);
        try {
            ((JComponent)this.listBox.getClientProperty("css_listparent")).putClientProperty("css_class", "dropdown-menu");
            this.listBox.putClientProperty("css_class", "dropdown-menu");
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Could not access css_listparent for JComboBox dropdown.");
        }
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        if (this.editor != null && null != this.focusListener_) {
            this.editor.removeFocusListener(this.focusListener_);
            this.focusListener_ = null;
        }
    }

    @Override
    protected JButton createArrowButton() {
        UIDefaults defaults_ = UIManager.getDefaults();
        return new JButton((Icon)new ZoomedIcon(defaults_.getIcon("icon-chevron-down"))){

            @Override
            public Border getBorder() {
                return null;
            }

            @Override
            public Color getForeground() {
                return CSSComboBoxUI.this.component_.getForeground();
            }

            @Override
            public Insets getInsets() {
                Insets insets = super.getInsets();
                return new Insets(insets.top, 0, insets.bottom, 0);
            }

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource(){

            @Override
            protected JTextField createEditorComponent() {
                JTextField editor = new JTextField("", 9){

                    @Override
                    public void updateUI() {
                        super.updateUI();
                        this.setBorder(null);
                        this.revalidate();
                    }

                    @Override
                    public Color getForeground() {
                        return CSSComboBoxUI.this.component_.getForeground();
                    }

                    @Override
                    public Color getCaretColor() {
                        return CSSComboBoxUI.this.component_.getForeground();
                    }
                };
                editor.setBorder(null);
                editor.addFocusListener(CSSComboBoxUI.this.focusListener_ = new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        CSSComboBoxUI.this.component_.repaint();
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        CSSComboBoxUI.this.component_.repaint();
                    }
                });
                return editor;
            }
        };
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null) {
            Insets buttonInsets = this.arrowButton.getInsets();
            Insets insets = this.comboBox.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += this.arrowButton.getMinimumSize().width;
            size.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            size = super.getMinimumSize(c);
            Insets margin = this.arrowButton.getMargin();
            if (margin != null) {
                size.height -= 4;
                size.width += margin.left + margin.right;
            } else {
                logger_.severe("The margin of the arrow button is null.");
            }
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

