/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.ZoomedIcon;
import com.ge.med.iungo.laf.CSSMenuItemUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class CSSCheckBoxMenuItemUI
extends CSSMenuItemUI {
    private static final Logger LOGGER = Logger.getLogger(CSSCheckBoxMenuItemUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JCheckBoxMenuItem);
        LOGGER.entering(CSSCheckBoxMenuItemUI.class.getName(), "createUI");
        return new CSSCheckBoxMenuItemUI(component);
    }

    protected CSSCheckBoxMenuItemUI(JComponent component) {
        super(component);
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSCheckBoxMenuItemUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorder());
        component.setOpaque(false);
        CBIcon cbIcon = new CBIcon();
        if (cbIcon.isAvailable()) {
            ((AbstractButton)component).setIcon(cbIcon);
        } else {
            this.checkIcon = new ZoomedIcon(UIManager.getIcon("CheckBoxMenuItem.checkIcon"));
        }
    }

    private class CBIcon
    implements Icon {
        private JComponent dummy_ = new AbstractButton(){
            {
                this.putClientProperty("css_element", "span");
                this.putClientProperty("css_class", "checkbox");
            }

            @Override
            public boolean isEnabled() {
                return CSSCheckBoxMenuItemUI.this.component_.isEnabled();
            }

            @Override
            public boolean isSelected() {
                return CSSCheckBoxMenuItemUI.this.component_ instanceof AbstractButton && ((AbstractButton)CSSCheckBoxMenuItemUI.this.component_).isSelected();
            }

            @Override
            public ButtonModel getModel() {
                return CSSCheckBoxMenuItemUI.this.component_ instanceof AbstractButton ? ((AbstractButton)CSSCheckBoxMenuItemUI.this.component_).getModel() : super.getModel();
            }
        };

        private CBIcon() {
        }

        @Override
        public int getIconWidth() {
            BackgroundInfo info = CSS.getInfo(this.dummy_);
            return info.size.width;
        }

        @Override
        public int getIconHeight() {
            BackgroundInfo info = CSS.getInfo(this.dummy_);
            return info.size.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            BackgroundInfo info = CSS.getInfo(this.dummy_);
            AffineTransform saveTransform = g2.getTransform();
            Shape saveClip = g2.getClip();
            g.clipRect(x, y, info.size.width, info.size.height);
            g.translate(x, y);
            Background.paintImages(info, g, x, y, info.size.width, info.size.height);
            g2.setTransform(saveTransform);
            g2.setClip(saveClip);
        }

        public boolean isAvailable() {
            BackgroundInfo info = CSS.getInfo(this.dummy_);
            return !info.backgroundImageList.isEmpty();
        }
    }
}

