/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class CSSButtonUI
extends BasicButtonUI {
    private static final Logger LOGGER = Logger.getLogger(CSSButtonUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof AbstractButton);
        LOGGER.entering(CSSButtonUI.class.getName(), "createUI");
        return new CSSButtonUI(component);
    }

    protected CSSButtonUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSButtonUI.class.getName(), "installUI");
        super.installUI(component);
        ((AbstractButton)component).setRolloverEnabled(true);
        LookAndFeel.installProperty(component, "opaque", Boolean.FALSE);
        if (component.getClientProperty("css_class") == null) {
            component.putClientProperty("css_class", "btn");
        }
        JComponent before = new JComponent(){};
        before.putClientProperty("css_relative", component);
        before.putClientProperty("css_pseudo", Boolean.TRUE);
        before.putClientProperty("css_before", Boolean.TRUE);
        component.putClientProperty("css_pseudo_before", before);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        assert (component == this.component_);
        BackgroundInfo info = CSS.getInfo(component);
        Background.updateComponentProperties(component, info);
        Border border = component.getBorder();
        if (border instanceof CSSBorder && ((AbstractButton)component).isBorderPainted()) {
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder && ((AbstractButton)component).isBorderPainted()) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }

    @Override
    protected void paintText(Graphics g, AbstractButton component, Rectangle textRect, String text) {
        g.setColor(component.getForeground());
        FontMetrics fm = g.getFontMetrics(g.getFont());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, component.getDisplayedMnemonicIndex(), textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
    }
}

