/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.graphics;

import com.ge.med.iungo.css.CSS;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ZoomedIcon
implements Icon {
    private static final Color TRANSPARENT = new Color(0, true);
    private final Icon baseIcon_;
    private final BufferedImage buffer_;

    public ZoomedIcon(Icon baseIcon) {
        this.baseIcon_ = baseIcon;
        this.buffer_ = this.baseIcon_ != null ? new BufferedImage(this.baseIcon_.getIconWidth(), this.baseIcon_.getIconHeight(), 2) : null;
    }

    @Override
    public int getIconWidth() {
        return this.baseIcon_ != null ? (int)Math.round((double)this.baseIcon_.getIconWidth() * CSS.getZoom()) : 0;
    }

    @Override
    public int getIconHeight() {
        return this.baseIcon_ != null ? (int)Math.round((double)this.baseIcon_.getIconHeight() * CSS.getZoom()) : 0;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.baseIcon_ != null) {
            Graphics2D bg = this.buffer_.createGraphics();
            bg.setColor(TRANSPARENT);
            bg.setComposite(AlphaComposite.Src);
            bg.fillRect(0, 0, this.baseIcon_.getIconWidth(), this.baseIcon_.getIconHeight());
            bg.setComposite(AlphaComposite.SrcOver);
            this.baseIcon_.paintIcon(c, bg, 0, 0);
            AffineTransform scale = AffineTransform.getScaleInstance(CSS.getZoom(), CSS.getZoom());
            ((Graphics2D)g).drawImage(this.buffer_, new AffineTransformOp(scale, 3), x, y);
        }
    }
}

