/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.util.logging.Logger;
import javax.swing.Icon;

public class PaddedIcon
implements Icon {
    protected static final Logger logger_ = Logger.getLogger(PaddedIcon.class.getName());
    protected final Icon icon_;
    private Dimension size_ = null;
    private Point origin_ = null;
    private Insets insets_ = null;

    private final Dimension getSize() {
        if (this.size_ == null || this.size_.width <= 0 || this.size_.height <= 0) {
            int w = this.icon_.getIconWidth();
            int h = this.icon_.getIconHeight();
            if (this.insets_ != null) {
                w += this.insets_.left + this.insets_.right;
                h += this.insets_.top + this.insets_.bottom;
            }
            this.size_ = new Dimension(w, h);
        }
        return this.size_;
    }

    protected final Point getOrigin() {
        if (this.origin_ == null) {
            if (this.insets_ != null) {
                this.origin_ = new Point(this.insets_.left, this.insets_.top);
            } else {
                int x = (this.getSize().width - this.icon_.getIconWidth()) / 2;
                int y = (this.getSize().height - this.icon_.getIconHeight()) / 2;
                this.origin_ = new Point(x, y);
            }
        }
        return this.origin_;
    }

    public PaddedIcon(Icon icon) {
        this.icon_ = icon;
    }

    public PaddedIcon(Icon icon, Dimension size) {
        this(icon);
        this.size_ = size;
    }

    public PaddedIcon(Icon icon, Dimension size, Point origin) {
        this(icon, size);
        this.origin_ = origin;
    }

    public PaddedIcon(Icon icon, Insets insets) {
        this(icon);
        this.insets_ = insets;
    }

    @Override
    public int getIconWidth() {
        return this.getSize().width;
    }

    @Override
    public int getIconHeight() {
        return this.getSize().height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Point origin = this.getOrigin();
        this.icon_.paintIcon(c, g, x + origin.x, y + origin.y);
    }
}

