/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;

public class FontIcon
implements Icon {
    private static final Logger logger_ = Logger.getLogger(FontIcon.class.getName());
    private final Font font_;
    private final char codePoint_;
    private final Dimension size_;
    private Shape glyph_ = null;
    private static FontRenderContext fontRenderContext_ = null;
    private static Map<String, Font> scaledFontCache_ = new LinkedHashMap<String, Font>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Font> e) {
            return this.size() > 100;
        }
    };

    public FontIcon(Font font, char codePoint) {
        this(font, codePoint, null);
    }

    public FontIcon(Font font, char codePoint, Dimension size) {
        double height;
        double width = size != null ? size.getWidth() : 0.0;
        double d = height = size != null ? size.getHeight() : 0.0;
        if (width > 0.0 && height > 0.0) {
            String cacheKey = font.getFontName() + "@" + (int)width + "x" + (int)height;
            Font f = scaledFontCache_.get(cacheKey);
            if (f == null) {
                Rectangle2D maxBounds = font.getMaxCharBounds(FontIcon.getFontRenderContext());
                double scale = Math.min(width / maxBounds.getWidth(), height / maxBounds.getHeight());
                f = font.deriveFont((float)Math.floor((double)font.getSize2D() * scale));
                scaledFontCache_.put(cacheKey, f);
            }
            font = f;
        }
        this.font_ = font;
        this.codePoint_ = codePoint;
        if (width <= 0.0 || height <= 0.0) {
            Rectangle2D maxBounds = this.font_.getMaxCharBounds(FontIcon.getFontRenderContext());
            width = maxBounds.getWidth();
            height = maxBounds.getHeight();
        }
        this.size_ = new Dimension((int)Math.ceil(width), (int)Math.ceil(height));
    }

    @Override
    public int getIconWidth() {
        return this.size_.width;
    }

    @Override
    public int getIconHeight() {
        return this.size_.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform transform = g2.getTransform();
        g2.translate(x, y);
        g2.setColor(c != null ? c.getForeground() : Color.black);
        g2.fill(this.getGlyph());
        g2.setTransform(transform);
    }

    private Shape getGlyph() {
        if (this.glyph_ == null) {
            Rectangle2D maxBounds = this.font_.getMaxCharBounds(FontIcon.getFontRenderContext());
            double descent = Math.min(maxBounds.getY(), 0.0) + maxBounds.getHeight();
            GlyphVector glyphVector = this.font_.createGlyphVector(FontIcon.getFontRenderContext(), new char[]{this.codePoint_});
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
            Rectangle2D glyphBounds = glyphMetrics.getBounds2D();
            double translateX = maxBounds.getX() - (maxBounds.getWidth() - (double)glyphMetrics.getAdvanceX()) / 2.0;
            double translateY = maxBounds.getY() - (descent / 2.0 - Math.max(0.0, Math.ceil(glyphBounds.getHeight() + Math.min(0.0, glyphBounds.getY()) - descent / 2.0)));
            this.glyph_ = AffineTransform.getTranslateInstance(-translateX, -translateY).createTransformedShape(glyphVector.getOutline());
        }
        return this.glyph_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FontRenderContext getFontRenderContext() {
        if (fontRenderContext_ != null) return fontRenderContext_;
        Class<FontIcon> clazz = FontIcon.class;
        synchronized (FontIcon.class) {
            if (fontRenderContext_ != null) return fontRenderContext_;
            fontRenderContext_ = new BufferedImage(1, 1, 2).createGraphics().getFontRenderContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fontRenderContext_;
        }
    }
}

