/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.graphics;

import com.ge.med.iungo.css.CSS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FAIcon
implements Icon {
    private final int width_;
    private final int height_;
    private final char codePoint_;
    private final Font font_;
    private static Map<String, Dimension> sizeMap_ = new HashMap<String, Dimension>();
    public static Map<String, Character> codePointMap_;

    public FAIcon(String cssClass) {
        this(FAIcon.getSize(cssClass), FAIcon.getCodePoint(cssClass));
    }

    public FAIcon(Dimension size, char codePoint) {
        this.width_ = size.width;
        this.height_ = size.height;
        this.codePoint_ = codePoint;
        this.font_ = Font.decode("FontAwesome");
    }

    @Override
    public int getIconWidth() {
        return this.width_;
    }

    @Override
    public int getIconHeight() {
        return this.height_;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = g2.getTransform();
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle box = this.font_.getMaxCharBounds(frc).getBounds();
        int pad = box.height + Math.min(0, box.y);
        float scale = (float)Math.min((double)this.width_ / box.getWidth(), (double)this.height_ / box.getHeight());
        Font font = this.font_.deriveFont(this.font_.getSize2D() * scale);
        box = font.getMaxCharBounds(frc).getBounds();
        double[] excess = new double[]{(double)this.width_ - box.getWidth(), (double)this.height_ - box.getHeight()};
        box = font.getMaxCharBounds(frc).getBounds();
        pad = box.height + Math.min(0, box.y);
        GlyphVector gv = font.createGlyphVector(frc, new char[]{this.codePoint_});
        GlyphMetrics gm = gv.getGlyphMetrics(0);
        Rectangle2D gb = gm.getBounds2D();
        Shape glyph = gv.getOutline();
        double[] t = new double[]{x, y};
        t[0] = t[0] + excess[0] / 2.0;
        t[1] = t[1] + excess[1] / 2.0;
        t[0] = t[0] - box.getX();
        t[1] = t[1] - box.getY();
        t[1] = t[1] + ((double)(pad / 2) - Math.max(0.0, Math.ceil(gb.getHeight() + Math.min(0.0, gb.getY()) - (double)(pad / 2))));
        t[0] = t[0] + (font.getMaxCharBounds(frc).getWidth() - (double)gm.getAdvanceX()) / 2.0;
        t[1] = t[1] + 0.0;
        g2.translate(Math.round(t[0]), Math.round(t[1]));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(c.getForeground());
        g2.fill(glyph);
        g2.setTransform(transform);
    }

    private static char getCodePoint(String cssClass) {
        for (String cssc : cssClass.split(" ")) {
            Character c = codePointMap_.get(cssc);
            if (c == null) continue;
            return c.charValue();
        }
        return codePointMap_.get("missing-glyph").charValue();
    }

    private static Dimension getSize(String cssClass) {
        for (String cssc : cssClass.split(" ")) {
            Dimension d = sizeMap_.get(cssc);
            if (d == null) continue;
            return d;
        }
        return sizeMap_.get("icon-default");
    }

    public static void main(String[] argv) throws Exception {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font iconFont = Font.createFont(0, new URL("file", "", 0, "hdx/components/font-awesome/build/assets/font-awesome/font/fontawesome-webfont.ttf", CSS.getURLStreamHandler()).openStream());
        ge.registerFont(iconFont);
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JPanel p = new JPanel(new FlowLayout(0, 10, 10));
        p.setPreferredSize(new Dimension(1600, 9999));
        for (String k : codePointMap_.keySet()) {
            char c = codePointMap_.get(k).charValue();
            if (!iconFont.canDisplay(c)) continue;
            JLabel l = new JLabel(k, new FAIcon(k + " icon-collosal"), 4);
            l.setOpaque(true);
            l.setBackground(Color.white);
            p.add(l);
        }
        f.add(new JScrollPane(p));
        f.pack();
        f.setVisible(true);
    }

    static {
        sizeMap_.put("icon-large", new Dimension(18, 18));
        sizeMap_.put("icon-huge", new Dimension(24, 24));
        sizeMap_.put("icon-colossal", new Dimension(36, 37));
        sizeMap_.put("icon-gargantuan", new Dimension(72, 72));
        sizeMap_.put("icon-default", new Dimension(14, 14));
        codePointMap_ = new TreeMap<String, Character>();
        codePointMap_.put("icon-glass", Character.valueOf('\uf000'));
        codePointMap_.put("icon-music", Character.valueOf('\uf001'));
        codePointMap_.put("icon-search", Character.valueOf('\uf002'));
        codePointMap_.put("icon-envelope", Character.valueOf('\uf003'));
        codePointMap_.put("icon-heart", Character.valueOf('\uf004'));
        codePointMap_.put("icon-star", Character.valueOf('\uf005'));
        codePointMap_.put("icon-star-empty", Character.valueOf('\uf006'));
        codePointMap_.put("icon-user", Character.valueOf('\uf007'));
        codePointMap_.put("icon-film", Character.valueOf('\uf008'));
        codePointMap_.put("icon-th-large", Character.valueOf('\uf009'));
        codePointMap_.put("icon-th", Character.valueOf('\uf00a'));
        codePointMap_.put("icon-th-list", Character.valueOf('\uf00b'));
        codePointMap_.put("icon-ok", Character.valueOf('\uf00c'));
        codePointMap_.put("icon-remove", Character.valueOf('\uf00d'));
        codePointMap_.put("icon-zoom-in", Character.valueOf('\uf00e'));
        codePointMap_.put("icon-zoom-out", Character.valueOf('\uf010'));
        codePointMap_.put("icon-off", Character.valueOf('\uf011'));
        codePointMap_.put("icon-signal", Character.valueOf('\uf012'));
        codePointMap_.put("icon-cog", Character.valueOf('\uf013'));
        codePointMap_.put("icon-trash", Character.valueOf('\uf014'));
        codePointMap_.put("icon-home", Character.valueOf('\uf015'));
        codePointMap_.put("icon-file", Character.valueOf('\uf016'));
        codePointMap_.put("icon-time", Character.valueOf('\uf017'));
        codePointMap_.put("icon-road", Character.valueOf('\uf018'));
        codePointMap_.put("icon-download-alt", Character.valueOf('\uf019'));
        codePointMap_.put("icon-download", Character.valueOf('\uf01a'));
        codePointMap_.put("icon-upload", Character.valueOf('\uf01b'));
        codePointMap_.put("icon-inbox", Character.valueOf('\uf01c'));
        codePointMap_.put("icon-play-circle", Character.valueOf('\uf01d'));
        codePointMap_.put("icon-repeat", Character.valueOf('\uf01e'));
        codePointMap_.put("icon-refresh", Character.valueOf('\uf021'));
        codePointMap_.put("icon-list-alt", Character.valueOf('\uf022'));
        codePointMap_.put("icon-lock", Character.valueOf('\uf023'));
        codePointMap_.put("icon-flag", Character.valueOf('\uf024'));
        codePointMap_.put("icon-headphones", Character.valueOf('\uf025'));
        codePointMap_.put("icon-volume-off", Character.valueOf('\uf026'));
        codePointMap_.put("icon-volume-down", Character.valueOf('\uf027'));
        codePointMap_.put("icon-volume-up", Character.valueOf('\uf028'));
        codePointMap_.put("icon-qrcode", Character.valueOf('\uf029'));
        codePointMap_.put("icon-barcode", Character.valueOf('\uf02a'));
        codePointMap_.put("icon-tag", Character.valueOf('\uf02b'));
        codePointMap_.put("icon-tags", Character.valueOf('\uf02c'));
        codePointMap_.put("icon-book", Character.valueOf('\uf02d'));
        codePointMap_.put("icon-bookmark", Character.valueOf('\uf02e'));
        codePointMap_.put("icon-print", Character.valueOf('\uf02f'));
        codePointMap_.put("icon-camera", Character.valueOf('\uf030'));
        codePointMap_.put("icon-font", Character.valueOf('\uf031'));
        codePointMap_.put("icon-bold", Character.valueOf('\uf032'));
        codePointMap_.put("icon-italic", Character.valueOf('\uf033'));
        codePointMap_.put("icon-text-height", Character.valueOf('\uf034'));
        codePointMap_.put("icon-text-width", Character.valueOf('\uf035'));
        codePointMap_.put("icon-align-left", Character.valueOf('\uf036'));
        codePointMap_.put("icon-align-center", Character.valueOf('\uf037'));
        codePointMap_.put("icon-align-right", Character.valueOf('\uf038'));
        codePointMap_.put("icon-align-justify", Character.valueOf('\uf039'));
        codePointMap_.put("icon-list", Character.valueOf('\uf03a'));
        codePointMap_.put("icon-indent-left", Character.valueOf('\uf03b'));
        codePointMap_.put("icon-indent-right", Character.valueOf('\uf03c'));
        codePointMap_.put("icon-facetime-video", Character.valueOf('\uf03d'));
        codePointMap_.put("icon-picture", Character.valueOf('\uf03e'));
        codePointMap_.put("icon-pencil", Character.valueOf('\uf040'));
        codePointMap_.put("icon-map-marker", Character.valueOf('\uf041'));
        codePointMap_.put("icon-adjust", Character.valueOf('\uf042'));
        codePointMap_.put("icon-tint", Character.valueOf('\uf043'));
        codePointMap_.put("icon-edit", Character.valueOf('\uf044'));
        codePointMap_.put("icon-share", Character.valueOf('\uf045'));
        codePointMap_.put("icon-check", Character.valueOf('\uf046'));
        codePointMap_.put("icon-move", Character.valueOf('\uf047'));
        codePointMap_.put("icon-step-backward", Character.valueOf('\uf048'));
        codePointMap_.put("icon-fast-backward", Character.valueOf('\uf049'));
        codePointMap_.put("icon-backward", Character.valueOf('\uf04a'));
        codePointMap_.put("icon-play", Character.valueOf('\uf04b'));
        codePointMap_.put("icon-pause", Character.valueOf('\uf04c'));
        codePointMap_.put("icon-stop", Character.valueOf('\uf04d'));
        codePointMap_.put("icon-forward", Character.valueOf('\uf04e'));
        codePointMap_.put("icon-fast-forward", Character.valueOf('\uf050'));
        codePointMap_.put("icon-step-forward", Character.valueOf('\uf051'));
        codePointMap_.put("icon-eject", Character.valueOf('\uf052'));
        codePointMap_.put("icon-chevron-left", Character.valueOf('\uf053'));
        codePointMap_.put("icon-chevron-right", Character.valueOf('\uf054'));
        codePointMap_.put("icon-plus-sign", Character.valueOf('\uf055'));
        codePointMap_.put("icon-minus-sign", Character.valueOf('\uf056'));
        codePointMap_.put("icon-remove-sign", Character.valueOf('\uf057'));
        codePointMap_.put("icon-ok-sign", Character.valueOf('\uf058'));
        codePointMap_.put("icon-question-sign", Character.valueOf('\uf059'));
        codePointMap_.put("icon-info-sign", Character.valueOf('\uf05a'));
        codePointMap_.put("icon-screenshot", Character.valueOf('\uf05b'));
        codePointMap_.put("icon-remove-circle", Character.valueOf('\uf05c'));
        codePointMap_.put("icon-ok-circle", Character.valueOf('\uf05d'));
        codePointMap_.put("icon-ban-circle", Character.valueOf('\uf05e'));
        codePointMap_.put("icon-arrow-left", Character.valueOf('\uf060'));
        codePointMap_.put("icon-arrow-right", Character.valueOf('\uf061'));
        codePointMap_.put("icon-arrow-up", Character.valueOf('\uf062'));
        codePointMap_.put("icon-arrow-down", Character.valueOf('\uf063'));
        codePointMap_.put("icon-share-alt", Character.valueOf('\uf064'));
        codePointMap_.put("icon-resize-full", Character.valueOf('\uf065'));
        codePointMap_.put("icon-resize-small", Character.valueOf('\uf066'));
        codePointMap_.put("icon-plus", Character.valueOf('\uf067'));
        codePointMap_.put("icon-minus", Character.valueOf('\uf068'));
        codePointMap_.put("icon-asterisk", Character.valueOf('\uf069'));
        codePointMap_.put("icon-exclamation-sign", Character.valueOf('\uf06a'));
        codePointMap_.put("icon-gift", Character.valueOf('\uf06b'));
        codePointMap_.put("icon-leaf", Character.valueOf('\uf06c'));
        codePointMap_.put("icon-fire", Character.valueOf('\uf06d'));
        codePointMap_.put("icon-eye-open", Character.valueOf('\uf06e'));
        codePointMap_.put("icon-eye-close", Character.valueOf('\uf070'));
        codePointMap_.put("icon-warning-sign", Character.valueOf('\uf071'));
        codePointMap_.put("icon-plane", Character.valueOf('\uf072'));
        codePointMap_.put("icon-calendar", Character.valueOf('\uf073'));
        codePointMap_.put("icon-random", Character.valueOf('\uf074'));
        codePointMap_.put("icon-comment", Character.valueOf('\uf075'));
        codePointMap_.put("icon-magnet", Character.valueOf('\uf076'));
        codePointMap_.put("icon-chevron-up", Character.valueOf('\uf077'));
        codePointMap_.put("icon-chevron-down", Character.valueOf('\uf078'));
        codePointMap_.put("icon-retweet", Character.valueOf('\uf079'));
        codePointMap_.put("icon-shopping-cart", Character.valueOf('\uf07a'));
        codePointMap_.put("icon-folder-close", Character.valueOf('\uf07b'));
        codePointMap_.put("icon-folder-open", Character.valueOf('\uf07c'));
        codePointMap_.put("icon-resize-vertical", Character.valueOf('\uf07d'));
        codePointMap_.put("icon-resize-horizontal", Character.valueOf('\uf07e'));
        codePointMap_.put("icon-bar-chart", Character.valueOf('\uf080'));
        codePointMap_.put("icon-twitter-sign", Character.valueOf('\uf081'));
        codePointMap_.put("icon-facebook-sign", Character.valueOf('\uf082'));
        codePointMap_.put("icon-camera-retro", Character.valueOf('\uf083'));
        codePointMap_.put("icon-key", Character.valueOf('\uf084'));
        codePointMap_.put("icon-cogs", Character.valueOf('\uf085'));
        codePointMap_.put("icon-comments", Character.valueOf('\uf086'));
        codePointMap_.put("icon-thumbs-up", Character.valueOf('\uf087'));
        codePointMap_.put("icon-thumbs-down", Character.valueOf('\uf088'));
        codePointMap_.put("icon-star-half", Character.valueOf('\uf089'));
        codePointMap_.put("icon-heart-empty", Character.valueOf('\uf08a'));
        codePointMap_.put("icon-signout", Character.valueOf('\uf08b'));
        codePointMap_.put("icon-linkedin-sign", Character.valueOf('\uf08c'));
        codePointMap_.put("icon-pushpin", Character.valueOf('\uf08d'));
        codePointMap_.put("icon-external-link", Character.valueOf('\uf08e'));
        codePointMap_.put("icon-signin", Character.valueOf('\uf090'));
        codePointMap_.put("icon-trophy", Character.valueOf('\uf091'));
        codePointMap_.put("icon-github-sign", Character.valueOf('\uf092'));
        codePointMap_.put("icon-upload-alt", Character.valueOf('\uf093'));
        codePointMap_.put("icon-lemon", Character.valueOf('\uf094'));
        codePointMap_.put("icon-phone", Character.valueOf('\uf095'));
        codePointMap_.put("icon-check-empty", Character.valueOf('\uf096'));
        codePointMap_.put("icon-bookmark-empty", Character.valueOf('\uf097'));
        codePointMap_.put("icon-phone-sign", Character.valueOf('\uf098'));
        codePointMap_.put("icon-twitter", Character.valueOf('\uf099'));
        codePointMap_.put("icon-facebook", Character.valueOf('\uf09a'));
        codePointMap_.put("icon-github", Character.valueOf('\uf09b'));
        codePointMap_.put("icon-unlock", Character.valueOf('\uf09c'));
        codePointMap_.put("icon-credit-card", Character.valueOf('\uf09d'));
        codePointMap_.put("icon-rss", Character.valueOf('\uf09e'));
        codePointMap_.put("icon-hdd", Character.valueOf('\uf0a0'));
        codePointMap_.put("icon-bullhorn", Character.valueOf('\uf0a1'));
        codePointMap_.put("icon-bell", Character.valueOf('\uf0a2'));
        codePointMap_.put("icon-certificate", Character.valueOf('\uf0a3'));
        codePointMap_.put("icon-hand-right", Character.valueOf('\uf0a4'));
        codePointMap_.put("icon-hand-left", Character.valueOf('\uf0a5'));
        codePointMap_.put("icon-hand-up", Character.valueOf('\uf0a6'));
        codePointMap_.put("icon-hand-down", Character.valueOf('\uf0a7'));
        codePointMap_.put("icon-circle-arrow-left", Character.valueOf('\uf0a8'));
        codePointMap_.put("icon-circle-arrow-right", Character.valueOf('\uf0a9'));
        codePointMap_.put("icon-circle-arrow-up", Character.valueOf('\uf0aa'));
        codePointMap_.put("icon-circle-arrow-down", Character.valueOf('\uf0ab'));
        codePointMap_.put("icon-globe", Character.valueOf('\uf0ac'));
        codePointMap_.put("icon-wrench", Character.valueOf('\uf0ad'));
        codePointMap_.put("icon-tasks", Character.valueOf('\uf0ae'));
        codePointMap_.put("icon-filter", Character.valueOf('\uf0b0'));
        codePointMap_.put("icon-briefcase", Character.valueOf('\uf0b1'));
        codePointMap_.put("icon-fullscreen", Character.valueOf('\uf0b2'));
        codePointMap_.put("icon-group", Character.valueOf('\uf0c0'));
        codePointMap_.put("icon-link", Character.valueOf('\uf0c1'));
        codePointMap_.put("icon-cloud", Character.valueOf('\uf0c2'));
        codePointMap_.put("icon-beaker", Character.valueOf('\uf0c3'));
        codePointMap_.put("icon-cut", Character.valueOf('\uf0c4'));
        codePointMap_.put("icon-copy", Character.valueOf('\uf0c5'));
        codePointMap_.put("icon-paper-clip", Character.valueOf('\uf0c6'));
        codePointMap_.put("icon-save", Character.valueOf('\uf0c7'));
        codePointMap_.put("icon-sign-blank", Character.valueOf('\uf0c8'));
        codePointMap_.put("icon-reorder", Character.valueOf('\uf0c9'));
        codePointMap_.put("icon-list-ul", Character.valueOf('\uf0ca'));
        codePointMap_.put("icon-list-ol", Character.valueOf('\uf0cb'));
        codePointMap_.put("icon-strikethrough", Character.valueOf('\uf0cc'));
        codePointMap_.put("icon-underline", Character.valueOf('\uf0cd'));
        codePointMap_.put("icon-table", Character.valueOf('\uf0ce'));
        codePointMap_.put("icon-magic", Character.valueOf('\uf0d0'));
        codePointMap_.put("icon-truck", Character.valueOf('\uf0d1'));
        codePointMap_.put("icon-pinterest", Character.valueOf('\uf0d2'));
        codePointMap_.put("icon-pinterest-sign", Character.valueOf('\uf0d3'));
        codePointMap_.put("icon-google-plus-sign", Character.valueOf('\uf0d4'));
        codePointMap_.put("icon-google-plus", Character.valueOf('\uf0d5'));
        codePointMap_.put("icon-money", Character.valueOf('\uf0d6'));
        codePointMap_.put("icon-caret-down", Character.valueOf('\uf0d7'));
        codePointMap_.put("icon-caret-up", Character.valueOf('\uf0d8'));
        codePointMap_.put("icon-caret-left", Character.valueOf('\uf0d9'));
        codePointMap_.put("icon-caret-right", Character.valueOf('\uf0da'));
        codePointMap_.put("icon-columns", Character.valueOf('\uf0db'));
        codePointMap_.put("icon-sort", Character.valueOf('\uf0dc'));
        codePointMap_.put("icon-sort-down", Character.valueOf('\uf0dd'));
        codePointMap_.put("icon-sort-up", Character.valueOf('\uf0de'));
        codePointMap_.put("icon-envelope-alt", Character.valueOf('\uf0e0'));
        codePointMap_.put("icon-linkedin", Character.valueOf('\uf0e1'));
        codePointMap_.put("icon-undo", Character.valueOf('\uf0e2'));
        codePointMap_.put("icon-legal", Character.valueOf('\uf0e3'));
        codePointMap_.put("icon-dashboard", Character.valueOf('\uf0e4'));
        codePointMap_.put("icon-comment-alt", Character.valueOf('\uf0e5'));
        codePointMap_.put("icon-comments-alt", Character.valueOf('\uf0e6'));
        codePointMap_.put("icon-bolt", Character.valueOf('\uf0e7'));
        codePointMap_.put("icon-sitemap", Character.valueOf('\uf0e8'));
        codePointMap_.put("icon-umbrella", Character.valueOf('\uf0e9'));
        codePointMap_.put("icon-paste", Character.valueOf('\uf0ea'));
        codePointMap_.put("icon-user-md", Character.valueOf('\uf200'));
        codePointMap_.put("icon-missing-glyph", Character.valueOf('\u0000'));
    }
}

