/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.graphics;

import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.FontIcon;
import com.ge.med.iungo.graphics.PaddedIcon;
import com.ge.med.iungo.util.Fonts;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class CSSFontIcon
extends PaddedIcon {
    private static final Logger logger_ = Logger.getLogger(CSSFontIcon.class.getName());
    public Color color_ = null;
    private static Font defaultFont_ = null;
    private static Component dummyComponent_ = null;
    private static Map<String, Icon> cache_ = new LinkedHashMap<String, Icon>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Icon> e) {
            return this.size() > 1000;
        }
    };
    private static Map<String, Character> codePointMap_ = new TreeMap<String, Character>();
    private static Map<String, Dimension> sizeMap_;
    static JPanel p_;
    static String demoSize_;
    static Color[] demoColor_;
    static boolean reverse_;

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Component component = c;
        if (this.color_ != null) {
            component = CSSFontIcon.getDummyComponent();
            component.setForeground(this.color_);
        }
        super.paintIcon(component, g, x, y);
    }

    public CSSFontIcon(char codePoint, Dimension size) {
        super(new FontIcon(CSSFontIcon.getDefaultFont(), codePoint, size));
    }

    public CSSFontIcon(char codePoint, float fontSize, Dimension size) {
        super((Icon)new FontIcon(CSSFontIcon.getDefaultFont().deriveFont(fontSize), codePoint), size);
    }

    public CSSFontIcon(Font font, char codePoint, Insets insets) {
        super((Icon)new FontIcon(font, codePoint), insets);
    }

    public CSSFontIcon(String cssClass) {
        this(CSSFontIcon.getCodePoint(cssClass), CSSFontIcon.getSize(cssClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Font getDefaultFont() {
        if (defaultFont_ != null) return defaultFont_;
        Class<CSSFontIcon> clazz = CSSFontIcon.class;
        synchronized (CSSFontIcon.class) {
            if (defaultFont_ != null) return defaultFont_;
            defaultFont_ = Fonts.getFont(Arrays.asList("ge-iconography-webfont"), 0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultFont_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Component getDummyComponent() {
        if (dummyComponent_ != null) return dummyComponent_;
        Class<CSSFontIcon> clazz = CSSFontIcon.class;
        synchronized (CSSFontIcon.class) {
            if (dummyComponent_ != null) return dummyComponent_;
            dummyComponent_ = new Component(){};
            // ** MonitorExit[var0] (shouldn't be in output)
            return dummyComponent_;
        }
    }

    public static Icon getIcon(JComponent component, String cacheKey) {
        Icon icon = cache_.get(cacheKey);
        if (icon == null) {
            component.putClientProperty("css_cacheKey", cacheKey);
            BackgroundInfo info = CSS.getInfo(component);
            if (info.content != null && info.content.length() > 0 && info.font != null) {
                Font font = info.font;
                char codePoint = (char)info.content.codePointAt(0);
                Insets insets = Background.getInsets(info);
                icon = new CSSFontIcon(font, codePoint, insets);
                cache_.put(cacheKey, icon);
            }
        }
        return icon;
    }

    public static Icon getIcon(char codePoint, float fontSize, Dimension size) {
        String cacheKey = "" + codePoint + "}" + fontSize + "|" + size;
        Icon icon = cache_.get(cacheKey);
        if (icon == null) {
            icon = new CSSFontIcon(codePoint, fontSize, size);
            cache_.put(cacheKey, icon);
        }
        return icon;
    }

    private static char getCodePoint(String cssClass) {
        for (String cssc : cssClass.split(" ")) {
            Character c = codePointMap_.get(cssc);
            if (c == null) continue;
            return c.charValue();
        }
        return codePointMap_.get("missing-glyph").charValue();
    }

    private static Dimension getSize(String cssClass) {
        String cssc;
        Dimension d = null;
        String[] arr$ = cssClass.split(" ");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (d = sizeMap_.get(cssc = arr$[i$])) == null; ++i$) {
        }
        if (d == null) {
            d = sizeMap_.get("icon-default");
            logger_.log(Level.FINE, "size set to icon-default");
        }
        return d;
    }

    public static Set<String> getIconNames() {
        return codePointMap_.keySet();
    }

    public static void main(String[] argv) throws Exception {
        try {
            UIManager.setLookAndFeel("com.ge.med.iungo.laf.HDxLightsOnLookAndFeel");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JPanel pp = new JPanel(new FlowLayout(0, 10, 10));
        final JComboBox<Object> size = new JComboBox<Object>(new Object[]{"icon-default", "icon-large", "icon-huge", "icon-colossal", "icon-gargantuan"});
        pp.add(size);
        size.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                demoSize_ = "" + size.getSelectedItem();
                CSSFontIcon.updateUI();
            }
        });
        final JComboBox<Object> color = new JComboBox<Object>(new Object[]{"plain", "fancy", "painful", "tasteless"});
        pp.add(color);
        color.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                switch ("" + color.getSelectedItem()) {
                    case "plain": {
                        demoColor_ = new Color[]{Color.black, Color.white};
                        break;
                    }
                    case "fancy": {
                        demoColor_ = new Color[]{new Color(0x333366), new Color(0xDDDDFF)};
                        break;
                    }
                    case "painful": {
                        demoColor_ = new Color[]{Color.magenta, Color.green};
                        break;
                    }
                    case "tasteless": {
                        demoColor_ = new Color[]{Color.magenta.darker(), Color.pink};
                    }
                }
                CSSFontIcon.updateUI();
            }
        });
        JCheckBox reverse = new JCheckBox("reverse", false);
        pp.add(reverse);
        reverse.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                reverse_ = !reverse_;
                CSSFontIcon.updateUI();
            }
        });
        f.add((Component)pp, "North");
        p_ = new JPanel(new FlowLayout(0, 20, 10));
        p_.setPreferredSize(new Dimension(1600, 9999));
        for (String k : CSSFontIcon.getIconNames()) {
            char c = codePointMap_.get(k).charValue();
            if (CSSFontIcon.getDefaultFont().canDisplay(c)) {
                CSSFontIcon i = new CSSFontIcon(k);
                JLabel l = new JLabel(k, i, 4);
                l.setFont(null);
                l.setForeground(null);
                l.setBackground(null);
                p_.add(l);
                continue;
            }
            System.out.println("Can't display " + k);
        }
        f.add(new JScrollPane(p_));
        f.pack();
        f.setVisible(true);
    }

    private static void updateUI() {
        p_.setBackground(demoColor_[reverse_ ? 0 : 1]);
        for (Component c : p_.getComponents()) {
            try {
                JLabel l = (JLabel)c;
                l.setForeground(demoColor_[reverse_ ? 1 : 0]);
                l.setIcon(new CSSFontIcon(l.getText() + " " + demoSize_));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    static {
        codePointMap_.put("icon-ico_3d_sq_lg", Character.valueOf('\uf100'));
        codePointMap_.put("icon-ico_3d_sq_sm", Character.valueOf('\uf101'));
        codePointMap_.put("icon-ico_add_rnd_lg", Character.valueOf('\uf102'));
        codePointMap_.put("icon-plus-sign", Character.valueOf('\uf103'));
        codePointMap_.put("icon-ico_advancedstatistics_sq_lg", Character.valueOf('\uf104'));
        codePointMap_.put("icon-ico_advancedstatistics_sq_sm", Character.valueOf('\uf105'));
        codePointMap_.put("icon-ico_alcohol_lg", Character.valueOf('\uf106'));
        codePointMap_.put("icon-ico_alcohol_sm", Character.valueOf('\uf107'));
        codePointMap_.put("icon-ico_alert_lg", Character.valueOf('\uf108'));
        codePointMap_.put("icon-warning-sign", Character.valueOf('\uf109'));
        codePointMap_.put("icon-ico_aligncenter_lg", Character.valueOf('\uf10a'));
        codePointMap_.put("icon-align-center", Character.valueOf('\uf10b'));
        codePointMap_.put("icon-ico_alignjustify_lg", Character.valueOf('\uf10c'));
        codePointMap_.put("icon-align-justify", Character.valueOf('\uf10d'));
        codePointMap_.put("icon-ico_alignleft_lg", Character.valueOf('\uf10e'));
        codePointMap_.put("icon-align-left", Character.valueOf('\uf10f'));
        codePointMap_.put("icon-ico_alignright_lg", Character.valueOf('\uf110'));
        codePointMap_.put("icon-align-right", Character.valueOf('\uf111'));
        codePointMap_.put("icon-ico_allergy_sq_lg", Character.valueOf('\uf112'));
        codePointMap_.put("icon-ico_allergy_sq_sm", Character.valueOf('\uf113'));
        codePointMap_.put("icon-ico_ambulance_lg", Character.valueOf('\uf114'));
        codePointMap_.put("icon-ambulance", Character.valueOf('\uf115'));
        codePointMap_.put("icon-ico_annotate_sq_lg", Character.valueOf('\uf116'));
        codePointMap_.put("icon-ico_annotate_sq_sm", Character.valueOf('\uf117'));
        codePointMap_.put("icon-ico_areazoom_lg", Character.valueOf('\uf118'));
        codePointMap_.put("icon-ico_areazoom_sm", Character.valueOf('\uf119'));
        codePointMap_.put("icon-ico_aro_navdown_lg", Character.valueOf('\uf11a'));
        codePointMap_.put("icon-caret-down", Character.valueOf('\uf11b'));
        codePointMap_.put("icon-ico_aro_rewind_rnd_lg", Character.valueOf('\uf11c'));
        codePointMap_.put("icon-backward", Character.valueOf('\uf11d'));
        codePointMap_.put("icon-ico_attachment_lg", Character.valueOf('\uf11e'));
        codePointMap_.put("icon-paper-clip", Character.valueOf('\uf11f'));
        codePointMap_.put("icon-ico_audioclip_lg", Character.valueOf('\uf120'));
        codePointMap_.put("icon-ico_audioclip_sm", Character.valueOf('\uf121'));
        codePointMap_.put("icon-ico_backtobeginning_rnd_lg", Character.valueOf('\uf122'));
        codePointMap_.put("icon-step-backward", Character.valueOf('\uf123'));
        codePointMap_.put("icon-ico_ban1_lg", Character.valueOf('\uf124'));
        codePointMap_.put("icon-ban-circle", Character.valueOf('\uf125'));
        codePointMap_.put("icon-ico_ban2_rnd_lg", Character.valueOf('\uf126'));
        codePointMap_.put("icon-ico_ban2_rnd_sm", Character.valueOf('\uf127'));
        codePointMap_.put("icon-ico_bandage_lg", Character.valueOf('\uf128'));
        codePointMap_.put("icon-ico_battery100_lg", Character.valueOf('\uf129'));
        codePointMap_.put("icon-ico_battery100_sm", Character.valueOf('\uf12a'));
        codePointMap_.put("icon-ico_battery25_lg", Character.valueOf('\uf12b'));
        codePointMap_.put("icon-ico_battery25_sm", Character.valueOf('\uf12c'));
        codePointMap_.put("icon-ico_battery50_lg", Character.valueOf('\uf12d'));
        codePointMap_.put("icon-ico_battery50_sm", Character.valueOf('\uf12e'));
        codePointMap_.put("icon-ico_battery5less_lg", Character.valueOf('\uf12f'));
        codePointMap_.put("icon-ico_battery5less_sm", Character.valueOf('\uf130'));
        codePointMap_.put("icon-ico_battery75_lg", Character.valueOf('\uf131'));
        codePointMap_.put("icon-ico_battery75_sm", Character.valueOf('\uf132'));
        codePointMap_.put("icon-ico_batterycharging_lg", Character.valueOf('\uf133'));
        codePointMap_.put("icon-ico_batterycharging_sm", Character.valueOf('\uf134'));
        codePointMap_.put("icon-ico_bell_lg", Character.valueOf('\uf135'));
        codePointMap_.put("icon-bell-alt", Character.valueOf('\uf136'));
        codePointMap_.put("icon-ico_beverage_lg", Character.valueOf('\uf137'));
        codePointMap_.put("icon-ico_beverage_sm", Character.valueOf('\uf138'));
        codePointMap_.put("icon-ico_blackwhite_lg", Character.valueOf('\uf139'));
        codePointMap_.put("icon-ico_blackwhite_sm", Character.valueOf('\uf13a'));
        codePointMap_.put("icon-ico_bold_sq_lg", Character.valueOf('\uf13b'));
        codePointMap_.put("icon-bold", Character.valueOf('\uf13c'));
        codePointMap_.put("icon-ico_bolt_lg", Character.valueOf('\uf13d'));
        codePointMap_.put("icon-bolt", Character.valueOf('\uf13e'));
        codePointMap_.put("icon-ico_book_lg", Character.valueOf('\uf13f'));
        codePointMap_.put("icon-book", Character.valueOf('\uf140'));
        codePointMap_.put("icon-ico_bookmark_lg", Character.valueOf('\uf141'));
        codePointMap_.put("icon-bookmark", Character.valueOf('\uf142'));
        codePointMap_.put("icon-ico_bookmarklist_lg", Character.valueOf('\uf143'));
        codePointMap_.put("icon-ico_bookmarklist_sm", Character.valueOf('\uf144'));
        codePointMap_.put("icon-ico_brightness_lg", Character.valueOf('\uf145'));
        codePointMap_.put("icon-ico_brightness_sm", Character.valueOf('\uf146'));
        codePointMap_.put("icon-ico_brush_lg", Character.valueOf('\uf147'));
        codePointMap_.put("icon-ico_brush_sm", Character.valueOf('\uf148'));
        codePointMap_.put("icon-ico_bug_lg", Character.valueOf('\uf149'));
        codePointMap_.put("icon-ico_bug_sm", Character.valueOf('\uf14a'));
        codePointMap_.put("icon-ico_bullhorn_lg", Character.valueOf('\uf14b'));
        codePointMap_.put("icon-bullhorn", Character.valueOf('\uf14c'));
        codePointMap_.put("icon-ico_calculator1_lg", Character.valueOf('\uf14d'));
        codePointMap_.put("icon-ico_calculator1_sm", Character.valueOf('\uf14e'));
        codePointMap_.put("icon-ico_calculator2_lg", Character.valueOf('\uf14f'));
        codePointMap_.put("icon-ico_calculator2_sm", Character.valueOf('\uf150'));
        codePointMap_.put("icon-ico_calendar_lg", Character.valueOf('\uf151'));
        codePointMap_.put("icon-calendar", Character.valueOf('\uf152'));
        codePointMap_.put("icon-ico_camera_lg", Character.valueOf('\uf153'));
        codePointMap_.put("icon-camera", Character.valueOf('\uf154'));
        codePointMap_.put("icon-ico_cardioeditor_lg", Character.valueOf('\uf155'));
        codePointMap_.put("icon-ico_cardioeditor_sm", Character.valueOf('\uf156'));
        codePointMap_.put("icon-ico_cardiorealmode_lg", Character.valueOf('\uf157'));
        codePointMap_.put("icon-ico_cardioschematicmode_lg", Character.valueOf('\uf158'));
        codePointMap_.put("icon-ico_cardioschematicmode_sm", Character.valueOf('\uf159'));
        codePointMap_.put("icon-ico_cardiovascular_sq_lg", Character.valueOf('\uf15a'));
        codePointMap_.put("icon-ico_cardiovascular_sq_sm", Character.valueOf('\uf15b'));
        codePointMap_.put("icon-ico_cart_lg", Character.valueOf('\uf15c'));
        codePointMap_.put("icon-shopping-cart", Character.valueOf('\uf15d'));
        codePointMap_.put("icon-ico_certificate_lg", Character.valueOf('\uf15e'));
        codePointMap_.put("icon-certificate", Character.valueOf('\uf15f'));
        codePointMap_.put("icon-ico_checkmark_rnd_lg", Character.valueOf('\uf160'));
        codePointMap_.put("icon-ok-sign", Character.valueOf('\uf161'));
        codePointMap_.put("icon-ico_cloud_lg", Character.valueOf('\uf162'));
        codePointMap_.put("icon-cloud", Character.valueOf('\uf163'));
        codePointMap_.put("icon-ico_clouddownload_lg", Character.valueOf('\uf164'));
        codePointMap_.put("icon-cloud-download", Character.valueOf('\uf165'));
        codePointMap_.put("icon-ico_cloudupload_lg", Character.valueOf('\uf166'));
        codePointMap_.put("icon-cloud-upload", Character.valueOf('\uf167'));
        codePointMap_.put("icon-ico_color_lg", Character.valueOf('\uf168'));
        codePointMap_.put("icon-ico_color_sm", Character.valueOf('\uf169'));
        codePointMap_.put("icon-ico_colorbground_lg", Character.valueOf('\uf16a'));
        codePointMap_.put("icon-ico_colorbground_sm", Character.valueOf('\uf16b'));
        codePointMap_.put("icon-ico_colorfont_lg", Character.valueOf('\uf16c'));
        codePointMap_.put("icon-ico_colorfont_sm", Character.valueOf('\uf16d'));
        codePointMap_.put("icon-ico_column_lg", Character.valueOf('\uf16e'));
        codePointMap_.put("icon-columns", Character.valueOf('\uf16f'));
        codePointMap_.put("icon-ico_command_sq_lg", Character.valueOf('\uf170'));
        codePointMap_.put("icon-ico_command_sq_sm", Character.valueOf('\uf171'));
        codePointMap_.put("icon-ico_comment_lg", Character.valueOf('\uf172'));
        codePointMap_.put("icon-comment", Character.valueOf('\uf173'));
        codePointMap_.put("icon-ico_comments_lg", Character.valueOf('\uf174'));
        codePointMap_.put("icon-comments", Character.valueOf('\uf175'));
        codePointMap_.put("icon-ico_connect_lg", Character.valueOf('\uf176'));
        codePointMap_.put("icon-ico_connect_sm", Character.valueOf('\uf177'));
        codePointMap_.put("icon-ico_connect_sq_lg", Character.valueOf('\uf178'));
        codePointMap_.put("icon-ico_connect_sq_sm", Character.valueOf('\uf179'));
        codePointMap_.put("icon-ico_contacts_lg", Character.valueOf('\uf17a'));
        codePointMap_.put("icon-ico_contacts_sm", Character.valueOf('\uf17b'));
        codePointMap_.put("icon-ico_contract_lg", Character.valueOf('\uf17c'));
        codePointMap_.put("icon-ico_contract_sm", Character.valueOf('\uf17d'));
        codePointMap_.put("icon-ico_contrast_lg", Character.valueOf('\uf17e'));
        codePointMap_.put("icon-adjust", Character.valueOf('\uf17f'));
        codePointMap_.put("icon-ico_controlcharacters_sq_lg", Character.valueOf('\uf180'));
        codePointMap_.put("icon-ico_controlcharacters_sq_sm", Character.valueOf('\uf181'));
        codePointMap_.put("icon-ico_copy_lg", Character.valueOf('\uf182'));
        codePointMap_.put("icon-copy", Character.valueOf('\uf183'));
        codePointMap_.put("icon-ico_cross_rnd_lg", Character.valueOf('\uf184'));
        codePointMap_.put("icon-remove-sign", Character.valueOf('\uf185'));
        codePointMap_.put("icon-ico_crossreference_lg", Character.valueOf('\uf186'));
        codePointMap_.put("icon-ico_crossreference_sm", Character.valueOf('\uf187'));
        codePointMap_.put("icon-ico_cut_lg", Character.valueOf('\uf188'));
        codePointMap_.put("icon-cut", Character.valueOf('\uf189'));
        codePointMap_.put("icon-ico_dashboard_lg", Character.valueOf('\uf18a'));
        codePointMap_.put("icon-dashboard", Character.valueOf('\uf18b'));
        codePointMap_.put("icon-ico_data_lg", Character.valueOf('\uf18c'));
        codePointMap_.put("icon-ico_data_sm", Character.valueOf('\uf18d'));
        codePointMap_.put("icon-ico_delete_lg", Character.valueOf('\uf18e'));
        codePointMap_.put("icon-trash", Character.valueOf('\uf18f'));
        codePointMap_.put("icon-ico_delivery_lg", Character.valueOf('\uf190'));
        codePointMap_.put("icon-truck", Character.valueOf('\uf191'));
        codePointMap_.put("icon-ico_desktop_lg", Character.valueOf('\uf192'));
        codePointMap_.put("icon-desktop", Character.valueOf('\uf193'));
        codePointMap_.put("icon-ico_diagnosis_lg", Character.valueOf('\uf194'));
        codePointMap_.put("icon-ico_diagnosis_sm", Character.valueOf('\uf195'));
        codePointMap_.put("icon-ico_digestive_sq_lg", Character.valueOf('\uf196'));
        codePointMap_.put("icon-ico_digestive_sq_sm", Character.valueOf('\uf197'));
        codePointMap_.put("icon-ico_disability_lg", Character.valueOf('\uf198'));
        codePointMap_.put("icon-ico_disability_sm", Character.valueOf('\uf199'));
        codePointMap_.put("icon-ico_diskspace_lg", Character.valueOf('\uf19a'));
        codePointMap_.put("icon-hdd", Character.valueOf('\uf19b'));
        codePointMap_.put("icon-ico_displayreset_sq_lg", Character.valueOf('\uf19c'));
        codePointMap_.put("icon-ico_displayreset_sq_sm", Character.valueOf('\uf19d'));
        codePointMap_.put("icon-ico_displaysettings_lg", Character.valueOf('\uf19e'));
        codePointMap_.put("icon-ico_displaysettings_sm", Character.valueOf('\uf19f'));
        codePointMap_.put("icon-ico_doctor_lg", Character.valueOf('\uf1a0'));
        codePointMap_.put("icon-user-md", Character.valueOf('\uf1a1'));
        codePointMap_.put("icon-ico_documents_lg", Character.valueOf('\uf1a2'));
        codePointMap_.put("icon-ico_documents_sm", Character.valueOf('\uf1a3'));
        codePointMap_.put("icon-ico_download_lg", Character.valueOf('\uf1a4'));
        codePointMap_.put("icon-download-alt", Character.valueOf('\uf1a5'));
        codePointMap_.put("icon-ico_drawarc_lg", Character.valueOf('\uf1a6'));
        codePointMap_.put("icon-ico_drawarc_sm", Character.valueOf('\uf1a7'));
        codePointMap_.put("icon-ico_drawingtools_lg", Character.valueOf('\uf1a8'));
        codePointMap_.put("icon-ico_drawingtools_sm", Character.valueOf('\uf1a9'));
        codePointMap_.put("icon-ico_drawline_lg", Character.valueOf('\uf1aa'));
        codePointMap_.put("icon-ico_drawline_sm", Character.valueOf('\uf1ab'));
        codePointMap_.put("icon-ico_drawshape_lg", Character.valueOf('\uf1ac'));
        codePointMap_.put("icon-ico_drawshape_sm", Character.valueOf('\uf1ad'));
        codePointMap_.put("icon-ico_edit_lg", Character.valueOf('\uf1ae'));
        codePointMap_.put("icon-edit", Character.valueOf('\uf1af'));
        codePointMap_.put("icon-ico_endocrinological_sq_lg", Character.valueOf('\uf1b0'));
        codePointMap_.put("icon-ico_endocrinological_sq_sm", Character.valueOf('\uf1b1'));
        codePointMap_.put("icon-ico_error_lg", Character.valueOf('\uf1b2'));
        codePointMap_.put("icon-remove-circle", Character.valueOf('\uf1b3'));
        codePointMap_.put("icon-ico_ethnicity_lg", Character.valueOf('\uf1b4'));
        codePointMap_.put("icon-ico_ethnicity_sm", Character.valueOf('\uf1b5'));
        codePointMap_.put("icon-ico_exam_lg", Character.valueOf('\uf1b6'));
        codePointMap_.put("icon-stethoscope", Character.valueOf('\uf1b7'));
        codePointMap_.put("icon-ico_exercise1_lg", Character.valueOf('\uf1b8'));
        codePointMap_.put("icon-ico_exercise1_sm", Character.valueOf('\uf1b9'));
        codePointMap_.put("icon-ico_exercise2_lg", Character.valueOf('\uf1ba'));
        codePointMap_.put("icon-ico_exercise2_sm", Character.valueOf('\uf1bb'));
        codePointMap_.put("icon-external-link", Character.valueOf('\uf1bc'));
        codePointMap_.put("icon-ico_facebook_sq_lg", Character.valueOf('\uf1bd'));
        codePointMap_.put("icon-facebook-sign", Character.valueOf('\uf1be'));
        codePointMap_.put("icon-ico_factory_lg", Character.valueOf('\uf1bf'));
        codePointMap_.put("icon-ico_factory_sm", Character.valueOf('\uf1c0'));
        codePointMap_.put("icon-ico_fastforward_rnd_lg", Character.valueOf('\uf1c1'));
        codePointMap_.put("icon-fast-forward", Character.valueOf('\uf1c2'));
        codePointMap_.put("icon-ico_fax_lg", Character.valueOf('\uf1c3'));
        codePointMap_.put("icon-ico_fax_sm", Character.valueOf('\uf1c4'));
        codePointMap_.put("icon-ico_feed_lg", Character.valueOf('\uf1c5'));
        codePointMap_.put("icon-rss", Character.valueOf('\uf1c6'));
        codePointMap_.put("icon-ico_feed_sq_lg", Character.valueOf('\uf1c7'));
        codePointMap_.put("icon-ico_feed_sq_sm", Character.valueOf('\uf1c8'));
        codePointMap_.put("icon-ico_female_lg", Character.valueOf('\uf1c9'));
        codePointMap_.put("icon-ico_female_sm", Character.valueOf('\uf1ca'));
        codePointMap_.put("icon-ico_filter_lg", Character.valueOf('\uf1cb'));
        codePointMap_.put("icon-filter", Character.valueOf('\uf1cc'));
        codePointMap_.put("icon-ico_fittodisplay_lg", Character.valueOf('\uf1cd'));
        codePointMap_.put("icon-ico_fittodisplay_sm", Character.valueOf('\uf1ce'));
        codePointMap_.put("icon-ico_flag_lg", Character.valueOf('\uf1cf'));
        codePointMap_.put("icon-flag", Character.valueOf('\uf1d0'));
        codePointMap_.put("icon-ico_fliphorizontal_lg", Character.valueOf('\uf1d1'));
        codePointMap_.put("icon-ico_fliphorizontal_sm", Character.valueOf('\uf1d2'));
        codePointMap_.put("icon-ico_folder_lg", Character.valueOf('\uf1d3'));
        codePointMap_.put("icon-folder-close", Character.valueOf('\uf1d4'));
        codePointMap_.put("icon-ico_folderopen_lg", Character.valueOf('\uf1d5'));
        codePointMap_.put("icon-folder-open-alt", Character.valueOf('\uf1d6'));
        codePointMap_.put("icon-ico_font_sq_lg", Character.valueOf('\uf1d7'));
        codePointMap_.put("icon-font", Character.valueOf('\uf1d8'));
        codePointMap_.put("icon-ico_fooddiet_sq_lg", Character.valueOf('\uf1d9'));
        codePointMap_.put("icon-food", Character.valueOf('\uf1da'));
        codePointMap_.put("icon-ico_footer_lg", Character.valueOf('\uf1db'));
        codePointMap_.put("icon-ico_footer_sm", Character.valueOf('\uf1dc'));
        codePointMap_.put("icon-ico_form1_lg", Character.valueOf('\uf1dd'));
        codePointMap_.put("icon-file", Character.valueOf('\uf1de'));
        codePointMap_.put("icon-ico_form2_lg", Character.valueOf('\uf1df'));
        codePointMap_.put("icon-file-alt", Character.valueOf('\uf1e0'));
        codePointMap_.put("icon-ico_frame_lg", Character.valueOf('\uf1e1'));
        codePointMap_.put("icon-ico_frame_sm", Character.valueOf('\uf1e2'));
        codePointMap_.put("icon-ico_freeroi_lg", Character.valueOf('\uf1e3'));
        codePointMap_.put("icon-ico_freeroi_sm", Character.valueOf('\uf1e4'));
        codePointMap_.put("icon-ico_fuel_lg", Character.valueOf('\uf1e5'));
        codePointMap_.put("icon-ico_fuel_sm", Character.valueOf('\uf1e6'));
        codePointMap_.put("icon-ico_fullscreen_lg", Character.valueOf('\uf1e7'));
        codePointMap_.put("icon-fullscreen", Character.valueOf('\uf1e8'));
        codePointMap_.put("icon-ico_function_sq_lg", Character.valueOf('\uf1e9'));
        codePointMap_.put("icon-ico_function_sq_sm", Character.valueOf('\uf1ea'));
        codePointMap_.put("icon-ico_game_lg", Character.valueOf('\uf1eb'));
        codePointMap_.put("icon-ico_game_sm", Character.valueOf('\uf1ec'));
        codePointMap_.put("icon-ico_genetics_lg", Character.valueOf('\uf1ed'));
        codePointMap_.put("icon-ico_genetics_sm", Character.valueOf('\uf1ee'));
        codePointMap_.put("icon-ico_genetics_sq_lg", Character.valueOf('\uf1ef'));
        codePointMap_.put("icon-ico_genetics_sq_sm", Character.valueOf('\uf1f0'));
        codePointMap_.put("icon-ico_googleplus_sq_lg", Character.valueOf('\uf1f1'));
        codePointMap_.put("icon-google-plus-sign", Character.valueOf('\uf1f2'));
        codePointMap_.put("icon-ico_gps_lg", Character.valueOf('\uf1f3'));
        codePointMap_.put("icon-ico_gps_sm", Character.valueOf('\uf1f4'));
        codePointMap_.put("icon-ico_hazard_lg", Character.valueOf('\uf1f5'));
        codePointMap_.put("icon-ico_hazard_sm", Character.valueOf('\uf1f6'));
        codePointMap_.put("icon-ico_header_lg", Character.valueOf('\uf1f7'));
        codePointMap_.put("icon-ico_header_sm", Character.valueOf('\uf1f8'));
        codePointMap_.put("icon-ico_heart_lg", Character.valueOf('\uf1f9'));
        codePointMap_.put("icon-heart", Character.valueOf('\uf1fa'));
        codePointMap_.put("icon-ico_height_lg", Character.valueOf('\uf1fb'));
        codePointMap_.put("icon-ico_height_sm", Character.valueOf('\uf1fc'));
        codePointMap_.put("icon-ico_help_rnd_lg", Character.valueOf('\uf1fd'));
        codePointMap_.put("icon-question-sign", Character.valueOf('\uf1fe'));
        codePointMap_.put("icon-ico_history_lg", Character.valueOf('\uf1ff'));
        codePointMap_.put("icon-ico_history_sm", Character.valueOf('\uf200'));
        codePointMap_.put("icon-ico_home_lg", Character.valueOf('\uf201'));
        codePointMap_.put("icon-home", Character.valueOf('\uf202'));
        codePointMap_.put("icon-ico_hospital_lg", Character.valueOf('\uf203'));
        codePointMap_.put("icon-hospital", Character.valueOf('\uf204'));
        codePointMap_.put("icon-ico_hospitalsign_lg", Character.valueOf('\uf205'));
        codePointMap_.put("icon-h-sign", Character.valueOf('\uf206'));
        codePointMap_.put("icon-ico_IDcredentials_lg", Character.valueOf('\uf207'));
        codePointMap_.put("icon-ico_IDcredentials_sm", Character.valueOf('\uf208'));
        codePointMap_.put("icon-ico_image_generic_lg", Character.valueOf('\uf209'));
        codePointMap_.put("icon-ico_image_generic_sm", Character.valueOf('\uf20a'));
        codePointMap_.put("icon-ico_image_man_lg", Character.valueOf('\uf20b'));
        codePointMap_.put("icon-picture", Character.valueOf('\uf20c'));
        codePointMap_.put("icon-ico_image_woman_lg", Character.valueOf('\uf20d'));
        codePointMap_.put("icon-ico_image_woman_sm", Character.valueOf('\uf20e'));
        codePointMap_.put("icon-ico_inbox_lg", Character.valueOf('\uf20f'));
        codePointMap_.put("icon-inbox", Character.valueOf('\uf210'));
        codePointMap_.put("icon-ico_indentleft_lg", Character.valueOf('\uf211'));
        codePointMap_.put("icon-indent-left", Character.valueOf('\uf212'));
        codePointMap_.put("icon-ico_indentright_lg", Character.valueOf('\uf213'));
        codePointMap_.put("icon-indent-right", Character.valueOf('\uf214'));
        codePointMap_.put("icon-ico_index_lg", Character.valueOf('\uf215'));
        codePointMap_.put("icon-ico_index_sm", Character.valueOf('\uf216'));
        codePointMap_.put("icon-ico_info_rnd_lg", Character.valueOf('\uf217'));
        codePointMap_.put("icon-info-sign", Character.valueOf('\uf218'));
        codePointMap_.put("icon-ico_inhalant_lg", Character.valueOf('\uf219'));
        codePointMap_.put("icon-ico_inhalant_sm", Character.valueOf('\uf21a'));
        codePointMap_.put("icon-ico_intravenous_lg", Character.valueOf('\uf21b'));
        codePointMap_.put("icon-ico_intravenous_sm", Character.valueOf('\uf21c'));
        codePointMap_.put("icon-ico_inventory_lg", Character.valueOf('\uf21d'));
        codePointMap_.put("icon-ico_inventory_sm", Character.valueOf('\uf21e'));
        codePointMap_.put("icon-ico_invertgreyscale_lg", Character.valueOf('\uf21f'));
        codePointMap_.put("icon-ico_invertgreyscale_sm", Character.valueOf('\uf220'));
        codePointMap_.put("icon-ico_invoice_lg", Character.valueOf('\uf221'));
        codePointMap_.put("icon-ico_invoice_sm", Character.valueOf('\uf222'));
        codePointMap_.put("icon-ico_italic_sq_lg", Character.valueOf('\uf223'));
        codePointMap_.put("icon-italic", Character.valueOf('\uf224'));
        codePointMap_.put("icon-ico_key1_lg", Character.valueOf('\uf225'));
        codePointMap_.put("icon-key", Character.valueOf('\uf226'));
        codePointMap_.put("icon-ico_key2_lg", Character.valueOf('\uf227'));
        codePointMap_.put("icon-ico_key2_sm", Character.valueOf('\uf228'));
        codePointMap_.put("icon-ico_keyframe_lg", Character.valueOf('\uf229'));
        codePointMap_.put("icon-ico_keyframe_sm", Character.valueOf('\uf22a'));
        codePointMap_.put("icon-ico_lab1_lg", Character.valueOf('\uf22b'));
        codePointMap_.put("icon-ico_lab1_sm", Character.valueOf('\uf22c'));
        codePointMap_.put("icon-ico_lab2_lg", Character.valueOf('\uf22d'));
        codePointMap_.put("icon-beaker", Character.valueOf('\uf22e'));
        codePointMap_.put("icon-ico_language_lg", Character.valueOf('\uf22f'));
        codePointMap_.put("icon-ico_language_sm", Character.valueOf('\uf230'));
        codePointMap_.put("icon-ico_layoutmultipleview1_lg", Character.valueOf('\uf231'));
        codePointMap_.put("icon-ico_layoutmultipleview1_sm", Character.valueOf('\uf232'));
        codePointMap_.put("icon-ico_layoutmultipleview2_lg", Character.valueOf('\uf233'));
        codePointMap_.put("icon-ico_layoutmultipleview2_sm", Character.valueOf('\uf234'));
        codePointMap_.put("icon-ico_layoutnoview_lg", Character.valueOf('\uf235'));
        codePointMap_.put("icon-ico_layoutnoview_sm", Character.valueOf('\uf236'));
        codePointMap_.put("icon-ico_leaf_lg", Character.valueOf('\uf237'));
        codePointMap_.put("icon-leaf", Character.valueOf('\uf238'));
        codePointMap_.put("icon-ico_legalgovt_lg", Character.valueOf('\uf239'));
        codePointMap_.put("icon-legal", Character.valueOf('\uf23a'));
        codePointMap_.put("icon-ico_lightbulb_lg", Character.valueOf('\uf23b'));
        codePointMap_.put("icon-lightbulb", Character.valueOf('\uf23c'));
        codePointMap_.put("icon-ico_link_lg", Character.valueOf('\uf23d'));
        codePointMap_.put("icon-link", Character.valueOf('\uf23e'));
        codePointMap_.put("icon-ico_linkedin_sq_lg", Character.valueOf('\uf23f'));
        codePointMap_.put("icon-linkedin-sign", Character.valueOf('\uf240'));
        codePointMap_.put("icon-ico_listol_lg", Character.valueOf('\uf241'));
        codePointMap_.put("icon-list-ol", Character.valueOf('\uf242'));
        codePointMap_.put("icon-ico_listul_lg", Character.valueOf('\uf243'));
        codePointMap_.put("icon-th-list", Character.valueOf('\uf244'));
        codePointMap_.put("icon-ico_localizerline_sq_lg", Character.valueOf('\uf245'));
        codePointMap_.put("icon-ico_localizerline_sq_sm", Character.valueOf('\uf246'));
        codePointMap_.put("icon-ico_lock_lg", Character.valueOf('\uf247'));
        codePointMap_.put("icon-lock", Character.valueOf('\uf248'));
        codePointMap_.put("icon-ico_login_lg", Character.valueOf('\uf249'));
        codePointMap_.put("icon-signin", Character.valueOf('\uf24a'));
        codePointMap_.put("icon-ico_logout_lg", Character.valueOf('\uf24b'));
        codePointMap_.put("icon-signout", Character.valueOf('\uf24c'));
        codePointMap_.put("icon-ico_magicwand_lg", Character.valueOf('\uf24d'));
        codePointMap_.put("icon-magic", Character.valueOf('\uf24e'));
        codePointMap_.put("icon-ico_magnet_lg", Character.valueOf('\uf24f'));
        codePointMap_.put("icon-magnet", Character.valueOf('\uf250'));
        codePointMap_.put("icon-ico_mail_lg", Character.valueOf('\uf251'));
        codePointMap_.put("icon-envelope-alt", Character.valueOf('\uf252'));
        codePointMap_.put("icon-ico_male_lg", Character.valueOf('\uf253'));
        codePointMap_.put("icon-ico_male_sm", Character.valueOf('\uf254'));
        codePointMap_.put("icon-ico_map_lg", Character.valueOf('\uf255'));
        codePointMap_.put("icon-ico_map_sm", Character.valueOf('\uf256'));
        codePointMap_.put("icon-ico_mapmarker_lg", Character.valueOf('\uf257'));
        codePointMap_.put("icon-map-marker", Character.valueOf('\uf258'));
        codePointMap_.put("icon-ico_measureangle_lg", Character.valueOf('\uf259'));
        codePointMap_.put("icon-ico_measureangle_sm", Character.valueOf('\uf25a'));
        codePointMap_.put("icon-ico_measurecalibration_lg", Character.valueOf('\uf25b'));
        codePointMap_.put("icon-ico_measurecalibration_sm", Character.valueOf('\uf25c'));
        codePointMap_.put("icon-ico_measuredistance_lg", Character.valueOf('\uf25d'));
        codePointMap_.put("icon-ico_measuredistance_sm", Character.valueOf('\uf25e'));
        codePointMap_.put("icon-ico_medicalkit_lg", Character.valueOf('\uf25f'));
        codePointMap_.put("icon-medkit", Character.valueOf('\uf260'));
        codePointMap_.put("icon-ico_medication_lg", Character.valueOf('\uf261'));
        codePointMap_.put("icon-ico_medication_sm", Character.valueOf('\uf262'));
        codePointMap_.put("icon-ico_medschedule_lg", Character.valueOf('\uf263'));
        codePointMap_.put("icon-ico_medschedule_sm", Character.valueOf('\uf264'));
        codePointMap_.put("icon-ico_module_lg", Character.valueOf('\uf265'));
        codePointMap_.put("icon-ico_module_sm", Character.valueOf('\uf266'));
        codePointMap_.put("icon-ico_modules_lg", Character.valueOf('\uf267'));
        codePointMap_.put("icon-ico_modules_sm", Character.valueOf('\uf268'));
        codePointMap_.put("icon-ico_moneydollar_lg", Character.valueOf('\uf269'));
        codePointMap_.put("icon-money", Character.valueOf('\uf26a'));
        codePointMap_.put("icon-ico_moneyeuro_lg", Character.valueOf('\uf26b'));
        codePointMap_.put("icon-ico_moneyeuro_sm", Character.valueOf('\uf26c'));
        codePointMap_.put("icon-ico_moneypound_lg", Character.valueOf('\uf26d'));
        codePointMap_.put("icon-ico_moneypound_sm", Character.valueOf('\uf26e'));
        codePointMap_.put("icon-ico_moneyyen_lg", Character.valueOf('\uf26f'));
        codePointMap_.put("icon-ico_moneyyen_sm", Character.valueOf('\uf270'));
        codePointMap_.put("icon-ico_monitorsetting_lg", Character.valueOf('\uf271'));
        codePointMap_.put("icon-ico_monitorsetting_sm", Character.valueOf('\uf272'));
        codePointMap_.put("icon-ico_moon_lg", Character.valueOf('\uf273'));
        codePointMap_.put("icon-ico_moon_sm", Character.valueOf('\uf274'));
        codePointMap_.put("icon-ico_multiplanar_lg", Character.valueOf('\uf275'));
        codePointMap_.put("icon-ico_multiplanar_sm", Character.valueOf('\uf276'));
        codePointMap_.put("icon-ico_muscular_sq_lg", Character.valueOf('\uf277'));
        codePointMap_.put("icon-ico_muscular_sq_sm", Character.valueOf('\uf278'));
        codePointMap_.put("icon-ico_navigateright_rnd_lg", Character.valueOf('\uf279'));
        codePointMap_.put("icon-ico_navigateright_rnd_sm", Character.valueOf('\uf27a'));
        codePointMap_.put("icon-ico_nervous_sq_lg", Character.valueOf('\uf27b'));
        codePointMap_.put("icon-ico_nervous_sq_sm", Character.valueOf('\uf27c'));
        codePointMap_.put("icon-ico_nextstudy_lg", Character.valueOf('\uf27d'));
        codePointMap_.put("icon-ico_nextstudy_sm", Character.valueOf('\uf27e'));
        codePointMap_.put("icon-ico_nfc_lg", Character.valueOf('\uf27f'));
        codePointMap_.put("icon-ico_nfc_sm", Character.valueOf('\uf280'));
        codePointMap_.put("icon-ico_note_lg", Character.valueOf('\uf281'));
        codePointMap_.put("icon-ico_note_sm", Character.valueOf('\uf282'));
        codePointMap_.put("icon-ico_nurse_lg", Character.valueOf('\uf283'));
        codePointMap_.put("icon-ico_nurse_sm", Character.valueOf('\uf284'));
        codePointMap_.put("icon-ico_office_lg", Character.valueOf('\uf285'));
        codePointMap_.put("icon-ico_office_sm", Character.valueOf('\uf286'));
        codePointMap_.put("icon-ico_oralliquid_lg", Character.valueOf('\uf287'));
        codePointMap_.put("icon-ico_oralliquid_sm", Character.valueOf('\uf288'));
        codePointMap_.put("icon-ico_oralpill_lg", Character.valueOf('\uf289'));
        codePointMap_.put("icon-ico_oralpill_sm", Character.valueOf('\uf28a'));
        codePointMap_.put("icon-ico_oraltablet_lg", Character.valueOf('\uf28b'));
        codePointMap_.put("icon-ico_oraltablet_sm", Character.valueOf('\uf28c'));
        codePointMap_.put("icon-ico_ovalroi_lg", Character.valueOf('\uf28d'));
        codePointMap_.put("icon-ico_ovalroi_sm", Character.valueOf('\uf28e'));
        codePointMap_.put("icon-ico_palette_lg", Character.valueOf('\uf28f'));
        codePointMap_.put("icon-ico_palette_sm", Character.valueOf('\uf290'));
        codePointMap_.put("icon-ico_panarrow_lg", Character.valueOf('\uf291'));
        codePointMap_.put("icon-move", Character.valueOf('\uf292'));
        codePointMap_.put("icon-ico_panhand_lg", Character.valueOf('\uf293'));
        codePointMap_.put("icon-ico_panhand_sm", Character.valueOf('\uf294'));
        codePointMap_.put("icon-ico_partlycloudy_lg", Character.valueOf('\uf295'));
        codePointMap_.put("icon-ico_partlycloudy_sm", Character.valueOf('\uf296'));
        codePointMap_.put("icon-ico_paste_lg", Character.valueOf('\uf297'));
        codePointMap_.put("icon-paste", Character.valueOf('\uf298'));
        codePointMap_.put("icon-ico_pause_rnd_lg", Character.valueOf('\uf299'));
        codePointMap_.put("icon-pause", Character.valueOf('\uf29a'));
        codePointMap_.put("icon-ico_pen_lg", Character.valueOf('\uf29b'));
        codePointMap_.put("icon-ico_pen_sm", Character.valueOf('\uf29c'));
        codePointMap_.put("icon-ico_pharmacy_lg", Character.valueOf('\uf29d'));
        codePointMap_.put("icon-ico_pharmacy_sm", Character.valueOf('\uf29e'));
        codePointMap_.put("icon-ico_phone_lg", Character.valueOf('\uf29f'));
        codePointMap_.put("icon-ico_phone_sm", Character.valueOf('\uf2a0'));
        codePointMap_.put("icon-ico_pinterest_sq_lg", Character.valueOf('\uf2a1'));
        codePointMap_.put("icon-pinterest-sign", Character.valueOf('\uf2a2'));
        codePointMap_.put("icon-ico_pixellens_lg", Character.valueOf('\uf2a3'));
        codePointMap_.put("icon-screenshot", Character.valueOf('\uf2a4'));
        codePointMap_.put("icon-ico_plan_lg", Character.valueOf('\uf2a5'));
        codePointMap_.put("icon-ico_plan_sm", Character.valueOf('\uf2a6'));
        codePointMap_.put("icon-ico_plane_lg", Character.valueOf('\uf2a7'));
        codePointMap_.put("icon-plane", Character.valueOf('\uf2a8'));
        codePointMap_.put("icon-ico_play_rnd_lg", Character.valueOf('\uf2a9'));
        codePointMap_.put("icon-play", Character.valueOf('\uf2aa'));
        codePointMap_.put("icon-ico_polygonroi_lg", Character.valueOf('\uf2ab'));
        codePointMap_.put("icon-ico_position1_lg", Character.valueOf('\uf2ac'));
        codePointMap_.put("icon-ico_position1_sm", Character.valueOf('\uf2ad'));
        codePointMap_.put("icon-ico_position2_lg", Character.valueOf('\uf2ae'));
        codePointMap_.put("icon-ico_position2_sm", Character.valueOf('\uf2af'));
        codePointMap_.put("icon-ico_power_lg", Character.valueOf('\uf2b0'));
        codePointMap_.put("icon-ico_power_sm", Character.valueOf('\uf2b1'));
        codePointMap_.put("icon-ico_prescription_lg", Character.valueOf('\uf2b2'));
        codePointMap_.put("icon-ico_prescription_sm", Character.valueOf('\uf2b3'));
        codePointMap_.put("icon-ico_presentation_lg", Character.valueOf('\uf2b4'));
        codePointMap_.put("icon-ico_presentation_sm", Character.valueOf('\uf2b5'));
        codePointMap_.put("icon-ico_preview_lg", Character.valueOf('\uf2b6'));
        codePointMap_.put("icon-eye-open", Character.valueOf('\uf2b7'));
        codePointMap_.put("icon-ico_previousstudy_lg", Character.valueOf('\uf2b8'));
        codePointMap_.put("icon-ico_previousstudy_sm", Character.valueOf('\uf2b9'));
        codePointMap_.put("icon-ico_print_lg", Character.valueOf('\uf2ba'));
        codePointMap_.put("icon-print", Character.valueOf('\uf2bb'));
        codePointMap_.put("icon-ico_procedure_sq_lg", Character.valueOf('\uf2bc'));
        codePointMap_.put("icon-ico_procedure_sq_sm", Character.valueOf('\uf2bd'));
        codePointMap_.put("icon-ico_pushpin_lg", Character.valueOf('\uf2be'));
        codePointMap_.put("icon-pushpin", Character.valueOf('\uf2bf'));
        codePointMap_.put("icon-ico_quote_sq_lg", Character.valueOf('\uf2c0'));
        codePointMap_.put("icon-quote-right", Character.valueOf('\uf2c1'));
        codePointMap_.put("icon-ico_radioactive_lg", Character.valueOf('\uf2c2'));
        codePointMap_.put("icon-ico_radioactive_sm", Character.valueOf('\uf2c3'));
        codePointMap_.put("icon-ico_rainy_lg", Character.valueOf('\uf2c4'));
        codePointMap_.put("icon-ico_rainy_sm", Character.valueOf('\uf2c5'));
        codePointMap_.put("icon-ico_record_lg", Character.valueOf('\uf2c6'));
        codePointMap_.put("icon-ico_record_sm", Character.valueOf('\uf2c7'));
        codePointMap_.put("icon-ico_rectal_lg", Character.valueOf('\uf2c8'));
        codePointMap_.put("icon-ico_rectal_sm", Character.valueOf('\uf2c9'));
        codePointMap_.put("icon-ico_rectangleroi_lg", Character.valueOf('\uf2ca'));
        codePointMap_.put("icon-ico_rectangleroi_sm", Character.valueOf('\uf2cb'));
        codePointMap_.put("icon-ico_recycle_lg", Character.valueOf('\uf2cc'));
        codePointMap_.put("icon-ico_recycle_sm", Character.valueOf('\uf2cd'));
        codePointMap_.put("icon-ico_redo_rnd_lg", Character.valueOf('\uf2ce'));
        codePointMap_.put("icon-repeat", Character.valueOf('\uf2cf'));
        codePointMap_.put("icon-ico_refresh_rnd_lg", Character.valueOf('\uf2d0'));
        codePointMap_.put("icon-ico_refresh_rnd_sm", Character.valueOf('\uf2d1'));
        codePointMap_.put("icon-ico_religion_lg", Character.valueOf('\uf2d2'));
        codePointMap_.put("icon-ico_religion_sm", Character.valueOf('\uf2d3'));
        codePointMap_.put("icon-ico_replace_sq_lg", Character.valueOf('\uf2d4'));
        codePointMap_.put("icon-ico_replace_sq_sm", Character.valueOf('\uf2d5'));
        codePointMap_.put("icon-ico_reply_lg", Character.valueOf('\uf2d6'));
        codePointMap_.put("icon-reply", Character.valueOf('\uf2d7'));
        codePointMap_.put("icon-ico_reports_lg", Character.valueOf('\uf2d8'));
        codePointMap_.put("icon-ico_reproduction_lg", Character.valueOf('\uf2d9'));
        codePointMap_.put("icon-ico_reproduction_sm", Character.valueOf('\uf2da'));
        codePointMap_.put("icon-ico_reset_rnd_lg", Character.valueOf('\uf2db'));
        codePointMap_.put("icon-ico_reset_rnd_sm", Character.valueOf('\uf2dc'));
        codePointMap_.put("icon-ico_resizehorizontal_lg", Character.valueOf('\uf2dd'));
        codePointMap_.put("icon-resize-horizontal", Character.valueOf('\uf2de'));
        codePointMap_.put("icon-ico_resizevertical_lg", Character.valueOf('\uf2df'));
        codePointMap_.put("icon-resize-vertical", Character.valueOf('\uf2e0'));
        codePointMap_.put("icon-ico_respiratory_sq_lg", Character.valueOf('\uf2e1'));
        codePointMap_.put("icon-ico_respiratory_sq_sm", Character.valueOf('\uf2e2'));
        codePointMap_.put("icon-ico_rotate90_lg", Character.valueOf('\uf2e3'));
        codePointMap_.put("icon-ico_rotate90_sm", Character.valueOf('\uf2e4'));
        codePointMap_.put("icon-ico_rotate_lg", Character.valueOf('\uf2e5'));
        codePointMap_.put("icon-ico_rotate_sm", Character.valueOf('\uf2e6'));
        codePointMap_.put("icon-ico_route_lg", Character.valueOf('\uf2e7'));
        codePointMap_.put("icon-ico_route_sm", Character.valueOf('\uf2e8'));
        codePointMap_.put("icon-ico_save_lg", Character.valueOf('\uf2e9'));
        codePointMap_.put("icon-save", Character.valueOf('\uf2ea'));
        codePointMap_.put("icon-ico_scanneddoc_lg", Character.valueOf('\uf2eb'));
        codePointMap_.put("icon-ico_scanneddoc_sm", Character.valueOf('\uf2ec'));
        codePointMap_.put("icon-barcode", Character.valueOf('\uf2ed'));
        codePointMap_.put("icon-ico_scheduler1_lg", Character.valueOf('\uf2ee'));
        codePointMap_.put("icon-time", Character.valueOf('\uf2ef'));
        codePointMap_.put("icon-ico_scheduler2_lg", Character.valueOf('\uf2f0'));
        codePointMap_.put("icon-ico_scheduler2_sm", Character.valueOf('\uf2f1'));
        codePointMap_.put("icon-ico_scroll_lg", Character.valueOf('\uf2f2'));
        codePointMap_.put("icon-ico_scroll_rnd_lg", Character.valueOf('\uf2f3'));
        codePointMap_.put("icon-ico_scroll_rnd_sm", Character.valueOf('\uf2f4'));
        codePointMap_.put("icon-ico_scroll_sm", Character.valueOf('\uf2f5'));
        codePointMap_.put("icon-ico_search_lg", Character.valueOf('\uf2f6'));
        codePointMap_.put("icon-search", Character.valueOf('\uf2f7'));
        codePointMap_.put("icon-ico_security_lg", Character.valueOf('\uf2f8'));
        codePointMap_.put("icon-ico_security_sm", Character.valueOf('\uf2f9'));
        codePointMap_.put("icon-ico_selectviewport_sq_lg", Character.valueOf('\uf2fa'));
        codePointMap_.put("icon-ico_selectviewport_sq_sm", Character.valueOf('\uf2fb'));
        codePointMap_.put("icon-ico_settings1_lg", Character.valueOf('\uf2fc'));
        codePointMap_.put("icon-cog", Character.valueOf('\uf2fd'));
        codePointMap_.put("icon-ico_settings2_lg", Character.valueOf('\uf2fe'));
        codePointMap_.put("icon-ico_settings2_sm", Character.valueOf('\uf2ff'));
        codePointMap_.put("icon-ico_share_lg", Character.valueOf('\uf300'));
        codePointMap_.put("icon-share", Character.valueOf('\uf301'));
        codePointMap_.put("icon-ico_signal_lg", Character.valueOf('\uf302'));
        codePointMap_.put("icon-signal", Character.valueOf('\uf303'));
        codePointMap_.put("icon-ico_singlepointroi_lg", Character.valueOf('\uf304'));
        codePointMap_.put("icon-ico_singlepointroi_sm", Character.valueOf('\uf305'));
        codePointMap_.put("icon-ico_sitemap_lg", Character.valueOf('\uf306'));
        codePointMap_.put("icon-sitexmap", Character.valueOf('\uf307'));
        codePointMap_.put("icon-ico_sizesync_lg", Character.valueOf('\uf308'));
        codePointMap_.put("icon-ico_sizesync_sm", Character.valueOf('\uf309'));
        codePointMap_.put("icon-ico_skeletal_sq_lg", Character.valueOf('\uf30a'));
        codePointMap_.put("icon-ico_skeletal_sq_sm", Character.valueOf('\uf30b'));
        codePointMap_.put("icon-ico_sort_sq_lg", Character.valueOf('\uf30c'));
        codePointMap_.put("icon-sort", Character.valueOf('\uf30d'));
        codePointMap_.put("icon-ico_spaceastronaut_lg", Character.valueOf('\uf30e'));
        codePointMap_.put("icon-ico_spaceastronaut_sm", Character.valueOf('\uf30f'));
        codePointMap_.put("icon-ico_spacemilkyway_lg", Character.valueOf('\uf310'));
        codePointMap_.put("icon-ico_spacemilkyway_sm", Character.valueOf('\uf311'));
        codePointMap_.put("icon-ico_spaceplanets_lg", Character.valueOf('\uf312'));
        codePointMap_.put("icon-ico_spaceplanets_sm", Character.valueOf('\uf313'));
        codePointMap_.put("icon-ico_spacerocket1_lg", Character.valueOf('\uf314'));
        codePointMap_.put("icon-ico_spacerocket1_sm", Character.valueOf('\uf315'));
        codePointMap_.put("icon-ico_spacerocket2_lg", Character.valueOf('\uf316'));
        codePointMap_.put("icon-ico_spacerocket2_sm", Character.valueOf('\uf317'));
        codePointMap_.put("icon-ico_spacesolarsystem1_lg", Character.valueOf('\uf318'));
        codePointMap_.put("icon-ico_spacesolarsystem1_sm", Character.valueOf('\uf319'));
        codePointMap_.put("icon-ico_spacesolarsystem2_lg", Character.valueOf('\uf31a'));
        codePointMap_.put("icon-ico_spacesolarsystem2_sm", Character.valueOf('\uf31b'));
        codePointMap_.put("icon-ico_spacesolarsystem3_lg", Character.valueOf('\uf31c'));
        codePointMap_.put("icon-ico_spacesolarsystem3_sm", Character.valueOf('\uf31d'));
        codePointMap_.put("icon-ico_spacetransmissions1_lg", Character.valueOf('\uf31e'));
        codePointMap_.put("icon-ico_spacetransmissions1_sm", Character.valueOf('\uf31f'));
        codePointMap_.put("icon-ico_spacetransmissions2_lg", Character.valueOf('\uf320'));
        codePointMap_.put("icon-ico_spacetransmissions2_sm", Character.valueOf('\uf321'));
        codePointMap_.put("icon-ico_spinner_lg", Character.valueOf('\uf322'));
        codePointMap_.put("icon-spinner", Character.valueOf('\uf323'));
        codePointMap_.put("icon-ico_star_lg", Character.valueOf('\uf324'));
        codePointMap_.put("icon-star", Character.valueOf('\uf325'));
        codePointMap_.put("icon-ico_starempty_lg", Character.valueOf('\uf326'));
        codePointMap_.put("icon-star-empty", Character.valueOf('\uf327'));
        codePointMap_.put("icon-ico_starhalf_lg", Character.valueOf('\uf328'));
        codePointMap_.put("icon-star-half", Character.valueOf('\uf329'));
        codePointMap_.put("icon-ico_statistics_sq_lg", Character.valueOf('\uf32a'));
        codePointMap_.put("icon-ico_statistics_sq_sm", Character.valueOf('\uf32b'));
        codePointMap_.put("icon-ico_stop_rnd_lg", Character.valueOf('\uf32c'));
        codePointMap_.put("icon-stop", Character.valueOf('\uf32d'));
        codePointMap_.put("icon-ico_stormy_lg", Character.valueOf('\uf32e'));
        codePointMap_.put("icon-ico_stormy_sm", Character.valueOf('\uf32f'));
        codePointMap_.put("icon-ico_strikethrough_sq_lg", Character.valueOf('\uf330'));
        codePointMap_.put("icon-strikethrough", Character.valueOf('\uf331'));
        codePointMap_.put("icon-ico_sublingual_lg", Character.valueOf('\uf332'));
        codePointMap_.put("icon-ico_sublingual_sm", Character.valueOf('\uf333'));
        codePointMap_.put("icon-ico_sunny_lg", Character.valueOf('\uf334'));
        codePointMap_.put("icon-ico_sunny_sm", Character.valueOf('\uf335'));
        codePointMap_.put("icon-ico_symbols_sq_lg", Character.valueOf('\uf336'));
        codePointMap_.put("icon-ico_symbols_sq_sm", Character.valueOf('\uf337'));
        codePointMap_.put("icon-ico_sync_lg", Character.valueOf('\uf338'));
        codePointMap_.put("icon-ico_sync_sm", Character.valueOf('\uf339'));
        codePointMap_.put("icon-ico_syringe_lg", Character.valueOf('\uf33a'));
        codePointMap_.put("icon-ico_syringe_sm", Character.valueOf('\uf33b'));
        codePointMap_.put("icon-ico_table_lg", Character.valueOf('\uf33c'));
        codePointMap_.put("icon-table", Character.valueOf('\uf33d'));
        codePointMap_.put("icon-ico_tag_lg", Character.valueOf('\uf33e'));
        codePointMap_.put("icon-tag", Character.valueOf('\uf33f'));
        codePointMap_.put("icon-ico_target_lg", Character.valueOf('\uf340'));
        codePointMap_.put("icon-ico_target_sm", Character.valueOf('\uf341'));
        codePointMap_.put("icon-ico_teaching_lg", Character.valueOf('\uf342'));
        codePointMap_.put("icon-ico_teaching_sm", Character.valueOf('\uf343'));
        codePointMap_.put("icon-ico_textheight_sq_lg", Character.valueOf('\uf344'));
        codePointMap_.put("icon-text-height", Character.valueOf('\uf345'));
        codePointMap_.put("icon-ico_textreport_lg", Character.valueOf('\uf346'));
        codePointMap_.put("icon-ico_textreport_sm", Character.valueOf('\uf347'));
        codePointMap_.put("icon-ico_textwidth_sq_lg", Character.valueOf('\uf348'));
        codePointMap_.put("icon-text-width", Character.valueOf('\uf349'));
        codePointMap_.put("icon-ico_thermometer_lg", Character.valueOf('\uf34a'));
        codePointMap_.put("icon-ico_thermometer_sm", Character.valueOf('\uf34b'));
        codePointMap_.put("icon-ico_thumbsdown_lg", Character.valueOf('\uf34c'));
        codePointMap_.put("icon-thumbs-down", Character.valueOf('\uf34d'));
        codePointMap_.put("icon-ico_thumbsup_lg", Character.valueOf('\uf34e'));
        codePointMap_.put("icon-thumbs-up", Character.valueOf('\uf34f'));
        codePointMap_.put("icon-ico_timeline_lg", Character.valueOf('\uf350'));
        codePointMap_.put("icon-ico_timeline_sm", Character.valueOf('\uf351'));
        codePointMap_.put("icon-ico_todo_lg", Character.valueOf('\uf352'));
        codePointMap_.put("icon-tasks", Character.valueOf('\uf353'));
        codePointMap_.put("icon-ico_twitter_sq_lg", Character.valueOf('\uf354'));
        codePointMap_.put("icon-twitter-sign", Character.valueOf('\uf355'));
        codePointMap_.put("icon-ico_underlined_sq_lg", Character.valueOf('\uf356'));
        codePointMap_.put("icon-underline", Character.valueOf('\uf357'));
        codePointMap_.put("icon-ico_undo_rnd_lg", Character.valueOf('\uf358'));
        codePointMap_.put("icon-undo", Character.valueOf('\uf359'));
        codePointMap_.put("icon-ico_unlink_lg", Character.valueOf('\uf35a'));
        codePointMap_.put("icon-ico_unlink_sm", Character.valueOf('\uf35b'));
        codePointMap_.put("icon-ico_unlock_lg", Character.valueOf('\uf35c'));
        codePointMap_.put("icon-unlock", Character.valueOf('\uf35d'));
        codePointMap_.put("icon-ico_urinary_sq_lg", Character.valueOf('\uf35e'));
        codePointMap_.put("icon-ico_urinary_sq_sm", Character.valueOf('\uf35f'));
        codePointMap_.put("icon-ico_user_female_lg", Character.valueOf('\uf360'));
        codePointMap_.put("icon-ico_user_female_sm", Character.valueOf('\uf361'));
        codePointMap_.put("icon-ico_user_groups_lg", Character.valueOf('\uf362'));
        codePointMap_.put("icon-group", Character.valueOf('\uf363'));
        codePointMap_.put("icon-ico_user_male_lg", Character.valueOf('\uf364'));
        codePointMap_.put("icon-user", Character.valueOf('\uf365'));
        codePointMap_.put("icon-ico_videos_lg", Character.valueOf('\uf366'));
        codePointMap_.put("icon-film", Character.valueOf('\uf367'));
        codePointMap_.put("icon-ico_vision_lg", Character.valueOf('\uf368'));
        codePointMap_.put("icon-ico_vision_sm", Character.valueOf('\uf369'));
        codePointMap_.put("icon-ico_vitals_lg", Character.valueOf('\uf36a'));
        codePointMap_.put("icon-ico_vitals_sm", Character.valueOf('\uf36b'));
        codePointMap_.put("icon-ico_volume_lg", Character.valueOf('\uf36c'));
        codePointMap_.put("icon-volume-up", Character.valueOf('\uf36d'));
        codePointMap_.put("icon-ico_weight_lg", Character.valueOf('\uf36e'));
        codePointMap_.put("icon-ico_weight_sm", Character.valueOf('\uf36f'));
        codePointMap_.put("icon-ico_windowclampedmode_sq_lg", Character.valueOf('\uf370'));
        codePointMap_.put("icon-ico_windowclampedmode_sq_sm", Character.valueOf('\uf371'));
        codePointMap_.put("icon-ico_windowlevels_lg", Character.valueOf('\uf372'));
        codePointMap_.put("icon-ico_windowlevels_sm", Character.valueOf('\uf373'));
        codePointMap_.put("icon-ico_wireless_lg", Character.valueOf('\uf374'));
        codePointMap_.put("icon-ico_wireless_sm", Character.valueOf('\uf375'));
        codePointMap_.put("icon-ico_wireless_sq_lg", Character.valueOf('\uf376'));
        codePointMap_.put("icon-ico_wireless_sq_sm", Character.valueOf('\uf377'));
        codePointMap_.put("icon-ico_worldamericas_lg", Character.valueOf('\uf378'));
        codePointMap_.put("icon-globe", Character.valueOf('\uf379'));
        codePointMap_.put("icon-ico_worldasia_lg", Character.valueOf('\uf37a'));
        codePointMap_.put("icon-ico_worldasia_sm", Character.valueOf('\uf37b'));
        codePointMap_.put("icon-ico_worldeurope_lg", Character.valueOf('\uf37c'));
        codePointMap_.put("icon-ico_worldeurope_sm", Character.valueOf('\uf37d'));
        codePointMap_.put("icon-ico_wrench_lg", Character.valueOf('\uf37e'));
        codePointMap_.put("icon-wrench", Character.valueOf('\uf37f'));
        codePointMap_.put("icon-ico_zoom200_lg", Character.valueOf('\uf380'));
        codePointMap_.put("icon-ico_zoom200_sm", Character.valueOf('\uf381'));
        codePointMap_.put("icon-ico_zoomcontinuous_lg", Character.valueOf('\uf382'));
        codePointMap_.put("icon-ico_zoomcontinuous_sm", Character.valueOf('\uf383'));
        codePointMap_.put("icon-ico_add_alt_lg", Character.valueOf('\uf384'));
        codePointMap_.put("icon-ico_add_alt_sm", Character.valueOf('\uf385'));
        codePointMap_.put("icon-ico_arrowdown_lg", Character.valueOf('\uf386'));
        codePointMap_.put("icon-circle-arrow-down", Character.valueOf('\uf387'));
        codePointMap_.put("icon-ico_arrowup_lg", Character.valueOf('\uf388'));
        codePointMap_.put("icon-circle-arrow-up", Character.valueOf('\uf389'));
        codePointMap_.put("icon-ico_arrowleft_lg", Character.valueOf('\uf38a'));
        codePointMap_.put("icon-circle-arrow-left", Character.valueOf('\uf38b'));
        codePointMap_.put("icon-ico_arrowright_lg", Character.valueOf('\uf38c'));
        codePointMap_.put("icon-circle-arrow-right", Character.valueOf('\uf38d'));
        codePointMap_.put("icon-chevron-down", Character.valueOf('\uf38e'));
        codePointMap_.put("icon-ico_chevron_left_lg", Character.valueOf('\uf390'));
        codePointMap_.put("icon-chevron-left", Character.valueOf('\uf391'));
        codePointMap_.put("icon-ico_chevron_right_lg", Character.valueOf('\uf392'));
        codePointMap_.put("icon-chevron-right", Character.valueOf('\uf393'));
        codePointMap_.put("icon-ico_chevron_up_lg", Character.valueOf('\uf394'));
        codePointMap_.put("icon-chevron-up", Character.valueOf('\uf395'));
        codePointMap_.put("icon-ico_exitfullscreen_lg", Character.valueOf('\uf396'));
        codePointMap_.put("icon-ico_exitfullscreen_sm", Character.valueOf('\uf397'));
        codePointMap_.put("icon-ico_instagram_lg", Character.valueOf('\uf398'));
        codePointMap_.put("icon-ico_instagram_sm", Character.valueOf('\uf399'));
        codePointMap_.put("icon-ico_menu_lg", Character.valueOf('\uf39a'));
        codePointMap_.put("icon-ico_menu_sm", Character.valueOf('\uf39b'));
        codePointMap_.put("icon-ico_refresh_alt_lg", Character.valueOf('\uf39c'));
        codePointMap_.put("icon-refresh", Character.valueOf('\uf39d'));
        codePointMap_.put("icon-ico_remove_lg", Character.valueOf('\uf39e'));
        codePointMap_.put("icon-remove", Character.valueOf('\uf39f'));
        codePointMap_.put("icon-ico_youtube_lg", Character.valueOf('\uf3a0'));
        codePointMap_.put("icon-ico_youtube_sm", Character.valueOf('\uf3a1'));
        codePointMap_.put("icon-ico_mutevolume_lg", Character.valueOf('\uf3a2'));
        codePointMap_.put("icon-ico_mutevolume_sm", Character.valueOf('\uf3a3'));
        codePointMap_.put("icon-ico_follow", Character.valueOf('\uf3a4'));
        codePointMap_.put("icon-ico_mobile", Character.valueOf('\uf3a5'));
        codePointMap_.put("icon-ico_webex", Character.valueOf('\uf3a6'));
        codePointMap_.put("icon-ico_2Col_lg", Character.valueOf('\uf3a7'));
        codePointMap_.put("icon-ico_2Col_sm", Character.valueOf('\uf3a8'));
        codePointMap_.put("icon-ico_3Col_lg", Character.valueOf('\uf3a9'));
        codePointMap_.put("icon-ico_3Col_sm", Character.valueOf('\uf3aa'));
        codePointMap_.put("icon-ico_alphaSort_lg", Character.valueOf('\uf3ab'));
        codePointMap_.put("icon-ico_alphaSort_sm", Character.valueOf('\uf3ac'));
        codePointMap_.put("icon-ico_alphaSort2_lg", Character.valueOf('\uf3ad'));
        codePointMap_.put("icon-ico_alphaSort2_sm", Character.valueOf('\uf3ae'));
        codePointMap_.put("icon-ico_arrowln_lg", Character.valueOf('\uf3af'));
        codePointMap_.put("icon-ico_arrowln_sm", Character.valueOf('\uf3b0'));
        codePointMap_.put("icon-ico_barchart_lg", Character.valueOf('\uf3b1'));
        codePointMap_.put("icon-bar-chart", Character.valueOf('\uf3b2'));
        codePointMap_.put("icon-ico_bracketLine_lg", Character.valueOf('\uf3b3'));
        codePointMap_.put("icon-ico_bracketLine_sm", Character.valueOf('\uf3b4'));
        codePointMap_.put("icon-ico_check1_lg", Character.valueOf('\uf3b5'));
        codePointMap_.put("icon-ico_check1_sm", Character.valueOf('\uf3b6'));
        codePointMap_.put("icon-ico_check2_lg", Character.valueOf('\uf3b7'));
        codePointMap_.put("icon-ico_check2_sm", Character.valueOf('\uf3b8'));
        codePointMap_.put("icon-ico_check3_lg", Character.valueOf('\uf3b9'));
        codePointMap_.put("icon-ico_check3_sm", Character.valueOf('\uf3ba'));
        codePointMap_.put("icon-ico_doubleDown_lg", Character.valueOf('\uf3bb'));
        codePointMap_.put("icon-double-angle-down", Character.valueOf('\uf3bc'));
        codePointMap_.put("icon-ico_doubleLeft_lg", Character.valueOf('\uf3bd'));
        codePointMap_.put("icon-double-angle-left", Character.valueOf('\uf3be'));
        codePointMap_.put("icon-ico_doubleRight_lg", Character.valueOf('\uf3bf'));
        codePointMap_.put("icon-double-angle-right", Character.valueOf('\uf3c0'));
        codePointMap_.put("icon-ico_doubleUp_lg", Character.valueOf('\uf3c1'));
        codePointMap_.put("icon-double-angle-up", Character.valueOf('\uf3c2'));
        codePointMap_.put("icon-ico_eject_lg", Character.valueOf('\uf3c3'));
        codePointMap_.put("icon-eject", Character.valueOf('\uf3c4'));
        codePointMap_.put("icon-ico_gears_lg", Character.valueOf('\uf3c5'));
        codePointMap_.put("icon-ico_gears_sm", Character.valueOf('\uf3c6'));
        codePointMap_.put("icon-ico_halfShield_lg", Character.valueOf('\uf3c7'));
        codePointMap_.put("icon-ico_halfShield_sm", Character.valueOf('\uf3c8'));
        codePointMap_.put("icon-ico_harddrive_lg", Character.valueOf('\uf3c9'));
        codePointMap_.put("icon-ico_harddrive_sm", Character.valueOf('\uf3ca'));
        codePointMap_.put("icon-ico_lineDown_lg", Character.valueOf('\uf3cb'));
        codePointMap_.put("icon-ico_lineDown_sm", Character.valueOf('\uf3cc'));
        codePointMap_.put("icon-ico_lineSort_lg", Character.valueOf('\uf3cd'));
        codePointMap_.put("icon-ico_lineSort_sm", Character.valueOf('\uf3ce'));
        codePointMap_.put("icon-ico_lineSort2_lg", Character.valueOf('\uf3cf'));
        codePointMap_.put("icon-ico_lineSort2_sm", Character.valueOf('\uf3d0'));
        codePointMap_.put("icon-ico_lineUp_lg", Character.valueOf('\uf3d1'));
        codePointMap_.put("icon-ico_lineUp_sm", Character.valueOf('\uf3d2'));
        codePointMap_.put("icon-ico_minus_lg", Character.valueOf('\uf3d3'));
        codePointMap_.put("icon-ico_minus_sm", Character.valueOf('\uf3d4'));
        codePointMap_.put("icon-ico_minus2_lg", Character.valueOf('\uf3d5'));
        codePointMap_.put("icon-ico_minus2_sm", Character.valueOf('\uf3d6'));
        codePointMap_.put("icon-ico_numSort_lg", Character.valueOf('\uf3d7'));
        codePointMap_.put("icon-ico_numSort_sm", Character.valueOf('\uf3d8'));
        codePointMap_.put("icon-ico_numSort2_lg", Character.valueOf('\uf3d9'));
        codePointMap_.put("icon-ico_numSort2_sm", Character.valueOf('\uf3da'));
        codePointMap_.put("icon-ico_squareLine_lg", Character.valueOf('\uf3db'));
        codePointMap_.put("icon-ico_squareLine_sm", Character.valueOf('\uf3dc'));
        codePointMap_.put("icon-ico_circle_arrow_down_lg", Character.valueOf('\uf3dd'));
        codePointMap_.put("icon-circle-arrow-down", Character.valueOf('\uf3de'));
        codePointMap_.put("icon-ico_circle_arrow_left_lg", Character.valueOf('\uf3df'));
        codePointMap_.put("icon-circle-arrow-left", Character.valueOf('\uf3e0'));
        codePointMap_.put("icon-ico_circle_arrow_right_lg", Character.valueOf('\uf3e1'));
        codePointMap_.put("icon-circle-arrow-right", Character.valueOf('\uf3e2'));
        codePointMap_.put("icon-ico_circle_arrow_up_lg", Character.valueOf('\uf3e3'));
        codePointMap_.put("icon-circle-arrow-up", Character.valueOf('\uf3e4'));
        codePointMap_.put("icon-ico_circle_blank_lg", Character.valueOf('\uf3e5'));
        codePointMap_.put("icon-circle-blank", Character.valueOf('\uf3e6'));
        codePointMap_.put("icon-ico_circle_lg", Character.valueOf('\uf3e7'));
        codePointMap_.put("icon-circle", Character.valueOf('\uf3e8'));
        codePointMap_.put("icon-ico_cogs_lg", Character.valueOf('\uf3e9'));
        codePointMap_.put("icon-cogs", Character.valueOf('\uf3ea'));
        codePointMap_.put("icon-ico_comment_alt_lg", Character.valueOf('\uf3eb'));
        codePointMap_.put("icon-comment-alt", Character.valueOf('\uf3ec'));
        codePointMap_.put("icon-ico_credit_card_lg", Character.valueOf('\uf3ed'));
        codePointMap_.put("icon-credit-card", Character.valueOf('\uf3ee'));
        codePointMap_.put("icon-ico_envelope_lg", Character.valueOf('\uf3ef'));
        codePointMap_.put("icon-envelope", Character.valueOf('\uf3f0'));
        codePointMap_.put("icon-ico_exchange_lg", Character.valueOf('\uf3f1'));
        codePointMap_.put("icon-exchange", Character.valueOf('\uf3f2'));
        codePointMap_.put("icon-ico_eye_close_lg", Character.valueOf('\uf3f3'));
        codePointMap_.put("icon-eye-close", Character.valueOf('\uf3f4'));
        codePointMap_.put("icon-ico_fast_backward_lg", Character.valueOf('\uf3f5'));
        codePointMap_.put("icon-fast-backward", Character.valueOf('\uf3f6'));
        codePointMap_.put("icon-ico_heart_empty_lg", Character.valueOf('\uf3f7'));
        codePointMap_.put("icon-heart-empty", Character.valueOf('\uf3f8'));
        codePointMap_.put("icon-ico_laptop_lg", Character.valueOf('\uf3f9'));
        codePointMap_.put("icon-laptop", Character.valueOf('\uf3fa'));
        codePointMap_.put("icon-minus-sign", Character.valueOf('\uf3fb'));
        codePointMap_.put("icon-ico_off_lg", Character.valueOf('\uf3fd'));
        codePointMap_.put("icon-off", Character.valueOf('\uf3fe'));
        codePointMap_.put("icon-ico_ok_circle_lg", Character.valueOf('\uf3ff'));
        codePointMap_.put("icon-ok-circle", Character.valueOf('\uf400'));
        codePointMap_.put("icon-ico_ok_lg", Character.valueOf('\uf401'));
        codePointMap_.put("icon-ok", Character.valueOf('\uf402'));
        codePointMap_.put("icon-ico_play_circle_lg", Character.valueOf('\uf403'));
        codePointMap_.put("icon-play-circle", Character.valueOf('\uf404'));
        codePointMap_.put("icon-ico_quote_left_lg", Character.valueOf('\uf405'));
        codePointMap_.put("icon-quote-left", Character.valueOf('\uf406'));
        codePointMap_.put("icon-ico_random_lg", Character.valueOf('\uf407'));
        codePointMap_.put("icon-random", Character.valueOf('\uf408'));
        codePointMap_.put("icon-ico_resize_full_lg", Character.valueOf('\uf409'));
        codePointMap_.put("icon-resize-full", Character.valueOf('\uf40a'));
        codePointMap_.put("icon-ico_resize_small_lg", Character.valueOf('\uf40b'));
        codePointMap_.put("icon-resize-small", Character.valueOf('\uf40c'));
        codePointMap_.put("icon-ico_sort_lg", Character.valueOf('\uf40d'));
        codePointMap_.put("icon-sort", Character.valueOf('\uf40e'));
        codePointMap_.put("icon-ico_step_forward_lg", Character.valueOf('\uf40f'));
        codePointMap_.put("icon-step-forward", Character.valueOf('\uf410'));
        codePointMap_.put("icon-ico_th_large_lg", Character.valueOf('\uf411'));
        codePointMap_.put("icon-th-large", Character.valueOf('\uf412'));
        codePointMap_.put("icon-ico_th_lg", Character.valueOf('\uf413'));
        codePointMap_.put("icon-th", Character.valueOf('\uf414'));
        codePointMap_.put("icon-ico_upload_lg", Character.valueOf('\uf415'));
        codePointMap_.put("icon-upload-alt", Character.valueOf('\uf416'));
        codePointMap_.put("icon-ico_volume_down_lg", Character.valueOf('\uf417'));
        codePointMap_.put("icon-volume-down", Character.valueOf('\uf418'));
        codePointMap_.put("icon-ico_volume_off_lg", Character.valueOf('\uf419'));
        codePointMap_.put("icon-volume-off", Character.valueOf('\uf41a'));
        codePointMap_.put("icon-ico_zoom_in_lg", Character.valueOf('\uf41b'));
        codePointMap_.put("icon-zoom-out", Character.valueOf('\uf41d'));
        codePointMap_.put("icon-zoom-in", Character.valueOf('\uf41e'));
        codePointMap_.put("icon-ico_asterisk_lg", Character.valueOf('\uf41f'));
        codePointMap_.put("icon-asterisk", Character.valueOf('\uf420'));
        codePointMap_.put("icon-ico_carot_down_lg", Character.valueOf('\uf421'));
        codePointMap_.put("icon-carot-down", Character.valueOf('\uf422'));
        codePointMap_.put("icon-ico_carot_left_lg", Character.valueOf('\uf423'));
        codePointMap_.put("icon-caret-left", Character.valueOf('\uf424'));
        codePointMap_.put("icon-ico_carot_right_lg", Character.valueOf('\uf425'));
        codePointMap_.put("icon-caret-right", Character.valueOf('\uf426'));
        codePointMap_.put("icon-ico_carot_up_lg", Character.valueOf('\uf427'));
        codePointMap_.put("icon-caret-up", Character.valueOf('\uf428'));
        codePointMap_.put("icon-ico_remove_circle_lg", Character.valueOf('\uf429'));
        codePointMap_.put("icon-remove-circle", Character.valueOf('\uf42a'));
        codePointMap_.put("icon-ico_warning_lg", Character.valueOf('\uf42b'));
        codePointMap_.put("icon-ico_warning_sm", Character.valueOf('\uf42c'));
        codePointMap_.put("icon-ico_keyboard_lg", Character.valueOf('\uf42d'));
        codePointMap_.put("icon-ico_minus", Character.valueOf('\uf42d'));
        codePointMap_.put("icon-ico_keyboard_sm", Character.valueOf('\uf42e'));
        codePointMap_.put("icon-ico_mouse_lg", Character.valueOf('\uf42f'));
        codePointMap_.put("icon-ico_mouse_sm", Character.valueOf('\uf430'));
        codePointMap_.put("icon-missing-glyph", Character.valueOf('\u0000'));
        sizeMap_ = new HashMap<String, Dimension>();
        sizeMap_.put("icon-default", new Dimension(14, 14));
        sizeMap_.put("icon-large", new Dimension(18, 18));
        sizeMap_.put("icon-huge", new Dimension(24, 24));
        sizeMap_.put("icon-colossal", new Dimension(36, 37));
        sizeMap_.put("icon-gargantuan", new Dimension(100, 72));
        demoSize_ = "icon-default";
        demoColor_ = new Color[]{Color.black, Color.white};
        reverse_ = false;
    }
}

