/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.graphics;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.css.CSSProperties;
import com.ge.med.iungo.util.Configuration;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;

public class Background {
    private static final Logger logger_ = Logger.getLogger(Background.class.getName());
    private static final Color TRANSPARENT = new Color(0, true);
    public static final Map<URL, BufferedImage> imageCache_ = new HashMap<URL, BufferedImage>();
    private static int bufferCacheSize_ = Configuration.getInt("bufferCacheSize", 1024);
    private static boolean bufferCacheActive_ = false;
    private static Map<String, BufferedImage> bufferCache_ = new LinkedHashMap<String, BufferedImage>(bufferCacheSize_, 1.1f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
            return this.size() > bufferCacheSize_;
        }
    };

    public static void updateComponentProperties(JComponent component, BackgroundInfo info) {
        Color foreground = component.getForeground();
        if (info.foreground != null && foreground instanceof UIResource && !info.foreground.equals(foreground)) {
            component.setForeground(info.foreground);
        }
        Color background = component.getBackground();
        if (info.background != null && background instanceof UIResource && !info.background.equals(background)) {
            component.setBackground(info.background);
        }
        Font font = component.getFont();
        if (info.font != null && font instanceof UIResource && !info.font.equals(font)) {
            component.setFont(info.font);
        }
    }

    public static BufferedImage getBuffer(Dimension size) {
        if (size.width <= 0 || size.height <= 0) {
            return null;
        }
        BufferedImage buffer = null;
        if (bufferCacheActive_ && SwingUtilities.isEventDispatchThread()) {
            buffer = bufferCache_.remove("" + size.width + "x" + size.height);
        }
        return buffer != null ? buffer : new BufferedImage(size.width, size.height, 2);
    }

    public static void recycleBuffer(BufferedImage buffer) {
        if (bufferCacheActive_ && SwingUtilities.isEventDispatchThread()) {
            bufferCache_.put("" + buffer.getWidth() + "x" + buffer.getHeight(), buffer);
        }
    }

    public static void addFontRenderingHints(Graphics2D g2, JComponent component) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static void paintBackgroundToBuffer(Graphics2D g2, JComponent component, BackgroundInfo info, CSSBorder border) {
        Dimension size = component.getSize();
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        g2.setClip(new Rectangle(size));
        g2.clipRect(0, 0, size.width, size.height);
        border.paintBorderAndBackground(component, g2, 0, 0, size.width, size.height, info);
    }

    public static void paintFromBuffer(Graphics g, BufferedImage buffer, float opacity) {
        if (buffer == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, opacity));
        g2.drawImage((Image)buffer, 0, 0, null);
        g2.setComposite(composite);
    }

    public static Insets getInsets(BackgroundInfo info) {
        Insets in = new Insets(info.borderWidth[0] + info.padding[0], info.borderWidth[3] + info.padding[3], info.borderWidth[2] + info.padding[2], info.borderWidth[1] + info.padding[1]);
        return in;
    }

    public static void paint(BackgroundInfo info, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.Src);
        if (info.borderWidth[0] > 0 || info.borderWidth[1] > 0 || info.borderWidth[2] > 0 || info.borderWidth[3] > 0) {
            if (info.borderColor[0].equals(info.borderColor[1]) && info.borderColor[0].equals(info.borderColor[2]) && info.borderColor[0].equals(info.borderColor[3])) {
                g2.setPaint(info.borderColor[0]);
            } else {
                int w = info.borderShape[0].getBounds().width;
                int h = info.borderShape[0].getBounds().height;
                if (w > 0 && h > 0) {
                    int w2 = w / 2;
                    int h2 = h / 2;
                    BufferedImage bi = Background.getBuffer(new Dimension(w, h));
                    Graphics2D big = bi.createGraphics();
                    big.setComposite(AlphaComposite.Src);
                    big.setColor(TRANSPARENT);
                    big.fillRect(0, 0, w, h);
                    if (info.borderColor[1].getAlpha() > 0) {
                        big.setColor(info.borderColor[1]);
                        big.fillRect(w2, 0, w - w2, h);
                    }
                    if (info.borderColor[3].getAlpha() > 0) {
                        big.setColor(info.borderColor[3]);
                        big.fillRect(0, 0, w2, h);
                    }
                    if (info.borderColor[0].getAlpha() > 0) {
                        big.setColor(info.borderColor[0]);
                        big.fillRect(info.borderWidth[3], 0, w - (info.borderWidth[3] + info.borderWidth[1]), h2);
                    }
                    if (info.borderColor[2].getAlpha() > 0) {
                        big.setColor(info.borderColor[2]);
                        big.fillRect(info.borderWidth[3], h2, w - (info.borderWidth[3] + info.borderWidth[1]), h - h2);
                    }
                    big.setColor(TRANSPARENT);
                    if (info.borderWidth[0] > 0 && info.borderColor[0].getAlpha() == 0) {
                        big.fillRect(0, 0, w, info.borderWidth[0]);
                    }
                    if (info.borderWidth[2] > 0 && info.borderColor[2].getAlpha() == 0) {
                        big.fillRect(0, h - info.borderWidth[2], w, info.borderWidth[2]);
                    }
                    if (info.borderWidth[1] > 0 && info.borderColor[1].getAlpha() == 0) {
                        big.fillRect(w - info.borderWidth[1], 0, info.borderWidth[1], h);
                    }
                    if (info.borderWidth[3] > 0 && info.borderColor[3].getAlpha() == 0) {
                        big.fillRect(0, 0, info.borderWidth[3], h);
                    }
                    g2.setPaint(new TexturePaint(bi, new Rectangle(0, 0, w, h)));
                }
            }
            g2.fill(info.borderShape[0]);
        }
        g2.setColor(info.background);
        g2.fill(info.borderShape[1]);
        g2.setComposite(composite);
        Background.paintImages(info, g, x, y, width, height);
    }

    public static void paintImages(BackgroundInfo info, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (info.backgroundImageList != null) {
            for (BackgroundInfo.BgImage bgi : info.backgroundImageList) {
                Rectangle2D.Double origin = new Rectangle2D.Double(0.0, 0.0, width, height);
                switch (bgi.background_origin_) {
                    case CONTENT_BOX: {
                        origin.x += (double)info.padding[1];
                        origin.y += (double)info.padding[0];
                        origin.width -= (double)(info.padding[1] + info.padding[3]);
                        origin.height -= (double)(info.padding[0] + info.padding[2]);
                    }
                    case PADDING_BOX: {
                        origin.x += (double)info.borderWidth[1];
                        origin.y += (double)info.borderWidth[0];
                        origin.width -= (double)(info.borderWidth[1] + info.borderWidth[3]);
                        origin.height -= (double)(info.borderWidth[0] + info.borderWidth[2]);
                    }
                }
                if (bgi.background_image_.url_ != null) {
                    BufferedImage bi = imageCache_.get(bgi.background_image_.url_);
                    if (bi == null) {
                        try {
                            bi = ImageIO.read(ImageIO.createImageInputStream(bgi.background_image_.url_.openStream()));
                            BufferedImageOp zoomOp = CSS.getZoomImageOp();
                            if (zoomOp != null) {
                                bi = zoomOp.filter(bi, null);
                            }
                            imageCache_.put(bgi.background_image_.url_, bi);
                        }
                        catch (Exception ex) {
                            logger_.log(Level.WARNING, "Could not load background image " + bgi.background_image_.url_ + ".", ex);
                            continue;
                        }
                    }
                    int iw = bi.getWidth();
                    int ih = bi.getHeight();
                    int cw = width;
                    int ch = height;
                    int percentBaseW = cw - iw;
                    int percentBaseH = ch - ih;
                    bgi.background_position_.offsetX_.setLengthBase(new CSSProperties.BpNumber(percentBaseW, CSSProperties.BpNumber.Unit.PIXEL));
                    bgi.background_position_.offsetY_.setLengthBase(new CSSProperties.BpNumber(percentBaseH, CSSProperties.BpNumber.Unit.PIXEL));
                    int ox = (int)Math.round(bgi.background_position_.offsetX_.toPX());
                    int oy = (int)Math.round(bgi.background_position_.offsetY_.toPX());
                    CSSProperties.BgPosition.Base bx = bgi.background_position_.baseX_;
                    CSSProperties.BgPosition.Base by = bgi.background_position_.baseY_;
                    int px = ox;
                    int py = oy;
                    if (bx == CSSProperties.BgPosition.Base.RIGHT) {
                        px = percentBaseW - ox;
                    }
                    if (by == CSSProperties.BgPosition.Base.BOTTOM) {
                        py = percentBaseH - oy;
                    }
                    g2.drawImage((Image)bi, px + info.borderWidth[0], py + info.borderWidth[3], null);
                }
                if (bgi.background_image_.function_ == null || info.background != null && !(info.background instanceof UIResource)) continue;
                switch (bgi.background_image_.function_.name_) {
                    case "linear-gradient": {
                        String angle = null;
                        LinkedList<Color> color = new LinkedList<Color>();
                        LinkedList<CSSProperties.BpNumber> stop = new LinkedList<CSSProperties.BpNumber>();
                        for (Object p : bgi.background_image_.function_.parameters_) {
                            if (p instanceof String) {
                                angle = (String)p;
                            }
                            if (p instanceof Color) {
                                color.add((Color)p);
                                stop.add(null);
                            }
                            if (!(p instanceof List)) continue;
                            Color c = null;
                            CSSProperties.BpNumber s = null;
                            for (Object pp : (List)p) {
                                if (pp instanceof String) {
                                    angle = (angle == null ? "" : angle + " ") + pp;
                                }
                                if (pp instanceof Color) {
                                    c = (Color)pp;
                                }
                                if (!(pp instanceof CSSProperties.BpNumber)) continue;
                                s = (CSSProperties.BpNumber)pp;
                            }
                            if (c == null) continue;
                            color.add(c);
                            stop.add(s);
                        }
                        if (color.size() < 2) {
                            logger_.log(Level.WARNING, "Not enough color specifications in linear gradient (" + color.size() + ").");
                            break;
                        }
                        if ("top".equals(angle)) break;
                        if (angle == null) {
                            angle = "to bottom";
                        }
                        double[][] boxLTRB = new double[][]{{0.0, 0.0}, {width, height}};
                        double[] centerXY = new double[]{(boxLTRB[0][0] + boxLTRB[1][0]) / 2.0, (boxLTRB[0][1] + boxLTRB[1][1]) / 2.0};
                        double[] from = null;
                        double[] to = null;
                        double degrees = 0.0;
                        switch (angle) {
                            default: {
                                if (angle.endsWith("deg")) {
                                    try {
                                        degrees = Double.parseDouble(angle.substring(0, angle.indexOf("deg")));
                                        degrees = (degrees + 360.0) % 360.0;
                                        if (degrees != 0.0) break;
                                        to = new double[]{centerXY[0], boxLTRB[0][1]};
                                        from = new double[]{centerXY[0], boxLTRB[1][1]};
                                        break;
                                    }
                                    catch (Exception ex) {
                                        logger_.log(Level.WARNING, "Ill formed linear gradient angle specification (" + angle + ").", ex);
                                    }
                                } else {
                                    logger_.log(Level.WARNING, "Ill formed linear gradient angle specification (" + angle + ").");
                                }
                            }
                            case "to bottom": 
                            case "180deg": 
                            case "-180deg": {
                                to = new double[]{centerXY[0], boxLTRB[1][1]};
                                from = new double[]{centerXY[0], boxLTRB[0][1]};
                                break;
                            }
                            case "to top": 
                            case "0deg": {
                                to = new double[]{centerXY[0], boxLTRB[0][1]};
                                from = new double[]{centerXY[0], boxLTRB[1][1]};
                                break;
                            }
                            case "to right": 
                            case "90deg": 
                            case "-270deg": {
                                to = new double[]{boxLTRB[1][0], centerXY[1]};
                                from = new double[]{boxLTRB[0][0], centerXY[1]};
                                break;
                            }
                            case "to left": 
                            case "270deg": 
                            case "-90deg": {
                                to = new double[]{boxLTRB[0][0], centerXY[1]};
                                from = new double[]{boxLTRB[1][0], centerXY[1]};
                                break;
                            }
                            case "to top right": 
                            case "to right top": {
                                to = new double[]{boxLTRB[1][0], boxLTRB[0][1]};
                                from = new double[]{boxLTRB[0][0], boxLTRB[1][1]};
                                break;
                            }
                            case "to top left": 
                            case "to left top": {
                                to = new double[]{boxLTRB[0][0], boxLTRB[0][1]};
                                from = new double[]{boxLTRB[1][0], boxLTRB[1][1]};
                                break;
                            }
                            case "to bottom left": 
                            case "to left bottom": {
                                to = new double[]{boxLTRB[0][0], boxLTRB[1][1]};
                                from = new double[]{boxLTRB[1][0], boxLTRB[0][1]};
                                break;
                            }
                            case "to bottom right": 
                            case "to right bottom": {
                                to = new double[]{boxLTRB[1][0], boxLTRB[1][1]};
                                from = new double[]{boxLTRB[0][0], boxLTRB[0][1]};
                            }
                        }
                        if (to == null || from == null) {
                            double[] toCornerXY = degrees < 90.0 ? new double[]{boxLTRB[1][0], boxLTRB[0][1]} : (degrees < 180.0 ? new double[]{boxLTRB[1][0], boxLTRB[1][1]} : (degrees < 270.0 ? new double[]{boxLTRB[0][0], boxLTRB[1][1]} : new double[]{boxLTRB[0][0], boxLTRB[0][1]}));
                            toCornerXY[0] = toCornerXY[0] - centerXY[0];
                            toCornerXY[1] = toCornerXY[1] - centerXY[1];
                            double gradientSlope = Math.cos(Math.toRadians(degrees)) / Math.sin(Math.toRadians(degrees));
                            double perpendicularSlope = -1.0 / gradientSlope;
                            double perpendicularYIntercept = toCornerXY[1] - perpendicularSlope * toCornerXY[0];
                            to = new double[]{perpendicularYIntercept / (gradientSlope - perpendicularSlope), gradientSlope * to[0]};
                            from = new double[]{-to[0], -to[1]};
                            to[0] = to[0] + centerXY[0];
                            to[1] = to[1] + centerXY[1];
                            from[0] = from[0] + centerXY[0];
                            from[1] = from[1] + centerXY[1];
                        }
                        if (stop.get(0) == null) {
                            stop.remove(0);
                            stop.add(0, new CSSProperties.BpNumber(0.0, CSSProperties.BpNumber.Unit.PERCENT));
                        }
                        if (stop.get(stop.size() - 1) == null) {
                            stop.remove(stop.size() - 1);
                            stop.add(new CSSProperties.BpNumber(100.0, CSSProperties.BpNumber.Unit.PERCENT));
                        }
                        Color[] colors = color.toArray(new Color[0]);
                        float[] fractions = new float[colors.length];
                        block51: for (int i = 0; i < fractions.length; ++i) {
                            CSSProperties.BpNumber bpn = (CSSProperties.BpNumber)stop.get(i);
                            switch (bpn.unit_) {
                                case PERCENT: {
                                    fractions[i] = (float)bpn.value_ / 100.0f;
                                    continue block51;
                                }
                                default: {
                                    logger_.log(Level.WARNING, "Unexpected units in linear gradient specification (" + (Object)((Object)bpn.unit_) + ").");
                                    fractions[i] = 100.0f * (float)i / (float)fractions.length;
                                }
                            }
                        }
                        g2.setPaint(new LinearGradientPaint((float)from[0], (float)from[1], (float)to[0], (float)to[1], fractions, colors));
                        g2.fill(info.borderShape[1]);
                        break;
                    }
                }
            }
        }
    }
}

