/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.css;

import com.ge.med.iungo.css.CSSProperties;
import com.ge.med.iungo.util.Fonts;
import cz.vutbr.web.css.Declaration;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class FontFaceProperties
extends CSSProperties {
    private static Logger logger_ = Logger.getLogger(FontFaceProperties.class.getName());
    private final List<Declaration> debugProcessedDeclarations_ = new LinkedList<Declaration>();
    public String font_family_ = null;
    public List<CSSProperties.BgImage> src_ = new ArrayList<CSSProperties.BgImage>();
    public List<CSSProperties.FoFormat> format_ = new ArrayList<CSSProperties.FoFormat>();
    public CSSProperties.FoStyle font_style_ = CSSProperties.FoStyle.NORMAL;
    public CSSProperties.BpNumber font_weight_ = new CSSProperties.BpNumber(500.0, CSSProperties.BpNumber.Unit.NONE);
    public CSSProperties.FoStretch font_stretch_ = CSSProperties.FoStretch.NORMAL;
    private boolean registered_ = false;
    private boolean valid_ = true;

    public synchronized boolean initFont() {
        if (!this.registered_ && this.valid_) {
            logger_.log(Level.INFO, "Loading @font-face (" + this.font_family_ + " " + (Object)((Object)this.font_style_) + " " + this.font_weight_ + ").");
            if (this.font_family_ != null) {
                URL url;
                LinkedList<URL> urls = new LinkedList<URL>();
                CSSProperties.BgImage[] src = this.src_.toArray(new CSSProperties.BgImage[0]);
                CSSProperties.FoFormat[] format = this.format_.toArray(new CSSProperties.FoFormat[0]);
                for (int i = 0; i < src.length && i < format.length; ++i) {
                    logger_.log(Level.FINE, "getFont " + i + " " + (Object)((Object)format[i]) + " " + (Object)((Object)format[i]));
                    if (format[i] != CSSProperties.FoFormat.TRUETYPE && format[i] != CSSProperties.FoFormat.OPENTYPE) continue;
                    URL url2 = src[i].url_;
                    if (url2 == null) {
                        logger_.log(Level.WARNING, "@font-face URL is null (" + this.font_family_ + " " + (Object)((Object)this.font_style_) + " " + this.font_weight_ + ").");
                        continue;
                    }
                    urls.add("file".equals(url2.getProtocol()) ? 0 : urls.size(), url2);
                }
                boolean bold = this.font_weight_.value_ > 500.0;
                boolean italic = this.font_style_ == CSSProperties.FoStyle.ITALIC || this.font_style_ == CSSProperties.FoStyle.OBLIQUE;
                int style = (bold ? 1 : 0) | (italic ? 2 : 0);
                Iterator i$ = urls.iterator();
                while (i$.hasNext() && !(this.registered_ = Fonts.addURLFont(this.font_family_, style, url = (URL)i$.next()))) {
                }
            }
            if (!this.registered_) {
                logger_.log(Level.WARNING, "No font located for @font-face (" + this.font_family_ + " " + (Object)((Object)this.font_style_) + " " + this.font_weight_ + ").");
                this.valid_ = false;
            }
        }
        return this.registered_;
    }

    public String toString() {
        StringBuffer pd = new StringBuffer();
        pd.append("[");
        for (Declaration d : this.debugProcessedDeclarations_) {
            pd.append("" + (d.isImportant() ? "*" : "") + d.toString().trim() + "; ");
        }
        pd.append("]");
        StringBuffer sm = new StringBuffer();
        sm.append("[");
        for (Map.Entry e : this.setMap_.entrySet()) {
            sm.append("" + (String)e.getKey() + " (" + ((Declaration)e.getValue()).toString().trim() + "); ");
        }
        sm.append("]");
        return "FontFaceProperties [font_family_=" + this.font_family_ + "; " + "src_=" + this.src_ + "; " + "format_=" + this.format_ + "; " + "font_style_=" + (Object)((Object)this.font_style_) + "; " + "font_weight_=" + this.font_weight_ + "; " + "font_stretch_=" + (Object)((Object)this.font_stretch_) + "; " + "setMap_=" + sm.toString() + "; " + "debugProcessedDeclarations_=" + pd.toString() + "]";
    }

    @Override
    public void set(String property, Declaration declaration, JComponent component) {
        this.debugProcessedDeclarations_.add(declaration);
        try {
            switch (property) {
                case "font-family": {
                    this.setString(declaration, property);
                    break;
                }
                case "src": {
                    this.setFontSource(declaration, "src", "format");
                    break;
                }
                case "font-style": {
                    this.setFontStyle(declaration, property);
                    break;
                }
                case "font-weight": {
                    this.setFontWeight(declaration, property);
                    break;
                }
                case "font-stretch": {
                    this.setFontStretch(declaration, property);
                    break;
                }
                case "unicode-range": {
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

