/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.css;

import com.ge.med.iungo.css.CSS;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermURI;
import java.awt.Color;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public abstract class CSSProperties {
    private static final Logger logger_ = Logger.getLogger(CSSProperties.class.getName());
    protected Map<String, Declaration> setMap_ = new LinkedHashMap<String, Declaration>();
    public static final Color COLOR_TRANSPARENT = new Color(0, true);
    public static final double BORDER_THIN = 1.0;
    public static final double BORDER_MEDIUM = 3.0;
    public static final double BORDER_THICK = 5.0;
    public static final double FONT_WEIGHT_REGULAR = 400.0;
    public static final double FONT_WEIGHT_MEDIUM = 500.0;
    public static final double FONT_WEIGHT_BOLD = 700.0;
    public static final double FONT_SIZE_XX_SMALL = 9.0;
    public static final double FONT_SIZE_X_SMALL = 10.0;
    public static final double FONT_SIZE_SMALL = 13.0;
    public static final double FONT_SIZE_MEDIUM = 16.0;
    public static final double FONT_SIZE_LARGE = 18.0;
    public static final double FONT_SIZE_X_LARGE = 24.0;
    public static final double FONT_SIZE_XX_LARGE = 32.0;
    public static final double LINE_HEIGHT_NORMAL = 1.2;

    public abstract void set(String var1, Declaration var2, JComponent var3);

    protected void setPropertyField(String property, Declaration declaration, Object value) {
        if (this.setMap_.containsKey(property)) {
            if (!declaration.isImportant()) {
                return;
            }
            this.setMap_.remove(property);
        }
        try {
            this.getClass().getField(property.replaceAll("-", "_") + "_").set(this, value);
            this.setMap_.put(property, declaration);
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception setting property " + property + " = " + value + ".", ex);
        }
    }

    protected boolean worthDoing(Declaration declaration, String property) {
        return declaration.isImportant() || !this.setMap_.containsKey(property);
    }

    protected boolean worthDoing(Declaration declaration, String[] properties) {
        boolean wd = declaration.isImportant();
        int i = 0;
        while (!wd && i < properties.length) {
            wd = !this.setMap_.containsKey(properties[i]);
        }
        return wd;
    }

    protected void setBorderStyles(Declaration declaration, String ... property) {
        Object[] v = new Object[property.length];
        int n = 0;
        for (Term t : declaration) {
            if (!(t instanceof TermIdent) && !(t instanceof TermString)) continue;
            switch ((String)t.getValue()) {
                default: {
                    logger_.log(Level.WARNING, "Unsupported border style \"" + t.getValue() + "\", substituting \"none\".");
                }
                case "none": {
                    v[n] = BoStyle.NONE;
                    break;
                }
                case "hidden": {
                    v[n] = BoStyle.HIDDEN;
                    break;
                }
                case "solid": {
                    v[n] = BoStyle.SOLID;
                    break;
                }
                case "dotted": {
                    v[n] = BoStyle.DOTTED;
                    break;
                }
                case "dashed": {
                    v[n] = BoStyle.DASHED;
                    break;
                }
                case "double": {
                    v[n] = BoStyle.DOUBLE;
                    break;
                }
                case "groove": {
                    v[n] = BoStyle.GROOVE;
                    break;
                }
                case "ridge": {
                    v[n] = BoStyle.RIDGE;
                    break;
                }
                case "inset": {
                    v[n] = BoStyle.INSET;
                    break;
                }
                case "outset": {
                    v[n] = BoStyle.OUTSET;
                }
            }
            if (++n != v.length) continue;
            break;
        }
        if (n == 0) {
            return;
        }
        if (v.length == 4) {
            switch (n) {
                case 1: {
                    v[2] = v[3] = v[0];
                    v[1] = v[3];
                    break;
                }
                case 2: {
                    v[2] = v[0];
                    v[3] = v[1];
                    break;
                }
                case 3: {
                    v[3] = v[1];
                }
            }
        }
        for (int i = 0; i < v.length; ++i) {
            this.setPropertyField(property[i], declaration, v[i]);
        }
    }

    protected void setFontFamily(Declaration declaration, String property) {
        LinkedList<String> v = new LinkedList<String>();
        for (Term t : declaration) {
            v.add((String)t.getValue());
        }
        this.setPropertyField(property, declaration, v);
    }

    protected void setFontStyle(Declaration declaration, String property) {
        FoStyle v = null;
        block10: for (Term t : declaration) {
            if (!(t instanceof TermIdent) && !(t instanceof TermString)) continue;
            switch ((String)t.getValue()) {
                default: {
                    logger_.log(Level.WARNING, "Unsupported font style \"" + t.getValue() + "\", substituting \"normal\".");
                }
                case "normal": {
                    v = FoStyle.NORMAL;
                    continue block10;
                }
                case "oblique": {
                    v = FoStyle.OBLIQUE;
                    continue block10;
                }
                case "italic": 
            }
            v = FoStyle.ITALIC;
        }
        if (v == null) {
            return;
        }
        this.setPropertyField(property, declaration, (Object)v);
    }

    protected void setFontStretch(Declaration declaration, String property) {
        FoStretch v = null;
        block22: for (Term t : declaration) {
            if (!(t instanceof TermIdent) && !(t instanceof TermString)) continue;
            switch ((String)t.getValue()) {
                default: {
                    logger_.log(Level.WARNING, "Unsupported font stretch \"" + t.getValue() + "\", substituting normal.");
                }
                case "normal": {
                    v = FoStretch.NORMAL;
                    continue block22;
                }
                case "ultra-condensed": {
                    v = FoStretch.ULTRA_CONDENSED;
                    continue block22;
                }
                case "extra-condensed": {
                    v = FoStretch.EXTRA_CONDENSED;
                    continue block22;
                }
                case "condensed": {
                    v = FoStretch.CONDENSED;
                    continue block22;
                }
                case "semi-condensed": {
                    v = FoStretch.SEMI_CONDENSED;
                    continue block22;
                }
                case "semi-expanded": {
                    v = FoStretch.SEMI_EXPANDED;
                    continue block22;
                }
                case "expanded": {
                    v = FoStretch.EXPANDED;
                    continue block22;
                }
                case "extra-expanded": {
                    v = FoStretch.EXTRA_EXPANDED;
                    continue block22;
                }
                case "ultra-expanded": 
            }
            v = FoStretch.ULTRA_EXPANDED;
        }
        if (v == null) {
            logger_.log(Level.WARNING, "No value:" + property + " " + declaration);
            return;
        }
        this.setPropertyField(property, declaration, (Object)v);
    }

    protected void setFontSource(Declaration declaration, String ... property) {
        LinkedList<BgImage> v = new LinkedList<BgImage>();
        LinkedList<FoFormat> f = new LinkedList<FoFormat>();
        for (Term t : declaration) {
            if (t instanceof TermURI) {
                try {
                    v.add(new BgImage(((TermURI)t).getBase(), (String)t.getValue()));
                }
                catch (MalformedURLException e) {
                    logger_.severe(e.getMessage());
                }
                continue;
            }
            if (!(t instanceof TermFunction)) continue;
            block5 : switch (((TermFunction)t).getFunctionName()) {
                case "local": {
                    v.add(new BgImage(CSSProperties.getFunction((TermFunction)t)));
                    break;
                }
                case "format": {
                    BgFunction ff = CSSProperties.getFunction((TermFunction)t);
                    String p0 = "" + ff.parameters_.get(0);
                    while (f.size() < v.size() - 1) {
                        f.add(FoFormat.UNSUPPORTED);
                    }
                    switch (p0) {
                        case "truetype": {
                            f.add(FoFormat.TRUETYPE);
                            break block5;
                        }
                        case "opentype": {
                            f.add(FoFormat.OPENTYPE);
                            break block5;
                        }
                        case "TBD": {
                            f.add(FoFormat.TYPE1);
                            break block5;
                        }
                    }
                    break;
                }
            }
        }
        while (f.size() < v.size()) {
            f.add(FoFormat.UNSUPPORTED);
        }
        this.setPropertyField(property[0], declaration, v);
        this.setPropertyField(property[1], declaration, f);
    }

    protected void setBackgroundAttachment(Declaration declaration, String property) {
        LinkedList<BgAttachment> v = new LinkedList<BgAttachment>();
        for (Term t : declaration) {
            if (!(t instanceof TermIdent) && !(t instanceof TermString)) continue;
            switch ((String)t.getValue()) {
                case "scroll": {
                    v.add(BgAttachment.SCROLL);
                    break;
                }
                case "fixed": {
                    v.add(BgAttachment.FIXED);
                    break;
                }
                case "local": {
                    v.add(BgAttachment.LOCAL);
                    break;
                }
            }
        }
        this.setPropertyField(property, declaration, v);
    }

    protected void setBackgroundBox(Declaration declaration, String property) {
        LinkedList<BgBox> v = new LinkedList<BgBox>();
        for (Term t : declaration) {
            if (!(t instanceof TermIdent) && !(t instanceof TermString)) continue;
            switch ((String)t.getValue()) {
                case "border-box": {
                    v.add(BgBox.BORDER_BOX);
                    break;
                }
                case "padding-box": {
                    v.add(BgBox.PADDING_BOX);
                    break;
                }
                case "content-box": {
                    v.add(BgBox.CONTENT_BOX);
                    break;
                }
            }
        }
        this.setPropertyField(property, declaration, v);
    }

    protected void setBorder(Declaration declaration, String ... property) {
        Object[] v = new Object[property.length];
        for (Term t : declaration) {
            if (t instanceof TermNumeric) {
                v[0] = CSSProperties.getNumber((TermNumeric)t, BpNumber.Unit.PIXEL);
            }
            if (t instanceof TermIdent || t instanceof TermString) {
                switch ((String)t.getValue()) {
                    default: {
                        logger_.log(Level.WARNING, "Unsupported border style \"" + t.getValue() + "\", substituting \"none\".");
                    }
                    case "none": {
                        v[1] = BoStyle.NONE;
                        v[0] = new BpNumber(0.0, BpNumber.Unit.PIXEL);
                        break;
                    }
                    case "hidden": {
                        v[1] = BoStyle.HIDDEN;
                        break;
                    }
                    case "dotted": {
                        v[1] = BoStyle.DOTTED;
                        break;
                    }
                    case "dashed": {
                        v[1] = BoStyle.DASHED;
                        break;
                    }
                    case "solid": {
                        v[1] = BoStyle.SOLID;
                        break;
                    }
                    case "double": {
                        v[1] = BoStyle.DOUBLE;
                        break;
                    }
                    case "groove": {
                        v[1] = BoStyle.GROOVE;
                        break;
                    }
                    case "ridge": {
                        v[1] = BoStyle.RIDGE;
                        break;
                    }
                    case "inset": {
                        v[1] = BoStyle.INSET;
                        break;
                    }
                    case "outset": {
                        v[1] = BoStyle.OUTSET;
                    }
                }
            }
            if (!(t instanceof TermColor)) continue;
            v[2] = (Color)t.getValue();
        }
        if (v.length == 12) {
            v[10] = v[11] = v[2];
            v[9] = v[11];
            v[8] = v[11];
            v[6] = v[7] = v[1];
            v[5] = v[7];
            v[4] = v[7];
            v[2] = v[3] = v[0];
            v[1] = v[3];
            v[0] = v[3];
        }
        for (int i = 0; i < v.length; ++i) {
            this.setPropertyField(property[i], declaration, v[i]);
        }
    }

    protected void setPosition(Declaration declaration, String property) {
        LinkedList<BgPosition> v = new LinkedList<BgPosition>();
        BgPosition.Base[] base = new BgPosition.Base[]{null, null};
        BpNumber[] offset = new BpNumber[]{null, null};
        int n = 0;
        for (Term t : declaration) {
            if (t instanceof TermLengthOrPercent && n < 2) {
                double d = ((Float)((TermLengthOrPercent)t).getValue()).floatValue();
                offset[n++] = new BpNumber(d, t instanceof TermPercent ? BpNumber.Unit.PERCENT : BpNumber.Unit.PIXEL);
                continue;
            }
            if (!(t instanceof TermIdent) && !(t instanceof TermString) || n >= 2) continue;
            base[n++] = BgPosition.getBase((String)t.getValue());
        }
        if (base[0] == BgPosition.Base.TOP || base[0] == BgPosition.Base.BOTTOM || base[1] == BgPosition.Base.LEFT || base[1] == BgPosition.Base.RIGHT) {
            BgPosition.Base tmp = base[0];
            base[0] = base[1];
            base[1] = tmp;
        }
        if (base[0] == BgPosition.Base.CENTER) {
            base[0] = BgPosition.Base.LEFT;
            offset[0] = new BpNumber(50.0, BpNumber.Unit.PERCENT);
        }
        if (base[1] == BgPosition.Base.CENTER) {
            base[1] = BgPosition.Base.TOP;
            offset[1] = new BpNumber(50.0, BpNumber.Unit.PERCENT);
        }
        v.add(new BgPosition(base[0] != null ? base[0] : BgPosition.Base.CENTER, offset[0] != null ? offset[0] : new BpNumber(0.0, BpNumber.Unit.PERCENT), base[1] != null ? base[1] : BgPosition.Base.CENTER, offset[1] != null ? offset[1] : new BpNumber(0.0, BpNumber.Unit.PERCENT)));
        this.setPropertyField(property, declaration, v);
    }

    protected void setBackgroundImage(Declaration declaration, String property) {
        LinkedList<BgImage> v = new LinkedList<BgImage>();
        for (Term t : declaration) {
            if (t instanceof TermURI) {
                try {
                    v.add(new BgImage(((TermURI)t).getBase(), (String)t.getValue()));
                }
                catch (MalformedURLException e) {
                    logger_.severe(e.getMessage());
                }
                continue;
            }
            if ((t instanceof TermIdent || t instanceof TermString) && "none".equals((String)t.getValue())) {
                v.add(new BgImage());
                continue;
            }
            if (!(t instanceof TermFunction)) continue;
            v.add(new BgImage(CSSProperties.getFunction((TermFunction)t)));
        }
        this.setPropertyField(property, declaration, v);
    }

    protected void setBackground(Declaration declaration, String ... property) {
        Object[] v = new Object[property.length];
        boolean n = false;
        for (Term t : declaration) {
            if (t instanceof TermURI) {
                ArrayList<BgImage> vv = new ArrayList<BgImage>();
                try {
                    vv.add(new BgImage(((TermURI)t).getBase(), (String)t.getValue()));
                    v[0] = vv;
                }
                catch (MalformedURLException e) {
                    logger_.severe(e.getMessage());
                }
            }
            if (!(t instanceof TermColor)) continue;
            try {
                v[7] = ((TermColor)t).getValue();
            }
            catch (Exception ex) {}
        }
        for (int i = 0; i < v.length; ++i) {
            this.setPropertyField(property[i], declaration, v[i]);
        }
    }

    protected void setString(Declaration declaration, String property) {
        String v = null;
        Iterator i$ = declaration.iterator();
        if (i$.hasNext()) {
            Term t = (Term)i$.next();
            v = (String)t.getValue();
        }
        this.setPropertyField(property, declaration, v);
    }

    protected void setColors(Declaration declaration, String ... property) {
        Color[] v = new Color[property.length];
        int n = 0;
        for (Term t : declaration) {
            if (!(t instanceof TermColor)) continue;
            v[n] = (Color)((TermColor)t).getValue();
            if (++n != v.length) continue;
            break;
        }
        if (n == 0) {
            return;
        }
        if (v.length == 4) {
            switch (n) {
                case 1: {
                    v[2] = v[3] = v[0];
                    v[1] = v[3];
                    break;
                }
                case 2: {
                    v[2] = v[0];
                    v[3] = v[1];
                    break;
                }
                case 3: {
                    v[3] = v[1];
                }
            }
        }
        for (int i = 0; i < v.length; ++i) {
            this.setPropertyField(property[i], declaration, v[i]);
        }
    }

    protected void setNumberPairs(Declaration declaration, String ... property) {
        BpNumber[][] v = new BpNumber[property.length][2];
        int n = 0;
        for (Term t : declaration) {
            if (!(t instanceof TermNumeric)) continue;
            v[n / 2][n % 2] = CSSProperties.getNumber((TermNumeric)t, BpNumber.Unit.PIXEL);
            if (++n != v.length * v[0].length) continue;
            break;
        }
        if (n == 0) {
            return;
        }
        assert (v.length == 1 || v.length == 4);
        if (v.length == 1 && n == 1) {
            v[0][1] = v[0][0];
        }
        if (v.length == 4) {
            switch (n) {
                case 8: {
                    break;
                }
                case 4: {
                    BpNumber bpNumber = v[1][1];
                    v[3][1] = bpNumber;
                    v[3][0] = bpNumber;
                    BpNumber bpNumber2 = v[1][0];
                    v[2][1] = bpNumber2;
                    v[2][0] = bpNumber2;
                    BpNumber bpNumber3 = v[0][1];
                    v[1][1] = bpNumber3;
                    v[1][0] = bpNumber3;
                    BpNumber bpNumber4 = v[0][0];
                    v[0][1] = bpNumber4;
                    v[0][0] = bpNumber4;
                    break;
                }
                case 3: {
                    BpNumber bpNumber = v[0][1];
                    v[3][1] = bpNumber;
                    v[3][0] = bpNumber;
                    BpNumber bpNumber5 = v[1][0];
                    v[2][1] = bpNumber5;
                    v[2][0] = bpNumber5;
                    BpNumber bpNumber6 = v[0][1];
                    v[1][1] = bpNumber6;
                    v[1][0] = bpNumber6;
                    BpNumber bpNumber7 = v[0][0];
                    v[0][1] = bpNumber7;
                    v[0][0] = bpNumber7;
                    break;
                }
                case 2: {
                    BpNumber bpNumber = v[0][1];
                    v[3][1] = bpNumber;
                    v[3][0] = bpNumber;
                    BpNumber bpNumber8 = v[0][0];
                    v[2][1] = bpNumber8;
                    v[2][0] = bpNumber8;
                    BpNumber bpNumber9 = v[0][1];
                    v[1][1] = bpNumber9;
                    v[1][0] = bpNumber9;
                    BpNumber bpNumber10 = v[0][0];
                    v[0][1] = bpNumber10;
                    v[0][0] = bpNumber10;
                    break;
                }
                case 1: {
                    BpNumber bpNumber = v[0][0];
                    v[3][1] = bpNumber;
                    v[3][0] = bpNumber;
                    BpNumber bpNumber11 = v[0][0];
                    v[2][1] = bpNumber11;
                    v[2][0] = bpNumber11;
                    BpNumber bpNumber12 = v[0][0];
                    v[1][1] = bpNumber12;
                    v[1][0] = bpNumber12;
                    BpNumber bpNumber13 = v[0][0];
                    v[0][1] = bpNumber13;
                    v[0][0] = bpNumber13;
                }
            }
        }
        for (int i = 0; i < v.length; ++i) {
            this.setPropertyField(property[i], declaration, v[i]);
        }
    }

    protected void setNumbers(Declaration declaration, String ... property) {
        BpNumber[] v = new BpNumber[property.length];
        int n = 0;
        for (Term t : declaration) {
            if (t instanceof TermNumeric) {
                v[n] = CSSProperties.getNumber((TermNumeric)t, BpNumber.Unit.PIXEL);
                if (++n != v.length) continue;
                break;
            }
            if (!(t instanceof TermIdent) && !(t instanceof TermString) || !"auto".equals((String)t.getValue())) continue;
            v[n] = new BpNumber(0.0, BpNumber.Unit.PIXEL);
            if (++n != v.length) continue;
            break;
        }
        if (n == 0) {
            return;
        }
        if (v.length == 4) {
            switch (n) {
                case 1: {
                    v[2] = v[3] = v[0];
                    v[1] = v[3];
                    break;
                }
                case 2: {
                    v[2] = v[0];
                    v[3] = v[1];
                    break;
                }
                case 3: {
                    v[3] = v[1];
                }
            }
        }
        for (int i = 0; i < v.length; ++i) {
            this.setPropertyField(property[i], declaration, v[i]);
        }
    }

    protected void setLineHeight(Declaration declaration, String property) {
        BpNumber v = null;
        for (Term t : declaration) {
            if (t instanceof TermNumeric) {
                v = CSSProperties.getNumber((TermNumeric)t, BpNumber.Unit.EM);
                break;
            }
            if (!(t instanceof TermIdent) && !(t instanceof TermString)) continue;
            switch ((String)t.getValue()) {
                default: {
                    logger_.log(Level.FINE, "Unsupported line height \"" + t.getValue() + "\", substituting \"normal\".");
                }
                case "normal": 
            }
            v = new BpNumber(1.2, BpNumber.Unit.EM);
            break;
        }
        if (v == null) {
            logger_.log(Level.WARNING, "Missing line height value.");
            return;
        }
        this.setPropertyField(property, declaration, v);
    }

    protected void setFontWeight(Declaration declaration, String property) {
        BpNumber v = null;
        for (Term t : declaration) {
            if (t instanceof TermNumeric) {
                v = CSSProperties.getNumber((TermNumeric)t, BpNumber.Unit.NONE);
                break;
            }
            if (!(t instanceof TermIdent) && !(t instanceof TermString)) continue;
            switch ((String)t.getValue()) {
                default: {
                    logger_.log(Level.FINE, "Unsupported font weight \"" + t.getValue() + "\", substituting \"normal\".");
                }
                case "normal": {
                    v = new BpNumber(500.0, BpNumber.Unit.NONE);
                    break;
                }
                case "bold": {
                    v = new BpNumber(700.0, BpNumber.Unit.NONE);
                    break;
                }
                case "bolder": {
                    v = new BpNumber(700.0, BpNumber.Unit.NONE);
                    break;
                }
                case "lighter": {
                    v = new BpNumber(400.0, BpNumber.Unit.NONE);
                    break;
                }
            }
            break;
        }
        if (v == null) {
            logger_.log(Level.WARNING, "Missing font weight value.");
            return;
        }
        this.setPropertyField(property, declaration, v);
    }

    private static BgFunction getFunction(TermFunction term) {
        LinkedList<BpNumber> parameters = new LinkedList<BpNumber>();
        Object parameter = null;
        for (Term t : term) {
            if (t.getOperator() == Term.Operator.COMMA && parameter != null) {
                parameters.add((BpNumber)parameter);
                parameter = null;
            }
            Object v = null;
            if (t instanceof TermColor) {
                v = ((TermColor)t).getValue();
            } else if (t instanceof TermNumeric) {
                v = CSSProperties.getNumber((TermNumeric)t, BpNumber.Unit.PIXEL);
            } else {
                if (!(t instanceof TermIdent) && !(t instanceof TermString)) continue;
                v = (String)t.getValue();
            }
            if (parameter == null) {
                parameter = v;
                continue;
            }
            if (parameter instanceof List) {
                ((List)parameter).add(v);
                continue;
            }
            LinkedList<Object> sublist = new LinkedList<Object>();
            sublist.add(parameter);
            sublist.add(v);
            parameter = sublist;
        }
        if (parameter != null) {
            parameters.add((BpNumber)parameter);
        }
        return new BgFunction(term.getFunctionName(), parameters);
    }

    private static BpNumber getNumber(TermNumeric term, BpNumber.Unit defaultUnit) {
        double v = ((Number)term.getValue()).doubleValue();
        if (term instanceof TermPercent) {
            return new BpNumber(v, BpNumber.Unit.PERCENT);
        }
        TermNumeric.Unit unit = term.getUnit();
        if (unit != null) {
            switch (unit) {
                default: {
                    logger_.log(Level.WARNING, "Unsupported unit \"" + (Object)((Object)unit) + "\", substituting \"" + (Object)((Object)defaultUnit) + "\".");
                }
                case none: {
                    return new BpNumber(v, defaultUnit);
                }
                case px: {
                    return new BpNumber(v, BpNumber.Unit.PIXEL);
                }
                case pt: {
                    return new BpNumber(v, BpNumber.Unit.POINT);
                }
                case pc: {
                    return new BpNumber(v, BpNumber.Unit.PICA);
                }
                case in: {
                    return new BpNumber(v, BpNumber.Unit.INCH);
                }
                case cm: {
                    return new BpNumber(v, BpNumber.Unit.CM);
                }
                case mm: {
                    return new BpNumber(v, BpNumber.Unit.MM);
                }
                case em: 
            }
            return new BpNumber(v, BpNumber.Unit.EM);
        }
        return new BpNumber(v, defaultUnit);
    }

    public static enum FoFormat {
        TRUETYPE,
        OPENTYPE,
        TYPE1,
        UNSUPPORTED;

    }

    public static enum FoStretch {
        NORMAL,
        ULTRA_CONDENSED,
        EXTRA_CONDENSED,
        CONDENSED,
        SEMI_CONDENSED,
        SEMI_EXPANDED,
        EXPANDED,
        EXTRA_EXPANDED,
        ULTRA_EXPANDED;

    }

    public static enum FoStyle {
        NORMAL,
        OBLIQUE,
        ITALIC;

    }

    public static class BdShadow {
    }

    public static enum BdBreak {
        SLICE,
        CLONE;

    }

    public static enum BiRepeat {
        STRETCH,
        REPEAT,
        ROUND,
        SPACE;

    }

    public static class BiWidth {
        public static final BiWidth ONE = null;
    }

    public static class BiSlice {
        public static final BiSlice FULL = null;
    }

    public static enum BoStyle {
        NONE,
        HIDDEN,
        DOTTED,
        DASHED,
        SOLID,
        DOUBLE,
        GROOVE,
        RIDGE,
        INSET,
        OUTSET;

    }

    public static class BpNumber {
        public final double value_;
        public final Unit unit_;
        public BpNumber lengthBase_ = null;
        public Font fontBase_ = null;
        private static final double px_per_pt = 1.3333333333333333;
        private static final double px_per_pc = 13.333333333333334;
        private static final double px_per_in = 96.0;
        private static final double px_per_cm = 37.79527559055118;
        private static final double px_per_mm = 3.7795275590551185;

        private static boolean isAbsolute(Unit unit) {
            return unit == Unit.PIXEL || unit == Unit.POINT || unit == Unit.PICA || unit == Unit.INCH || unit == Unit.CM || unit == Unit.MM;
        }

        public boolean isAbsolute() {
            return BpNumber.isAbsolute(this.unit_);
        }

        public BpNumber(double value, Unit unit) {
            this.value_ = value;
            this.unit_ = unit;
        }

        public void setLengthBase(BpNumber lengthBase) {
            this.lengthBase_ = lengthBase;
        }

        public void setFontBase(Font fontBase) {
            this.fontBase_ = fontBase;
        }

        public double toPX() {
            switch (this.unit_) {
                case PIXEL: {
                    return this.value_;
                }
                case POINT: {
                    return this.value_ * 1.3333333333333333;
                }
                case PICA: {
                    return this.value_ * 13.333333333333334;
                }
                case INCH: {
                    return this.value_ * 96.0;
                }
                case CM: {
                    return this.value_ * 37.79527559055118;
                }
                case MM: {
                    return this.value_ * 3.7795275590551185;
                }
                case PERCENT: {
                    if (this.lengthBase_ != null) {
                        return this.value_ * this.lengthBase_.toPX() / 100.0;
                    }
                    if (this.fontBase_ != null) {
                        return this.value_ * (double)this.fontBase_.getSize2D() / 100.0;
                    }
                    logger_.log(Level.WARNING, "No absolute base for % value (no conversion performed).");
                    return this.value_;
                }
                case EM: {
                    if (this.fontBase_ != null) {
                        return this.value_ * (double)this.fontBase_.getSize2D();
                    }
                    if (this.lengthBase_ != null) {
                        return this.value_ * this.lengthBase_.toPX();
                    }
                    logger_.log(Level.WARNING, "No absolute base for em value (no conversion performed).");
                    return this.value_;
                }
                case EX: {
                    if (this.fontBase_ != null) {
                        return this.value_ * (double)this.fontBase_.getSize2D() / 2.0;
                    }
                    logger_.log(Level.WARNING, "No absolute base for ex value (no conversion performed).");
                    return this.value_;
                }
            }
            logger_.log(Level.WARNING, "Unsupported unit " + (Object)((Object)this.unit_) + " (no conversion performed).");
            return this.value_;
        }

        public BpNumber convert(Unit unit) {
            if (this.unit_ == Unit.NONE || unit == this.unit_ || !BpNumber.isAbsolute(unit)) {
                return this;
            }
            double value = this.toPX();
            switch (unit) {
                case PIXEL: {
                    break;
                }
                case POINT: {
                    value /= 1.3333333333333333;
                    break;
                }
                case PICA: {
                    value /= 13.333333333333334;
                    break;
                }
                case INCH: {
                    value /= 96.0;
                    break;
                }
                case CM: {
                    value /= 37.79527559055118;
                    break;
                }
                case MM: {
                    value /= 3.7795275590551185;
                }
            }
            return new BpNumber(value, unit);
        }

        public String toString() {
            return "" + this.value_ + " " + (Object)((Object)this.unit_);
        }

        public static enum Unit {
            NONE,
            PIXEL,
            POINT,
            PICA,
            INCH,
            CM,
            MM,
            PERCENT,
            EM,
            EX;

        }
    }

    public static class BgSize {
        public static final BgSize AUTO = null;
        public static final BgSize CONTAIN = null;
        public static final BgSize COVER = null;
    }

    public static enum BgBox {
        BORDER_BOX,
        PADDING_BOX,
        CONTENT_BOX;

    }

    public static enum BgAttachment {
        SCROLL,
        FIXED,
        LOCAL;

    }

    public static enum BgRepeat {
        REPEAT,
        SPACE,
        ROUND,
        NO_REPEAT;

    }

    public static class BgFunction {
        public final String name_;
        public final List parameters_;

        public BgFunction(String name, List parameters) {
            this.name_ = name;
            this.parameters_ = parameters;
        }

        public String toString() {
            StringBuffer pb = new StringBuffer();
            for (Object p : this.parameters_) {
                if (pb.length() > 0) {
                    pb.append(",");
                }
                pb.append("" + p);
            }
            return "" + this.name_ + "(" + pb + ")";
        }
    }

    public static class BgImage {
        public final URL url_;
        public final BgFunction function_;

        public BgImage() {
            this.url_ = null;
            this.function_ = null;
        }

        public BgImage(URL baseURL, String path) throws MalformedURLException {
            URL bu = null;
            if (baseURL != null) {
                try {
                    bu = new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), baseURL.getFile(), CSS.getURLStreamHandler());
                }
                catch (Exception ex) {
                    logger_.log(Level.WARNING, "URL resolution failed:" + baseURL + " (ignored).", ex);
                    bu = baseURL;
                }
            }
            URL url = new URL(bu, path);
            URL u = null;
            try {
                u = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), CSS.getURLStreamHandler());
            }
            catch (Exception ex) {
                u = url;
            }
            if (!"file".equals(u.getProtocol()) || !"".equals(u.getHost())) {
                logger_.severe("Unsupported non-file URL:" + u + " (ignored).");
                u = null;
            }
            this.url_ = u;
            this.function_ = null;
        }

        public BgImage(BgFunction function) {
            this.url_ = null;
            this.function_ = function;
        }

        public String toString() {
            return "" + this.url_ + " " + this.function_;
        }
    }

    public static class BgPosition {
        public final Base baseX_;
        public final BpNumber offsetX_;
        public final Base baseY_;
        public final BpNumber offsetY_;

        public static Base getBase(String s) {
            return s.equalsIgnoreCase("left") ? Base.LEFT : (s.equalsIgnoreCase("right") ? Base.RIGHT : (s.equalsIgnoreCase("top") ? Base.TOP : (s.equalsIgnoreCase("bottom") ? Base.BOTTOM : Base.CENTER)));
        }

        public BgPosition(Base baseX, BpNumber offsetX, Base baseY, BpNumber offsetY) {
            this.baseX_ = baseX;
            this.offsetX_ = offsetX;
            this.baseY_ = baseY;
            this.offsetY_ = offsetY;
        }

        public BgPosition() {
            this(Base.CENTER, new BpNumber(0.0, BpNumber.Unit.PERCENT), Base.CENTER, new BpNumber(0.0, BpNumber.Unit.PERCENT));
        }

        public String toString() {
            return "" + (Object)((Object)this.baseX_) + " " + this.offsetX_ + " " + (Object)((Object)this.baseY_) + " " + this.offsetY_;
        }

        public static enum Base {
            CENTER,
            LEFT,
            RIGHT,
            TOP,
            BOTTOM;

        }
    }
}

