/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.css;

import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.BackgroundProperties;
import com.ge.med.iungo.css.CSSProperties;
import com.ge.med.iungo.css.FontFaceProperties;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.util.Configuration;
import com.ge.med.iungo.util.Fonts;
import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleFontFace;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermString;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImageOp;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class CSS {
    private static final Logger logger_ = Logger.getLogger(CSS.class.getName());
    private static StyleSheet[] styleSheet_ = null;
    private static Map<String, FontFaceProperties> fontFaces_ = new TreeMap<String, FontFaceProperties>();
    private static Map<String, Integer> iconCodes_ = new TreeMap<String, Integer>();
    private static int styleSheetCacheSize_ = Configuration.getInt("styleSheetCacheSize", 4);
    private static boolean styleSheetCacheActive_ = !Configuration.getBoolean("styleSheetCacheDisable", false);
    private static Map<URL, StyleSheet> styleSheetCache_ = new LinkedHashMap<URL, StyleSheet>(styleSheetCacheSize_, 1.1f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<URL, StyleSheet> eldest) {
            return this.size() > styleSheetCacheSize_;
        }
    };
    private static Map<String, String> genericFonts_ = new HashMap<String, String>();
    private static JComponent defaultBody_;
    private static URLStreamHandler urlStreamHandler_;
    private static int infoCacheSize_;
    private static boolean infoCacheActive_;
    private static Map<String, BackgroundInfo> infoCache_;
    private static int propertiesCacheSize_;
    private static boolean propertiesCacheActive_;
    private static Map<String, BackgroundProperties> propertiesCache_;
    private static final double ZOOM_MIN = 0.3;
    private static final double ZOOM_MAX = 3.0;
    private static String zoomString_;
    private static double zoom_;
    private static BufferedImageOp zoomImageOp_;

    public static synchronized void loadStyleSheet(List<StyleSheetURL> cssList) throws CSSException, IOException, MalformedURLException {
        ArrayList<StyleSheet> styleSheetList = new ArrayList<StyleSheet>(cssList.size());
        for (StyleSheetURL css : cssList) {
            long t0;
            StyleSheet ss = null;
            if (css.serializedURL_ != null) {
                if (styleSheetCacheActive_) {
                    ss = styleSheetCache_.get(css.serializedURL_);
                }
                if (ss == null) {
                    try {
                        t0 = System.currentTimeMillis();
                        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(css.serializedURL_.openStream(), 256000));
                        ss = (StyleSheet)ois.readObject();
                        ois.close();
                        logger_.log(Level.INFO, "Successfully loaded serialized style sheet <" + css.serializedURL_.getPath() + "> in " + (System.currentTimeMillis() - t0) + "ms.");
                        if (ss != null && styleSheetCacheActive_) {
                            styleSheetCache_.put(css.serializedURL_, ss);
                        }
                    }
                    catch (Exception e) {
                        logger_.log(Level.WARNING, "Failed to load serialized style sheet <" + css.serializedURL_.getPath() + ">. Falling back to .css file.");
                    }
                }
            }
            if (ss == null) {
                if (styleSheetCacheActive_) {
                    ss = styleSheetCache_.get(css.rawURL_);
                }
                if (ss == null) {
                    try {
                        t0 = System.currentTimeMillis();
                        Logger.getLogger("cz.vutbr").setLevel(Level.WARNING);
                        ss = CSSFactory.parse(css.rawURL_, "UTF-8");
                        logger_.log(Level.INFO, "Successfully parsed style sheet <" + css.rawURL_.getPath() + "> in " + (System.currentTimeMillis() - t0) + "ms.");
                        if (ss != null && styleSheetCacheActive_) {
                            styleSheetCache_.put(css.rawURL_, ss);
                        }
                    }
                    catch (Exception e) {
                        logger_.log(Level.SEVERE, "Failure parsing style sheet <" + css.rawURL_.getPath() + ">.", e);
                    }
                }
            }
            if (ss == null) continue;
            CSS.loadFontFaces(ss);
            CSS.loadIcons(ss);
            styleSheetList.add(ss);
        }
        styleSheet_ = styleSheetList.toArray(new StyleSheet[0]);
        CSS.clearCache();
    }

    private static void loadFontFaces(StyleSheet styleSheet) {
        for (RuleBlock rb : styleSheet) {
            if (!(rb instanceof RuleFontFace)) continue;
            LinkedList<CSSProperty> cssp = new LinkedList<CSSProperty>();
            for (Declaration d : (RuleFontFace)rb) {
                cssp.add(0, new CSSProperty(d.getProperty(), d));
            }
            FontFaceProperties ffp = new FontFaceProperties();
            for (CSSProperty p : cssp) {
                logger_.log(Level.FINE, "SET:" + p.property_ + "\t" + p.declaration_);
                ffp.set(p.property_, p.declaration_, null);
            }
            if (!ffp.initFont()) continue;
            fontFaces_.put(ffp.font_family_ + "-" + ffp.font_weight_ + "-" + (Object)((Object)ffp.font_style_) + "-" + (Object)((Object)ffp.font_stretch_), ffp);
        }
    }

    private static List<String> resolveFontFamilies(List<String> fontFamilies, JComponent component) {
        JComponent parent = component != null ? CSS.getParent(component) : null;
        LinkedList<String> allFontFamilies = new LinkedList<String>();
        for (String fontFamily : fontFamilies) {
            if ("inherit".equals(fontFamily)) {
                if (parent == null) {
                    logger_.log(Level.WARNING, "Unresolved \"inherit\" font-family reference ignored.");
                    continue;
                }
                BackgroundProperties bp = CSS.getBackgroundProperties(parent);
                if (bp.font_family_ == null) continue;
                allFontFamilies.addAll(CSS.resolveFontFamilies(bp.font_family_, parent));
                continue;
            }
            String gff = genericFonts_.get(fontFamily);
            allFontFamilies.add(gff != null ? gff : fontFamily);
        }
        return allFontFamilies;
    }

    public static synchronized Font getFont(JComponent component, List<String> fontFamilies, CSSProperties.BpNumber weight, CSSProperties.FoStyle style, CSSProperties.FoStretch stretch, float size) {
        fontFamilies = new LinkedList<String>(new LinkedHashSet<String>(CSS.resolveFontFamilies(fontFamilies, component)));
        int awtStyle = (weight.value_ > 500.0 ? 1 : 0) | (style == CSSProperties.FoStyle.ITALIC || style == CSSProperties.FoStyle.OBLIQUE ? 2 : 0);
        return Fonts.getFontUIResource(Fonts.getFont(fontFamilies, awtStyle).deriveFont(size));
    }

    private static void loadIcons(StyleSheet styleSheet) {
        for (RuleBlock ruleBlock : styleSheet) {
            if (!(ruleBlock instanceof RuleSet)) continue;
            RuleSet ruleSet = (RuleSet)ruleBlock;
            String iconName = null;
            for (CombinedSelector combinedSelector : ruleSet.getSelectors()) {
                for (Selector selector : combinedSelector) {
                    for (Selector.SelectorPart selectorPart : selector) {
                        Selector.ElementClass elementClass;
                        String className;
                        if (!(selectorPart instanceof Selector.ElementClass) || !(className = (elementClass = (Selector.ElementClass)selectorPart).getClassName()).startsWith("icon-")) continue;
                        iconName = className;
                    }
                }
            }
            if (iconName == null) continue;
            for (Declaration declaration : ruleSet) {
                String property = declaration.getProperty();
                if (!property.equals("content")) continue;
                for (Term term : declaration) {
                    String value;
                    if (!(term instanceof TermString) || !(value = (String)term.getValue()).startsWith("\\")) continue;
                    try {
                        iconCodes_.put(iconName, Integer.valueOf(value.substring(1), 16));
                    }
                    catch (Exception ex) {
                        logger_.log(Level.SEVERE, "", ex);
                    }
                }
            }
        }
    }

    public static synchronized List<DeclarationMatch> getCSS(JComponent component) {
        LinkedList<RuleSet> ruleSets = new LinkedList<RuleSet>();
        final HashMap<RuleSet, SelectorMatch> match = new HashMap<RuleSet, SelectorMatch>();
        for (StyleSheet styleSheet : styleSheet_) {
            for (RuleBlock rb : styleSheet) {
                RuleSet rs;
                SelectorMatch m;
                if (!(rb instanceof RuleSet) || (m = CSS.match(component, rs = (RuleSet)rb)) == null) continue;
                ruleSets.add(rs);
                match.put(rs, m);
            }
        }
        Collections.sort(ruleSets, new Comparator<RuleSet>(){

            @Override
            public int compare(RuleSet rs1, RuleSet rs2) {
                int s1 = ((SelectorMatch)match.get((Object)rs1)).specificity_;
                int s2 = ((SelectorMatch)match.get((Object)rs2)).specificity_;
                return s1 < s2 ? -1 : (s1 > s2 ? 1 : 0);
            }
        });
        LinkedList<DeclarationMatch> declarations = new LinkedList<DeclarationMatch>();
        for (RuleSet ruleSet : ruleSets) {
            SelectorMatch sm = (SelectorMatch)match.get(ruleSet);
            for (Declaration d : ruleSet) {
                declarations.add(new DeclarationMatch(d, sm));
            }
        }
        return declarations;
    }

    private static SelectorMatch match(JComponent component, RuleSet ruleSet) {
        int specificity = -1;
        CombinedSelector selector = null;
        List<CombinedSelector> combinedSelectorList = ruleSet.getSelectors();
        for (CombinedSelector cs : combinedSelectorList) {
            LinkedList<Selector> selectorList = new LinkedList<Selector>(cs);
            Collections.reverse(selectorList);
            int sp = CSS.match(component, selectorList);
            if (sp <= specificity) continue;
            selector = cs;
            specificity = sp;
        }
        if (specificity == -1) {
            return null;
        }
        return new SelectorMatch(selector, specificity);
    }

    private static Object getClientProperty(JComponent component, String key) {
        Object relative;
        Object value = component.getClientProperty(key);
        if (value == null && (relative = component.getClientProperty("css_relative")) instanceof JComponent) {
            value = ((JComponent)relative).getClientProperty(key);
        }
        return value;
    }

    public static JComponent getParent(Component c) {
        Object o;
        if (c == defaultBody_) {
            return null;
        }
        Container p = null;
        if (c instanceof JComponent && (o = ((JComponent)c).getClientProperty("css_parent")) instanceof Container) {
            p = (Container)o;
        }
        if (p instanceof JComponent) {
            return (JComponent)p;
        }
        for (p = c.getParent(); p != null && !(p instanceof JComponent); p = p.getParent()) {
        }
        if (p instanceof JComponent) {
            return (JComponent)p;
        }
        return defaultBody_;
    }

    private static int match(JComponent component, List<Selector> selectorList) {
        int specificity = 0;
        LinkedList<Selector> sl = new LinkedList<Selector>(selectorList);
        while (!sl.isEmpty()) {
            Selector s = (Selector)sl.remove(0);
            int mm = CSS.matchS(component, s);
            if (mm == -1) {
                return -1;
            }
            specificity += mm;
            Selector.Combinator combinator = s.getCombinator();
            if (combinator == null) continue;
            switch (combinator) {
                case CHILD: {
                    JComponent c = CSS.getParent(component);
                    if (!(c instanceof JComponent)) {
                        return -1;
                    }
                    int m = CSS.match(c, sl);
                    if (m == -1) {
                        return -1;
                    }
                    return specificity += m;
                }
                case DESCENDANT: {
                    JComponent c = CSS.getParent(component);
                    while (c != null) {
                        int m;
                        if (c instanceof JComponent && (m = CSS.match(c, sl)) != -1) {
                            return specificity += m;
                        }
                        c = CSS.getParent(c);
                    }
                    return -1;
                }
                case ADJACENT: {
                    Container p = component.getParent();
                    if (p == null) {
                        return -1;
                    }
                    Component[] c = p.getComponents();
                    for (int i = 1; i < c.length; ++i) {
                        if (c[i] != component) continue;
                        if (!(c[i - 1] instanceof JComponent)) {
                            return -1;
                        }
                        int m = CSS.match((JComponent)c[i - 1], sl);
                        if (m == -1) {
                            return -1;
                        }
                        return specificity += m;
                    }
                    return -1;
                }
            }
        }
        return specificity;
    }

    private static int matchS(JComponent component, Selector selector) {
        int specificity = 0;
        boolean isPseudoElement = Boolean.TRUE.equals(component.getClientProperty("css_pseudo"));
        boolean matchPseudoElement = false;
        for (Selector.SelectorPart sp : selector) {
            String s;
            if (sp instanceof Selector.ElementName) {
                s = ((Selector.ElementName)sp).getName();
                if (!s.equals("*") && !s.equals(CSS.getClientProperty(component, "css_element"))) {
                    return -1;
                }
                ++specificity;
            }
            if (sp instanceof Selector.ElementClass) {
                s = ((Selector.ElementClass)sp).getClassName();
                Object p = CSS.getClientProperty(component, "css_class");
                if (!(p instanceof String)) {
                    return -1;
                }
                if (!component.isEnabled()) {
                    p = p + " disabled";
                }
                if (component instanceof AbstractButton && ((AbstractButton)component).isSelected()) {
                    p = p + " checked";
                }
                boolean match = false;
                for (String cc : ((String)p).split(" ")) {
                    match = match || s.equals(cc);
                }
                if (!match) {
                    return -1;
                }
                specificity += 1000;
            }
            if (sp instanceof Selector.ElementID) {
                s = ((Selector.ElementID)sp).getID();
                if (!s.equals(CSS.getClientProperty(component, "css_id"))) {
                    return -1;
                }
                specificity += 1000000000;
            }
            if (sp instanceof Selector.ElementAttribute) {
                s = ((Selector.ElementAttribute)sp).getAttribute();
                String v = ((Selector.ElementAttribute)sp).getValue();
                String value = (String)CSS.getClientProperty(component, "css_attribute_" + s);
                if (value == null) {
                    return -1;
                }
                boolean match = false;
                switch (((Selector.ElementAttribute)sp).getOperator()) {
                    case NO_OPERATOR: {
                        match = true;
                        break;
                    }
                    case EQUALS: {
                        match = value.equals(v);
                        break;
                    }
                    case STARTSWITH: {
                        match = value.startsWith(v);
                        break;
                    }
                    case INCLUDES: {
                        match = value.contains(v);
                        break;
                    }
                    case CONTAINS: {
                        match = value.contains(v);
                        break;
                    }
                    case DASHMATCH: {
                        match = value.startsWith(v);
                        break;
                    }
                }
                if (!match) {
                    return -1;
                }
                specificity += 1000000;
            }
            if (!(sp instanceof Selector.PseudoPage)) continue;
            s = ((Selector.PseudoPage)sp).getValue();
            boolean explicitMatch = Boolean.TRUE.equals(CSS.getClientProperty(component, "css_" + s));
            boolean explicitFalse = Boolean.FALSE.equals(CSS.getClientProperty(component, "css_" + s));
            boolean match = false;
            boolean element = false;
            switch (s) {
                case "active": {
                    match = explicitMatch || component instanceof AbstractButton && ((AbstractButton)component).getModel() != null && ((AbstractButton)component).getModel().isArmed();
                    break;
                }
                case "hover": {
                    match = explicitMatch || component instanceof AbstractButton && ((AbstractButton)component).getModel() != null && ((AbstractButton)component).getModel().isRollover();
                    break;
                }
                case "enabled": {
                    match = component.isEnabled();
                    break;
                }
                case "disabled": {
                    match = !component.isEnabled();
                    break;
                }
                case "checked": {
                    match = component instanceof AbstractButton && ((AbstractButton)component).isSelected();
                    break;
                }
                case "focus": {
                    match = explicitMatch || component.hasFocus() && !explicitFalse;
                    break;
                }
                case "empty": {
                    match = component.getComponentCount() == 0;
                    break;
                }
                case "only-child": {
                    Container p = component.getParent();
                    match = p != null && p.getComponentCount() == 1;
                    element = true;
                    break;
                }
                case "nth-child": {
                    element = true;
                    break;
                }
                case "first-child": {
                    match = explicitMatch;
                    if (match) {
                        logger_.log(Level.FINE, "FIRST CHILD " + component.hashCode());
                    }
                    element = true;
                    break;
                }
                case "last-child": {
                    match = explicitMatch;
                    element = true;
                    break;
                }
                case "nth-last-child": {
                    element = true;
                    break;
                }
                case "before": {
                    match = explicitMatch;
                    element = true;
                    matchPseudoElement = true;
                    break;
                }
                case "after": {
                    match = explicitMatch;
                    element = true;
                    matchPseudoElement = true;
                }
            }
            if (!match) {
                return -1;
            }
            specificity += element ? 1 : 1000;
        }
        if (isPseudoElement && !matchPseudoElement) {
            return -1;
        }
        return specificity;
    }

    public static URLStreamHandler getURLStreamHandler() {
        if (urlStreamHandler_ == null) {
            urlStreamHandler_ = new URLStreamHandler(){

                @Override
                public URLConnection openConnection(URL url) {
                    if ("file".equals(url.getProtocol())) {
                        return new URLConnection(url){

                            @Override
                            public void connect() {
                            }

                            @Override
                            public InputStream getInputStream() {
                                logger_.log(Level.INFO, "RESOURCE/FILE URL CONNECTION:" + this.url.getPath());
                                InputStream is = null;
                                try {
                                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.url.getPath());
                                    if (is != null) {
                                        logger_.log(Level.INFO, "Reading " + this.url.getPath() + " from class loader resource.");
                                        return new BufferedInputStream(is, 128000);
                                    }
                                    logger_.log(Level.INFO, "Reading " + this.url.getPath() + " from external file.");
                                    return new BufferedInputStream(new FileInputStream(this.url.getPath()), 128000);
                                }
                                catch (Exception ex) {
                                    logger_.log(Level.WARNING, "Exception reading " + this.url.getPath() + ".", ex);
                                    return null;
                                }
                            }
                        };
                    }
                    try {
                        logger_.log(Level.WARNING, "Unsupported non-file URL:" + url + ".");
                        return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile()).openConnection();
                    }
                    catch (Exception ex) {
                        logger_.log(Level.WARNING, "Unanticipated exception reading " + url.getPath() + ".", ex);
                        return null;
                    }
                }
            };
        }
        return urlStreamHandler_;
    }

    private static void clearCache() {
        infoCache_.clear();
        propertiesCache_.clear();
        Background.imageCache_.clear();
    }

    private static String getPropertiesCacheKey(JComponent component) {
        if (!infoCacheActive_ && !propertiesCacheActive_) {
            return "";
        }
        Object cacheKey = component.getClientProperty("css_cacheKey");
        if (cacheKey != null) {
            return cacheKey.toString();
        }
        StringBuffer sb = new StringBuffer();
        CSS.getPropertiesCacheKey(component, sb);
        return sb.toString();
    }

    private static void getPropertiesCacheKey(JComponent component, StringBuffer sb) {
        Object cacheKey = component.getClientProperty("css_cacheKey");
        if (cacheKey != null) {
            sb.append(cacheKey.toString());
            return;
        }
        sb.append('#');
        sb.append(component.getComponentCount());
        sb.append(component.hasFocus() ? "F" : "f");
        sb.append(component.isEnabled() ? "E" : "e");
        if (component instanceof JComboBox) {
            sb.append(((JComboBox)component).isEditable() ? "D" : "d");
        }
        if (component instanceof JTextComponent) {
            sb.append(((JTextComponent)component).isEditable() ? "D" : "d");
        }
        if (component instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)component;
            sb.append(ab.isSelected() ? "S" : "s");
            sb.append(ab.isBorderPainted() ? "B" : "b");
            ButtonModel bm = ab.getModel();
            if (bm != null) {
                sb.append(bm.isArmed() ? "A" : "a");
                sb.append(bm.isRollover() ? "R" : "r");
            }
        }
        sb.append('*');
        Object s = component.getClientProperty("css_element");
        if (null != s) {
            sb.append('a');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_class"))) {
            sb.append('b');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_id"))) {
            sb.append('c');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_active"))) {
            sb.append('d');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_after"))) {
            sb.append('e');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_attribute_class"))) {
            sb.append('f');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_attribute_data-toggle"))) {
            sb.append('g');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_attribute_data-visualization"))) {
            sb.append('h');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_attribute_disabled"))) {
            sb.append('i');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_attribute_readonly"))) {
            sb.append('j');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_attribute_type"))) {
            sb.append('k');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_before"))) {
            sb.append('l');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_disabled"))) {
            sb.append('m');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_first-child"))) {
            sb.append('n');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_focus"))) {
            sb.append('o');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_hover"))) {
            sb.append('p');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_last-child"))) {
            sb.append('q');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_link"))) {
            sb.append('r');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_odd"))) {
            sb.append('s');
            sb.append(s.hashCode());
        }
        if (null != (s = component.getClientProperty("css_visited"))) {
            sb.append('t');
            sb.append(s.hashCode());
        }
        sb.append('^');
        JComponent p = CSS.getParent(component);
        if (p instanceof JComponent) {
            CSS.getPropertiesCacheKey(p, sb);
        }
    }

    private static String getInfoCacheKey(JComponent component, String propertiesCacheKey) {
        if (!infoCacheActive_ && !propertiesCacheActive_) {
            return "";
        }
        Object cacheKey = component.getClientProperty("css_cacheKey");
        if (cacheKey != null) {
            return cacheKey.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(propertiesCacheKey);
        sb.append(component.getFont());
        sb.append(component.getSize());
        sb.append(component.getBackground());
        return sb.toString();
    }

    public static double getZoom() {
        if (zoomString_ == null) {
            CSS.checkZoom();
        }
        return zoom_;
    }

    public static BufferedImageOp getZoomImageOp() {
        return zoomImageOp_;
    }

    private static synchronized void checkZoom() {
        String zoomString = Configuration.get("zoom", "");
        if (!zoomString.equals(zoomString_)) {
            try {
                double zoom = Double.parseDouble(zoomString);
                zoom_ = Math.max(Math.min(zoom, 3.0), 0.3);
                zoomImageOp_ = zoom_ == 1.0 ? null : new AffineTransformOp(AffineTransform.getScaleInstance(zoom_, zoom_), 3);
            }
            catch (Exception ex) {
                zoom_ = 1.0;
                zoomImageOp_ = null;
            }
            zoomString_ = zoomString;
            CSS.clearCache();
        }
    }

    public static synchronized BackgroundProperties getBackgroundProperties(JComponent component) {
        BackgroundProperties properties;
        String cacheKey = CSS.getPropertiesCacheKey(component);
        if (!propertiesCacheActive_ || (properties = propertiesCache_.get(cacheKey)) == null) {
            properties = new BackgroundProperties(component);
            if (propertiesCacheActive_) {
                propertiesCache_.put(cacheKey, properties);
            }
        }
        return properties;
    }

    public static synchronized BackgroundInfo getInfo(JComponent component) {
        BackgroundInfo info;
        String cacheKeyP = CSS.getPropertiesCacheKey(component);
        String cacheKeyI = CSS.getInfoCacheKey(component, cacheKeyP);
        if (!infoCacheActive_ || (info = infoCache_.get(cacheKeyI)) == null) {
            BackgroundProperties properties;
            if (!propertiesCacheActive_ || (properties = propertiesCache_.get(cacheKeyP)) == null) {
                properties = new BackgroundProperties(component);
                if (propertiesCacheActive_) {
                    propertiesCache_.put(cacheKeyP, properties);
                }
            }
            info = new BackgroundInfo(component, properties);
            if (infoCacheActive_) {
                infoCache_.put(cacheKeyI, info);
            }
        }
        return info;
    }

    static {
        genericFonts_.put("serif", Configuration.get("css_serif", "Serif"));
        genericFonts_.put("sans-serif", Configuration.get("css_sans-serif", "SansSerif"));
        genericFonts_.put("monospace", Configuration.get("css_monospace", "Monospaced"));
        genericFonts_.put("cursive", Configuration.get("css_cursive", "Dialog"));
        genericFonts_.put("fantasy", Configuration.get("css_fantasy", "Dialog"));
        defaultBody_ = new JComponent(){};
        defaultBody_.putClientProperty("css_element", "body");
        urlStreamHandler_ = null;
        infoCacheSize_ = Configuration.getInt("infoCacheSize", 1024);
        infoCacheActive_ = !Configuration.getBoolean("infoCacheDisable", false);
        infoCache_ = new LinkedHashMap<String, BackgroundInfo>(infoCacheSize_, 1.1f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BackgroundInfo> eldest) {
                return this.size() > infoCacheSize_;
            }
        };
        propertiesCacheSize_ = Configuration.getInt("propertiesCacheSize", 1024);
        propertiesCacheActive_ = !Configuration.getBoolean("propertiesCacheDisable", false);
        propertiesCache_ = new LinkedHashMap<String, BackgroundProperties>(propertiesCacheSize_, 1.1f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BackgroundProperties> eldest) {
                return this.size() > propertiesCacheSize_;
            }
        };
        zoomString_ = null;
        zoom_ = 1.0;
        zoomImageOp_ = null;
    }

    public static class CSSProperty {
        public final String property_;
        public final Declaration declaration_;

        public CSSProperty(String property, Declaration declaration) {
            this.property_ = property;
            this.declaration_ = declaration;
        }
    }

    public static class DeclarationMatch {
        public final Declaration declaration_;
        public final SelectorMatch selector_;

        public DeclarationMatch(Declaration declaration, SelectorMatch selector) {
            this.declaration_ = declaration;
            this.selector_ = selector;
        }
    }

    public static class SelectorMatch {
        public final CombinedSelector selector_;
        public final int specificity_;

        public SelectorMatch(CombinedSelector selector, int specificity) {
            this.selector_ = selector;
            this.specificity_ = specificity;
        }
    }

    public static class StyleSheetURL {
        public final URL rawURL_;
        public final URL serializedURL_;

        public StyleSheetURL(URL rawURL, URL serializedURL) {
            this.rawURL_ = rawURL;
            this.serializedURL_ = serializedURL;
        }

        public StyleSheetURL(URL rawURL) {
            this(rawURL, null);
        }
    }
}

