/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.css;

import com.ge.med.iungo.css.BackgroundProperties;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.css.CSSProperties;
import com.ge.med.iungo.shape.RoundCornerRectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BackgroundInfo {
    private static final Logger logger_ = Logger.getLogger(BackgroundInfo.class.getName());
    private static final String MD = "\u00b7";
    private final CSSProperties debugCSSProperties_;
    public String content;
    public Dimension size;
    public Dimension minSize;
    public Dimension maxSize;
    public int[] margin;
    public int[] padding;
    public boolean[] borderShown;
    public int[] borderWidth;
    public Shape[] borderShape;
    public Color[] borderColor;
    public Color background;
    public Color foreground;
    public float opacity;
    public Font font;
    public double lineHeight;
    public List<BgImage> backgroundImageList;

    public BackgroundInfo(CSSProperties debugCSSProperties) {
        this.content = null;
        this.size = new Dimension();
        this.minSize = new Dimension();
        this.maxSize = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        this.margin = new int[]{0, 0, 0, 0};
        this.padding = new int[]{0, 0, 0, 0};
        this.borderShown = new boolean[]{false, false, false, false};
        this.borderWidth = new int[]{0, 0, 0, 0};
        this.borderShape = new Shape[2];
        this.borderColor = new Color[4];
        this.background = null;
        this.foreground = null;
        this.opacity = 1.0f;
        this.font = null;
        this.debugCSSProperties_ = debugCSSProperties;
    }

    public BackgroundInfo(JComponent component, BackgroundProperties bp) {
        block20: {
            this.content = null;
            this.size = new Dimension();
            this.minSize = new Dimension();
            this.maxSize = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
            this.margin = new int[]{0, 0, 0, 0};
            this.padding = new int[]{0, 0, 0, 0};
            this.borderShown = new boolean[]{false, false, false, false};
            this.borderWidth = new int[]{0, 0, 0, 0};
            this.borderShape = new Shape[2];
            this.borderColor = new Color[4];
            this.background = null;
            this.foreground = null;
            this.opacity = 1.0f;
            this.font = null;
            this.debugCSSProperties_ = bp;
            try {
                double fontSizePX;
                if (component != null && component.getFont() != null && !(component.getFont() instanceof UIResource)) {
                    this.font = component.getFont();
                    fontSizePX = this.font.getSize2D();
                } else {
                    CSSProperties.BpNumber fontSize = bp.font_size_;
                    fontSizePX = fontSize.isAbsolute() ? fontSize.toPX() : 0.0;
                    CSSProperties.BpNumber relativeFS = fontSize;
                    JComponent jc = CSS.getParent(component);
                    while (jc != null && fontSizePX == 0.0) {
                        BackgroundProperties jcbp = CSS.getBackgroundProperties(jc);
                        CSSProperties.BpNumber fs = jcbp.font_size_;
                        if (fs.isAbsolute()) {
                            relativeFS.setLengthBase(fs);
                            fontSizePX = fontSize.toPX();
                            break;
                        }
                        Font jcf = jc.getFont();
                        if (jcf != null && !(jcf instanceof UIResource)) {
                            relativeFS.setFontBase(jcf);
                            fontSizePX = fontSize.toPX();
                            break;
                        }
                        relativeFS.setLengthBase(fs);
                        relativeFS = fs;
                        jc = CSS.getParent(jc);
                    }
                    if (fontSizePX == 0.0) {
                        relativeFS.setLengthBase(new CSSProperties.BpNumber(16.0, CSSProperties.BpNumber.Unit.PIXEL));
                        fontSizePX = fontSize.toPX();
                    }
                    LinkedList<String> ff = new LinkedList<String>();
                    ff.addAll(bp.font_family_);
                    this.font = CSS.getFont(component, bp.font_family_, bp.font_weight_, bp.font_style_, bp.font_stretch_, (float)Math.round(fontSizePX * CSS.getZoom() * 100.0) / 100.0f);
                }
                CSSProperties.BpNumber em = new CSSProperties.BpNumber(fontSizePX, CSSProperties.BpNumber.Unit.PIXEL);
                bp.line_height_.setLengthBase(em);
                this.lineHeight = BackgroundInfo.zoomedPX(bp.line_height_);
                bp.width_.setLengthBase(em);
                bp.height_.setLengthBase(em);
                bp.min_width_.setLengthBase(em);
                bp.min_height_.setLengthBase(em);
                bp.max_width_.setLengthBase(em);
                bp.max_height_.setLengthBase(em);
                this.size = new Dimension(BackgroundInfo.zoomedPX(bp.width_), BackgroundInfo.zoomedPX(bp.height_));
                this.minSize = new Dimension(BackgroundInfo.zoomedPX(bp.min_width_), BackgroundInfo.zoomedPX(bp.min_height_));
                this.maxSize = new Dimension(BackgroundInfo.zoomedPX(bp.max_width_), BackgroundInfo.zoomedPX(bp.max_height_));
                bp.margin_top_.setLengthBase(em);
                bp.margin_right_.setLengthBase(em);
                bp.margin_bottom_.setLengthBase(em);
                bp.margin_left_.setLengthBase(em);
                this.margin = new int[]{BackgroundInfo.zoomedPX(bp.margin_top_), BackgroundInfo.zoomedPX(bp.margin_right_), BackgroundInfo.zoomedPX(bp.margin_bottom_), BackgroundInfo.zoomedPX(bp.margin_left_)};
                bp.padding_top_.setLengthBase(em);
                bp.padding_right_.setLengthBase(em);
                bp.padding_bottom_.setLengthBase(em);
                bp.padding_left_.setLengthBase(em);
                this.padding = new int[]{BackgroundInfo.zoomedPX(bp.padding_top_), BackgroundInfo.zoomedPX(bp.padding_right_), BackgroundInfo.zoomedPX(bp.padding_bottom_), BackgroundInfo.zoomedPX(bp.padding_left_)};
                this.borderShown = new boolean[]{bp.border_top_style_ != CSSProperties.BoStyle.NONE && bp.border_top_style_ != CSSProperties.BoStyle.HIDDEN, bp.border_right_style_ != CSSProperties.BoStyle.NONE && bp.border_right_style_ != CSSProperties.BoStyle.HIDDEN, bp.border_bottom_style_ != CSSProperties.BoStyle.NONE && bp.border_bottom_style_ != CSSProperties.BoStyle.HIDDEN, bp.border_left_style_ != CSSProperties.BoStyle.NONE && bp.border_left_style_ != CSSProperties.BoStyle.HIDDEN};
                bp.border_top_width_.setLengthBase(em);
                bp.border_right_width_.setLengthBase(em);
                bp.border_bottom_width_.setLengthBase(em);
                bp.border_left_width_.setLengthBase(em);
                this.borderWidth = new int[]{this.borderShown[0] ? BackgroundInfo.zoomedPX(bp.border_top_width_) : 0, this.borderShown[1] ? BackgroundInfo.zoomedPX(bp.border_right_width_) : 0, this.borderShown[2] ? BackgroundInfo.zoomedPX(bp.border_bottom_width_) : 0, this.borderShown[3] ? BackgroundInfo.zoomedPX(bp.border_left_width_) : 0};
                this.borderColor = new Color[]{this.borderWidth[0] > 0 && bp.border_top_color_ != null ? bp.border_top_color_ : new Color(0, true), this.borderWidth[1] > 0 && bp.border_right_color_ != null ? bp.border_right_color_ : new Color(0, true), this.borderWidth[2] > 0 && bp.border_bottom_color_ != null ? bp.border_bottom_color_ : new Color(0, true), this.borderWidth[3] > 0 && bp.border_left_color_ != null ? bp.border_left_color_ : new Color(0, true)};
                this.backgroundImageList = new ArrayList<BgImage>();
                if (bp.background_image_ != null) {
                    for (int i = bp.background_image_.size() - 1; i >= 0; --i) {
                        try {
                            BgImage bgi = new BgImage();
                            bgi.background_image_ = bp.background_image_.get(i);
                            bgi.background_repeat_ = bp.background_repeat_.get(i % bp.background_repeat_.size());
                            bgi.background_attachment_ = bp.background_attachment_.get(i % bp.background_attachment_.size());
                            bgi.background_position_ = bp.background_position_.get(i % bp.background_position_.size());
                            bgi.background_clip_ = bp.background_clip_.get(i % bp.background_clip_.size());
                            bgi.background_origin_ = bp.background_origin_.get(i % bp.background_origin_.size());
                            bgi.background_size_ = bp.background_size_.get(i % bp.background_size_.size());
                            this.backgroundImageList.add(bgi);
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                this.opacity = (float)bp.opacity_.value_;
                if (component != null && component.getForeground() != null && !(component.getForeground() instanceof UIResource)) {
                    this.foreground = component.getForeground();
                } else {
                    Color fg = bp.color_;
                    JComponent p = component;
                    while (fg == null && (p = CSS.getParent(p)) instanceof JComponent) {
                        fg = CSS.getBackgroundProperties((JComponent)p).color_;
                    }
                    Color color = this.foreground = fg != null ? new ColorUIResource(fg) : null;
                }
                this.background = component != null && component.getBackground() != null && !(component.getBackground() instanceof UIResource) ? component.getBackground() : (bp.background_color_ != null ? new ColorUIResource(bp.background_color_) : null);
                double[][] radius = new double[2][4];
                for (int i = 0; i < 2; ++i) {
                    bp.border_top_left_radius_[i].setLengthBase(em);
                    bp.border_top_right_radius_[i].setLengthBase(em);
                    bp.border_bottom_right_radius_[i].setLengthBase(em);
                    bp.border_bottom_left_radius_[i].setLengthBase(em);
                    radius[i][0] = bp.border_top_left_radius_[i].toPX() * CSS.getZoom();
                    radius[i][1] = bp.border_top_right_radius_[i].toPX() * CSS.getZoom();
                    radius[i][2] = bp.border_bottom_right_radius_[i].toPX() * CSS.getZoom();
                    radius[i][3] = bp.border_bottom_left_radius_[i].toPX() * CSS.getZoom();
                }
                int[] bw = this.borderWidth;
                double[][] vx = new double[][]{{2.0 * radius[0][0], 2.0 * radius[0][3], 2.0 * radius[0][2], 2.0 * radius[0][1]}, {2.0 * Math.max(0.0, radius[0][0] - (double)bw[3]), 2.0 * Math.max(0.0, radius[0][3] - (double)bw[3]), 2.0 * Math.max(0.0, radius[0][2] - (double)bw[1]), 2.0 * Math.max(0.0, radius[0][1] - (double)bw[1])}};
                double[][] vy = new double[][]{{2.0 * radius[1][0], 2.0 * radius[1][3], 2.0 * radius[1][2], 2.0 * radius[1][1]}, {2.0 * Math.max(0.0, radius[1][0] - (double)bw[0]), 2.0 * Math.max(0.0, radius[1][3] - (double)bw[2]), 2.0 * Math.max(0.0, radius[1][2] - (double)bw[2]), 2.0 * Math.max(0.0, radius[1][1] - (double)bw[0])}};
                boolean different = false;
                for (int i = 1; i < 4 && !different; ++i) {
                    different = vx[0][i] != vx[0][0] || vy[0][i] != vy[0][0];
                }
                boolean rounded = different || vx[0][0] > 0.0 || vy[0][0] > 0.0;
                Dimension csize = component.getSize();
                int[] cxywh = new int[]{0, 0, csize.width, csize.height};
                Rectangle[] bounds = new Rectangle[]{new Rectangle(cxywh[0], cxywh[1], cxywh[2], cxywh[3]), new Rectangle(cxywh[0] + bw[3], cxywh[1] + bw[0], cxywh[2] - (bw[3] + bw[1]), cxywh[3] - (bw[0] + bw[2]))};
                Shape shape = !rounded ? bounds[0] : (this.borderShape[0] = !different ? new RoundRectangle2D.Double(bounds[0].x, bounds[0].y, bounds[0].width, bounds[0].height, vx[0][0], vy[0][0]) : new RoundCornerRectangle((double)bounds[0].x, (double)bounds[0].y, (double)bounds[0].width, (double)bounds[0].height, vx[0], vy[0]));
                Shape shape2 = !rounded ? bounds[1] : (this.borderShape[1] = !different ? new RoundRectangle2D.Double(bounds[1].x, bounds[1].y, bounds[1].width, bounds[1].height, vx[1][0], vy[1][0]) : new RoundCornerRectangle((double)bounds[1].x, (double)bounds[1].y, (double)bounds[1].width, (double)bounds[1].height, vx[1], vy[1]));
                if (bp.content_ == null || bp.content_.length() <= 0) break block20;
                Pattern escape = Pattern.compile("\\\\([0-9a-fA-F]*)");
                Matcher matcher = escape.matcher(bp.content_);
                while (matcher.find()) {
                    String unicode;
                    try {
                        unicode = new String(new int[]{Integer.parseInt(matcher.group(1), 16)}, 0, 1);
                    }
                    catch (Exception ex) {
                        unicode = "";
                    }
                    this.content = matcher.replaceFirst(unicode);
                    matcher = escape.matcher(this.content);
                }
            }
            catch (Exception ex) {
                logger_.log(Level.SEVERE, "Exception initializing BackgroundInfo for component:" + component + ".", ex);
                logger_.log(Level.INFO, "BackgroundInfo:" + this);
            }
        }
    }

    private static int zoomedPX(CSSProperties.BpNumber length) {
        return (int)Math.round(length.toPX() * CSS.getZoom());
    }

    public String toString() {
        StringBuffer bgi = new StringBuffer();
        if (this.backgroundImageList != null) {
            for (BgImage b : this.backgroundImageList) {
                bgi.append("" + b);
            }
        }
        return "BackgroundInfo [\u00b7  content=" + this.content + MD + "  size=" + this.size + MD + "  minSize=" + this.minSize + MD + "  maxSize=" + this.maxSize + MD + "  margin=" + (this.margin == null ? "" : Arrays.toString(this.margin)) + MD + "  padding=" + (this.padding == null ? "" : Arrays.toString(this.padding)) + MD + "  borderWidth=" + (this.borderWidth == null ? "" : Arrays.toString(this.borderWidth)) + MD + "  borderShown=" + (this.borderShown == null ? "" : Arrays.toString(this.borderShown)) + MD + "  borderShape=" + (this.borderShape == null ? "" : Arrays.toString(this.borderShape)) + MD + "  borderColor=" + (this.borderColor == null ? "" : "[" + this.borderColor[0] + (this.borderColor[0] == null ? "" : "a:" + this.borderColor[0].getAlpha()) + "," + this.borderColor[1] + (this.borderColor[1] == null ? "" : "a:" + this.borderColor[1].getAlpha()) + "," + this.borderColor[2] + (this.borderColor[2] == null ? "" : "a:" + this.borderColor[2].getAlpha()) + "," + this.borderColor[3] + (this.borderColor[3] == null ? "" : "a:" + this.borderColor[3].getAlpha()) + "]") + MD + "  background=" + this.background + (this.background == null ? "" : "a:" + this.background.getAlpha()) + MD + "  foreground=" + this.foreground + (this.foreground == null ? "" : "a:" + this.foreground.getAlpha()) + MD + "  opacity=" + this.opacity + MD + "  font=" + this.font + MD + "  lineHeight=" + this.lineHeight + MD + "  backgroundImageList=" + bgi + MD + "  debugCSSProperties=" + this.debugCSSProperties_ + "]" + MD;
    }

    public static class BgImage {
        public CSSProperties.BgImage background_image_;
        public CSSProperties.BgRepeat background_repeat_;
        public CSSProperties.BgAttachment background_attachment_;
        public CSSProperties.BgPosition background_position_;
        public CSSProperties.BgBox background_clip_;
        public CSSProperties.BgBox background_origin_;
        public CSSProperties.BgSize background_size_;

        public String toString() {
            return "BgImage [\u00b7    background_image_=" + this.background_image_ + BackgroundInfo.MD + "    background_repeat_=" + (Object)((Object)this.background_repeat_) + BackgroundInfo.MD + "    background_attachment_=" + (Object)((Object)this.background_attachment_) + BackgroundInfo.MD + "    background_position_=" + this.background_position_ + BackgroundInfo.MD + "    background_clip_=" + (Object)((Object)this.background_clip_) + BackgroundInfo.MD + "    background_origin_=" + (Object)((Object)this.background_origin_) + BackgroundInfo.MD + "    background_size_=" + this.background_size_ + "]" + BackgroundInfo.MD;
        }
    }
}

