/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.border;

import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.CSSFontIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class CSSBorder
implements Border {
    @Override
    public Insets getBorderInsets(Component c) {
        Object pseudoBefore;
        Insets margin = new Insets(0, 0, 0, 0);
        if (!(c instanceof JComponent)) {
            return margin;
        }
        JComponent component = (JComponent)c;
        if (component instanceof JTextComponent) {
            margin = ((JTextComponent)component).getMargin();
        }
        BackgroundInfo info = CSS.getInfo(component);
        Object beforeIcon = component.getClientProperty("css_icon_before");
        if (!(beforeIcon instanceof Icon) && (pseudoBefore = component.getClientProperty("css_pseudo_before")) instanceof JComponent) {
            beforeIcon = CSSFontIcon.getIcon((JComponent)pseudoBefore, "::before|" + this.getPseudoKey(component));
        }
        int beforeWidth = beforeIcon instanceof Icon ? ((Icon)beforeIcon).getIconWidth() : 0;
        int afterWidth = 0;
        Insets insets = Background.getInsets(info);
        return new Insets(insets.top + margin.top, insets.left + margin.left + beforeWidth, insets.bottom + margin.bottom, insets.right + margin.right + afterWidth);
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int width, int height) {
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorderAndBackground(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JComponent)) {
            return;
        }
        JComponent component = (JComponent)c;
        BackgroundInfo info = CSS.getInfo(component);
        this.paintBorderAndBackground(component, g, x, y, width, height, info);
    }

    public void paintBorderAndBackground(JComponent component, Graphics g, int x, int y, int width, int height, BackgroundInfo info) {
        int yOffset;
        Insets insets;
        Object pseudoBefore;
        Background.paint(info, g, x, y, width, height);
        Object beforeIcon = component.getClientProperty("css_icon_before");
        if (!(beforeIcon instanceof Icon) && (pseudoBefore = component.getClientProperty("css_pseudo_before")) instanceof JComponent) {
            beforeIcon = CSSFontIcon.getIcon((JComponent)pseudoBefore, "::before|" + this.getPseudoKey(component));
        }
        Object afterIcon = component.getClientProperty("css_icon_after");
        if (beforeIcon instanceof Icon) {
            insets = Background.getInsets(info);
            yOffset = (height - (insets.top + insets.bottom) - ((Icon)beforeIcon).getIconHeight()) / 2;
            ((Icon)beforeIcon).paintIcon(component, g, x + insets.left, y + insets.top + yOffset);
        }
        if (afterIcon instanceof Icon) {
            insets = Background.getInsets(info);
            yOffset = (height - (insets.top + insets.bottom) - ((Icon)afterIcon).getIconHeight()) / 2;
            ((Icon)afterIcon).paintIcon(component, g, x + width - ((Icon)afterIcon).getIconWidth(), y + insets.top + yOffset);
        }
    }

    private String getPseudoKey(JComponent component) {
        StringBuffer sb = new StringBuffer();
        sb.append(component.getClientProperty("css_element"));
        sb.append("|");
        sb.append(component.getClientProperty("css_class"));
        sb.append("|");
        sb.append(CSS.getZoom());
        sb.append("|");
        sb.append(component.hasFocus() ? "T" : "F");
        sb.append(component.isEnabled() ? "T" : "F");
        if (component instanceof JComboBox) {
            sb.append(((JComboBox)component).isEditable() ? "T" : "F");
        }
        if (component instanceof JTextComponent) {
            sb.append(((JTextComponent)component).isEditable() ? "T" : "F");
        }
        if (component instanceof AbstractButton) {
            sb.append(((AbstractButton)component).isSelected() ? "T" : "F");
            sb.append(((AbstractButton)component).isBorderPainted() ? "T" : "F");
            ButtonModel m = ((AbstractButton)component).getModel();
            if (m != null) {
                sb.append(m.isArmed() ? "T" : "F");
                sb.append(m.isRollover() ? "T" : "F");
            }
        }
        return sb.toString();
    }
}

