/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.PixelWindowing;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class XpThumbnailImageIcon
extends JPanel {
    private JLabel imgiconlabel = new JLabel();
    private JPanel label = new JPanel();
    private DMObject dmImage = null;
    private boolean ICON_ONLY = false;
    private static final Logger logger_ = Logger.getLogger(XpThumbnailImageIcon.class.getName());
    public static String ICON_DIM = CvPropertiesManager.getProperty("cvf.listview_image_icon_SIZE", "128x128");
    private static Dimension ICON_DIMENSION = new Dimension();

    public XpThumbnailImageIcon(DMObject img) {
        String[] dimension = ICON_DIM.split("x");
        XpThumbnailImageIcon.ICON_DIMENSION.width = Integer.parseInt(dimension[0]);
        XpThumbnailImageIcon.ICON_DIMENSION.height = Integer.parseInt(dimension[1]);
        this.initUI(img);
    }

    public XpThumbnailImageIcon(DMObject img, boolean icononly) {
        this.ICON_ONLY = icononly;
        String[] dimension = ICON_DIM.split("x");
        XpThumbnailImageIcon.ICON_DIMENSION.width = Integer.parseInt(dimension[0]);
        XpThumbnailImageIcon.ICON_DIMENSION.height = Integer.parseInt(dimension[1]);
        this.initUI(img);
    }

    public XpThumbnailImageIcon(DMObject img, boolean icononly, Dimension dimension) {
        this.ICON_ONLY = icononly;
        ICON_DIMENSION = dimension;
        this.initUI(img);
    }

    private void initUI(DMObject img) {
        this.setLayout(new BorderLayout());
        DMImage[] imgs = img.getImages(null);
        XpMedicalImage[] xpMedicalImages = XpMedicalDmImage.wrapDMImages(imgs);
        XpMedicalImage img1 = xpMedicalImages[0];
        BufferedImage finalimage = this.applyWWWL(img1);
        if (finalimage != null) {
            Image img2 = finalimage.getScaledInstance(XpThumbnailImageIcon.ICON_DIMENSION.width, XpThumbnailImageIcon.ICON_DIMENSION.height, 4);
            ImageIcon icon = new ImageIcon(img2);
            this.imgiconlabel.setIcon(icon);
        }
        this.imgiconlabel.setPreferredSize(ICON_DIMENSION);
        this.imgiconlabel.setMinimumSize(ICON_DIMENSION);
        this.imgiconlabel.setMaximumSize(ICON_DIMENSION);
        this.add((Component)this.imgiconlabel, "North");
        if (!this.ICON_ONLY) {
            this.setLabel(img);
            this.add((Component)this.label, "Center");
        }
    }

    private BufferedImage applyWWWL(XpImage img1) {
        BufferedImage bi = (BufferedImage)img1.getPixelData();
        double windowlevel = img1.getDefaultWindowLevel();
        double windowwidth = img1.getDefaultWindowWidth();
        XpImageRenderAttributes attributes = new XpImageRenderAttributes();
        attributes.setWindowing(windowwidth, windowlevel);
        PixelWindowing pixwin = new PixelWindowing();
        int[] colorTable = new int[65536];
        pixwin.fillColorTable(attributes, colorTable, img1.getRescaleSlope(), img1.getRescaleIntercept(), 0);
        IndexColorModel cm = new IndexColorModel(16, 65536, colorTable, 0, false, -1, 1);
        BufferedImage finalimage = null;
        if (bi.getColorModel().getPixelSize() == 16) {
            WritableRaster raster = bi.getRaster();
            finalimage = new BufferedImage(cm, raster, false, null);
        } else {
            finalimage = bi;
        }
        return finalimage;
    }

    public void addLabel(String lab) {
        this.label.add(new JLabel(lab));
    }

    private void setLabel(DMObject img) {
        try {
            Properties properties = new Properties();
            try {
                properties.load(XpThumbnailImageIcon.class.getResourceAsStream("ListView.properties"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.label.setLayout(new BoxLayout(this.label, 1));
            String[] labels = properties.getProperty("Labels").split("\\|");
            Font font = this.label.getFont();
            this.label.setPreferredSize(new Dimension(XpThumbnailImageIcon.ICON_DIMENSION.width, labels.length * 25));
            for (int i = 0; i < labels.length; ++i) {
                Object objAns = null;
                String[] sepersted = labels[i].split("\\,");
                String strgroup = sepersted[0];
                String strelement = sepersted[1];
                String formatterclass = sepersted[2];
                if (!formatterclass.equals("null")) {
                    Class c = CvUtils.getClass(formatterclass);
                    Formatter f = (Formatter)c.newInstance();
                    objAns = f.format(img);
                } else {
                    int group = Integer.parseInt(strgroup.substring(2, strgroup.length()), 16);
                    int element = Integer.parseInt(strelement.substring(2, strelement.length()), 16);
                    DMTag tag2 = new DMTag(group, element);
                    objAns = img.getValue(tag2);
                }
                if (objAns == null || objAns.toString().trim().equals("")) continue;
                JLabel label1 = new JLabel(objAns.toString());
                label1.setFont(new Font(font.getFontName(), 1, Integer.parseInt(CvPropertiesManager.getProperty("cvf.listview_label_fontsize", "16"))));
                this.label.add(label1);
            }
        }
        catch (Exception e) {
            logger_.log(Level.SEVERE, "{0} Error while seting the labels to thumbnailview" + e.getMessage(), e);
        }
    }
}

