/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class ValueBasedDecimalFormatter
extends DecimalFormat {
    private double intNumbersLimit = 99999.0;
    public static final String intPattern = CvPropertiesManager.getProperty("cvf.intPattern", "##0.0");
    public static final String doublePrecisionPattern = CvPropertiesManager.getProperty("cvf.doublePrecisionPattern", "0.###");
    public static final String scientificNotationPattern = CvPropertiesManager.getProperty("cvf.scientificNotationPattern", "0.000E0");

    @Override
    public StringBuffer format(double arg0, StringBuffer arg1, FieldPosition arg2) {
        this.applyPattern(arg0);
        return super.format(arg0, arg1, arg2);
    }

    @Override
    public StringBuffer format(long arg0, StringBuffer arg1, FieldPosition arg2) {
        this.applyPattern(arg0);
        return super.format(arg0, arg1, arg2);
    }

    public void applyPattern(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Number invalid");
        }
        double number = value;
        if (number < 0.0) {
            number = -number;
        }
        if (number > 0.0 && number < 1.0) {
            if (this.getPrecisionValue(number, 2)) {
                this.applyPattern(doublePrecisionPattern);
            } else {
                this.applyPattern(scientificNotationPattern);
            }
        } else if (number <= this.intNumbersLimit) {
            this.applyPattern(intPattern);
        } else if (number > this.intNumbersLimit) {
            this.applyPattern(scientificNotationPattern);
        }
    }

    public String customFormat(double value) {
        this.applyPattern(value);
        return super.format(value);
    }

    public boolean getPrecisionValue(double value, int limit) {
        int zeros = 0;
        while (value < 1.0) {
            value *= 10.0;
            ++zeros;
        }
        return --zeros <= limit;
    }
}

