/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;

public class ToolManager {
    private HashMap<String, Object> actionCache = new LinkedHashMap<String, Object>();
    private HashMap<String, ArrayList<Object>> allControls = new HashMap();
    private List<String> favoriteTools = new LinkedList<String>();
    public final int ADD_TOOL_FROM_MOUSE_RIGHT_MENU = 2;
    public final int ADD_TOOL_FROM_MYTOOL_SETTINGS = 1;
    public static final int MY_TOOL_MAX_LIMIT = 18;
    private static ToolManager tools = null;

    private ToolManager() {
    }

    public static ToolManager getInstance() {
        if (tools == null) {
            tools = new ToolManager();
        }
        return tools;
    }

    public HashMap<String, Object> getActions() {
        return this.actionCache;
    }

    public Object getAction(String actionKey) {
        if (actionKey != null && !actionKey.equals("")) {
            if (this.actionCache.containsKey(actionKey.trim())) {
                return this.actionCache.get(actionKey);
            }
            try {
                Object action = CvUtils.getClass(actionKey.trim()).newInstance();
                this.actionCache.put(actionKey.trim(), action);
                return action;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setTools(String actionKey, ArrayList<Object> tools) {
        this.allControls.put(actionKey, tools);
    }

    public void setTool(String actionKey, Object tool) {
        ArrayList<Object> toolList = this.allControls.get(actionKey);
        if (toolList == null) {
            ArrayList<Object> tools = new ArrayList<Object>();
            tools.add(tool);
            this.allControls.put(actionKey, tools);
        } else {
            toolList.add(tool);
        }
    }

    public ArrayList<Object> getTool(String actionKey) {
        return this.allControls.get(actionKey);
    }

    public HashMap<String, ArrayList<Object>> getAllToolsMaps() {
        return this.allControls;
    }

    public List<String> getFavoriteToolKeys() {
        return this.favoriteTools;
    }

    public void setFavoriteToolKeys(List<String> favToolsKeys) {
        try {
            this.favoriteTools = favToolsKeys;
            this.saveMyToolsUserPreferences();
        }
        catch (Exception e) {
            System.err.println("ToolManager.setFavoriteTools() :" + e.getMessage());
        }
    }

    public boolean setFavoriteToolKey(String favoriteTool) {
        boolean success = false;
        if (!this.favoriteTools.contains(favoriteTool) && (success = this.favoriteTools.add(favoriteTool))) {
            this.saveMyToolsUserPreferences();
        }
        return success;
    }

    public boolean removeFavoriteToolKey(String favoriteTool) {
        boolean sucess = false;
        try {
            sucess = this.favoriteTools.remove(favoriteTool);
            if (sucess) {
                this.saveMyToolsUserPreferences();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ToolManager.removeFavoriteTool() :");
        }
        return sucess;
    }

    public void setAction(String actionKey, Object action) {
        if (actionKey != null && !actionKey.equals("") && action != null && this.actionCache.get(actionKey) == null) {
            this.actionCache.put(actionKey.trim(), action);
        } else {
            System.err.println("@@@@@ actionKey already available ");
        }
    }

    public void loadMyToolKeys() {
        String mytools_str;
        String mytools_obj;
        String myTools = XPDisplayPrefsUtils.getSystemMyTools();
        if (!this.isFavoriteToolKeysChanged()) {
            return;
        }
        this.favoriteTools = new LinkedList<String>();
        if (!myTools.equals("")) {
            String[] toolArray;
            for (String tool : toolArray = myTools.split(",")) {
                this.favoriteTools.add(tool);
            }
        } else if (!(this.favoriteTools != null && this.favoriteTools.size() > 0 || (mytools_obj = CvPropertiesManager.getProperty("mytools")) == null || (mytools_str = mytools_obj.toString()) == null || mytools_str.equals(""))) {
            String[] toolArray;
            for (String tool : toolArray = mytools_str.split(",")) {
                this.favoriteTools.add(tool);
            }
            this.saveMyToolsUserPreferences();
        }
    }

    private void saveMyToolsUserPreferences() {
        StringBuilder tools = new StringBuilder();
        int toolCount = this.favoriteTools.size();
        for (int i = 0; i < toolCount; ++i) {
            tools.append(this.favoriteTools.get(i));
            if (i + 1 >= toolCount) continue;
            tools.append(",");
        }
        XPDisplayPrefsUtils.saveMyTools(tools.toString());
        try {
            CvPropertiesManager.getUserPreferences().sync();
            CvPropertiesManager.getUserPreferences().flush();
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
    }

    public int getMyToolLimit() {
        String mytoolMaxLimit = Integer.valueOf(18).toString();
        mytoolMaxLimit = CvPropertiesManager.getProperty("mytool.max_limit", mytoolMaxLimit);
        return Integer.parseInt(mytoolMaxLimit);
    }

    public boolean isFavoriteToolKeysChanged() {
        String[] toolArray;
        String myTools = XPDisplayPrefsUtils.getSystemMyTools();
        if (myTools == null && this.favoriteTools == null) {
            return true;
        }
        if (myTools != null && this.favoriteTools == null || myTools == null && this.favoriteTools != null) {
            return true;
        }
        for (String str : this.favoriteTools) {
            if (myTools.contains(str)) continue;
            return true;
        }
        for (String tool : toolArray = myTools.split(",")) {
            if (this.favoriteTools.contains(tool)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.actionCache.clear();
        this.allControls.clear();
        this.favoriteTools.clear();
    }
}

