/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public abstract class HandleFactory {
    private static int width;
    private static int height;
    private static int x;
    private static int y;
    private static int cwidth;
    private static int cheight;
    private static int cx;
    private static int cy;
    private static int pointbound;
    private static Color handlecolor;
    private static Color selectedcolor;
    private static Color unselectedcolor;
    private Cursor rotatecursor = Cursor.getPredefinedCursor(0);
    private Cursor resizecursor = Cursor.getPredefinedCursor(5);
    private Cursor movecursor = Cursor.getPredefinedCursor(13);

    public Shape getResizeHandleShape(HandleStyle hs) {
        Shape s = this.getHandleShape(hs);
        return s == null ? this.getHandleShape(HandleStyle.BOX) : s;
    }

    public Shape getMoveHandleShape(HandleStyle hs) {
        Shape s = this.getHandleShape(hs);
        return s == null ? this.getHandleShape(HandleStyle.BOX) : s;
    }

    public Shape getRotateHandleShape(HandleStyle hs) {
        Shape s = this.getHandleShape(hs);
        return s == null ? this.getHandleShape(HandleStyle.BOX) : s;
    }

    public Shape getContainmentShape() {
        Rectangle s = new Rectangle(cx, cy, cwidth, cheight);
        return s;
    }

    public Shape getPolygonPointShape(HandleStyle hs) {
        Shape s = this.getHandleShape(hs);
        return s == null ? this.getHandleShape(HandleStyle.BOX) : s;
    }

    public Shape getPointHandleShape(HandleStyle hs) {
        Shape s = this.getHandleShape(hs);
        return s == null ? this.getHandleShape(HandleStyle.BOX) : s;
    }

    private Shape getPointMarkerShape() {
        GeneralPath pointshape = new GeneralPath();
        pointshape.reset();
        pointshape.moveTo(0.0f, -pointbound / 2 - 3);
        pointshape.lineTo(0.0f, -pointbound / 2);
        pointshape.moveTo(0.0f, pointbound / 2 + 3);
        pointshape.lineTo(0.0f, pointbound / 2);
        pointshape.moveTo(-pointbound / 2 - 3, 0.0f);
        pointshape.lineTo(-pointbound / 2, 0.0f);
        pointshape.moveTo(pointbound / 2 + 3, 0.0f);
        pointshape.lineTo(pointbound / 2, 0.0f);
        Ellipse2D.Double el = new Ellipse2D.Double(-pointbound / 2, -pointbound / 2, pointbound, pointbound);
        pointshape.append(el, false);
        return pointshape;
    }

    public Rectangle getHandleBounds() {
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getContainmentBounds() {
        return new Rectangle(cx, cy, cwidth, cheight);
    }

    public int getPointHandleBound() {
        return pointbound;
    }

    public Color getHandleColor() {
        return handlecolor;
    }

    public Color getHandleSelectedColor() {
        return selectedcolor;
    }

    public Color getHandleUnSelectedColor() {
        return unselectedcolor;
    }

    public Cursor getRotateHandleCursor() {
        return this.rotatecursor;
    }

    public Cursor getResizeHandleCursor() {
        return this.resizecursor;
    }

    public Cursor getMoveHandleCursor() {
        return this.movecursor;
    }

    private Shape getCrosshairHandleShape() {
        Rectangle r = this.getHandleBounds();
        int w = (int)r.getWidth();
        int h = (int)r.getHeight();
        GeneralPath cross = new GeneralPath();
        cross.reset();
        cross.moveTo(0.0f, -h / 2);
        cross.lineTo(0.0f, h / 2);
        cross.moveTo(-w / 2, 0.0f);
        cross.lineTo(w / 2, 0.0f);
        return cross;
    }

    private Shape getAngleCrosshairHandleShape() {
        Rectangle r = this.getHandleBounds();
        int w = (int)(r.getWidth() / 2.0) * 2;
        int h = (int)(r.getHeight() / 2.0) * 2;
        GeneralPath cross = new GeneralPath();
        cross.reset();
        cross.moveTo(-w / 2, -h / 2);
        cross.lineTo(w / 2, h / 2);
        cross.moveTo(w / 2, -h / 2);
        cross.lineTo(-w / 2, h / 2);
        return cross;
    }

    private Shape getBoxHandleShape() {
        Rectangle r = this.getHandleBounds();
        return r;
    }

    private Shape getRoundHandleShape() {
        Rectangle r = this.getHandleBounds();
        int w = (int)r.getWidth();
        int h = (int)r.getHeight();
        Ellipse2D.Double s = new Ellipse2D.Double(-w / 2, -h / 2, w, h);
        return s;
    }

    public Shape getHandleShape(HandleStyle hs) {
        Shape s = null;
        switch (hs) {
            case BOX: {
                return this.getBoxHandleShape();
            }
            case CROSSHAIR: {
                return this.getCrosshairHandleShape();
            }
            case ANGLECROSSHAIR: {
                return this.getAngleCrosshairHandleShape();
            }
            case ROUND: {
                return this.getRoundHandleShape();
            }
            case POINTMARKER: {
                return this.getPointMarkerShape();
            }
        }
        return s;
    }

    static {
        int len;
        int[] dim;
        width = 0;
        height = 0;
        x = 0;
        y = 0;
        cwidth = 0;
        cheight = 0;
        cx = 0;
        cy = 0;
        pointbound = 10;
        handlecolor = null;
        selectedcolor = null;
        unselectedcolor = null;
        String val = CvPropertiesManager.getProperty("cvf.Handle.PointShape.size");
        if (val != null) {
            pointbound = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.Handle.BoxShape.size")) != null) {
            dim = CvUtils.parseIntList(val, ", ");
            len = dim.length;
            if (len == 4) {
                x = dim[0];
                y = dim[1];
                width = dim[2];
                height = dim[3];
            } else if (dim.length == 2) {
                x = 0;
                y = 0;
                width = dim[0];
                height = dim[1];
            } else if (dim.length == 1) {
                x = 0;
                y = 0;
                width = dim[0];
                height = dim[0];
            } else {
                x = 0;
                y = 0;
                width = 7;
                height = 7;
            }
        }
        if ((val = CvPropertiesManager.getProperty("cvf.Handle.ContainmentShape.size")) != null) {
            dim = CvUtils.parseIntList(val, ", ");
            len = dim.length;
            if (len == 4) {
                cx = dim[0];
                cy = dim[1];
                cwidth = dim[2];
                cheight = dim[3];
            } else if (dim.length == 2) {
                cx = 0;
                cy = 0;
                cwidth = dim[0];
                cheight = dim[1];
            } else {
                cx = 0;
                cy = 0;
                cwidth = 7;
                cheight = 7;
            }
        }
        handlecolor = CvUtils.getColor(CvPropertiesManager.getProperty("cvf.XpHandle.Color", "red"));
        selectedcolor = CvUtils.getColor(CvPropertiesManager.getProperty("cvf.XpAppContext.selectionColor", "yellow"));
        unselectedcolor = CvUtils.getColor(CvPropertiesManager.getProperty("cvf.XpAppContext.unselectionColor", "cyan"));
    }

    public static enum HandleStyle {
        BOX,
        CROSSHAIR,
        ANGLECROSSHAIR,
        ROUND,
        POINTMARKER;

    }
}

