/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExecWrapper {
    private static final Logger logger_ = Logger.getLogger("com.ge.med.cse.cvf.util");
    protected String java_;
    protected String main_;
    protected List classpath_;
    protected List options_;
    protected List parameters_;
    protected Map environment_;

    public static void main(String[] argv) {
        logger_.info("PID:" + Utilities.getPid());
        logger_.info("ENV:" + Utilities.getEnv());
        Properties properties = System.getProperties();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String t = (String)e.nextElement();
            String v = properties.getProperty(t);
            logger_.log(Level.FINE, t + "<" + v + ">");
        }
        logger_.info(new ExecWrapper("date").executeAndWait().getInputStream().toString());
        logger_.info(new ExecWrapper("ps -ef").executeAndWait().getInputStream().toString());
        ProcessWrapper pw = new ExecWrapper("ls -ltr").executeAndWait();
        Utilities.redirect(pw.getInputStream(), System.out);
    }

    public ExecWrapper(String main, String java, List classpath, List options, List parameters, Map environment) {
        this.main_ = main;
        this.java_ = java;
        this.classpath_ = classpath;
        this.options_ = options;
        this.parameters_ = parameters;
        this.environment_ = environment;
    }

    public ExecWrapper(String main, List parameters, Map environment) {
        this(main, "", null, null, parameters, environment);
    }

    public ExecWrapper(String main, String java, String classpath, String[] options, String[] parameters, String[] environment) {
        this(main, java, classpath != null ? new ArrayList<String>(Arrays.asList(classpath)) : null, options != null ? new ArrayList<String>(Arrays.asList(options)) : null, parameters != null ? new ArrayList<String>(Arrays.asList(parameters)) : null, ExecWrapper.parseEnvironment(environment));
    }

    public ExecWrapper(String main, String[] parameters, String[] environment) {
        this(main, "", null, null, parameters, environment);
    }

    public ExecWrapper(String main) {
        this(main, (List)null, null);
    }

    public ProcessWrapper execute(ChangeListener exitListener) {
        try {
            return new ProcessWrapper(this, exitListener);
        }
        catch (Throwable t) {
            logger_.warning("COULD NOT EXECUTE(" + t + "): " + this);
            t.printStackTrace();
            return null;
        }
    }

    public ProcessWrapper execute() {
        return this.execute(null);
    }

    public ProcessWrapper executeAndWait() {
        ProcessWrapper process = this.execute();
        if (process != null) {
            process.waitFor();
        }
        return process;
    }

    public String getMain() {
        return this.main_;
    }

    public String getJava() {
        return this.java_;
    }

    public List getClasspath() {
        return this.classpath_ != null ? new ArrayList(this.classpath_) : null;
    }

    public List getOptions() {
        return this.options_ != null ? new ArrayList(this.options_) : null;
    }

    public List getParameters() {
        return this.parameters_ != null ? new ArrayList(this.parameters_) : null;
    }

    public Map getEnvironment() {
        return this.environment_ != null ? new HashMap(this.environment_) : null;
    }

    public String toString() {
        int i;
        String[] environment = this.getEnvironmentArray(false);
        String[] command2 = this.getCommandArray();
        StringBuffer buffer = new StringBuffer();
        for (i = 0; environment != null && i < environment.length; ++i) {
            buffer.append(" " + environment[i]);
        }
        for (i = 0; i < command2.length; ++i) {
            buffer.append(" " + command2[i]);
        }
        return buffer.substring(1);
    }

    protected String[] getCommandArray() {
        ArrayList<String> list = new ArrayList<String>();
        String java = this.java_;
        if (java == null) {
            java = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java";
        }
        if (java.length() > 0) {
            list.add(java);
            ArrayList<String> classpath = this.classpath_;
            if (classpath == null) {
                classpath = new ArrayList<String>(Arrays.asList(System.getProperty("java.class.path")));
            }
            if (classpath.size() > 0) {
                list.add("-cp");
                String cp = "";
                Iterator i = classpath.iterator();
                while (i.hasNext()) {
                    cp = cp + "" + i.next() + (i.hasNext() ? File.pathSeparator : "");
                }
                cp = cp.replace(':', File.pathSeparatorChar);
                cp = cp.replace('/', File.separatorChar);
                cp = cp.replace(';', File.pathSeparatorChar);
                cp = cp.replace('\\', File.separatorChar);
                list.add(cp);
            }
            if (this.options_ != null) {
                list.addAll(this.options_);
            }
        }
        list.add(this.main_);
        if (this.parameters_ != null) {
            list.addAll(this.parameters_);
        }
        return list.toArray(new String[0]);
    }

    protected String[] getEnvironmentArray(boolean inherit) {
        if (this.environment_ == null || this.environment_.size() == 0) {
            return null;
        }
        Map environment = inherit ? ExecWrapper.merge(Utilities.getEnv(), this.environment_) : this.environment_;
        ArrayList<String> list = new ArrayList<String>();
        for (Object k : environment.keySet()) {
            list.add("" + k + "=" + environment.get(k));
        }
        return list.toArray(new String[0]);
    }

    private static Map merge(Map a1, Map a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        HashMap a = new HashMap(a1);
        a.putAll(a2);
        return a;
    }

    private static Map parseEnvironment(String[] env) {
        if (env == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < env.length; ++i) {
            try {
                map.put(env[i].substring(0, env[i].indexOf("=")), env[i].substring(env[i].indexOf("=") + 1));
                continue;
            }
            catch (Exception ex) {
                logger_.warning("Could not parse environment <" + env[i] + ">:" + ex);
            }
        }
        return map;
    }

    public static final class Utilities {
        private Utilities() {
        }

        public static Map getEnv() {
            try {
                HashMap<String, String> env = new HashMap<String, String>();
                BufferedReader out = new BufferedReader(new InputStreamReader(new ExecWrapper(System.getProperty("os.name").toLowerCase().startsWith("windows") ? "cmd /c set" : "env").execute().getInputStream()));
                String line = out.readLine();
                while (line != null) {
                    int eq = line.indexOf("=");
                    while (eq > 0) {
                        env.put(line.substring(0, eq), line.substring(eq + 1));
                        eq = 0;
                    }
                    line = out.readLine();
                }
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logger_.finer("ENVIRONMENT:" + env);
                return env;
            }
            catch (Exception ex) {
                logger_.warning("Could not get parent environment:" + ex);
                return null;
            }
        }

        public static int getPid() {
            try {
                return Integer.parseInt(new File("/proc/self").getCanonicalFile().getName());
            }
            catch (Exception ex) {
                return -1;
            }
        }

        public static void redirect(InputStream in, OutputStream out) {
            Utilities.redirect(in, out, 4096);
        }

        public static void redirect(final InputStream in, final OutputStream out, final int bufferSize) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    byte[] buffer = new byte[bufferSize];
                    try {
                        int n = in.read(buffer);
                        while (n > 0) {
                            if (out != null) {
                                out.write(buffer, 0, n);
                            }
                            n = in.read(buffer);
                        }
                    }
                    catch (Exception ex) {
                        PrintStream ps = new PrintStream(out);
                        ps.println("could not redirect output:" + ex);
                        ex.printStackTrace(ps);
                    }
                }
            };
            thread.setName("Redirect" + in.hashCode());
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static class BufferedPipe
    extends PipedInputStream {
        protected Thread thread_;

        protected Thread getThread() {
            return this.thread_;
        }

        public BufferedPipe(final InputStream input) {
            try {
                final PipedOutputStream pipe = new PipedOutputStream();
                this.connect(pipe);
                this.thread_ = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            int c = input.read();
                            while (c >= 0) {
                                BufferedPipe bufferedPipe = BufferedPipe.this;
                                synchronized (bufferedPipe) {
                                    pipe.write(c);
                                }
                                c = input.read();
                            }
                            pipe.close();
                            input.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                };
                this.thread_.setName("BufferedPipe" + this.hashCode());
                this.thread_.setDaemon(true);
                this.thread_.start();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        @Override
        protected synchronized void receive(int b) throws IOException {
            super.receive(b);
            if (this.in != this.out) {
                return;
            }
            byte[] newbuffer = new byte[this.buffer.length + 1024];
            int l = this.buffer.length - this.out;
            try {
                System.arraycopy(this.buffer, this.out, newbuffer, 0, l);
                System.arraycopy(this.buffer, 0, newbuffer, l, this.out);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.out = 0;
            this.in = this.buffer.length;
            this.buffer = newbuffer;
        }

        public synchronized String toString() {
            try {
                byte[] buffer = new byte[this.available()];
                for (int i = 0; i < buffer.length; i += this.read(buffer, i, buffer.length - i)) {
                }
                return new String(buffer);
            }
            catch (IOException ioe) {
                return ioe.toString();
            }
        }
    }

    public static class ProcessWrapper
    extends Process {
        private ExecWrapper wrapper_;
        private ChangeListener exitListener_;
        private OutputStream outputStream_;
        private InputStream inputStream_;
        private InputStream errorStream_;
        private Thread waiter_ = null;
        private Process process_ = null;
        private boolean stopping_ = false;

        private ProcessWrapper(ExecWrapper wrapper, ChangeListener exitListener) throws IOException {
            this.wrapper_ = wrapper;
            this.exitListener_ = exitListener;
            String[] command2 = this.wrapper_.getCommandArray();
            this.process_ = command2.length == 1 ? Runtime.getRuntime().exec(command2[0], this.wrapper_.getEnvironmentArray(true)) : Runtime.getRuntime().exec(command2, this.wrapper_.getEnvironmentArray(true));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ProcessWrapper.this.destroy();
                }
            });
            this.outputStream_ = this.process_.getOutputStream();
            this.inputStream_ = new BufferedPipe(this.process_.getInputStream());
            this.errorStream_ = new BufferedPipe(this.process_.getErrorStream());
            this.waiter_ = new Thread(){
                {
                    this.setName("ProcessWrapper" + ProcessWrapper.this.hashCode());
                }

                @Override
                public void run() {
                    logger_.info("EXECUTING: " + ProcessWrapper.this.wrapper_);
                    try {
                        ProcessWrapper.this.process_.waitFor();
                        ((BufferedPipe)ProcessWrapper.this.inputStream_).getThread().join();
                        ((BufferedPipe)ProcessWrapper.this.errorStream_).getThread().join();
                        try {
                            ProcessWrapper.this.outputStream_.close();
                        }
                        catch (Exception ex) {}
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    ProcessWrapper.this.waiter_ = null;
                    ProcessWrapper.this.stopping_ = false;
                    ProcessWrapper.this.fireChange();
                    logger_.info("EXITED(" + ProcessWrapper.this.process_.exitValue() + "): " + ProcessWrapper.this.wrapper_);
                }
            };
            this.waiter_.start();
        }

        public ExecWrapper getExecWrapper() {
            return this.wrapper_;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.outputStream_;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream_;
        }

        @Override
        public InputStream getErrorStream() {
            return this.errorStream_;
        }

        @Override
        public int exitValue() {
            return this.process_.exitValue();
        }

        @Override
        public int waitFor() {
            Thread waiter = this.waiter_;
            if (waiter == null) {
                return this.exitValue();
            }
            try {
                waiter.join();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            return this.exitValue();
        }

        @Override
        public void destroy() {
            if (!this.isRunning()) {
                return;
            }
            this.stopping_ = true;
            this.fireChange();
            this.process_.destroy();
        }

        public boolean isRunning() {
            return this.waiter_ != null;
        }

        public boolean isStopping() {
            return this.stopping_;
        }

        private void fireChange() {
            if (this.exitListener_ != null) {
                try {
                    this.exitListener_.stateChanged(new ChangeEvent(this));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

