/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceVpContentPane;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.DicomPrintable;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpMultiImageViewport;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DicomPrintablePort
implements DicomPrintable {
    protected JComponent vp;
    private XpComponentSave cs;
    private String imagePath;
    private int _noOfBits;
    protected static final boolean usePortSize = CvPropertiesManager.getBoolean("cvf.print.useportsize", false);
    protected static boolean printRGB = CvPropertiesManager.getBoolean("cvf.print.rgb", true);

    public DicomPrintablePort(JComponent comp) {
        block9: {
            List uas;
            int i;
            List rois;
            block10: {
                this.vp = null;
                this.cs = null;
                this.imagePath = null;
                this._noOfBits = 8;
                this.vp = comp;
                if (!(this.vp instanceof XpViewport)) break block9;
                if (!usePortSize) {
                    this.vp.setSize(512, 512);
                }
                if (!(this.vp instanceof XpCompositePort)) break block10;
                int numPorts = ((XpCompositePort)this.vp).getRows() * ((XpCompositePort)this.vp).getCols();
                for (int i2 = 0; i2 < numPorts; ++i2) {
                    List uas2;
                    int j;
                    List rois2;
                    XpFrameVisualizer port = ((XpCompositePort)this.vp).getPort(i2);
                    if (port instanceof ROICapable && (rois2 = port.getRois()) != null) {
                        for (j = 0; j < rois2.size(); ++j) {
                            Object ra = rois2.get(j);
                            if (!(ra instanceof Selectable) || !((Selectable)ra).isSelected()) continue;
                            ((Selectable)ra).setSelected(false);
                        }
                    }
                    if (port instanceof UserAnnoCapable && (uas2 = port.getUserAnnos()) != null) {
                        for (j = 0; j < uas2.size(); ++j) {
                            Object ua = uas2.get(j);
                            if (!(ua instanceof Selectable) || !((Selectable)ua).isSelected()) continue;
                            ((Selectable)ua).setSelected(false);
                        }
                    }
                    port.setDrawBorder(false);
                    port.refreshSelection();
                }
                break block9;
            }
            if (this.vp instanceof ROICapable && (rois = ((ROICapable)((Object)this.vp)).getRois()) != null) {
                for (i = 0; i < rois.size(); ++i) {
                    Object ra = rois.get(i);
                    if (!(ra instanceof Selectable) || !((Selectable)ra).isSelected()) continue;
                    ((Selectable)ra).setSelected(false);
                }
            }
            if (!(this.vp instanceof UserAnnoCapable) || (uas = ((UserAnnoCapable)((Object)this.vp)).getUserAnnos()) == null) break block9;
            for (i = 0; i < uas.size(); ++i) {
                Object ua = uas.get(i);
                if (!(ua instanceof Selectable) || !((Selectable)ua).isSelected()) continue;
                ((Selectable)ua).setSelected(false);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.vp instanceof XpViewport) {
            CvUtils.dispose((XpViewport)this.vp);
        }
    }

    public int getNoOfBits() {
        return this._noOfBits;
    }

    public void setNoOfBits(int bits) {
        this._noOfBits = bits;
    }

    public void setLargeFontAnnotation(int[] annotkey) {
        String st = "";
        StringBuffer stb = new StringBuffer(st);
        for (int i = 0; i < annotkey.length; ++i) {
            stb.append(annotkey[i]);
            stb.append(",");
        }
        Properties prop = new Properties();
        st = stb.toString();
        stb = null;
        prop.setProperty("LargeFontKeys", st);
        if (this.vp instanceof XpCompositePort) {
            XpAnnotationGenerator ag = ((XpCompositePort)this.vp).getAnnotationGenerator();
            ((XpCompositePort)this.vp).setAnnotationGenerator(ag.getClass(), prop);
        } else if (this.vp instanceof XpSingularPort) {
            XpAnnotationGenerator ag = ((XpSingularPort)this.vp).getAnnotationGenerator();
            ((XpSingularPort)this.vp).setAnnotationGenerator(ag.getClass(), prop);
        }
    }

    public void setFilmAnnotationItems(String annotLevel, int customAnnotMask) {
        block7: {
            block8: {
                if (annotLevel == null) {
                    return;
                }
                if (!(this.vp instanceof AnnotCapable)) break block7;
                ((AnnotCapable)((Object)this.vp)).setAnnotationVisible(true);
                if (!"custom".equals(annotLevel)) {
                    XPDisplayPrefsUtils.setAnnotLevel((AnnotCapable)((Object)this.vp), annotLevel);
                    this.vp.updateUI();
                } else if (this.vp instanceof FrameOwner) {
                    String imageType = CvUtils.getImageTypeKey((Capable)((Object)this.vp));
                    XPDisplayPrefsUtils.setCustomAnnotItems((AnnotCapable)((Object)this.vp), imageType, customAnnotMask);
                    this.vp.updateUI();
                }
                if (!(this.vp instanceof XpSingularPort)) break block8;
                XpMedicalImage2DVc mivc = ((XpSingularPort)this.vp).getMedicalImageVc();
                int comps = mivc.getComponentCount();
                for (int i = 0; i < comps; ++i) {
                    Component c = mivc.getComponent(i);
                    if (!(c instanceof XpReferenceVpContentPane)) continue;
                    this.setReferenceVpAnnotation((XpReferenceVpContentPane)c, annotLevel, customAnnotMask);
                }
                break block7;
            }
            if (!(this.vp instanceof XpCompositePort)) break block7;
            int numPorts = ((XpCompositePort)this.vp).getRows() * ((XpCompositePort)this.vp).getCols();
            for (int i = 0; i < numPorts; ++i) {
                XpFrameVisualizer port = ((XpCompositePort)this.vp).getPort(i);
                XpMedicalImage2DVc mivc = port.getMedicalImageVc();
                int comps = mivc.getComponentCount();
                for (int j = 0; j < comps; ++j) {
                    Component c = mivc.getComponent(j);
                    if (!(c instanceof XpReferenceVpContentPane)) continue;
                    this.setReferenceVpAnnotation((XpReferenceVpContentPane)c, annotLevel, customAnnotMask);
                }
            }
        }
    }

    private void setReferenceVpAnnotation(XpReferenceVpContentPane rvpc, String annotLevel, int customAnnotMask) {
        Component[] cc = rvpc.getComponents();
        for (int j = 0; j < cc.length; ++j) {
            if (!(cc[j] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)cc[j])).setAnnotationVisible(true);
            if (!"custom".equals(annotLevel)) {
                XPDisplayPrefsUtils.setAnnotLevel((AnnotCapable)((Object)cc[j]), annotLevel);
                continue;
            }
            if (!(cc[j] instanceof FrameOwner)) continue;
            String imageType = CvUtils.getImageTypeKey((Capable)((Object)cc[j]));
            XPDisplayPrefsUtils.setCustomAnnotItems((AnnotCapable)((Object)cc[j]), imageType, customAnnotMask);
        }
    }

    @Override
    public String getESIString() {
        if (this.vp instanceof FrameOwner) {
            StringBuffer esi = new StringBuffer("");
            XpMedicalDmImage image = null;
            if (this.vp instanceof XpCompositePort) {
                esi.append("MID");
                image = (XpMedicalDmImage)((XpCompositePort)this.vp).getPort(0).getFrame();
            } else {
                image = (XpMedicalDmImage)((FrameOwner)((Object)this.vp)).getFrame();
            }
            Object o = this.vp.getClientProperty("reference_viewport");
            if (o != null && "true".equals(o)) {
                if (esi.toString().length() > 0) {
                    esi.append("+");
                }
                esi.append("Ref");
            }
            if (esi.toString().length() > 0) {
                esi.append(",");
            }
            if (image != null) {
                String exNo = (String)image.getDMImage().getValue(32, 16);
                esi.append("Ex: ").append(exNo == null ? "0" : exNo);
                String seNo = (String)image.getDMImage().getValue(32, 17);
                esi.append(",Se: ").append(seNo == null ? "0" : seNo);
                String imNo = (String)image.getDMImage().getValue(32, 19);
                esi.append(",Im: ").append(imNo == null ? "0" : imNo);
                return this.formatToESI(esi.toString(), ",");
            }
        }
        return "NULL";
    }

    protected String formatToESI(String toFormat, String delim) {
        int totalLen;
        StringBuffer toReturn = new StringBuffer();
        String SPACE = " ";
        String[] tofill = toFormat.split(delim);
        for (int i = 0; i < tofill.length; ++i) {
            int len = tofill[i].length();
            if (len <= 10) {
                toReturn.append(tofill[i]);
                for (int j = len; j < 10; ++j) {
                    toReturn.append(" ");
                }
                continue;
            }
            toReturn.append(tofill[i].substring(1, 10));
        }
        for (int k = totalLen = toReturn.toString().length(); k < 40; ++k) {
            toReturn.append(" ");
        }
        return toReturn.toString();
    }

    public void setOriginalImagePath(String imgPath) {
        this.imagePath = imgPath;
    }

    @Override
    public String getOriginalImagePath() {
        XpMedicalDmImage image;
        if (this.imagePath != null && this.imagePath.trim().length() != 0) {
            return this.imagePath;
        }
        if (this.vp instanceof FrameOwner && (image = (XpMedicalDmImage)((FrameOwner)((Object)this.vp)).getFrame()) != null) {
            return image.getDMImage().getFilePath();
        }
        return null;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int type;
        if (pageIndex > 0) {
            return 1;
        }
        int w = (int)pageFormat.getImageableWidth();
        int h = (int)pageFormat.getImageableHeight();
        int x = (int)pageFormat.getImageableX();
        int y = (int)pageFormat.getImageableY();
        int vp_w = this.vp.getWidth();
        int vp_h = this.vp.getHeight();
        double ratio = (double)vp_w / (double)vp_h;
        double nw = (double)h * ratio;
        double nh = (double)w / ratio;
        int center_x = 0;
        if (nw <= (double)w && nw < (double)h) {
            center_x = (int)(((double)w - nw) * 0.5);
            w = (int)nw;
        } else {
            h = (int)nh;
        }
        if (this.cs == null) {
            this.cs = new XpComponentSave();
        }
        final Graphics2D g2 = (Graphics2D)graphics;
        final int ww = w;
        final int hh = h;
        final int xx = x + center_x;
        final int yy = y;
        int n = this.isColorImage() ? 4 : (type = this._noOfBits == 8 ? 2 : 1);
        if (SwingUtilities.isEventDispatchThread()) {
            BufferedImage bi = this.cs.renderOffscreen(this.vp, ww, hh, type);
            g2.translate(xx, yy);
            g2.drawImage((Image)bi, 0, 0, null);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BufferedImage bi = DicomPrintablePort.this.cs.renderOffscreen(DicomPrintablePort.this.vp, ww, hh, type);
                        g2.translate(xx, yy);
                        g2.drawImage((Image)bi, 0, 0, null);
                    }
                });
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return 0;
    }

    public static XpViewport cloneViewport(XpViewport port, int portindex) {
        XpViewport comp = null;
        if (port == null) {
            return null;
        }
        String renderer = CvPropertiesManager.getProperty("cvf.print.renderer");
        if (port instanceof XpCompositePort) {
            XpCompositePort cp = (XpCompositePort)port;
            if (portindex != -1) {
                XpFrameVisualizer fv = cp.getPort(portindex);
                if (fv != null) {
                    comp = (XpViewport)fv.clone();
                    DicomPrintablePort.copyObject(fv, (XpSingularPort)comp, true);
                }
            } else {
                int rows = cp.getRows();
                int cols = cp.getCols();
                int numports = rows * cols;
                XpMultiImageViewport mivp = null;
                mivp = renderer != null ? new XpMultiImageViewport(renderer) : new XpMultiImageViewport();
                mivp.setRowCol(rows, cols);
                for (int i = 0; i < numports; ++i) {
                    XpFrameVisualizer fv = mivp.getPort(i);
                    XpFrameVisualizer sfv = cp.getPort(i);
                    XpImageScene scene2 = sfv.getScene();
                    if (scene2 == null) {
                        return mivp;
                    }
                    if (i == 0) {
                        mivp.setImages(new XpMedicalImage[]{(XpMedicalImage)scene2.getFrame()});
                    } else {
                        mivp.addImage((XpMedicalImage)scene2.getFrame(), i);
                    }
                    XpImageScene newscene = fv.getScene();
                    newscene.setImageRenderAttributes(scene2.getImageRenderAttributes());
                    fv.getMedicalImageVc().refreshImageRenderAttributes();
                    List rl = scene2.getRois();
                    for (int j = 0; j < rl.size(); ++j) {
                        Replicable sr;
                        RoiActor newra;
                        RoiActor ra = (RoiActor)rl.get(j);
                        if (!(ra instanceof Replicable) || (newra = (RoiActor)(sr = (Replicable)((Object)ra)).clone()) == null) continue;
                        newscene.add(newra);
                    }
                    List ual = scene2.getUserAnnos();
                    for (int j = 0; j < ual.size(); ++j) {
                        XpUserAnnotationModel uam = (XpUserAnnotationModel)ual.get(j);
                        XpUserAnnotationModel newuam = (XpUserAnnotationModel)uam.clone();
                        newscene.add(newuam);
                    }
                    fv.syncScene();
                    DicomPrintablePort.copyObject(sfv, fv, false, true);
                }
                comp = mivp;
            }
        } else if (port instanceof XpImageViewport) {
            XpImageViewport p = (XpImageViewport)port;
            if (p.getScene(p.getFrameIndex()) == null) {
                return null;
            }
            XpFrameVisualizer fv = null;
            fv = renderer != null ? new XpFrameVisualizer(renderer) : new XpFrameVisualizer();
            XpImageScene scn = p.getScene(p.getFrameIndex());
            Object scene3 = null;
            if (scn != null) {
                scene3 = scn.clone();
                fv.setFrameScene((XpImageScene)scene3, p.getMedicalImageVc().getDicomSource());
                DicomPrintablePort.copyObject(p, fv, false);
            }
            comp = fv;
        } else if (port instanceof XpFrameVisualizer) {
            comp = renderer != null ? new XpFrameVisualizer(renderer) : (XpViewport)port.clone();
            DicomPrintablePort.copyObject((XpFrameVisualizer)port, (XpSingularPort)comp, true);
        } else {
            comp = (XpViewport)port.clone();
        }
        return comp;
    }

    public static void copyObject(XpSingularPort source, XpSingularPort out, boolean mivconly) {
        DicomPrintablePort.copyObject(source, out, mivconly, false);
    }

    public static void copyObject(XpSingularPort source, XpSingularPort out, boolean mivconly, boolean scaleRefViewport) {
        Replicable rep;
        Component newcomponent;
        Component c;
        int i;
        XpSingularPort iv = out;
        if (!mivconly) {
            XpImage2DVc ivc = source.getMedicalImageVc().getImageVc();
            int childCount = ivc.getComponentCount();
            for (i = 0; i < childCount; ++i) {
                c = ivc.getComponent(i);
                if (!c.isVisible() || !(c instanceof Replicable) || (newcomponent = (Component)(rep = (Replicable)((Object)c)).clone()) == null) continue;
                iv.getMedicalImageVc().getImageVc().add(newcomponent);
            }
        }
        XpMedicalImage2DVc mivc = source.getMedicalImageVc();
        int comps = mivc.getComponentCount();
        for (i = 0; i < comps; ++i) {
            c = mivc.getComponent(i);
            if (!c.isVisible() || !(c instanceof Replicable) || (newcomponent = (Component)(rep = (Replicable)((Object)c)).clone()) == null) continue;
            iv.getMedicalImageVc().add(newcomponent, i);
            if (!(newcomponent instanceof XpReferenceVpContentPane)) continue;
            ((XpReferenceVpContentPane)newcomponent).setScaling(scaleRefViewport);
        }
    }

    public boolean isColorImage() {
        if (printRGB) {
            return true;
        }
        boolean iscolor = false;
        if (this.vp instanceof XpCompositePort) {
            XpCompositePort cport = (XpCompositePort)this.vp;
            int tports = cport.getNumPorts();
            for (int i = 0; i < tports && !(iscolor = this.isColorImg(cport.getPort(i))); ++i) {
            }
        } else if (this.vp instanceof XpSingularPort) {
            iscolor = this.isColorImg((XpSingularPort)this.vp);
        } else if (this.vp instanceof Component && this.vp.getColorModel().getComponentSize().length > 1) {
            return true;
        }
        return iscolor;
    }

    private boolean isColorImg(XpSingularPort vp) {
        XpImage img = vp.getFrame();
        if (img == null) {
            return false;
        }
        RenderedImage rimg = img.getPixelData();
        int[] cc = rimg.getColorModel().getComponentSize();
        XpImageRenderAttributes ira = vp.getImageRenderAttributes();
        if (ira == null) {
            return false;
        }
        int nChannels = cc.length;
        return nChannels != 1 || ira.getColormap() != null || ira.getColorOverlay() != null;
    }
}

