/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.comparators.NumberComparator;
import com.ge.med.cse.cvf.ui.ImageListCellRenderer;
import com.ge.med.cse.cvf.util.XpThumbnailImageIcon;
import com.ge.med.terra.tap.dm.DMObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XpThumbnailListView
extends JPanel
implements ListSelectionListener {
    public static final String LISTVIEW_SELECTION_CHANGE = "listview_selection_change";
    private JList list = new JList();
    private DefaultListModel listviewmodel = new DefaultListModel();
    private boolean showFirstImage = true;

    public XpThumbnailListView(DMObject[] seriesobj, boolean showFirstImage) {
        this.showFirstImage = showFirstImage;
        this.init();
        this.setSeriesObjects(seriesobj);
    }

    public XpThumbnailListView(DMObject seriesobj, boolean showFirstImage) {
        this.showFirstImage = showFirstImage;
        this.init();
        DMObject[] images = seriesobj.getRelated("image");
        this.listviewmodel.add(0, new SeriesThumbnailObject(seriesobj, showFirstImage));
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setUI(null);
        this.list.setName("listview");
        JScrollPane scrollpane = new JScrollPane(this.list);
        this.list.setCellRenderer(new ImageListCellRenderer());
        this.list.setModel(this.listviewmodel);
        ImageListCellRenderer renderer = (ImageListCellRenderer)this.list.getCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.add((Component)scrollpane, "Center");
        this.list.addListSelectionListener(this);
    }

    private void setSeriesObjects(DMObject[] seriesobj) {
        this.listviewmodel.clear();
        for (int i = 0; i < seriesobj.length; ++i) {
            this.listviewmodel.add(i, new SeriesThumbnailObject(seriesobj[i], this.showFirstImage));
        }
    }

    public void addSeriesObjects(DMObject seriesobj) {
        this.listviewmodel.add(this.listviewmodel.getSize(), new SeriesThumbnailObject(seriesobj, this.showFirstImage));
    }

    public DMObject[] getAllSelectedSeries() {
        List selectedvalues = this.list.getSelectedValuesList();
        DMObject[] allseries = new DMObject[selectedvalues.size()];
        for (int i = 0; i < selectedvalues.size(); ++i) {
            SeriesThumbnailObject seriesThumbnailObject = (SeriesThumbnailObject)selectedvalues.get(i);
            allseries[i] = seriesThumbnailObject.getSeriesObj();
        }
        return allseries;
    }

    public int getselectedIndex() {
        return this.list.getSelectedIndex();
    }

    public DMObject[] getAllseries() {
        DMObject[] allseries = new DMObject[this.listviewmodel.size()];
        for (int i = 0; i < this.listviewmodel.size(); ++i) {
            SeriesThumbnailObject seriesThumbnailObject = (SeriesThumbnailObject)this.listviewmodel.get(i);
            allseries[i] = seriesThumbnailObject.getSeriesObj();
        }
        return allseries;
    }

    public void setSelection(int fromIndex, int toIndex) {
        this.list.setSelectionInterval(fromIndex, toIndex);
    }

    public void addSelection(int fromIndex, int toIndex) {
        this.list.addSelectionInterval(fromIndex, toIndex);
    }

    public void addSelection(DMObject[] seriesobj) {
        for (int i = 0; i < this.listviewmodel.size(); ++i) {
            SeriesThumbnailObject seriesThumbnailObject = (SeriesThumbnailObject)this.listviewmodel.get(i);
            for (int j = 0; j < seriesobj.length; ++j) {
                if (!seriesThumbnailObject.getSeriesObj().equals(seriesobj[j])) continue;
                this.list.addSelectionInterval(i, i);
            }
        }
    }

    public void setSelection(DMObject[] seriesobj) {
        for (int j = 0; j < seriesobj.length; ++j) {
            for (int i = 0; i < this.listviewmodel.size(); ++i) {
                SeriesThumbnailObject seriesThumbnailObject = (SeriesThumbnailObject)this.listviewmodel.get(i);
                if (!seriesThumbnailObject.getSeriesObj().equals(seriesobj[j])) continue;
                if (j == 0) {
                    this.list.setSelectionInterval(i, i);
                    continue;
                }
                this.list.addSelectionInterval(i, i);
            }
        }
    }

    public void setSelection(DMObject seriesobj) {
        for (int i = 0; i < this.listviewmodel.size(); ++i) {
            SeriesThumbnailObject seriesThumbnailObject = (SeriesThumbnailObject)this.listviewmodel.get(i);
            if (!seriesThumbnailObject.getSeriesObj().equals(seriesobj)) continue;
            this.list.setSelectionInterval(i, i);
        }
    }

    public void addSelection(DMObject seriesobj) {
        for (int i = 0; i < this.listviewmodel.size(); ++i) {
            SeriesThumbnailObject seriesThumbnailObject = (SeriesThumbnailObject)this.listviewmodel.get(i);
            if (!seriesThumbnailObject.getSeriesObj().equals(seriesobj)) continue;
            this.list.addSelectionInterval(i, i);
        }
    }

    public void removeSelection(int fromIndex, int toIndex) {
        this.list.removeSelectionInterval(fromIndex, toIndex);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        List selectedvalues = this.list.getSelectedValuesList();
        DMObject[] series = new DMObject[selectedvalues.size()];
        for (int i = 0; i < selectedvalues.size(); ++i) {
            SeriesThumbnailObject seriesThumbnailObject = (SeriesThumbnailObject)selectedvalues.get(i);
            series[i] = seriesThumbnailObject.getSeriesObj();
        }
        this.firePropertyChange(LISTVIEW_SELECTION_CHANGE, "", series);
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    @Override
    public void removeAll() {
        this.list.removeAll();
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    class SeriesThumbnailObject {
        private DMObject seriesObj;
        private XpThumbnailImageIcon thumbnailview;
        private boolean showFirstimage = true;

        SeriesThumbnailObject(DMObject seriesobj, boolean showFirstimage) {
            this.seriesObj = seriesobj;
            this.showFirstimage = showFirstimage;
            DMObject firstimage = null;
            DMObject middleimage = null;
            DMObject[] images = this.seriesObj.getRelated("image", null);
            Arrays.sort(images, new NumberComparator(32, 19));
            if (showFirstimage) {
                firstimage = images[0];
            } else {
                middleimage = images[images.length / 2 + images.length % 2];
            }
            if (showFirstimage) {
                if (firstimage != null) {
                    this.thumbnailview = new XpThumbnailImageIcon(firstimage, false);
                }
            } else if (middleimage != null) {
                this.thumbnailview = new XpThumbnailImageIcon(middleimage, false);
            }
        }

        public DMObject getSeriesObj() {
            return this.seriesObj;
        }

        public XpThumbnailImageIcon getThumbnaView() {
            return this.thumbnailview;
        }
    }
}

