/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.idc.PagingCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.xpv.onport.XPopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XpOnportSlider
extends XPopPanel {
    public FramePositioningCapable port;
    private FramePositioningCapable fCap = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    boolean enabled = true;
    private Properties properties = null;
    private JSlider pagingSlider = new JSlider();
    private Capable cap = null;
    private int startValue = 0;
    private int endValue = 0;
    private transient PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String pname = evt.getPropertyName();
            if (("data_changed".equals(pname) || "CONTENT_CHANGED".equals(pname) || "CONTENT_UPDATED".equals(pname) || "FrameIndex".equals(pname)) && XpOnportSlider.this.fCap != null && XpOnportSlider.this.fCap.getNumFrames() > 0) {
                XpOnportSlider.this.setEnabled(true);
                XpOnportSlider.this.updateSlider();
                ((JComponent)((Object)XpOnportSlider.this.fCap)).updateUI();
            }
        }
    };

    public XpOnportSlider() {
        this.setName("XP_ONPORT_SLIDER");
        Properties prop = new Properties();
        prop.setProperty("backGroundR", "0");
        prop.setProperty("backGroundG", "0");
        prop.setProperty("backGroundB", "0");
        XpOnportSlider.setProperties(prop);
        this.setLayout(new BorderLayout());
        try {
            this.jbInit();
            this.setFocusable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setStayOnMouseEnter(true);
    }

    private void jbInit() throws Exception {
        this.properties = CvPropertiesManager.getProperties();
        this.pagingSlider.setName("XP_Slider");
        this.pagingSlider.setOpaque(false);
        this.setSliderOrientation(1);
        this.setOpaque(false);
        this.pagingSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == XpOnportSlider.this.pagingSlider) {
                    XpOnportSlider.this.updatePort();
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.port != null) {
            if (this.pagingSlider.getOrientation() == 1) {
                JComponent c = (JComponent)this.listenTo;
                int height = c.getHeight();
                int sliderHt = height - (int)(0.3 * (double)height);
                return new Dimension(50, sliderHt);
            }
            JComponent c = (JComponent)this.listenTo;
            int width = c.getWidth();
            int sliderWidth = width - (int)(0.3 * (double)width);
            return new Dimension(sliderWidth, 50);
        }
        return super.getPreferredSize();
    }

    public void setSliderOrientation(int ornt) {
        if (ornt != 0) {
            if (ornt != 1) {
                ornt = 1;
            }
        }
        this.pagingSlider.setOrientation(ornt);
        if (ornt == 0) {
            this.add((Component)this.pagingSlider, "Center");
            this.setPreferredSize(new Dimension(350, 40));
            this.setMinimumSize(new Dimension(150, 30));
            this.pagingSlider.setInverted(true);
        } else {
            this.add((Component)this.pagingSlider, "Center");
            this.setPreferredSize(new Dimension(40, 350));
            this.setMinimumSize(new Dimension(30, 150));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabled = enabled;
    }

    @Override
    public void fire() {
        if (this.enabled) {
            super.fire();
        }
    }

    @Override
    public void setCapable(Capable capable) {
        this.cap = capable;
        this.fCap = (FramePositioningCapable)capable.getCapable(FramePositioningCapable.class.getName());
        if (this.fCap != null) {
            this.port = this.fCap;
            this.port.addPropertyChangeListener(this.viewPortListener);
            if (this.fCap.getNumFrames() < 1) {
                this.setEnabled(false);
            } else {
                this.updateSlider();
            }
        }
    }

    @Override
    protected void displayLevel(int level) {
        if (this.cap != null) {
            if (this.cap instanceof PagingCapable && !((PagingCapable)this.cap).isPagingOn()) {
                super.displayLevel(0);
                return;
            }
            CineCapable cine = (CineCapable)this.cap.getCapable("com.ge.med.idc.CineCapable");
            if (null != cine) {
                if (cine.getCine()) {
                    super.displayLevel(0);
                } else {
                    super.displayLevel(level);
                }
            } else {
                super.displayLevel(level);
            }
        } else {
            super.displayLevel(level);
        }
    }

    public void updateSlider() {
        if (this.port == null) {
            return;
        }
        this.endValue = this.port.getNumFrames();
        this.startValue = this.endValue > 0 ? 1 : this.endValue;
        BoundedRangeModel model = this.pagingSlider.getModel();
        int newSliderValue = this.endValue > 0 ? this.endValue - this.port.getFrameIndex() : this.endValue;
        this.pagingSlider.getModel().setRangeProperties(newSliderValue, 0, this.startValue, this.endValue, model.getValueIsAdjusting());
        ((JComponent)((Object)this.port)).updateUI();
    }

    private void updatePort() {
        int id = this.pagingSlider.getValue();
        if (id != this.endValue - this.port.getFrameIndex()) {
            this.port.setFrameIndex(this.endValue - id);
        }
        ((JComponent)((Object)this.port)).updateUI();
    }

    @Override
    public boolean isSupported(Capable capable) {
        return capable instanceof FramePositioningCapable;
    }

    @Override
    public void setPort(JComponent c) {
        if (c == null) {
            if (this.cap != null) {
                this.cap.removePropertyChangeListener(this.viewPortListener);
            }
            this.listenTo = c;
        } else {
            super.setPort(c);
        }
    }

    @Override
    public void listenTo(Component c) {
        if (c == null) {
            if (this.cap != null) {
                this.cap.removePropertyChangeListener(this.viewPortListener);
            }
            this.listenTo = c;
        } else {
            super.listenTo(c);
        }
    }
}

