/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.idc.PagingCapable;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.ui.CvNumberedThumbSlider;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.xpv.onport.XPopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class XpOnportPagingSlider
extends XPopPanel {
    public static final String NO_SKIP_MODE = "NO_SKIP_MODE";
    public static final String SCROLL_VALUE = "SCROLL_VALUE";
    public final String BUTTON_NAME = "PagingSlider.button";
    public final String BUTTON_FONT = "Slider.button.font";
    public final String BUTTON_BORDER = "Slider.button.border";
    public FramePositioningCapable port;
    private FramePositioningCapable fCap = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    boolean enabled = true;
    private Properties properties = null;
    private JPanel minpanel = new JPanel(new FlowLayout(1));
    private JPanel maxpanel = new JPanel(new FlowLayout(1));
    private JSlider pagingSlider = new CvNumberedThumbSlider();
    private JButton minbutton = null;
    private JButton maxbutton = null;
    private int startValue = 0;
    private int endValue = 0;
    private Capable cap = null;
    private transient PropertyChangeListener MaxButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (XpOnportPagingSlider.this.endValue > 0) {
                XpOnportPagingSlider.this.port.setFrameIndex(XpOnportPagingSlider.this.endValue - 1);
            }
            XpOnportPagingSlider.this.updateSlider();
        }
    };
    private transient PropertyChangeListener MinButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (XpOnportPagingSlider.this.endValue > 0) {
                XpOnportPagingSlider.this.port.setFrameIndex(0);
            }
            XpOnportPagingSlider.this.updateSlider();
        }
    };
    private transient PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String pname = evt.getPropertyName();
            if (("data_changed".equals(pname) || "CONTENT_CHANGED".equals(pname) || "CONTENT_UPDATED".equals(pname) || "FrameIndex".equals(pname)) && XpOnportPagingSlider.this.fCap != null && XpOnportPagingSlider.this.fCap.getNumFrames() > 0) {
                XpOnportPagingSlider.this.setEnabled(true);
                XpOnportPagingSlider.this.updateSliderButtons();
                XpOnportPagingSlider.this.updateSlider();
                ((JComponent)((Object)XpOnportPagingSlider.this.fCap)).updateUI();
            }
        }
    };
    transient MouseInputListener mouseChangeAdapter = new MouseInputAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            XpOnportPagingSlider.this.updateSliderOnMouseEnter(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            XpOnportPagingSlider.this.maxpanel.removeAll();
            XpOnportPagingSlider.this.minpanel.removeAll();
            XpOnportPagingSlider.this.updateUI();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            XpOnportPagingSlider.this.maxpanel.add(XpOnportPagingSlider.this.maxbutton);
            XpOnportPagingSlider.this.minpanel.add(XpOnportPagingSlider.this.minbutton);
            XpOnportPagingSlider.this.updateUI();
        }
    };

    public XpOnportPagingSlider() {
        this.setName("XP_POP_SLIDER");
        Properties prop = new Properties();
        prop.setProperty("backGroundR", "0");
        prop.setProperty("backGroundG", "0");
        prop.setProperty("backGroundB", "0");
        XpOnportPagingSlider.setProperties(prop);
        this.setLayout(new BorderLayout());
        try {
            this.jbInit();
            this.setFocusable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setStayOnMouseEnter(true);
    }

    private void jbInit() throws Exception {
        Border buttonBorder;
        Font buttonFont;
        this.properties = CvPropertiesManager.getProperties();
        this.pagingSlider.setName("XP_Slider");
        this.pagingSlider.setOpaque(false);
        this.minbutton = LookAndFeelFactory.getButton("PagingSlider.button");
        if (null == this.minbutton) {
            this.minbutton = new JButton();
            this.minbutton.setFocusable(false);
        }
        this.maxbutton = LookAndFeelFactory.getButton("PagingSlider.button");
        if (null == this.maxbutton) {
            this.maxbutton = new JButton();
            this.maxbutton.setFocusable(false);
        }
        if (null != (buttonFont = LookAndFeelFactory.getFont("Slider.button.font", "Button.font"))) {
            this.minbutton.setFont(buttonFont);
            this.maxbutton.setFont(buttonFont);
        }
        if (null != (buttonBorder = LookAndFeelFactory.getBorder("Slider.button.border", null))) {
            this.minbutton.setBorder(buttonBorder);
            this.maxbutton.setBorder(buttonBorder);
        }
        this.minbutton.setPreferredSize(new Dimension(60, 20));
        this.minpanel.add(this.minbutton);
        this.minpanel.setOpaque(false);
        this.minpanel.setPreferredSize(new Dimension(35, 35));
        this.maxbutton.setPreferredSize(new Dimension(60, 20));
        this.maxpanel.setPreferredSize(new Dimension(35, 35));
        this.maxpanel.add(this.maxbutton);
        this.maxpanel.setOpaque(false);
        this.setSliderOrientation(1);
        this.setOpaque(false);
        this.maxbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XpOnportPagingSlider.this.endValue > 0) {
                    XpOnportPagingSlider.this.port.setFrameIndex(XpOnportPagingSlider.this.endValue - 1);
                }
                XpOnportPagingSlider.this.updateSlider();
            }
        });
        this.minbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XpOnportPagingSlider.this.endValue > 0) {
                    XpOnportPagingSlider.this.port.setFrameIndex(0);
                }
                XpOnportPagingSlider.this.updateSlider();
            }
        });
        this.pagingSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == XpOnportPagingSlider.this.pagingSlider) {
                    XpOnportPagingSlider.this.updatePort();
                }
            }
        });
        this.pagingSlider.addMouseListener(this.mouseChangeAdapter);
        this.pagingSlider.addMouseMotionListener(this.mouseChangeAdapter);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.port != null) {
            if (this.pagingSlider.getOrientation() == 1) {
                JComponent c = (JComponent)this.listenTo;
                int height = c.getHeight();
                int sliderHt = height - (int)(0.3 * (double)height);
                return new Dimension(50, sliderHt);
            }
            JComponent c = (JComponent)this.listenTo;
            int width = c.getWidth();
            int sliderWidth = width - (int)(0.3 * (double)width);
            return new Dimension(sliderWidth, 50);
        }
        return super.getPreferredSize();
    }

    public void setSliderOrientation(int ornt) {
        if (ornt != 0) {
            if (ornt != 1) {
                ornt = 1;
            }
        }
        this.pagingSlider.setOrientation(ornt);
        if (ornt == 0) {
            this.add((Component)this.minpanel, "West");
            this.add((Component)this.pagingSlider, "Center");
            this.add((Component)this.maxpanel, "East");
            this.setPreferredSize(new Dimension(350, 40));
            this.setMinimumSize(new Dimension(150, 30));
            this.pagingSlider.setInverted(true);
        } else {
            this.add((Component)this.minpanel, "North");
            this.add((Component)this.pagingSlider, "Center");
            this.add((Component)this.maxpanel, "South");
            this.setPreferredSize(new Dimension(40, 350));
            this.setMinimumSize(new Dimension(30, 150));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabled = enabled;
    }

    @Override
    public void fire() {
        if (this.enabled) {
            super.fire();
        }
    }

    @Override
    public final void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public final void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    @Override
    public void setCapable(Capable capable) {
        this.cap = capable;
        this.fCap = (FramePositioningCapable)capable.getCapable(FramePositioningCapable.class.getName());
        if (this.fCap != null) {
            this.port = this.fCap;
            this.port.addPropertyChangeListener(this.viewPortListener);
            if (this.fCap.getNumFrames() < 1) {
                this.setEnabled(false);
            } else {
                this.updateSliderButtons();
                this.updateSlider();
            }
        }
    }

    @Override
    protected void displayLevel(int level) {
        if (this.cap != null) {
            if (this.cap instanceof PagingCapable && !((PagingCapable)this.cap).isPagingOn()) {
                super.displayLevel(0);
                return;
            }
            CineCapable cine = (CineCapable)this.cap.getCapable("com.ge.med.idc.CineCapable");
            if (null != cine) {
                if (cine.getCine()) {
                    super.displayLevel(0);
                } else {
                    super.displayLevel(level);
                }
            } else {
                super.displayLevel(level);
            }
        } else {
            super.displayLevel(level);
        }
    }

    public void updateSlider() {
        if (this.port == null) {
            return;
        }
        BoundedRangeModel model = this.pagingSlider.getModel();
        int newSliderValue = this.endValue > 0 ? this.endValue - this.port.getFrameIndex() : this.endValue;
        this.pagingSlider.getModel().setRangeProperties(newSliderValue, 0, this.startValue, this.endValue, model.getValueIsAdjusting());
        ((JComponent)((Object)this.port)).updateUI();
    }

    public void updatePort() {
        int id = this.pagingSlider.getValue();
        if (id != this.endValue - this.port.getFrameIndex()) {
            this.port.setFrameIndex(this.endValue - id);
        }
        ((JComponent)((Object)this.port)).updateUI();
    }

    @Override
    public boolean isSupported(Capable capable) {
        return capable instanceof FramePositioningCapable;
    }

    @Override
    public void setPort(JComponent c) {
        if (c == null) {
            if (this.cap != null) {
                this.cap.removePropertyChangeListener(this.viewPortListener);
            }
            this.listenTo = c;
        } else {
            super.setPort(c);
        }
    }

    @Override
    public void listenTo(Component c) {
        if (c == null) {
            if (this.cap != null) {
                this.cap.removePropertyChangeListener(this.viewPortListener);
            }
            this.listenTo = c;
        } else {
            super.listenTo(c);
        }
    }

    public void updateSliderButtons() {
        this.endValue = this.port.getNumFrames();
        this.startValue = this.endValue > 0 ? 1 : this.endValue;
        this.minbutton.setText("" + this.startValue);
        this.maxbutton.setText("" + this.endValue);
        ((JComponent)((Object)this.port)).updateUI();
    }

    void updateSliderOnMouseEnter(MouseEvent e) {
        this.updateSliderButtons();
        this.updateSlider();
    }
}

