/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.xpv.onport.XPopPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class XpHoverMenuPanel
extends XPopPanel {
    private Capable cap = null;
    private String targetVpName = "";
    private Properties properties = null;
    private JPanel westCtrlPanel = null;
    private JPanel eastCtrlPanel = null;
    private JPanel centerCtrlPanel = null;
    public FramePositioningCapable port;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private final Dimension buttonDim = new Dimension(22, 22);
    private final Dimension iconSize = new Dimension(18, 18);
    private static final String DOT = ".";
    private static final String HOVERMENU_EAST_PANEL = "cvf.hovermenu.panel.east";
    private static final String HOVERMENU_WEST_PANEL = "cvf.hovermenu.panel.west";
    private static final String HOVERMENU_CENTER_PANEL = "cvf.hovermenu.panel.center";
    private static final String HOVERMENU_EAST_CTRL = "cvf.hovermenu.ctrl.east.";
    private static final String HOVERMENU_WEST_CTRL = "cvf.hovermenu.ctrl.west.";
    private static final String HOVERMENU_CENTER_CTRL = "cvf.hovermenu.ctrl.center.";
    public final String HOVERMENU_BUTTON_BORDER = "HoverMenu.button.border";
    private static final String HOVERMENU_MINIMUMWIDTH = "cvf.hovermenu.minimumwidth";
    private static final String DEFAULT_MINWIDTH = "320";

    public XpHoverMenuPanel() {
        this(null, null);
    }

    XpHoverMenuPanel(Properties p) {
        this(null, p);
    }

    public XpHoverMenuPanel(String applicationName, Properties props) {
        this.targetVpName = null == applicationName ? "" : applicationName;
        Color hoverMenuBgColor = LookAndFeelFactory.getColor("HoverMenu.Background.Color", null);
        if (null != hoverMenuBgColor) {
            String redVal = String.valueOf(hoverMenuBgColor.getRed());
            String greenVal = String.valueOf(hoverMenuBgColor.getGreen());
            String blueVal = String.valueOf(hoverMenuBgColor.getBlue());
            Properties prop = new Properties();
            prop.setProperty("backGroundR", redVal);
            prop.setProperty("backGroundG", greenVal);
            prop.setProperty("backGroundB", blueVal);
            XpHoverMenuPanel.setProperties(prop);
        }
        this.properties = CvPropertiesManager.getProperties();
        if (props != null) {
            this.properties.putAll((Map<?, ?>)props);
        }
        try {
            this.jbInit();
            this.setPreferredSize(new Dimension(400, 38));
            this.setMinimumSize(new Dimension(400, 38));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setStayOnMouseEnter(true);
    }

    private void jbInit() throws Exception {
        this.mainPanel.setName("Xp_Hover_Menu");
        this.setLayout(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(400, 38));
        this.addCtrlsToHoverMenu();
        this.add(this.mainPanel);
    }

    private void addCtrlsToHoverMenu() {
        Set<Object> allKeys;
        if (this.targetVpName != null && this.targetVpName.length() > 0) {
            this.targetVpName = this.targetVpName + DOT;
        }
        this.addPanelsToHoverMenu();
        int eastCtrlCnt = 0;
        int westCtrlCnt = 0;
        int centerCtrlCnt = 0;
        eastCtrlCnt = Integer.parseInt(this.properties.getProperty(this.targetVpName + HOVERMENU_EAST_CTRL + "count", "-1"));
        westCtrlCnt = Integer.parseInt(this.properties.getProperty(this.targetVpName + HOVERMENU_WEST_CTRL + "count", "-1"));
        centerCtrlCnt = Integer.parseInt(this.properties.getProperty(this.targetVpName + HOVERMENU_CENTER_CTRL + "count", "-1"));
        if (eastCtrlCnt == -1) {
            eastCtrlCnt = 0;
            allKeys = this.properties.keySet();
            for (Object key : allKeys) {
                if (!key.toString().startsWith(this.targetVpName + HOVERMENU_EAST_CTRL) || key.toString().endsWith("btnStyle")) continue;
                ++eastCtrlCnt;
            }
        }
        if (westCtrlCnt == -1) {
            westCtrlCnt = 0;
            allKeys = this.properties.keySet();
            for (Object key : allKeys) {
                if (!key.toString().startsWith(this.targetVpName + HOVERMENU_WEST_CTRL) || key.toString().endsWith("btnStyle")) continue;
                ++westCtrlCnt;
            }
        }
        if (centerCtrlCnt == -1) {
            centerCtrlCnt = 0;
            allKeys = this.properties.keySet();
            for (Object key : allKeys) {
                if (!key.toString().startsWith(this.targetVpName + HOVERMENU_CENTER_CTRL) || key.toString().endsWith("btnStyle")) continue;
                ++centerCtrlCnt;
            }
        }
        if (0 == eastCtrlCnt && 0 == westCtrlCnt && 0 == centerCtrlCnt) {
            return;
        }
        if (eastCtrlCnt > 0 && null == this.eastCtrlPanel) {
            this.eastCtrlPanel = new JPanel(new FlowLayout());
            this.createAndAddCtrlsToPanel(this.eastCtrlPanel, eastCtrlCnt, this.targetVpName + HOVERMENU_EAST_CTRL);
            this.mainPanel.add((Component)this.eastCtrlPanel, "East");
        }
        if (westCtrlCnt > 0 && null == this.westCtrlPanel) {
            this.westCtrlPanel = new JPanel(new FlowLayout());
            this.createAndAddCtrlsToPanel(this.westCtrlPanel, westCtrlCnt, this.targetVpName + HOVERMENU_WEST_CTRL);
            this.mainPanel.add((Component)this.westCtrlPanel, "West");
        }
        if (centerCtrlCnt > 0 && null == this.centerCtrlPanel) {
            this.centerCtrlPanel = new JPanel(new FlowLayout());
            this.createAndAddCtrlsToPanel(this.centerCtrlPanel, centerCtrlCnt, this.targetVpName + HOVERMENU_CENTER_CTRL);
            this.mainPanel.add((Component)this.centerCtrlPanel, "Center");
        }
    }

    private void addPanelsToHoverMenu() {
        Set<Object> allKeys = this.properties.keySet();
        if (allKeys.contains(HOVERMENU_EAST_PANEL)) {
            this.eastCtrlPanel = this.createPanel(HOVERMENU_EAST_PANEL);
            this.mainPanel.add((Component)this.eastCtrlPanel, "East");
        }
        if (allKeys.contains(HOVERMENU_WEST_PANEL)) {
            this.westCtrlPanel = this.createPanel(HOVERMENU_WEST_PANEL);
            this.mainPanel.add((Component)this.westCtrlPanel, "West");
        }
        if (allKeys.contains(HOVERMENU_CENTER_PANEL)) {
            this.centerCtrlPanel = this.createPanel(HOVERMENU_CENTER_PANEL);
            this.mainPanel.add((Component)this.centerCtrlPanel, "Center");
        }
    }

    public void addPanelsToHoverMenu(JPanel panel, String location) {
        if (location.equals("East")) {
            this.mainPanel.remove(this.eastCtrlPanel);
            this.eastCtrlPanel = panel;
            this.mainPanel.add((Component)this.eastCtrlPanel, location);
        } else if (location.equals("West")) {
            this.mainPanel.remove(this.westCtrlPanel);
            this.westCtrlPanel = panel;
            this.mainPanel.add((Component)this.westCtrlPanel, location);
        } else if (location.equals("Center")) {
            this.mainPanel.remove(this.centerCtrlPanel);
            this.centerCtrlPanel = panel;
            this.mainPanel.add((Component)this.centerCtrlPanel, location);
        }
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    @Override
    protected void displayLevel(int level) {
        if (this.listenTo != null) {
            String minimumexpectedwidth = CvPropertiesManager.getProperty(this.targetVpName + HOVERMENU_MINIMUMWIDTH, DEFAULT_MINWIDTH);
            int minexpectedwidth = Integer.parseInt(minimumexpectedwidth);
            if (this.listenTo.getWidth() < minexpectedwidth) {
                super.displayLevel(0);
            } else {
                super.displayLevel(level);
            }
        } else {
            super.displayLevel(level);
        }
    }

    @Override
    public void listenTo(Component c) {
        if (c == null) {
            this.listenTo = c;
            this.removeMenuPanels(this.eastCtrlPanel);
            this.removeMenuPanels(this.westCtrlPanel);
            this.removeMenuPanels(this.centerCtrlPanel);
        } else {
            super.listenTo(c);
        }
    }

    @Override
    public void setPort(JComponent c) {
        if (c == null) {
            this.listenTo = c;
            this.cap = null;
            this.removeMenuPanels(this.eastCtrlPanel);
            this.removeMenuPanels(this.westCtrlPanel);
            this.removeMenuPanels(this.centerCtrlPanel);
        } else {
            super.setPort(c);
        }
    }

    private JPanel createPanel(String panelType) {
        String panelClassName = (String)this.properties.get(panelType);
        Class hoverMenuPanelClass = null;
        try {
            hoverMenuPanelClass = CvUtils.getClass(panelClassName);
            JPanel hoverMenuPanel = (JPanel)hoverMenuPanelClass.newInstance();
            return hoverMenuPanel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void createAndAddCtrlsToPanel(JPanel pnl, int ctrlCnt, String locProp) {
        for (int i = 0; i < ctrlCnt; ++i) {
            try {
                String obj = this.properties.getProperty(locProp + i);
                Class c = CvUtils.getClass(obj);
                Object o = c.newInstance();
                BaseAction ba = (BaseAction)o;
                AbstractButton b = null;
                String btntype = this.properties.getProperty(locProp + i + ".btnStyle");
                switch (btntype = btntype == null ? "DEFAULT" : btntype.trim().toUpperCase()) {
                    case "TOGGLE": {
                        b = new HMToggleButton(ba);
                        break;
                    }
                    case "RADIO": {
                        b = new HMRadioButton(ba);
                    }
                    default: {
                        b = new HMButton(ba);
                    }
                }
                b.setFocusable(false);
                Border buttonBorder = LookAndFeelFactory.getBorder("HoverMenu.button.border", "Button.border");
                if (null != buttonBorder) {
                    b.setBorder(buttonBorder);
                } else if (null != LookAndFeelFactory.getPropertyValue("HoverMenu.button.border")) {
                    b.setBorder(buttonBorder);
                }
                b.setPreferredSize(this.buttonDim);
                b.setMinimumSize(this.buttonDim);
                b.setMaximumSize(this.buttonDim);
                Object dsIcon = ba.getValue("SmallIcon");
                if (dsIcon instanceof ImageIcon) {
                    Icon icon = this.getScaledIcon((ImageIcon)dsIcon);
                    ba.putValue("SmallIcon", icon);
                }
                if (dsIcon != null) {
                    b.setText("");
                }
                pnl.add(b);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createAndAddCtrlsToPanel(JPanel pnl, BaseAction action) {
        try {
            BaseAction ba = action;
            HMButton b = new HMButton(ba);
            b.setFocusable(false);
            Border buttonBorder = LookAndFeelFactory.getBorder("HoverMenu.button.border", "Button.border");
            if (null != buttonBorder) {
                b.setBorder(buttonBorder);
            } else if (null != LookAndFeelFactory.getPropertyValue("HoverMenu.button.border")) {
                b.setBorder(buttonBorder);
            }
            b.setPreferredSize(this.buttonDim);
            b.setMinimumSize(this.buttonDim);
            b.setMaximumSize(this.buttonDim);
            Object dsIcon = ba.getValue("SmallIcon");
            if (dsIcon instanceof ImageIcon) {
                Icon icon = this.getScaledIcon((ImageIcon)dsIcon);
                ba.putValue("SmallIcon", icon);
            }
            if (dsIcon != null) {
                b.setText("");
            }
            pnl.add(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Icon getScaledIcon(ImageIcon icon) {
        Image img = icon.getImage();
        int ich = icon.getIconHeight() > this.iconSize.height ? this.iconSize.height : icon.getIconHeight();
        int icw = icon.getIconWidth() > this.iconSize.width ? this.iconSize.width : icon.getIconWidth();
        ImageIcon ic = new ImageIcon(img.getScaledInstance(icw, ich, 4));
        return ic;
    }

    @Override
    public boolean isSupported(Capable capable) {
        return true;
    }

    private void setCapableForMenuPanels(JPanel panel) {
        if (panel != null) {
            for (Component comp : panel.getComponents()) {
                try {
                    AbstractButton b;
                    if (!(comp instanceof AbstractButton) || !((b = (AbstractButton)comp).getAction() instanceof BaseAction)) continue;
                    BaseAction ba = (BaseAction)b.getAction();
                    ba.setCapable(this.cap);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void removeMenuPanels(JPanel panel) {
        if (panel != null) {
            for (Component comp : panel.getComponents()) {
                try {
                    AbstractButton b;
                    Action a;
                    if (!(comp instanceof AbstractButton) || (a = (b = (AbstractButton)comp).getAction()) == null || !(a instanceof BaseAction)) continue;
                    ((BaseAction)a).setCapable(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setCapable(Capable c) {
        if (c == null) {
            return;
        }
        this.cap = c;
        this.setCapableForMenuPanels(this.eastCtrlPanel);
        this.setCapableForMenuPanels(this.westCtrlPanel);
        this.setCapableForMenuPanels(this.centerCtrlPanel);
    }

    public void setEnableAction(String actionclass, boolean enable) {
        boolean found = false;
        Action act = null;
        Component[] comps = this.mainPanel.getComponents();
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                Component[] innercomps = null;
                if (comps[i] instanceof JPanel) {
                    innercomps = ((JPanel)comps[i]).getComponents();
                    for (int j = 0; j < innercomps.length; ++j) {
                        Action aa;
                        if (!(innercomps[i] instanceof AbstractButton) || !(aa = ((AbstractButton)innercomps[j]).getAction()).getClass().getName().equals(actionclass) && !aa.getClass().getSimpleName().equals(actionclass)) continue;
                        act = aa;
                        found = true;
                        break;
                    }
                }
                if (found) break;
            }
        }
        if (found) {
            act.setEnabled(enable);
        }
    }

    private class HMButton
    extends JButton {
        public HMButton(Action a) {
            super(a);
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            if (XpHoverMenuPanel.this.getLevel() <= 0) {
                XpHoverMenuPanel.this.displayLevel(0);
            }
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (XpHoverMenuPanel.this.getLevel() <= 0) {
                XpHoverMenuPanel.this.displayLevel(0);
            }
        }
    }

    private class HMRadioButton
    extends JRadioButton {
        public HMRadioButton(Action a) {
            super(a);
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            if (XpHoverMenuPanel.this.getLevel() <= 0) {
                XpHoverMenuPanel.this.displayLevel(0);
            }
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (XpHoverMenuPanel.this.getLevel() <= 0) {
                XpHoverMenuPanel.this.displayLevel(0);
            }
        }
    }

    private class HMToggleButton
    extends JToggleButton {
        public HMToggleButton(Action a) {
            super(a);
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            if (XpHoverMenuPanel.this.getLevel() <= 0) {
                XpHoverMenuPanel.this.displayLevel(0);
            }
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (XpHoverMenuPanel.this.getLevel() <= 0) {
                XpHoverMenuPanel.this.displayLevel(0);
            }
        }
    }

    public static enum ButtonType {
        DEFAULT,
        TOGGLE,
        RADIO;

    }
}

