/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.ToolManager;
import com.ge.med.idc.Capable;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class XpGridButtonPanel
extends JPanel
implements ActionListener,
PlasmaControl {
    private JPanel controlArea;
    private static JPanel controlArea_Copy = null;
    private JPanel controlPanel;
    private XPcaPanel selectedPanel = null;
    private CardLayout card = new CardLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    private Capable cap_ = null;
    int row = 0;
    int col = 0;
    int rowcount = 0;
    int colcount = 0;
    private HashMap panelmap = new HashMap();
    private static int ICON_WIDTH = 20;
    private static int ICON_HEIGHT = 20;
    private Insets inset = new Insets(0, 0, 0, 0);
    private int GRID_BEGIN_GAP = 25;
    private Properties properties = null;
    private static final Logger logger_ = Logger.getLogger(XpGridButtonPanel.class.getName());

    public XpGridButtonPanel(int rows, int columns) {
        super(new BorderLayout());
        this.jbinit(rows, columns);
    }

    private void jbinit(int rows, int columns) {
        this.controlPanel = new JPanel();
        this.controlArea = new JPanel();
        this.controlArea.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                Component comp = SwingUtilities.getRoot(XpGridButtonPanel.this.controlArea);
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
                Component comp = SwingUtilities.getRoot(XpGridButtonPanel.this.controlArea);
                if (null != comp) {
                    comp.revalidate();
                    comp.repaint();
                }
            }
        });
        this.controlArea.setLayout(this.card);
        this.rowcount = rows;
        this.colcount = columns;
        this.controlPanel.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        this.gbc.gridx = columns + 1;
        this.gbc.gridy = rows;
        this.gbc.weightx = 0.5;
        this.controlPanel.add((Component)panel, this.gbc);
        this.gbc.anchor = 18;
        this.controlArea.setVisible(false);
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.controlArea, "Center");
    }

    public void addControl(String classname) {
        Insets insets;
        Object o = null;
        JButton btn = null;
        if (this.col == this.colcount) {
            this.col = 0;
            ++this.row;
        }
        this.gbc.weightx = 0.0;
        if (this.row > this.rowcount) {
            return;
        }
        this.gbc.insets = this.col == 0 ? (insets = new Insets(this.inset.top, this.GRID_BEGIN_GAP, this.inset.bottom, this.inset.right)) : this.inset;
        this.gbc.gridx = this.col++;
        this.gbc.gridy = this.row;
        if (classname != null) {
            try {
                o = CvUtils.getClass(classname).newInstance();
                if (o instanceof AbstractAction) {
                    if (o instanceof BaseAction) {
                        Icon icon;
                        if (this.cap_ != null) {
                            ((BaseAction)o).setCapable(this.cap_);
                        }
                        if ((icon = (Icon)((Action)o).getValue("SmallIcon")) != null) {
                            ((BaseAction)o).putValue("SmallIcon", CvUtils.getScaledIcon(icon, ICON_WIDTH, ICON_HEIGHT));
                        }
                    }
                    btn = new JButton(o);
                    btn.setName(classname);
                    btn.addActionListener(this);
                    if (((Action)o).getValue("SmallIcon") != null) {
                        btn.setText("");
                    }
                } else if (o instanceof XPcaPanel) {
                    XPcaPanel xpcapanel = o;
                    if (this.properties != null) {
                        xpcapanel.setProperties(this.properties);
                    }
                    if (this.cap_ != null && this.cap_ instanceof XPscreen) {
                        xpcapanel.setScreen((XPscreen)this.cap_);
                    } else if (xpcapanel instanceof PlasmaControl && this.cap_ != null) {
                        ((PlasmaControl)((Object)xpcapanel)).setCapable(this.cap_);
                    }
                    Icon icon = xpcapanel.getIcon();
                    String text = xpcapanel.getName();
                    this.panelmap.put(xpcapanel.getClass().getName(), xpcapanel);
                    ImageIcon ic = null;
                    if (icon != null) {
                        ic = (ImageIcon)icon;
                    }
                    btn = icon != null ? new JButton(CvUtils.getScaledIcon(ic, ICON_WIDTH, ICON_HEIGHT)) : new JButton(text);
                    btn.setName(xpcapanel.getClass().getName());
                    btn.setToolTipText(xpcapanel.getTitle());
                    btn.addActionListener(this);
                    this.controlArea.add((Component)xpcapanel, btn.getName());
                } else if (o instanceof PlasmaControl) {
                    if (o instanceof JButton) {
                        btn = o;
                        btn.addActionListener(this);
                        if (this.cap_ != null) {
                            ((PlasmaControl)o).setCapable(this.cap_);
                        }
                    } else if (o instanceof JPanel) {
                        // empty if block
                    }
                } else {
                    logger_.log(Level.WARNING, "classname not recognized. This control won't be added to gridbuttonpanel.");
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                logger_.log(Level.WARNING, "class can not be initialized. This control won't be added to gridbuttonpanel, {0}", new Object[]{e});
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                logger_.log(Level.WARNING, "class can not be initialized. This control won't be added to gridbuttonpanel, {0}", new Object[]{e});
            }
            catch (Exception e) {
                e.printStackTrace();
                logger_.log(Level.WARNING, "class can not be initialized. This control won't be added to gridbuttonpanel, {0}", new Object[]{e});
            }
        }
        if (btn != null) {
            this.controlPanel.add(btn, this.gbc);
        }
    }

    public void addControl(String classname, int row, int col) {
        Insets insets;
        this.row = row++;
        this.col = col;
        Object o = null;
        JButton btn = null;
        if (col == this.colcount) {
            col = 0;
        }
        if (row > this.rowcount) {
            return;
        }
        this.gbc.insets = col == 0 ? (insets = new Insets(this.inset.top, this.GRID_BEGIN_GAP, this.inset.bottom, this.inset.right)) : this.inset;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = col++;
        this.gbc.gridy = row;
        if (classname != null) {
            try {
                o = CvUtils.getClass(classname).newInstance();
                if (o instanceof AbstractAction) {
                    if (o instanceof BaseAction) {
                        Icon icon;
                        if (this.cap_ != null) {
                            ((BaseAction)o).setCapable(this.cap_);
                        }
                        if ((icon = (Icon)((Action)o).getValue("SmallIcon")) != null) {
                            ((BaseAction)o).putValue("SmallIcon", CvUtils.getScaledIcon(icon, ICON_WIDTH, ICON_HEIGHT));
                        }
                    }
                    btn = new JButton(o);
                    btn.setName(classname);
                    btn.addActionListener(this);
                    if (((Action)o).getValue("SmallIcon") != null) {
                        btn.setText("");
                    }
                } else if (o instanceof XPcaPanel) {
                    XPcaPanel xpcapanel = o;
                    this.panelmap.put(xpcapanel.getClass().getName(), xpcapanel);
                    if (this.properties != null) {
                        xpcapanel.setProperties(this.properties);
                    }
                    if (this.cap_ != null && this.cap_ instanceof XPscreen) {
                        xpcapanel.setScreen((XPscreen)this.cap_);
                    } else if (xpcapanel instanceof PlasmaControl && this.cap_ != null) {
                        ((PlasmaControl)((Object)xpcapanel)).setCapable(this.cap_);
                    }
                    Icon icon = xpcapanel.getIcon();
                    String text = xpcapanel.getName();
                    ImageIcon ic = null;
                    if (icon != null) {
                        ic = (ImageIcon)icon;
                    }
                    btn = icon != null ? new JButton(CvUtils.getScaledIcon(ic, ICON_WIDTH, ICON_HEIGHT)) : new JButton(text);
                    btn.setName(xpcapanel.getClass().getName());
                    btn.setToolTipText(xpcapanel.getTitle());
                    btn.addActionListener(this);
                    ToolManager.getInstance().setAction(btn.getName(), xpcapanel);
                    this.controlArea.add((Component)xpcapanel, btn.getName());
                } else if (o instanceof PlasmaControl) {
                    if (o instanceof JButton) {
                        btn = o;
                        if (this.cap_ != null) {
                            ((PlasmaControl)o).setCapable(this.cap_);
                        }
                        btn.addActionListener(this);
                    } else if (o instanceof JPanel) {
                        // empty if block
                    }
                } else {
                    logger_.log(Level.WARNING, "classname not recognized. This control won't be added to gridbuttonpanel.");
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                logger_.log(Level.WARNING, "class can not be initialized. This control won't be added to gridbuttonpanel, {0}", new Object[]{e});
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                logger_.log(Level.WARNING, "class can not be initialized. This control won't be added to gridbuttonpanel, {0}", new Object[]{e});
            }
            catch (Exception e) {
                e.printStackTrace();
                logger_.log(Level.WARNING, "class can not be initialized. This control won't be added to gridbuttonpanel, {0}", new Object[]{e});
            }
        }
        if (btn != null) {
            this.controlPanel.add(btn, this.gbc);
        }
    }

    public void addControl(AbstractAction action) {
        Icon icon;
        Insets insets;
        if (this.col == this.colcount) {
            this.col = 0;
            ++this.row;
        }
        if (this.row > this.rowcount) {
            return;
        }
        this.gbc.insets = this.col == 0 ? (insets = new Insets(this.inset.top, this.GRID_BEGIN_GAP, this.inset.bottom, this.inset.right)) : this.inset;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = this.col++;
        this.gbc.gridy = this.row;
        if (this.cap_ != null) {
            ((BaseAction)action).setCapable(this.cap_);
        }
        if ((icon = (Icon)action.getValue("SmallIcon")) != null) {
            ((BaseAction)action).putValue("SmallIcon", CvUtils.getScaledIcon(icon, ICON_WIDTH, ICON_HEIGHT));
        }
        JButton btn = new JButton(action);
        btn.addActionListener(this);
        if (action.getValue("SmallIcon") != null) {
            btn.setText("");
        }
        this.controlPanel.add((Component)btn, this.gbc);
    }

    public void addControl(AbstractAction action, int row, int col) {
        Icon icon;
        Insets insets;
        this.row = row++;
        this.col = col;
        if (col == this.colcount) {
            col = 0;
        }
        if (row > this.rowcount) {
            return;
        }
        this.gbc.insets = col == 0 ? (insets = new Insets(this.inset.top, this.GRID_BEGIN_GAP, this.inset.bottom, this.inset.right)) : this.inset;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = col++;
        this.gbc.gridy = row;
        if (this.cap_ != null) {
            ((BaseAction)action).setCapable(this.cap_);
        }
        if ((icon = (Icon)action.getValue("SmallIcon")) != null) {
            ((BaseAction)action).putValue("SmallIcon", CvUtils.getScaledIcon(icon, ICON_WIDTH, ICON_HEIGHT));
        }
        JButton btn = new JButton(action);
        btn.addActionListener(this);
        if (action.getValue("SmallIcon") != null) {
            btn.setText("");
        }
        this.controlPanel.add((Component)btn, this.gbc);
    }

    public void addControl(XPcaPanel xpcapanel) {
        Insets insets;
        if (this.col == this.colcount) {
            this.col = 0;
            ++this.row;
        }
        if (this.row > this.rowcount) {
            return;
        }
        this.gbc.insets = this.col == 0 ? (insets = new Insets(this.inset.top, this.GRID_BEGIN_GAP, this.inset.bottom, this.inset.right)) : this.inset;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = this.col++;
        this.gbc.gridy = this.row;
        Icon ico = xpcapanel.getIcon();
        if (this.cap_ != null && this.cap_ instanceof XPscreen) {
            xpcapanel.setScreen((XPscreen)this.cap_);
        } else if (xpcapanel instanceof PlasmaControl && this.cap_ != null) {
            ((PlasmaControl)((Object)xpcapanel)).setCapable(this.cap_);
        }
        if (this.properties != null) {
            xpcapanel.setProperties(this.properties);
        }
        this.panelmap.put(xpcapanel.getClass().getName(), xpcapanel);
        String text = xpcapanel.getName();
        Icon icon = xpcapanel.getIcon();
        Object icon1 = null;
        ImageIcon ic = null;
        if (icon != null) {
            ic = (ImageIcon)icon;
        }
        JButton btn = ico != null ? new JButton(CvUtils.getScaledIcon(ic, ICON_WIDTH, ICON_HEIGHT)) : new JButton(text);
        btn.setName(xpcapanel.getClass().getName());
        btn.setToolTipText(xpcapanel.getTitle());
        btn.addActionListener(this);
        this.controlArea.add((Component)xpcapanel, btn.getName());
        this.controlPanel.add((Component)btn, this.gbc);
    }

    public void addControl(XPcaPanel xpcapanel, int row, int col) {
        Icon icon;
        Insets insets;
        this.row = row++;
        this.col = col;
        if (col == this.colcount) {
            col = 0;
        }
        if (row > this.rowcount) {
            return;
        }
        this.gbc.insets = col == 0 ? (insets = new Insets(this.inset.top, this.GRID_BEGIN_GAP, this.inset.bottom, this.inset.right)) : this.inset;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = col++;
        this.gbc.gridy = row;
        ImageIcon ic = null;
        Icon ico = xpcapanel.getIcon();
        if (this.cap_ != null && this.cap_ instanceof XPscreen) {
            xpcapanel.setScreen((XPscreen)this.cap_);
        } else if (xpcapanel instanceof PlasmaControl && this.cap_ != null) {
            ((PlasmaControl)((Object)xpcapanel)).setCapable(this.cap_);
        }
        if (this.properties != null) {
            xpcapanel.setProperties(this.properties);
        }
        if ((icon = xpcapanel.getIcon()) != null) {
            ic = (ImageIcon)icon;
        }
        this.panelmap.put(xpcapanel.getClass().getName(), xpcapanel);
        String text = xpcapanel.getName();
        JButton btn = ic != null ? new JButton(CvUtils.getScaledIcon(ic, ICON_WIDTH, ICON_HEIGHT)) : new JButton(text);
        btn.setName(xpcapanel.getClass().getName());
        btn.setToolTipText(xpcapanel.getTitle());
        btn.addActionListener(this);
        this.controlArea.add((Component)xpcapanel, btn.getName());
        this.controlPanel.add((Component)btn, this.gbc);
    }

    public void addControl(JButton button, int row, int col) {
        Insets insets;
        this.row = row++;
        this.col = col;
        if (col == this.colcount) {
            col = 0;
        }
        if (row > this.rowcount) {
            return;
        }
        this.gbc.insets = col == 0 ? (insets = new Insets(this.inset.top, this.GRID_BEGIN_GAP, this.inset.bottom, this.inset.right)) : this.inset;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = col++;
        this.gbc.gridy = row;
        Icon icon = button.getIcon();
        if (null != icon) {
            button.setIcon(CvUtils.getScaledIcon(icon, ICON_WIDTH, ICON_HEIGHT));
        }
        if (button != null) {
            button.addActionListener(this);
            if (button instanceof PlasmaControl && this.cap_ != null) {
                ((PlasmaControl)((Object)button)).setCapable(this.cap_);
            }
            this.controlPanel.add((Component)button, this.gbc);
        }
    }

    public void addControl(JButton button) {
        Insets insets;
        if (this.col == this.colcount) {
            this.col = 0;
            ++this.row;
        }
        if (this.row > this.rowcount) {
            return;
        }
        this.gbc.insets = this.col == 0 ? (insets = new Insets(this.inset.top, this.GRID_BEGIN_GAP, this.inset.bottom, this.inset.right)) : this.inset;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = this.col++;
        this.gbc.gridy = this.row;
        if (button != null) {
            button.addActionListener(this);
            if (button instanceof PlasmaControl && this.cap_ != null) {
                ((PlasmaControl)((Object)button)).setCapable(this.cap_);
            }
            this.controlPanel.add((Component)button, this.gbc);
        }
    }

    public void setEnabled(boolean enabled, int row, int col) {
        Component[] components = this.controlPanel.getComponents();
        GridBagLayout layout = (GridBagLayout)this.controlPanel.getLayout();
        for (int i = 0; i < components.length; ++i) {
            GridBagConstraints constraints = layout.getConstraints(components[i]);
            if (constraints.gridx != col || constraints.gridy != row) continue;
            components[i].setEnabled(enabled);
        }
    }

    public Component getControl(int row, int col) {
        Component[] components = this.controlPanel.getComponents();
        GridBagLayout layout = (GridBagLayout)this.controlPanel.getLayout();
        for (int i = 0; i < components.length; ++i) {
            GridBagConstraints constraints = layout.getConstraints(components[i]);
            if (constraints.gridx != col || constraints.gridy != row) continue;
            return components[i];
        }
        return null;
    }

    public Component getControl(String controlName) {
        Component[] components = this.controlPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            String componentName;
            if (!(components[i] instanceof JButton) || (componentName = components[i].getName()) == null || !componentName.contains(controlName)) continue;
            return components[i];
        }
        return null;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag && this.selectedPanel != null) {
            this.controlArea.setVisible(aFlag);
        }
    }

    @Override
    public void setCapable(Capable cap) {
        if (cap != null) {
            this.cap_ = cap;
            Component[] components = this.controlPanel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                Component comp = components[i];
                if (!(comp instanceof JButton)) continue;
                JButton controlbutton = (JButton)comp;
                Action action = controlbutton.getAction();
                if (controlbutton instanceof PlasmaControl) {
                    ((PlasmaControl)((Object)controlbutton)).setCapable(this.cap_);
                    continue;
                }
                if (action instanceof PlasmaControl) {
                    ((PlasmaControl)((Object)action)).setCapable(cap);
                    continue;
                }
                XPcaPanel panel = null;
                String classname = controlbutton.getName();
                if (classname == null || (panel = (XPcaPanel)this.panelmap.get(classname)) == null) continue;
                if (this.cap_ instanceof XPscreen) {
                    panel.setScreen((XPscreen)this.cap_);
                    continue;
                }
                if (!(panel instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)panel)).setCapable(this.cap_);
            }
        } else {
            logger_.log(Level.SEVERE, "The given capable is null");
        }
    }

    public Capable getCapable() {
        return this.cap_;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JButton) {
            JButton gridbutton = (JButton)event.getSource();
            if (gridbutton.getAction() != null) {
                this.selectedPanel = null;
                this.controlArea.setVisible(false);
            } else {
                if (this.selectedPanel != null) {
                    this.selectedPanel.panelStop();
                }
                XPcaPanel panel = null;
                String classname = ((JButton)event.getSource()).getName();
                if (classname != null) {
                    panel = (XPcaPanel)this.panelmap.get(classname);
                }
                if (panel != null) {
                    this.selectedPanel = panel;
                    this.selectedPanel.panelStart();
                    this.card.show(this.controlArea, ((JButton)event.getSource()).getName());
                    this.controlArea.setBorder(BorderFactory.createTitledBorder(panel.getTitle()));
                    this.controlArea.setVisible(true);
                    controlArea_Copy = this.controlArea;
                } else {
                    this.controlArea.setVisible(false);
                }
            }
        }
    }

    public static void exitPanel() {
        controlArea_Copy.setVisible(false);
    }

    public void setProperties(Properties prop) {
        this.properties = prop;
        Component[] components = this.controlPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (!(comp instanceof JButton)) continue;
            JButton controlbutton = (JButton)comp;
            XPcaPanel panel = null;
            String classname = controlbutton.getName();
            if (classname == null || (panel = (XPcaPanel)this.panelmap.get(classname)) == null) continue;
            panel.setProperties(prop);
        }
    }

    public void setGridGaps(int top, int left, int bottom, int right) {
        this.inset = new Insets(top, left, bottom, right);
    }

    public void setGapBeforeFirstButton(int left) {
        this.GRID_BEGIN_GAP = left;
    }

    public void setButtonSize(int width, int height) {
        ICON_WIDTH = width;
        ICON_HEIGHT = height;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public void updateColOnRemove(int compCount) {
        this.col = compCount - 1;
    }
}

