/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.terra.xpv.base.PlasmaControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public class XpComboButton
extends JButton
implements PlasmaControl,
MouseListener,
ActionListener {
    private JButton arrowButton = null;
    private JPopupMenu popup = null;
    private Vector<Action> actionList = new Vector();
    protected JMenuItem[] popupItems = null;
    protected Border emptyBorder = BorderFactory.createEmptyBorder();
    protected Border raisedBorder = BorderFactory.createBevelBorder(0);
    private static final String buttonColor = "PopupIcon.color";
    private static final String buttonDisabledColor = "PopupDisabledIcon.color";
    boolean isMouseIn = false;
    ClearPropertyTrigger alT = new ClearPropertyTrigger();

    public XpComboButton() {
        this.initUI();
    }

    public XpComboButton(Action[] actions) {
        this.initUI();
        this.setActions(actions);
    }

    public void setActions(Action[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            this.actionList.add(actions[i]);
        }
        Action action = this.actionList.get(0);
        this.setName(this.actionList.get(0).getClass().getName());
        if (action.getValue("showActionText") != null) {
            if (action.getValue("Name") != null) {
                this.putClientProperty("hideActionText", Boolean.FALSE);
            }
        }
        this.setAction(this.actionList.get(0));
        this.actionList.trimToSize();
        if (this.actionList.size() > 1) {
            this.popupItems = new JMenuItem[this.actionList.size()];
            for (int i = 0; i < this.popupItems.length; ++i) {
                this.popupItems[i] = new JMenuItem(){

                    @Override
                    public String getText() {
                        Action act = this.getAction();
                        if (act != null) {
                            if (act.getValue("showActionText") != null) {
                                if (act.getValue("Name") != null) {
                                    return (String)act.getValue("Name");
                                }
                            }
                            return null;
                        }
                        return this.getClientProperty("hideActionText") == Boolean.TRUE ? null : super.getText();
                    }
                };
                this.popupItems[i].putClientProperty("hideActionText", Boolean.TRUE);
            }
            this.configurePopup();
        }
    }

    protected void initUI() {
        this.setText(null);
        this.arrowButton = new JButton(new DownArrowIcon());
        this.arrowButton.setName("XpArrowBtn");
        this.putClientProperty("hideActionText", Boolean.TRUE);
        this.setFocusable(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setIconTextGap(0);
        this.arrowButton.setBorder(this.emptyBorder);
        this.arrowButton.setFocusable(false);
        this.arrowButton.addMouseListener(this);
        this.arrowButton.addActionListener(this);
        this.arrowButton.setPreferredSize(new Dimension(11, 20));
        this.popup = new JPopupMenu();
        this.popup.setName("XpComboPopUp");
        this.addMouseListener(this);
        this.setLayout(new LayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                XpComboButton.this.arrowButton.setPreferredSize(new Dimension(11, XpComboButton.this.getHeight() - 3));
                Dimension arrowPrefSize = XpComboButton.this.arrowButton.getPreferredSize();
                XpComboButton.this.arrowButton.setBounds(parent.getWidth() - arrowPrefSize.width - 1, parent.getHeight() - arrowPrefSize.height - 1, arrowPrefSize.width, arrowPrefSize.height);
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(0, 0);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, 0);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        });
        this.add(this.arrowButton);
    }

    protected void configurePopup() {
        this.popup.removeAll();
        Color popupBackground = LookAndFeelFactory.getColor("popupBackground.color", null);
        if (popupBackground != null) {
            this.popup.setBackground(popupBackground);
        }
        int i = 0;
        int j = 0;
        while (i < this.actionList.size()) {
            if (!this.actionList.get(i).equals(this.getAction())) {
                this.popupItems[j].setAction(this.actionList.get(i));
                this.popupItems[j].setName(this.actionList.get(i).getClass().getName());
                this.popupItems[j].removeActionListener(this);
                this.popupItems[j].addActionListener(this);
                this.popupItems[j].removeActionListener(this.alT);
                this.popupItems[j].addActionListener(this.alT);
                this.popup.add(this.popupItems[j]);
            } else {
                this.setName(this.actionList.get(i).getClass().getName());
            }
            ++i;
            ++j;
        }
    }

    public void setPopUpMenu(JPopupMenu menu) {
        this.popup = menu;
    }

    public JPopupMenu getPopUpMenu() {
        return this.popup;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isMouseIn && this.isEnabled()) {
            Graphics2D g2 = (Graphics2D)g;
            Color beforePaint = g2.getColor();
            Color lineColor = LookAndFeelFactory.getColor(buttonColor, null);
            if (null != lineColor) {
                g2.setColor(lineColor);
            }
            Rectangle arrowDim = this.arrowButton.getBounds();
            Boolean comboSplit = CvPropertiesManager.getBoolean("cvf.combosplit", true);
            if (comboSplit.booleanValue()) {
                g2.drawLine(arrowDim.x, arrowDim.y, arrowDim.x, arrowDim.y + arrowDim.height);
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.arrowButton.setEnabled(b);
        for (Action act : this.actionList) {
            act.setEnabled(b);
        }
    }

    @Override
    public void setCapable(Capable Capable2) {
        for (Action act : this.actionList) {
            if (!(act instanceof PlasmaControl)) continue;
            ((PlasmaControl)((Object)act)).setCapable(Capable2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.arrowButton)) {
            if (!this.popup.isShowing()) {
                this.popup.show(this.arrowButton, 0, this.arrowButton.getHeight());
            }
        } else if (e.getSource() instanceof JMenuItem) {
            Action toSet = ((JMenuItem)e.getSource()).getAction();
            if (toSet.getValue("changeOnSelection") == "no") {
                return;
            }
            this.setAction(toSet);
            this.configurePopup();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isMouseIn = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isMouseIn = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    protected static class DownArrowIcon
    implements Icon {
        static final int size = 6;

        protected DownArrowIcon() {
        }

        @Override
        public int getIconHeight() {
            return 6;
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Color iconEnabledColor = LookAndFeelFactory.getColor(XpComboButton.buttonColor, null);
            Color iconDisabledColor = LookAndFeelFactory.getColor(XpComboButton.buttonDisabledColor, null);
            if (null != iconEnabledColor && null != iconDisabledColor) {
                g2.setColor(c.isEnabled() ? iconEnabledColor : iconDisabledColor);
            }
            int[] xPoints = new int[]{x, x + 6, x + 3};
            int[] yPoints = new int[]{y, y, y + 3};
            g2.drawPolygon(xPoints, yPoints, 3);
            g2.fillPolygon(xPoints, yPoints, 3);
        }
    }

    private class ClearPropertyTrigger
    implements ActionListener {
        private ClearPropertyTrigger() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XpComboButton.this.firePropertyChange("ClearPanel", false, true);
        }
    }
}

