/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.xpv.base.PlasmaControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class XpCollapsablePanel
extends JPanel
implements PlasmaControl {
    private static boolean ICON_CLICK_ONLY = true;
    private JLabel ghiconLabel = new JLabel();
    private JLabel gheaderLabel = new JLabel();
    private Icon expandedicon = CvUtils.getIcon("XP_DOWN_ARROW_SMALL_ICON");
    private Icon collapsedicon = CvUtils.getIcon("XP_RIGHT_ARROW_SMALL_ICON");
    private String title = "";
    private Font titleFont;
    public static final String COLLAPSABLE_STATE_CHANGE = "collapsable_state_change";
    private JPanel groupControlPanel;
    private GroupHeaderPanel groupHeaderPanel;
    private Capable cap = null;

    public XpCollapsablePanel() {
        this("", null, null, null);
    }

    public XpCollapsablePanel(JPanel panel, Icon openicon, Icon closedicon) {
        this("", panel, openicon, closedicon);
    }

    public XpCollapsablePanel(String text, JPanel panel, Icon openicon, Icon closedicon) {
        super(new BorderLayout());
        this.groupHeaderPanel = new GroupHeaderPanel(text, openicon, closedicon);
        this.groupControlPanel = panel;
        if (this.cap != null && this.groupControlPanel != null && this.groupControlPanel instanceof PlasmaControl) {
            ((PlasmaControl)((Object)this.groupControlPanel)).setCapable(this.cap);
        }
        this.add((Component)this.groupHeaderPanel, "North");
        this.add((Component)this.groupControlPanel, "Center");
        this.setCollapsed(true);
    }

    public XpCollapsablePanel(String text, JPanel panel, Icon openicon, Icon closedicon, boolean iconClickEnabled) {
        super(new BorderLayout());
        ICON_CLICK_ONLY = iconClickEnabled;
        this.groupHeaderPanel = new GroupHeaderPanel(text, openicon, closedicon);
        this.groupControlPanel = panel;
        if (this.cap != null && this.groupControlPanel != null && this.groupControlPanel instanceof PlasmaControl) {
            ((PlasmaControl)((Object)this.groupControlPanel)).setCapable(this.cap);
        }
        this.add((Component)this.groupHeaderPanel, "North");
        this.add((Component)this.groupControlPanel, "Center");
        this.setCollapsed(true);
    }

    public void seHeaderBackground(Color bg) {
        if (this.groupHeaderPanel != null) {
            this.groupHeaderPanel.setBackground(bg);
        }
    }

    public void setPanelBackground(Color bg) {
        if (this.groupControlPanel != null) {
            this.groupControlPanel.setBackground(bg);
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.gheaderLabel.setText(title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.gheaderLabel.setFont(font);
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setOpenCloseIcon(Icon openicon, Icon closeicon) {
        this.expandedicon = openicon;
        this.collapsedicon = closeicon;
    }

    public Icon getOpenIcon() {
        return this.expandedicon;
    }

    public Icon getCloseIcon() {
        return this.collapsedicon;
    }

    public void setCollapsed(boolean collapse) {
        boolean old = this.isCollapsed();
        this.firePropertyChange(COLLAPSABLE_STATE_CHANGE, old, collapse);
        this.groupControlPanel.setVisible(!collapse);
        this.groupHeaderPanel.setIcon(!collapse);
        this.revalidate();
        this.repaint();
    }

    public boolean isCollapsed() {
        return !this.groupControlPanel.isShowing();
    }

    @Override
    public void setCapable(Capable c) {
        this.cap = c;
        if (this.cap != null && this.groupControlPanel != null && this.groupControlPanel instanceof PlasmaControl) {
            ((PlasmaControl)((Object)this.groupControlPanel)).setCapable(this.cap);
        }
    }

    public void setHeaderHeight(int height) {
        this.groupHeaderPanel.setPreferredSize(new Dimension(this.groupHeaderPanel.getWidth(), height));
        this.groupHeaderPanel.setMinimumSize(new Dimension(this.groupHeaderPanel.getWidth(), height));
    }

    public int getHeaderHeight() {
        return this.groupHeaderPanel.getHeight();
    }

    public JPanel getControlPanel() {
        return this.groupControlPanel;
    }

    protected class GroupHeaderPanel
    extends JPanel
    implements MouseListener {
        public GroupHeaderPanel(String text, Icon openicon, Icon closedicon) {
            XpCollapsablePanel.this.title = text;
            if (openicon != null) {
                XpCollapsablePanel.this.expandedicon = (ImageIcon)openicon;
            }
            if (closedicon != null) {
                XpCollapsablePanel.this.collapsedicon = (ImageIcon)closedicon;
            }
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout(10, 0));
            this.add((Component)XpCollapsablePanel.this.ghiconLabel, "West");
            this.add((Component)XpCollapsablePanel.this.gheaderLabel, "Center");
            XpCollapsablePanel.this.ghiconLabel.setIcon(XpCollapsablePanel.this.collapsedicon);
            XpCollapsablePanel.this.gheaderLabel.setText(XpCollapsablePanel.this.title);
            if (ICON_CLICK_ONLY) {
                XpCollapsablePanel.this.ghiconLabel.addMouseListener(this);
            } else {
                this.addMouseListener(this);
            }
        }

        public void setIcon(boolean iscollapsed) {
            if (iscollapsed) {
                XpCollapsablePanel.this.ghiconLabel.setIcon(XpCollapsablePanel.this.collapsedicon);
            } else {
                XpCollapsablePanel.this.ghiconLabel.setIcon(XpCollapsablePanel.this.expandedicon);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            XpCollapsablePanel.this.setCollapsed(!XpCollapsablePanel.this.isCollapsed());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

