/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.laf.RowColumnListUI;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.xpv.base.PlasmaControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class RowColFormatToggleButton
extends JToggleButton
implements PlasmaControl,
MouseMotionListener,
MouseListener,
PropertyChangeListener,
Replicable {
    private static final long serialVersionUID = 1000000000L;
    protected JPopupMenu popup = new JPopupMenu();
    protected JList list = new JList();
    protected JLabel infoLabel = new JLabel();
    protected JPanel labelPanel = new JPanel();
    protected JPanel leftPanel = new JPanel();
    protected Border labelBorder = BorderFactory.createLineBorder(LookAndFeelFactory.getColor("ListUI.color", "P9"));
    protected RowColumnListUI.ListDataModel model;
    protected Capable cap_;
    boolean paintRowCols = CvPropertiesManager.getBoolean("RowColFormatButton.paintRowCols", false);
    public String label;

    public RowColFormatToggleButton() {
        this(8, 8);
    }

    public RowColFormatToggleButton(int row, int col) {
        this.setFocusable(false);
        this.setIcon(new RowColIcon());
        this.model = new RowColumnListUI.ListDataModel(new Dimension(row, col));
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                int row = RowColFormatToggleButton.this.model.getSelected().height;
                int col = RowColFormatToggleButton.this.model.getSelected().width;
                String label = row + "x" + col;
                RowColFormatToggleButton.this.infoLabel.setText(label);
                RowColFormatToggleButton.this.setToolTipText(RowColFormatToggleButton.this.infoLabel.getText());
            }
        });
        this.list.setModel(this.model);
        this.list.setUI(new RowColumnListUI());
        this.list.addMouseMotionListener(this);
        this.list.addMouseListener(this);
        this.list.setName(RowColFormatToggleButton.class.getName() + "list");
        this.infoLabel.setName(RowColFormatToggleButton.class.getName() + "InfoLabel");
        this.leftPanel.setPreferredSize(new Dimension(25, 15));
        this.leftPanel.setName(RowColFormatToggleButton.class.getName() + "leftPanel");
        this.labelPanel.setLayout(new BorderLayout());
        this.labelPanel.add((Component)this.leftPanel, "West");
        this.labelPanel.add((Component)this.infoLabel, "Center");
        this.labelPanel.setBorder(this.labelBorder);
        this.labelPanel.setPreferredSize(new Dimension(40, 25));
        this.labelPanel.setName(RowColFormatToggleButton.class.getName() + "labelPanel");
        this.popup.add(this.list);
        JSeparator separator = new JSeparator();
        separator.setForeground(LookAndFeelFactory.getColor("SEPARATOR_COLOR", "P9"));
        this.popup.add(separator);
        this.popup.add(this.labelPanel);
        this.popup.setName("FormatSelector");
        this.setName(this.getClass().getName());
        this.model.setSelected(new Dimension(2, 2));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RowColFormatToggleButton.this.popup.isVisible()) {
                    RowColFormatToggleButton.this.popup.show((Component)e.getSource(), 0, RowColFormatToggleButton.this.getBounds().height);
                }
            }
        });
        this.popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!RowColFormatToggleButton.this.popup.isVisible()) {
                    RowColFormatToggleButton.this.processRowColRequest();
                }
            }
        });
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int index = this.list.locationToIndex(e.getPoint());
        Dimension dim = (Dimension)this.model.getElementAt(index);
        Dimension sel = this.model.getSelected();
        if (Double.compare(dim.getWidth(), sel.getWidth()) != 0 || Double.compare(dim.getHeight(), sel.getHeight()) != 0) {
            this.model.setSelected(dim);
        }
        this.list.repaint();
        this.repaint();
    }

    public int getRow() {
        return this.model.getSelected().height;
    }

    public int getCol() {
        return this.model.getSelected().width;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int index = this.list.locationToIndex(e.getPoint());
        Dimension dim = (Dimension)this.model.getElementAt(index);
        Dimension sel = this.model.getSelected();
        if (Double.compare(dim.getWidth(), sel.getWidth()) != 0 || Double.compare(dim.getHeight(), sel.getHeight()) != 0) {
            this.model.setSelected(dim);
        }
        this.list.repaint();
        this.repaint();
    }

    @Override
    public void setCapable(Capable s) {
        this.cap_ = s;
        RowColCapable rowColCap = this.getRowColCapable();
        this.model.setSelected(new Dimension(rowColCap.getRows(), rowColCap.getCols()));
        s.removePropertyChangeListener("RowColumnProperty", this);
        s.addPropertyChangeListener("RowColumnProperty", this);
        s.removePropertyChangeListener("ComponentSelection", this);
        s.addPropertyChangeListener("ComponentSelection", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        RowColCapable rowColCap = this.getRowColCapable();
        int rows = rowColCap.getRows();
        int cols = rowColCap.getCols();
        this.model.setSelected(new Dimension(cols, rows));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.popup.setVisible(false);
        this.repaint();
    }

    protected void processRowColRequest() {
        if (!this.popup.isVisible() && this.cap_ != null) {
            Dimension sel = this.model.getSelected();
            RowColCapable rowColCap = this.getRowColCapable();
            rowColCap.setRowCol((int)sel.getHeight(), (int)sel.getWidth());
            rowColCap.repaint();
        }
        this.repaint();
    }

    public RowColCapable getRowColCapable() {
        return this.cap_ != null ? (RowColCapable)this.cap_.getCapable(RowColCapable.class.getName()) : null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    public Dimension getDimension() {
        return this.model.getSelected();
    }

    @Override
    public Object clone() {
        RowColFormatToggleButton rcfb = new RowColFormatToggleButton();
        rcfb.setCapable(this.cap_);
        return rcfb;
    }

    private class RowColIcon
    implements Icon {
        static final int size = 21;
        Dimension dim = new Dimension(2, 2);

        private RowColIcon() {
        }

        @Override
        public int getIconHeight() {
            return 21;
        }

        @Override
        public int getIconWidth() {
            return 21;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int i;
            g.setColor(Color.GRAY.darker());
            g.fillRect(x, y, 21, 21);
            g.setColor(Color.white);
            g.drawRect(x, y, 21, 21);
            if (RowColFormatToggleButton.this.paintRowCols) {
                this.dim = RowColFormatToggleButton.this.getDimension();
            }
            for (i = 0; i < this.dim.width - 1; ++i) {
                g.drawLine((i + 1) * 21 / this.dim.width + x, y, (i + 1) * 21 / this.dim.width + x, y + 21 - 1);
            }
            for (i = 0; i < this.dim.height - 1; ++i) {
                g.drawLine(x, y + (i + 1) * 21 / this.dim.height, x + 21 - 1, y + (i + 1) * 21 / this.dim.height);
            }
        }
    }
}

