/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.laf.RowColumnListUI;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.xpv.base.PlasmaControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class RowColFormatButton
extends JButton
implements PlasmaControl,
MouseMotionListener,
MouseListener,
PropertyChangeListener,
Replicable {
    private static final long serialVersionUID = 1000000000L;
    JPopupMenu popup = new JPopupMenu();
    protected JList list = new JList();
    protected JLabel infoLabel = new JLabel();
    JPanel labelPanel = new JPanel();
    JPanel leftPanel = new JPanel();
    Border labelBorder = BorderFactory.createLineBorder(LookAndFeelFactory.getColor("ListUI.color", "P9"));
    protected RowColumnListUI.ListDataModel model;
    Capable cap_;
    boolean paintRowCols = CvPropertiesManager.getBoolean("RowColFormatButton.paintRowCols", false);
    private String XP_SPLIT_SERIES_TOOLTIP = CvUtils.getResourceBundle().getString("XP_SPLIT_SERIES_TOOLTIP");

    public RowColFormatButton() {
        this(5, 5);
    }

    public RowColFormatButton(int row, int col) {
        this.setFocusable(false);
        this.setIcon(new RowColIcon());
        this.model = new RowColumnListUI.ListDataModel(new Dimension(row, col));
        this.list.setModel(this.model);
        this.list.setUI(new RowColumnListUI());
        this.list.addMouseMotionListener(this);
        this.list.addMouseListener(this);
        this.list.setName(RowColFormatButton.class.getName() + "list");
        this.infoLabel.setName(this.XP_SPLIT_SERIES_TOOLTIP);
        if ("".equals(this.infoLabel.getText())) {
            this.setToolTipText(this.XP_SPLIT_SERIES_TOOLTIP);
        }
        this.infoLabel.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RowColFormatButton.this.setToolTipText(RowColFormatButton.this.XP_SPLIT_SERIES_TOOLTIP + " : " + RowColFormatButton.this.infoLabel.getText());
            }
        });
        this.leftPanel.setPreferredSize(new Dimension(25, 15));
        this.leftPanel.setName(RowColFormatButton.class.getName() + "leftPanel");
        this.labelPanel.setLayout(new BorderLayout());
        this.labelPanel.add((Component)this.leftPanel, "West");
        this.labelPanel.add((Component)this.infoLabel, "Center");
        this.labelPanel.setBorder(this.labelBorder);
        this.labelPanel.setPreferredSize(new Dimension(40, 25));
        this.labelPanel.setName(RowColFormatButton.class.getName() + "labelPanel");
        this.labelPanel.setToolTipText(this.XP_SPLIT_SERIES_TOOLTIP);
        this.popup.add(this.list);
        JSeparator separator = new JSeparator();
        separator.setForeground(LookAndFeelFactory.getColor("SEPARATOR_COLOR", "P9"));
        this.popup.add(separator);
        this.popup.add(this.labelPanel);
        this.popup.setName("FormalSelector");
        this.setName(this.getClass().getName());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RowColFormatButton.this.popup.isVisible()) {
                    RowColFormatButton.this.popup.show((Component)e.getSource(), 0, RowColFormatButton.this.getBounds().height);
                }
            }
        });
        this.popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!RowColFormatButton.this.popup.isVisible()) {
                    RowColFormatButton.this.processRowColRequest();
                }
            }
        });
    }

    @Override
    public void setCapable(Capable s) {
        this.cap_ = s;
        RowColCapable rowColCap = this.getRowColCapable();
        this.model.setSelected(new Dimension(rowColCap.getRows(), rowColCap.getCols()));
        this.setToolTipText(this.XP_SPLIT_SERIES_TOOLTIP + " : " + rowColCap.getRows() + "X" + rowColCap.getCols());
        s.removePropertyChangeListener("RowColumnProperty", this);
        s.addPropertyChangeListener("RowColumnProperty", this);
        s.removePropertyChangeListener("ComponentSelection", this);
        s.addPropertyChangeListener("ComponentSelection", this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int index = this.list.locationToIndex(e.getPoint());
        Dimension dim = (Dimension)((RowColumnListUI.ListDataModel)this.list.getModel()).getElementAt(index);
        Dimension sel = ((RowColumnListUI.ListDataModel)this.list.getModel()).getSelected();
        int col = (int)sel.getWidth();
        int row = (int)sel.getHeight();
        String label = row + "x" + col;
        this.infoLabel.setText(label);
        if (dim.getWidth() != sel.getWidth() || dim.getHeight() != sel.getHeight()) {
            ((RowColumnListUI.ListDataModel)this.list.getModel()).setSelected(dim);
        }
        this.list.repaint();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.popup.setVisible(false);
        this.repaint();
    }

    protected void processRowColRequest() {
        if (!this.popup.isVisible()) {
            Dimension sel = this.model.getSelected();
            RowColCapable rowColCap = this.getRowColCapable();
            rowColCap.setRowCol((int)sel.getHeight(), (int)sel.getWidth());
            rowColCap.repaint();
        }
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        RowColCapable rowColCap = this.getRowColCapable();
        int rows = rowColCap.getRows();
        int cols = rowColCap.getCols();
        this.infoLabel.setText(rows + "X" + cols);
        this.model.setSelected(new Dimension(cols, rows));
    }

    public RowColCapable getRowColCapable() {
        return (RowColCapable)this.cap_.getCapable(RowColCapable.class.getName());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public Dimension getDimension() {
        return this.model.getSelected();
    }

    @Override
    public Object clone() {
        RowColFormatButton rcfb = new RowColFormatButton();
        rcfb.setCapable(this.cap_);
        return rcfb;
    }

    private class RowColIcon
    implements Icon {
        static final int size = 20;
        Dimension dim = new Dimension(2, 2);

        private RowColIcon() {
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int i;
            g.setColor(Color.GRAY.darker());
            g.fillRect(x, y, 20, 20);
            g.setColor(Color.white);
            g.drawRect(x, y, 20, 20);
            if (RowColFormatButton.this.paintRowCols) {
                this.dim = RowColFormatButton.this.getDimension();
            }
            for (i = 0; i < this.dim.width - 1; ++i) {
                g.drawLine((i + 1) * 20 / this.dim.width + x, y, (i + 1) * 20 / this.dim.width + x, y + 20 - 1);
            }
            for (i = 0; i < this.dim.height - 1; ++i) {
                g.drawLine(x, y + (i + 1) * 20 / this.dim.height, x + 20 - 1, y + (i + 1) * 20 / this.dim.height);
            }
        }
    }
}

