/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class ProcessingLineBorder
extends AbstractBorder {
    private Color darkGray = new Color(127, 127, 127);
    private Color lightGray = new Color(192, 192, 192);
    private int thickness = 2;

    public ProcessingLineBorder() {
    }

    public ProcessingLineBorder(int thick) {
        this.thickness = thick;
    }

    public void setThickness(int thick) {
        this.thickness = thick;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int i;
        int[] xpts = new int[4];
        int[] ypts = new int[4];
        boolean smoothRightTopEdge = false;
        boolean smoothLeftBottomEdge = false;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.lightGray);
        g2.fillRect(x, y, width, this.thickness);
        g2.setColor(this.darkGray);
        for (i = x + this.thickness; i <= x + width; i += 8 * this.thickness) {
            xpts[0] = i;
            if (i == x + width) {
                smoothRightTopEdge = true;
                xpts[1] = i;
            } else {
                xpts[1] = i + 4 * this.thickness;
            }
            xpts[2] = i;
            xpts[3] = i - 4 * this.thickness;
            ypts[0] = ypts[1] = y;
            ypts[2] = ypts[3] = y + this.thickness;
            g2.fillPolygon(xpts, ypts, 4);
        }
        g2.setColor(this.lightGray);
        g2.fillRect(x, y + this.thickness, this.thickness, height - this.thickness);
        g2.setColor(this.darkGray);
        for (i = y + this.thickness; i <= y + height; i += 8 * this.thickness) {
            xpts[0] = x;
            xpts[1] = x + this.thickness;
            xpts[2] = x + this.thickness;
            xpts[3] = x;
            ypts[0] = i;
            ypts[1] = i - 4 * this.thickness;
            ypts[2] = ypts[0];
            if (i == y + height) {
                smoothLeftBottomEdge = true;
                ypts[3] = i;
            } else {
                ypts[3] = i + 4 * this.thickness;
            }
            g2.fillPolygon(xpts, ypts, 4);
        }
        g2.setColor(this.lightGray);
        g2.fillRect(x + width - this.thickness, y + this.thickness, this.thickness, height - this.thickness);
        g2.setColor(this.darkGray);
        for (i = smoothRightTopEdge ? y + this.thickness : y + 7 * this.thickness; i <= y + height; i += 8 * this.thickness) {
            xpts[0] = x + width - this.thickness;
            xpts[1] = x + width;
            xpts[2] = x + width;
            xpts[3] = x + width - this.thickness;
            ypts[0] = i;
            ypts[1] = i - 4 * this.thickness;
            ypts[2] = i;
            ypts[3] = i == y + height ? i : i + 4 * this.thickness;
            g2.fillPolygon(xpts, ypts, 4);
        }
        g2.setColor(this.lightGray);
        g2.fillRect(x + this.thickness, y + height - this.thickness, width - 2 * this.thickness, this.thickness);
        g2.setColor(this.darkGray);
        for (i = smoothLeftBottomEdge ? x + this.thickness : x + 8 * this.thickness; i <= x + width - this.thickness; i += 8 * this.thickness) {
            xpts[0] = i;
            xpts[1] = i + 4 * this.thickness;
            xpts[2] = i;
            xpts[3] = i == x ? i : i - 4 * this.thickness;
            ypts[0] = ypts[1] = y + height - this.thickness;
            ypts[2] = ypts[3] = y + height;
            g2.fillPolygon(xpts, ypts, 4);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }
}

