/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.cpanels.XpCinePanel;
import com.ge.med.cse.cvf.cpanels.XpFilmPanel;
import com.ge.med.cse.cvf.cpanels.XpROIStatisticsPanel;
import com.ge.med.cse.cvf.cpanels.XpTextPagePanel;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.plugins.CvPlugInManager;
import com.ge.med.cse.cvf.plugins.CvPlugin;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.ToolManager;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwPalletteComboControl;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XPcomboPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XpSelector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

public class CVFSelector
extends XpSelector
implements PropertyChangeListener {
    private static final String LAST_SELECTED_ITEM = "LAST_SELECTED_ITEM";
    public static final String SEPARATOR = ".";
    public static final String COUNT_PROPERTY = "count";
    public static final String DEFAULT = "default";
    private static final Logger logger = Logger.getLogger(CVFSelector.class.getName());
    private String[] applicationTabs;
    private JComponent[] applicationTabbedPane;
    private Properties prop_;
    private HashMap<String, JComponent[]> buttonPanelsMap = new HashMap();
    private transient ResourceBundle resBundle = CvUtils.getResourceBundle();
    private List<PlasmaControl> plasmaControls_ = new Vector<PlasmaControl>();
    private JPanel dummy = new JPanel();
    private XPcaPanel[] ctlPanels_;
    private AbstractButton selected;
    private ButtonGroup[] bg = null;
    private Vector<ActionListener> listeners = new Vector();
    private String[] plugInslistString = null;
    protected String currentApp = null;
    protected Border panelBorder;
    protected Border buttonBorder = null;
    protected static final String BUTTON_GROUP = "btngrp";
    private XPscreen screen = null;
    final boolean isOnDemandLoading = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.plugin.OnDemandPluginLoad"));
    public static final String TABBEDPANEUI_NAME = "tabui.class";
    transient CvPlugin plugIn = null;
    XPcaPanel[] dummyPanelsForPlugin = null;
    transient ArrayList<CvPlugin> allPlugins = new ArrayList();
    JTabbedPane tabbedPane = null;
    JPanel myToolPanel = null;
    JPopupMenu popup_add_mytool = null;
    JPopupMenu popup_remove_mytool = null;
    JPanel[] buttonPanels = null;
    int myToolIndex = -1;
    transient ActionListener pluginInsListner = new ActionListener(){

        @Override
        public void actionPerformed(final ActionEvent e) {
            if (e.getSource() instanceof AbstractButton) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        long start = System.currentTimeMillis();
                        final CvPlugin plugin = CvPlugInManager.getInstace().getPluginInstance(CVFSelector.this.plugInslistString[0]);
                        logger.log(Level.INFO, "Time to load plugin " + CVFSelector.this.plugInslistString[0] + " is : " + (System.currentTimeMillis() - start) + " millisecond ");
                        CVFSelector.this.dummyPanelsForPlugin[0].setScreen(CVFSelector.this.screen);
                        plugin.setCapable(CVFSelector.this.screen);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                XPcomboPanel combo = (XPcomboPanel)SwingUtilities.getAncestorOfClass(XPcomboPanel.class, (AbstractButton)e.getSource());
                                if (combo != null) {
                                    combo.addPanel(null, CVFSelector.this.dummyPanelsForPlugin[0], null, "");
                                }
                                CVFSelector.this.dummyPanelsForPlugin[0].add(plugin.getPluginUI());
                                CVFSelector.this.dummyPanelsForPlugin[0].revalidate();
                                if (plugin.getPluginUI() instanceof XPcaPanel) {
                                    CVFSelector.this.dummyPanelsForPlugin[0].setBorder(BorderFactory.createTitledBorder(((XPcaPanel)plugin.getPluginUI()).getTitle()));
                                }
                                ((AbstractButton)e.getSource()).addActionListener(CVFSelector.this.al);
                                if (combo != null) {
                                    combo.revalidate();
                                }
                                ((AbstractButton)e.getSource()).doClick();
                            }
                        });
                    }
                });
                thread.start();
                ((AbstractButton)e.getSource()).removeActionListener(this);
            }
        }
    };
    final CardLayout applicationTabCards = new CardLayout();
    int count = 0;
    transient ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedName = ((AbstractButton)e.getSource()).getName();
            if (e.getSource() instanceof JButton) {
                CVFSelector.this.saveSelectedItem(null);
                CVFSelector.this.setSelectedItem(null);
            } else {
                CVFSelector.this.saveSelectedItem(selectedName);
            }
            CVFSelector.this.fireActionListener(e);
        }
    };
    boolean isColorSet = false;
    private PropertyChangeListener paginglistener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if ("paging_property".equals(pce.getPropertyName())) {
                CVFSelector.this.setEnableControl(Boolean.parseBoolean(pce.getNewValue().toString().trim()), "XpCinePanel");
            }
        }
    };
    String excludetools = null;
    String selectedTool = null;
    transient MouseListener mrclAdd = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getModifiers() == 4) {
                try {
                    AbstractButton button = (AbstractButton)e.getSource();
                    CVFSelector.this.selectedTool = ((AbstractButton)e.getSource()).getName();
                    if (ToolManager.getInstance().getFavoriteToolKeys().toString().contains(CVFSelector.this.selectedTool)) {
                        JMenuItem addMenuItem = (JMenuItem)CVFSelector.this.popup_add_mytool.getComponent(0);
                        addMenuItem.setEnabled(false);
                    } else {
                        JMenuItem addMenuItem = (JMenuItem)CVFSelector.this.popup_add_mytool.getComponent(0);
                        addMenuItem.setEnabled(true);
                    }
                    CVFSelector.this.popup_add_mytool.show(e.getComponent(), e.getX(), e.getY());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    };
    transient MouseListener mrclRemove = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getModifiers() == 4) {
                CVFSelector.this.selectedTool = ((AbstractButton)e.getSource()).getName();
                CVFSelector.this.popup_remove_mytool.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    };
    transient ActionListener myToolsAddRemoveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object obj = e.getSource();
                if (((JMenuItem)obj).getName().equalsIgnoreCase("Add_Tool")) {
                    if (CVFSelector.this.addMyTool(CVFSelector.this.selectedTool)) {
                        ToolManager.getInstance().setFavoriteToolKey(CVFSelector.this.selectedTool);
                        CVFSelector.this.screen.firePropertyChange("MyTools", 0, ToolManager.getInstance().ADD_TOOL_FROM_MOUSE_RIGHT_MENU);
                    }
                } else if (CVFSelector.this.removeFromMyTools(CVFSelector.this.selectedTool)) {
                    ToolManager.getInstance().removeFavoriteToolKey(CVFSelector.this.selectedTool);
                    CVFSelector.this.screen.firePropertyChange("MyTools", 0, ToolManager.getInstance().ADD_TOOL_FROM_MOUSE_RIGHT_MENU);
                    CVFSelector.this.saveSelectedItem(null);
                    CVFSelector.this.setSelectedItem(null);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    };
    ArrayList<String> myToolsList = new ArrayList();
    static int myTools = 0;
    transient PropertyChangeListener myToolsChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ((Integer)evt.getNewValue() == ToolManager.getInstance().ADD_TOOL_FROM_MYTOOL_SETTINGS) {
                ArrayList mytools = (ArrayList)CVFSelector.this.myToolsList.clone();
                for (String existingTool : mytools) {
                    if (ToolManager.getInstance().getFavoriteToolKeys().contains(existingTool)) continue;
                    CVFSelector.this.removeFromMyTools(existingTool);
                }
                List<String> favoriteTools = ToolManager.getInstance().getFavoriteToolKeys();
                for (String newTool : favoriteTools) {
                    if (CVFSelector.this.myToolsList.contains(newTool)) continue;
                    CVFSelector.this.addMyTool(newTool);
                }
            }
        }
    };

    public CVFSelector() {
        this((XPcaPanel[])null);
        ToolManager.getInstance().clear();
        this.dummy.setName(CVFSelector.class.getName() + "dummy");
    }

    public CVFSelector(XPcaPanel[] ctlPanels) {
        boolean isLoadPlugin;
        ToolManager.getInstance().clear();
        Class borderFactoryClass = LookAndFeelFactory.getClass("BorderFactory.class");
        if (null != borderFactoryClass) {
            Object[] params = new Boolean[]{false, false, false, false};
            try {
                Method borderMethod = borderFactoryClass.getMethod("createButtonBorder", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                this.buttonBorder = (Border)borderMethod.invoke(null, params);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        if (isLoadPlugin = CvUtils.isPluginLoad()) {
            final CvPlugInManager plugManager = CvPlugInManager.getInstace();
            this.plugInslistString = plugManager.getPluginNameForExtension("ControlArea");
            if (this.plugInslistString != null) {
                this.dummyPanelsForPlugin = new XPcaPanel[this.plugInslistString.length];
            }
            if (this.plugInslistString != null) {
                int i;
                final ArrayList<XPcaPanel> arrList = new ArrayList<XPcaPanel>();
                if (ctlPanels != null) {
                    for (i = 0; i < ctlPanels.length; ++i) {
                        arrList.add(ctlPanels[i]);
                    }
                }
                if (this.isOnDemandLoading) {
                    for (i = 0; i < this.plugInslistString.length; ++i) {
                        this.dummyPanelsForPlugin[i] = new dummyPluginPanel();
                        arrList.add(this.dummyPanelsForPlugin[i]);
                        this.dummyPanelsForPlugin[i].putClientProperty("plug_in_panel", this.plugInslistString[i]);
                    }
                    XPcaPanel[] tempPanel = new XPcaPanel[arrList.size()];
                    for (int i2 = 0; i2 < arrList.size(); ++i2) {
                        tempPanel[i2] = (XPcaPanel)arrList.get(i2);
                    }
                    this.ctlPanels_ = tempPanel;
                } else {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < CVFSelector.this.plugInslistString.length; ++i) {
                                CVFSelector.this.plugIn = plugManager.getPluginInstance(CVFSelector.this.plugInslistString[i]);
                                if (CVFSelector.this.plugIn == null || !(CVFSelector.this.plugIn.getPluginUI() instanceof XPcaPanel)) continue;
                                arrList.add((XPcaPanel)CVFSelector.this.plugIn.getPluginUI());
                                CVFSelector.this.allPlugins.add(CVFSelector.this.plugIn);
                            }
                            XPcaPanel[] tempPanel = new XPcaPanel[arrList.size()];
                            for (int i = 0; i < arrList.size(); ++i) {
                                tempPanel[i] = (XPcaPanel)arrList.get(i);
                            }
                            CVFSelector.access$102(CVFSelector.this, tempPanel);
                        }
                    });
                    thread.start();
                }
            }
        } else {
            this.ctlPanels_ = ctlPanels != null ? Arrays.copyOf(ctlPanels, ctlPanels.length) : null;
        }
        this.setLayout(this.applicationTabCards);
        this.add((Component)this.dummy, "");
    }

    @Override
    public void setProperties(Properties prop) {
        this.popup_add_mytool = new JPopupMenu();
        this.popup_remove_mytool = new JPopupMenu();
        JMenuItem addToTools = new JMenuItem(CvUtils.getResourceBundle().getString("ADD_TO_MY_TOOLS"));
        addToTools.setName("Add_Tool");
        JMenuItem removeFromTools = new JMenuItem(CvUtils.getResourceBundle().getString("REMOVE_FROM_MY_TOOLS"));
        removeFromTools.setName("Remove_Tool");
        this.popup_add_mytool.add(addToTools);
        this.popup_remove_mytool.add(removeFromTools);
        addToTools.addActionListener(this.myToolsAddRemoveListener);
        removeFromTools.addActionListener(this.myToolsAddRemoveListener);
        int pluginCount = 0;
        if (this.plugInslistString != null && this.plugInslistString.length != 0) {
            pluginCount = 1;
        }
        if (prop.getProperty("PanelBorder") != null) {
            try {
                this.panelBorder = (Border)CvUtils.getClass(prop.getProperty("PanelBorder").trim()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (prop.getProperty("ButtonBorder") != null) {
            try {
                this.buttonBorder = (Border)CvUtils.getClass(prop.getProperty("PanelBorder").trim()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashMap<String, XPcaPanel> ctlPanelHash = new HashMap<String, XPcaPanel>();
        if (this.ctlPanels_ != null) {
            int len = this.ctlPanels_.length;
            for (int i = 0; i < len; ++i) {
                if (this.ctlPanels_[i] == null || this.ctlPanels_[i].getClass().getName().contains("DummyXpcaPanel")) continue;
                ctlPanelHash.put(this.ctlPanels_[i].getClass().getName(), this.ctlPanels_[i]);
            }
        }
        this.prop_ = prop;
        String appsString = prop.getProperty("apps");
        this.applicationTabs = appsString.split("\\s*,\\s*");
        this.applicationTabbedPane = new JComponent[this.applicationTabs.length];
        for (int applicationIndex = 0; applicationIndex < this.applicationTabs.length; ++applicationIndex) {
            Color tabPaneFgColor;
            int numTabs = Integer.parseInt(prop.getProperty(this.applicationTabs[applicationIndex] + SEPARATOR + COUNT_PROPERTY));
            this.bg = new ButtonGroup[numTabs += pluginCount];
            for (int i = 0; i < this.bg.length; ++i) {
                this.bg[i] = new ButtonGroup();
            }
            if (numTabs > 1) {
                String[] selectedPanelforRespectiveTab = new String[numTabs];
                for (int i = 0; i < numTabs; ++i) {
                    selectedPanelforRespectiveTab[i] = prop.getProperty(appsString + SEPARATOR + String.valueOf(i) + SEPARATOR + DEFAULT);
                }
                this.applicationTabbedPane[applicationIndex] = new JTabbedPane(1, 1);
                this.applicationTabbedPane[applicationIndex].setName(appsString);
                Color tabbedPaneBgColor = LookAndFeelFactory.getColor(null, "P9");
                if (null != tabbedPaneBgColor) {
                    this.applicationTabbedPane[applicationIndex].setBackground(tabbedPaneBgColor);
                }
                this.applicationTabbedPane[applicationIndex].putClientProperty(LAST_SELECTED_ITEM, selectedPanelforRespectiveTab);
                this.applicationTabbedPane[applicationIndex].putClientProperty(BUTTON_GROUP, this.bg);
                TabbedPaneUI tabbedUI = null;
                Class tabUIClass = LookAndFeelFactory.getClass(TABBEDPANEUI_NAME);
                if (tabUIClass != null) {
                    try {
                        tabbedUI = (TabbedPaneUI)tabUIClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
                if (null != tabbedUI) {
                    ((JTabbedPane)this.applicationTabbedPane[applicationIndex]).setUI(tabbedUI);
                }
            } else {
                this.applicationTabbedPane[applicationIndex] = new JPanel(new BorderLayout());
                this.applicationTabbedPane[applicationIndex].putClientProperty(BUTTON_GROUP, this.bg);
            }
            this.add((Component)this.applicationTabbedPane[applicationIndex], this.applicationTabs[applicationIndex]);
            Color panelBgColor = LookAndFeelFactory.getColor(null, "P10");
            if (null != panelBgColor) {
                this.setBackground(panelBgColor);
            }
            if (null != (tabPaneFgColor = LookAndFeelFactory.getColor("cvfselect.TabPane.FgColor", null))) {
                this.applicationTabbedPane[applicationIndex].setForeground(tabPaneFgColor);
            }
            this.applicationTabbedPane[applicationIndex].setOpaque(false);
            this.buttonPanels = new JPanel[numTabs];
            this.buttonPanelsMap.put(this.applicationTabs[applicationIndex], this.buttonPanels);
            for (int tabIndex = 0; tabIndex < numTabs - pluginCount; ++tabIndex) {
                String buttonDimString = prop.getProperty(this.applicationTabs[applicationIndex] + SEPARATOR + tabIndex + SEPARATOR + "dimension");
                String[] dims = buttonDimString.trim().split("\\s*x\\s*");
                int dx = Integer.parseInt(dims[0]);
                int dy = Integer.parseInt(dims[1]);
                this.buttonPanels[tabIndex] = new JPanel(new GridLayout(dy, dx));
                this.buttonPanels[tabIndex].setBorder(BorderFactory.createEmptyBorder());
                JPanel p = new JPanel(new BorderLayout());
                String panelProp = LookAndFeelFactory.getPropertyValue("Panel.Background");
                if (null != panelProp && panelProp.equalsIgnoreCase("null")) {
                    p.setBackground(null);
                    this.buttonPanels[tabIndex].setBackground(null);
                }
                p.add((Component)this.buttonPanels[tabIndex], "North");
                if (numTabs > 1) {
                    Color tabbedPaneFgColor;
                    String orig;
                    this.tabbedPane = (JTabbedPane)this.applicationTabbedPane[applicationIndex];
                    String strkey = this.applicationTabs[applicationIndex] + SEPARATOR + tabIndex + SEPARATOR + "name";
                    String translated = orig = prop.getProperty(strkey);
                    try {
                        translated = this.resBundle.getString(orig);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.buttonPanels[tabIndex].setName(orig);
                    if (orig.contains("My_Tools")) {
                        if (this.prop_.getProperty("enablemytools", "false").equalsIgnoreCase("false")) continue;
                        this.tabbedPane.addTab(translated, p);
                        tabbedPaneFgColor = LookAndFeelFactory.getColor(null, "P5");
                        System.out.println("tabbedPaneFgColor....." + tabbedPaneFgColor);
                        if (null != tabbedPaneFgColor) {
                            this.tabbedPane.setForegroundAt(tabIndex, tabbedPaneFgColor);
                        }
                        this.myToolPanel = this.buttonPanels[tabIndex];
                        this.myToolIndex = tabIndex;
                        this.tabbedPane.setSelectedIndex(tabIndex);
                    } else {
                        this.tabbedPane.addTab(translated, p);
                        tabbedPaneFgColor = LookAndFeelFactory.getColor(null, "P5");
                        if (null != tabbedPaneFgColor) {
                            this.tabbedPane.setForegroundAt(tabIndex, tabbedPaneFgColor);
                        }
                    }
                } else {
                    this.applicationTabbedPane[applicationIndex].add(p);
                }
                for (int row = 0; row < dy; ++row) {
                    for (int col = 0; col < dx; ++col) {
                        Color triggerBgColor;
                        Insets buttonInset;
                        String borderProp;
                        String prefix = this.applicationTabs[applicationIndex] + SEPARATOR + tabIndex + SEPARATOR + col + SEPARATOR + row;
                        String cellCountString = prop.getProperty(prefix + SEPARATOR + COUNT_PROPERTY);
                        if (cellCountString != null) {
                            int cellCount = Integer.parseInt(cellCountString.trim());
                            Action[] actions = new Action[cellCount];
                            for (int itemIndex = 0; itemIndex < cellCount; ++itemIndex) {
                                String cellComponentString = prop.getProperty(prefix + SEPARATOR + itemIndex);
                                try {
                                    Object o = ToolManager.getInstance().getAction(cellComponentString);
                                    if (o instanceof AbstractAction) {
                                        actions[itemIndex] = (Action)o;
                                        if (o instanceof PlasmaControl) {
                                            this.plasmaControls_.add((PlasmaControl)o);
                                        }
                                        this.addControls(cellComponentString, o);
                                    } else if (o instanceof AbstractButton) {
                                        AbstractButton b = (AbstractButton)o;
                                        if (b.getAction() != null) {
                                            actions[itemIndex] = b.getAction();
                                        }
                                        this.addControls(cellComponentString, b);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (actions[itemIndex] != null) continue;
                                actions[itemIndex] = new AbstractAction(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                    }
                                };
                            }
                            String clsName = prop.getProperty("PalleteCombo");
                            if (clsName == null) {
                                XPwPalletteComboControl PalleteCombo = new XPwPalletteComboControl(actions);
                                this.configMouseRightClick(PalleteCombo, "combo");
                                this.buttonPanels[tabIndex].add(PalleteCombo);
                            } else {
                                try {
                                    Constructor constr = CvUtils.getClass(clsName).getConstructor(Action[].class);
                                    if (constr != null) {
                                        JComponent toAdd = (JComponent)constr.newInstance(new Object[]{actions});
                                        String borderProp2 = LookAndFeelFactory.getPropertyValue("cvfselect.button.border");
                                        if (null != borderProp2 && borderProp2.equalsIgnoreCase("null")) {
                                            toAdd.setBorder(this.buttonBorder);
                                        }
                                        toAdd.addPropertyChangeListener("ClearPanel", new PropertyChangeListener(){

                                            @Override
                                            public void propertyChange(PropertyChangeEvent evt) {
                                                CVFSelector.this.setSelectedItem(null);
                                            }
                                        });
                                        if (toAdd instanceof AbstractButton) {
                                            ((AbstractButton)toAdd).addActionListener(this.al);
                                        }
                                        this.configMouseRightClick(toAdd, "combo");
                                        this.buttonPanels[tabIndex].add(toAdd);
                                    }
                                }
                                catch (Exception e) {
                                    this.buttonPanels[tabIndex].add(new XPwPalletteComboControl(actions));
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            String componentString = prop.getProperty(prefix);
                            if (componentString != null) {
                                try {
                                    Insets buttonInset2;
                                    String borderProp3;
                                    AbstractButton b;
                                    Object o = ctlPanelHash.get(componentString);
                                    Object pp = null;
                                    if (o != null) {
                                        pp = o;
                                        ToolManager.getInstance().setAction(componentString, pp);
                                    } else {
                                        o = ToolManager.getInstance().getAction(componentString);
                                    }
                                    if (o instanceof AbstractAction) {
                                        b = null;
                                        if (prop.getProperty(prefix + ".component") != null) {
                                            String compName = prop.getProperty((prefix + ".component").trim());
                                            Class compClsass = CvUtils.getClass(compName.trim());
                                            Constructor ctor = compClsass.getConstructor(Action.class);
                                            b = (AbstractButton)ctor.newInstance(o);
                                            b.setName(o.getClass().getName().trim());
                                        } else {
                                            b = new JButton((Action)o);
                                            Color buttonColor = LookAndFeelFactory.getColor(null, "P8");
                                            if (null != buttonColor) {
                                                b.setBackground(buttonColor);
                                                b.setForeground(buttonColor);
                                            }
                                            b.setName(o.getClass().getName().trim());
                                        }
                                        if (o instanceof PlasmaControl) {
                                            this.plasmaControls_.add((PlasmaControl)o);
                                        }
                                        b.setText("");
                                        borderProp3 = LookAndFeelFactory.getPropertyValue("cvfselect.button.border");
                                        if (null != borderProp3 && borderProp3.equalsIgnoreCase("null")) {
                                            b.setBorder(this.buttonBorder);
                                        }
                                        if (null != (buttonInset2 = LookAndFeelFactory.getInsets("cvfselect.Button.Inset", null))) {
                                            b.setMargin(buttonInset2);
                                        }
                                        b.addActionListener(this.al);
                                        this.configMouseRightClick(b, componentString);
                                        this.addControls(componentString, o);
                                        this.buttonPanels[tabIndex].add(b);
                                    } else if (o instanceof AbstractButton) {
                                        b = (AbstractButton)o;
                                        if (o instanceof PlasmaControl) {
                                            this.plasmaControls_.add((PlasmaControl)o);
                                        }
                                        if (null != (borderProp3 = LookAndFeelFactory.getPropertyValue("cvfselect.button.border")) && borderProp3.equalsIgnoreCase("null")) {
                                            b.setBorder(this.buttonBorder);
                                        }
                                        if (null != (buttonInset2 = LookAndFeelFactory.getInsets("cvfselect.Button.Inset", null))) {
                                            b.setMargin(buttonInset2);
                                        }
                                        b.setName(b.getClass().getName());
                                        this.buttonPanels[tabIndex].add(b);
                                        Color ButtonBgColor = LookAndFeelFactory.getColor(null, "P8");
                                        if (null != ButtonBgColor) {
                                            b.setBackground(ButtonBgColor);
                                        }
                                        b.addActionListener(this.al);
                                        this.configMouseRightClick(b, componentString);
                                        this.addControls(componentString, o);
                                    } else if (o instanceof XPcaPanel) {
                                        XPcaPanel cap = (XPcaPanel)o;
                                        Icon ico = cap.getIcon();
                                        String text = cap.getName();
                                        JToggleButton trigger = null;
                                        trigger = ico != null ? new JToggleButton(cap.getIcon()) : new JToggleButton(text);
                                        trigger.setName(componentString);
                                        borderProp = LookAndFeelFactory.getPropertyValue("cvfselect.button.border");
                                        if (null != borderProp && borderProp.equalsIgnoreCase("null")) {
                                            trigger.setBorder(this.buttonBorder);
                                        }
                                        if (null != (buttonInset = LookAndFeelFactory.getInsets("cvfselect.Button.Inset", null))) {
                                            trigger.setMargin(buttonInset);
                                        }
                                        this.buttonPanels[tabIndex].add(trigger);
                                        triggerBgColor = LookAndFeelFactory.getColor(null, "P8");
                                        if (null != triggerBgColor) {
                                            trigger.setBackground(triggerBgColor);
                                        }
                                        this.bg[tabIndex].add(trigger);
                                        this.addControls(componentString, trigger);
                                        this.configMouseRightClick(trigger, componentString);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    JLabel l = new JLabel();
                                    Color labelBorder = LookAndFeelFactory.getColor("cvfselect.Label.Color", null);
                                    if (null != labelBorder) {
                                        l.setBorder(BorderFactory.createLineBorder(labelBorder));
                                    }
                                    this.buttonPanels[tabIndex].add(l);
                                }
                            } else {
                                JLabel l = new JLabel();
                                Color labelBorder = LookAndFeelFactory.getColor("cvfselect.Label.Color", null);
                                if (null != labelBorder) {
                                    l.setBorder(BorderFactory.createLineBorder(labelBorder));
                                }
                                this.buttonPanels[tabIndex].add(l);
                            }
                        }
                        try {
                            if (col != dx - 2) continue;
                            String pluginindexString = CvPropertiesManager.getProperty("pluginsTab", "-1");
                            int pluginIndex = -1;
                            if (pluginindexString != null && pluginindexString != null) {
                                try {
                                    pluginIndex = Integer.parseInt(pluginindexString);
                                }
                                catch (Exception parseex) {
                                    pluginIndex = -1;
                                }
                            }
                            if (tabIndex != pluginIndex || this.plugInslistString == null || this.plugInslistString.length <= 0) continue;
                            for (int i = 0; i < this.plugInslistString.length; ++i) {
                                Color triggerFgColor;
                                String componentString;
                                if (this.isOnDemandLoading) {
                                    componentString = dummyPluginPanel.class.getName();
                                    JToggleButton trigger = new JToggleButton();
                                    Icon ic = CvPlugInManager.getInstace().getIconFromPlugin(this.plugInslistString[0]);
                                    if (ic != null) {
                                        trigger.setIcon(ic);
                                    } else {
                                        trigger.setText(CvPlugInManager.getInstace().getPluigin18NName(this.plugInslistString[0]));
                                    }
                                    String tooltip = CvPlugInManager.getInstace().getPluginDescription(this.plugInslistString[0]);
                                    if (tooltip != null) {
                                        trigger.setToolTipText(tooltip);
                                    }
                                    trigger.setName(dummyPluginPanel.class.getName());
                                    ToolManager.getInstance().setAction(componentString, this.dummyPanelsForPlugin[i]);
                                    borderProp = LookAndFeelFactory.getPropertyValue("cvfselect.button.border");
                                    if (null != borderProp && borderProp.equalsIgnoreCase("null")) {
                                        trigger.setBorder(this.buttonBorder);
                                    }
                                    if (null != (buttonInset = LookAndFeelFactory.getInsets("cvfselect.Button.Inset", null))) {
                                        trigger.setMargin(buttonInset);
                                    }
                                    this.buttonPanels[tabIndex].add(trigger);
                                    triggerBgColor = LookAndFeelFactory.getColor(null, "P8");
                                    System.out.println("triggerBgColor...P8..." + triggerBgColor);
                                    if (null != triggerBgColor) {
                                        trigger.setBackground(triggerBgColor);
                                    }
                                    trigger.addActionListener(this.pluginInsListner);
                                    this.bg[tabIndex].add(trigger);
                                    this.addControls(componentString, trigger);
                                    this.configMouseRightClick(trigger, componentString);
                                    continue;
                                }
                                if (!(this.plugIn.getPluginUI() instanceof XPcaPanel)) continue;
                                componentString = this.plugIn.getPluginUI().getClass().getName();
                                XPcaPanel cap = (XPcaPanel)this.plugIn.getPluginUI();
                                Icon ico = cap.getIcon();
                                String text = this.plugIn.getShortDescription();
                                JToggleButton trigger = null;
                                trigger = ico != null ? new JToggleButton(this.plugIn.getIcon()) : new JToggleButton(text);
                                trigger.setName(componentString);
                                ToolManager.getInstance().setAction(componentString, this.plugIn.getPluginUI());
                                String borderProp4 = LookAndFeelFactory.getPropertyValue("cvfselect.button.border");
                                if (null != borderProp4 && borderProp4.equalsIgnoreCase("null")) {
                                    trigger.setBorder(this.buttonBorder);
                                }
                                trigger.setFocusable(false);
                                Insets buttonInset3 = LookAndFeelFactory.getInsets("cvfselect.Button.Inset", null);
                                if (null != buttonInset3) {
                                    trigger.setMargin(buttonInset3);
                                }
                                this.buttonPanels[tabIndex].add(trigger);
                                Color triggerBgColor2 = LookAndFeelFactory.getColor(null, "P8");
                                if (null != triggerBgColor2) {
                                    trigger.setBackground(triggerBgColor2);
                                }
                                if (null != (triggerFgColor = LookAndFeelFactory.getColor("cvfselct.Trigger.FgColor", null))) {
                                    trigger.setForeground(triggerFgColor);
                                }
                                this.bg[tabIndex].add(trigger);
                                this.addControls(componentString, trigger);
                                this.configMouseRightClick(trigger, componentString);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (this.tabbedPane == null) continue;
            this.tabbedPane.addChangeListener(new TabChangeListener());
        }
    }

    private void loadMyTools() {
        try {
            if (ToolManager.getInstance().isFavoriteToolKeysChanged()) {
                ToolManager.getInstance().loadMyToolKeys();
                this.removeAllMyTools();
                List<String> mytools = ToolManager.getInstance().getFavoriteToolKeys();
                if (mytools != null && mytools.size() > 0) {
                    for (String myToolactionName : mytools) {
                        this.addMyTool(myToolactionName);
                    }
                }
            } else {
                System.err.println("isFavoriteToolKeysChanged : False");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getSelectedItem() {
        String toReturn = null;
        for (int i = 0; i < this.applicationTabbedPane.length; ++i) {
            if (!this.applicationTabbedPane[i].isVisible()) continue;
            if (this.applicationTabbedPane[i] instanceof JTabbedPane) {
                int selectedIndex = ((JTabbedPane)this.applicationTabbedPane[i]).getSelectedIndex();
                toReturn = ((String[])this.applicationTabbedPane[i].getClientProperty(LAST_SELECTED_ITEM))[selectedIndex];
                break;
            }
            toReturn = (String)this.applicationTabbedPane[i].getClientProperty(LAST_SELECTED_ITEM);
        }
        if (toReturn == null || toReturn.equalsIgnoreCase("null")) {
            return DummyXpcaPanel.class.getName();
        }
        return toReturn;
    }

    private void saveSelectedItem(String selected) {
        for (int i = 0; i < this.applicationTabbedPane.length; ++i) {
            if (!this.applicationTabbedPane[i].isVisible()) continue;
            if (this.applicationTabbedPane[i] instanceof JTabbedPane) {
                int selectedIndex = ((JTabbedPane)this.applicationTabbedPane[i]).getSelectedIndex();
                String[] stored = (String[])this.applicationTabbedPane[i].getClientProperty(LAST_SELECTED_ITEM);
                stored[selectedIndex] = selected;
                this.applicationTabbedPane[i].putClientProperty(LAST_SELECTED_ITEM, stored);
                continue;
            }
            this.applicationTabbedPane[i].putClientProperty(LAST_SELECTED_ITEM, selected);
        }
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    protected void fireActionListener(ActionEvent ev) {
        for (ActionListener a : this.listeners) {
            try {
                a.actionPerformed(ev);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setSelectedItem(String componentName) {
        ArrayList<Object> o = ToolManager.getInstance().getTool(componentName);
        if (o != null) {
            this.performSelection(o instanceof List ? (AbstractButton)((List)o).get(0) : (AbstractButton)((Object)o));
        } else {
            for (int i = 0; i < this.applicationTabbedPane.length; ++i) {
                if (this.applicationTabbedPane[i].isVisible()) {
                    if (!(this.applicationTabbedPane[i] instanceof JTabbedPane)) continue;
                    int selectedIndex = ((JTabbedPane)this.applicationTabbedPane[i]).getSelectedIndex();
                    String[] current = (String[])this.applicationTabbedPane[i].getClientProperty(LAST_SELECTED_ITEM);
                    current[selectedIndex] = null;
                    this.applicationTabbedPane[i].putClientProperty(LAST_SELECTED_ITEM, current);
                    final ButtonGroup bg = ((ButtonGroup[])this.applicationTabbedPane[i].getClientProperty(BUTTON_GROUP))[selectedIndex];
                    if (bg == null || bg.getSelection() == null) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JToggleButton but = new JToggleButton();
                            bg.add(but);
                            but.setSelected(true);
                            but.remove(but);
                        }
                    });
                    continue;
                }
                this.applicationTabbedPane[i].putClientProperty(LAST_SELECTED_ITEM, "null");
                ButtonGroup bg = (ButtonGroup)this.applicationTabbedPane[i].getClientProperty(BUTTON_GROUP);
                if (bg == null || bg.getSelection() == null) continue;
                bg.getSelection().setSelected(false);
            }
            this.fireActionListener(new ActionEvent(this, 121, "ShowNoPanel"));
        }
    }

    private void performSelection(AbstractButton button) {
        if (button == null) {
            return;
        }
        JTabbedPane pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, button);
        if (pane != null) {
            Container toSelect;
            for (toSelect = button; toSelect != null && !(toSelect.getParent() instanceof JTabbedPane); toSelect = toSelect.getParent()) {
            }
            if (toSelect != null) {
                pane.setSelectedComponent(toSelect);
            }
        }
        if (button.isEnabled()) {
            button.doClick();
        } else {
            button.setEnabled(true);
            button.doClick();
            button.setEnabled(false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ((JComponent)CVFSelector.this.getParent()).setBorder(null);
                    ((JComponent)CVFSelector.this.getParent().getParent()).setBorder(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void addElement(final XPcaPanel pan, String name, Icon icon, String desc) {
        Color panelBgColor;
        if (!this.isColorSet) {
            pan.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    Color panelBgColor = LookAndFeelFactory.getColor(null, "P9");
                    if (null != panelBgColor) {
                        pan.getParent().setBackground(panelBgColor);
                    }
                    pan.removeAncestorListener(this);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }
            });
        }
        if (null != (panelBgColor = LookAndFeelFactory.getColor(null, "P9"))) {
            this.updateBackground(pan, panelBgColor);
        }
        if (this.panelBorder == null && !pan.getTitle().equalsIgnoreCase("NoName")) {
            pan.setBorder(BorderFactory.createTitledBorder(pan.getTitle()));
        } else {
            pan.setBorder(this.panelBorder);
        }
        if (pan.getClass().getName().contains("DummyXpcaPanel")) {
            return;
        }
        String componentName = pan.getClass().getName();
        Object o = null;
        if (ToolManager.getInstance().getTool(pan.getClass().getName()) != null) {
            o = ToolManager.getInstance().getTool(pan.getClass().getName()).get(0);
        }
        if (o != null) {
            if (o instanceof List) {
                for (AbstractButton element : (List)o) {
                    element.setName(componentName);
                    element.addActionListener(this.al);
                }
            } else {
                ((AbstractButton)o).setName(componentName);
                ((AbstractButton)o).addActionListener(this.al);
                if (name != null) {
                    ((AbstractButton)o).setToolTipText(name);
                }
            }
        } else {
            System.err.println("fail to find button for " + componentName);
        }
    }

    private void updateBackground(JPanel pan, Color c) {
        pan.setBackground(c);
        Component[] children = pan.getComponents();
        for (int i = 0; children != null && i < children.length; ++i) {
            if (children[i] instanceof JPanel) {
                this.updateBackground((JPanel)children[i], c);
                continue;
            }
            if (!(children[i] instanceof JSlider)) continue;
            children[i].setBackground(c);
        }
    }

    @Override
    public void setSelectedApplication(String appName) {
        boolean found = false;
        for (int i = 0; i < this.applicationTabs.length; ++i) {
            if (!this.applicationTabs[i].equals(appName)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Applicaiton " + appName + " not defined.");
        }
        this.applicationTabCards.show(this, appName);
        this.currentApp = appName;
        String componentName = this.prop_.getProperty(appName + ".default");
        String prevUserSelected = this.getSelectedItem();
        String toSelect = componentName != null ? prevUserSelected : componentName;
        this.setSelectedItem(toSelect);
    }

    @Override
    public void setScreen(XPscreen screen) {
        if (this.screen != null) {
            this.screen.removePropertyChangeListener("paging_property", this.paginglistener);
        }
        if (screen != null) {
            String[] propsToAdd;
            this.screen = screen;
            for (String propertyName : propsToAdd = CvPropertiesManager.getProperty("Selector.Modes", "").split(",")) {
                screen.removePropertyChangeListener(propertyName, this);
                screen.addPropertyChangeListener(propertyName, this);
            }
            for (PlasmaControl control : this.plasmaControls_) {
                control.setCapable(screen);
            }
            this.screen.addPropertyChangeListener("paging_property", this.paginglistener);
            if (this.myToolPanel != null) {
                screen.addPropertyChangeListener("MyTools", this.myToolsChangeListener);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CVFSelector.this.loadMyTools();
                    }
                });
                screen.addPropertyChangeListener("PrefsChange", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CVFSelector.this.loadMyTools();
                            }
                        });
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String[] pnls;
        if ("reference_viewport".equals(evt.getPropertyName()) && "false".equals(evt.getNewValue().toString().trim()) && this.screen != null && this.screen.getNumComponents() > 1) {
            for (int i = 0; i < this.screen.getNumComponents(); ++i) {
                if (!(this.screen.getPort(i) instanceof XpViewport) || XpReferenceImageApp.getRefPortCount((XpViewport)this.screen.getPort(i)) <= 0) continue;
                return;
            }
        }
        if ((pnls = CvPropertiesManager.getProperty(evt.getPropertyName().trim() + SEPARATOR + evt.getNewValue().toString().trim()).split(",")).length == 1 && (pnls[0].equalsIgnoreCase("all") || pnls[0].equalsIgnoreCase("none"))) {
            this.setEnableAllControls(pnls[0].equalsIgnoreCase("all"));
        } else {
            this.setEnableAllControls(false);
            for (int i = 0; i < pnls.length; ++i) {
                ArrayList<Object> tmpObjs = ToolManager.getInstance().getTool(pnls[i]);
                if (this.screen != null && (tmpObjs == null || tmpObjs.size() <= 0)) {
                    tmpObjs = new ArrayList();
                    Action tmpObj = this.screen.getActionMap().get(pnls[i]);
                    if (tmpObj == null) {
                        if (this.screen.getActionMap() != null && this.screen.getActionMap().allKeys() != null) {
                            for (int j = 0; j < this.screen.getActionMap().allKeys().length; ++j) {
                                Action action = this.screen.getActionMap().get(this.screen.getActionMap().allKeys()[j]);
                                if (!pnls[i].equalsIgnoreCase(String.valueOf(action).split("@")[0])) continue;
                                String strActionName = action.getValue("Name") != null ? action.getValue("Name").toString() : action.getClass().getName();
                                tmpObj = this.screen.getActionMap().get(strActionName);
                                tmpObjs.add(tmpObj);
                            }
                        }
                    } else {
                        tmpObjs.add(tmpObj);
                    }
                }
                if (tmpObjs == null) continue;
                for (Object tmpObj : tmpObjs) {
                    Object panel;
                    if (tmpObj instanceof Action) {
                        ((Action)tmpObj).setEnabled(true);
                        continue;
                    }
                    if (!(tmpObj instanceof AbstractButton)) continue;
                    ((AbstractButton)tmpObj).setEnabled(true);
                    String panelClass = ((AbstractButton)tmpObj).getName();
                    ArrayList<Object> panels = ToolManager.getInstance().getTool(panelClass);
                    if (panels == null || panels.size() <= 0 || !((panel = panels.get(0)) instanceof XPcaPanel) || panel instanceof XpROIStatisticsPanel || panel instanceof XpCinePanel || panel instanceof XpFilmPanel || panel instanceof XpTextPagePanel || panel instanceof dummyPluginPanel) continue;
                    CvUtils.setEnabled((XPcaPanel)panel, true);
                }
            }
        }
    }

    protected void setEnableControl(boolean disable, String panelClassName) {
        HashMap<String, ArrayList<Object>> allControls = ToolManager.getInstance().getAllToolsMaps();
        Set<String> keys = allControls.keySet();
        for (String key : keys) {
            ArrayList<Object> values = allControls.get(key);
            for (Object value : values) {
                String panelClsNm;
                if (!(value instanceof AbstractButton) || (panelClsNm = ((AbstractButton)value).getName()) == null || !panelClsNm.contains(panelClassName)) continue;
                ((AbstractButton)value).setEnabled(disable);
            }
        }
    }

    protected void setEnableAllControls(boolean disable) {
        HashMap<String, ArrayList<Object>> allControls = ToolManager.getInstance().getAllToolsMaps();
        Iterator<ArrayList<Object>> iter = allControls.values().iterator();
        Set<String> keys = allControls.keySet();
        for (String key : keys) {
            ArrayList<Object> values = allControls.get(key);
            for (Object value : values) {
                if (value instanceof Action) {
                    ((Action)value).setEnabled(disable);
                    continue;
                }
                if (!(value instanceof AbstractButton)) continue;
                ((AbstractButton)value).setEnabled(disable);
                String panelClass = ((AbstractButton)value).getName();
                Object panel = ToolManager.getInstance().getTool(panelClass).get(0);
                if (panel != null) {
                    if (panel instanceof XpROIStatisticsPanel || panel instanceof XpCinePanel || panel instanceof XpFilmPanel || panel instanceof XpTextPagePanel || panel instanceof dummyPluginPanel || !(panel instanceof XPcaPanel)) continue;
                    CvUtils.setEnabled((XPcaPanel)panel, disable);
                    continue;
                }
                System.err.println("AbstractButton : null :" + value);
            }
        }
        if (this.screen.getActionMap() != null && this.screen.getActionMap().allKeys() != null) {
            for (int i = 0; i < this.screen.getActionMap().allKeys().length; ++i) {
                Action action = this.screen.getActionMap().get(this.screen.getActionMap().allKeys()[i]);
                if (action == null) continue;
                action.setEnabled(disable);
            }
        }
    }

    private void addControls(String compName, Object control) {
        ToolManager.getInstance().setTool(compName, control);
    }

    private void configMouseRightClick(JComponent toAdd, String actionKey) {
        if (this.prop_.getProperty("enablemytools", "false").equalsIgnoreCase("true")) {
            Object excludeMyTool;
            if (this.excludetools == null && (excludeMyTool = this.prop_.get("mytool_exclude")) != null) {
                this.excludetools = excludeMyTool.toString();
            }
            if (this.excludetools == null || !this.excludetools.contains(actionKey)) {
                toAdd.addMouseListener(this.mrclAdd);
            }
        }
    }

    private boolean removeFromMyTools(String actionName) {
        try {
            int i = this.myToolsList.indexOf(actionName);
            this.myToolsList.remove(i);
            this.myToolPanel.remove(i + 1);
            this.myToolPanel.add(new JLabel());
            this.myToolPanel.validate();
            this.myToolPanel.repaint();
            --myTools;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void removeAllMyTools() {
        int compCount = this.myToolPanel.getComponentCount();
        for (int i = 1; i < compCount; ++i) {
            if (this.myToolPanel.getComponent(i) instanceof JLabel) continue;
            this.myToolPanel.remove(i + 1);
            this.myToolPanel.add(new JLabel());
        }
        myTools = 0;
        this.myToolsList.clear();
    }

    private boolean addMyTool(String actionName) {
        boolean status = true;
        if (myTools + 1 < this.myToolPanel.getComponentCount()) {
            if (this.myToolsList.contains(actionName)) {
                return false;
            }
            ++myTools;
            try {
                AbstractButton b;
                Object o = ToolManager.getInstance().getAction(actionName);
                ArrayList<Object> existingTools = ToolManager.getInstance().getTool(actionName);
                if (existingTools != null && existingTools.size() > 0) {
                    Object ob = existingTools.get(0);
                    if (ob instanceof AbstractButton) {
                        status = ((AbstractButton)ob).isEnabled();
                    } else if (ob instanceof AbstractAction) {
                        status = ((AbstractAction)ob).isEnabled();
                    } else {
                        System.out.println("failed to get the status of the : " + ob);
                    }
                }
                if (o instanceof AbstractAction) {
                    Insets buttonInset;
                    b = null;
                    b = new JButton((Action)o);
                    Color buttonColor = LookAndFeelFactory.getColor(null, "P8");
                    if (null != buttonColor) {
                        b.setBackground(buttonColor);
                        b.setForeground(buttonColor);
                    }
                    b.setName(o.getClass().getName().trim());
                    if (o instanceof PlasmaControl) {
                        this.plasmaControls_.add((PlasmaControl)o);
                        ((PlasmaControl)o).setCapable(this.screen);
                    }
                    b.setText("");
                    String borderProp = LookAndFeelFactory.getPropertyValue("cvfselect.button.border");
                    if (null != borderProp && borderProp.equalsIgnoreCase("null")) {
                        b.setBorder(this.buttonBorder);
                    }
                    if (null != (buttonInset = LookAndFeelFactory.getInsets("cvfselect.Button.Inset", null))) {
                        b.setMargin(buttonInset);
                    }
                    b.addActionListener(this.al);
                    this.myToolPanel.remove(myTools);
                    this.myToolPanel.add((Component)b, myTools);
                    this.myToolsList.add(actionName);
                    b.addMouseListener(this.mrclRemove);
                    b.setEnabled(status);
                    this.addControls(actionName, o);
                } else if (o instanceof AbstractButton) {
                    if (o instanceof Replicable) {
                        b = (AbstractButton)((Replicable)o).clone();
                        this.myToolPanel.remove(myTools);
                        this.myToolPanel.add((Component)b, myTools);
                        b.addMouseListener(this.mrclRemove);
                        b.addActionListener(this.al);
                        b.setEnabled(status);
                        this.myToolsList.add(actionName);
                    } else {
                        Insets buttonInset;
                        String borderProp;
                        b = (AbstractButton)o;
                        if (o instanceof PlasmaControl) {
                            this.plasmaControls_.add((PlasmaControl)o);
                            ((PlasmaControl)o).setCapable(this.screen);
                        }
                        if (null != (borderProp = LookAndFeelFactory.getPropertyValue("cvfselect.button.border")) && borderProp.equalsIgnoreCase("null")) {
                            b.setBorder(this.buttonBorder);
                        }
                        if (null != (buttonInset = LookAndFeelFactory.getInsets("cvfselect.Button.Inset", null))) {
                            b.setMargin(buttonInset);
                        }
                        b.setFocusable(false);
                        b.setName(b.getClass().getName());
                        Color buttonBgColor = LookAndFeelFactory.getColor(null, "P8");
                        if (null != buttonBgColor) {
                            b.setBackground(buttonBgColor);
                        }
                        b.addActionListener(this.al);
                        this.addControls(actionName, o);
                        this.myToolPanel.remove(myTools);
                        this.myToolPanel.add((Component)b, myTools);
                        b.setEnabled(status);
                        b.addMouseListener(this.mrclRemove);
                        this.myToolsList.add(actionName);
                    }
                } else if (o instanceof XPcaPanel) {
                    Color triggerBgColor;
                    Insets buttonInset;
                    XPcaPanel cap = (XPcaPanel)o;
                    Icon ico = null;
                    String text = null;
                    String tooltip = null;
                    if (o instanceof dummyPluginPanel) {
                        JToggleButton obj = (JToggleButton)ToolManager.getInstance().getTool(actionName).get(0);
                        ico = obj.getIcon();
                        text = obj.getName();
                        tooltip = obj.getToolTipText();
                    } else {
                        ico = cap.getIcon();
                        text = cap.getName();
                        tooltip = cap.getTitle();
                    }
                    JToggleButton trigger = null;
                    trigger = ico != null ? new JToggleButton(ico) : new JToggleButton(text);
                    trigger.setName(actionName);
                    String borderProp = LookAndFeelFactory.getPropertyValue("cvfselect.button.border");
                    if (null != borderProp && borderProp.equalsIgnoreCase("null")) {
                        trigger.setBorder(this.buttonBorder);
                    }
                    if (null != (buttonInset = LookAndFeelFactory.getInsets("cvfselect.Button.Inset", null))) {
                        trigger.setMargin(buttonInset);
                    }
                    if (null != (triggerBgColor = LookAndFeelFactory.getColor(null, "P8"))) {
                        trigger.setBackground(triggerBgColor);
                    }
                    trigger.addActionListener(this.al);
                    this.addControls(actionName, trigger);
                    this.bg[this.myToolIndex].add(trigger);
                    trigger.setToolTipText(tooltip);
                    if (o instanceof dummyPluginPanel) {
                        trigger.addActionListener(this.pluginInsListner);
                    }
                    this.myToolPanel.remove(myTools);
                    this.myToolPanel.add((Component)trigger, myTools);
                    trigger.setEnabled(status);
                    trigger.addMouseListener(this.mrclRemove);
                    this.myToolsList.add(actionName);
                } else {
                    System.err.println("Support is missing : " + actionName + "; " + o);
                }
                this.myToolPanel.validate();
                this.myToolPanel.repaint();
                return true;
            }
            catch (Exception e) {
                --myTools;
                e.printStackTrace();
            }
        } else {
            JOptionPane.showOptionDialog(this.screen, CvUtils.getResourceBundle().getString("MY_TOOLS_EXCEEDED") + ToolManager.getInstance().getMyToolLimit(), CvUtils.getResourceBundle().getString("My_Tools"), 0, 1, null, new String[]{CvUtils.getResourceBundle().getString("XP_BUT_OK")}, DEFAULT);
        }
        return false;
    }

    static /* synthetic */ XPcaPanel[] access$102(CVFSelector x0, XPcaPanel[] x1) {
        x0.ctlPanels_ = x1;
        return x1;
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ArrayList<Object> obj = ToolManager.getInstance().getTool(((String[])CVFSelector.this.tabbedPane.getClientProperty(CVFSelector.LAST_SELECTED_ITEM))[CVFSelector.this.tabbedPane.getSelectedIndex()]);
            if (obj != null) {
                if (obj instanceof List) {
                    List list = obj;
                    for (int i = 0; i < list.size(); ++i) {
                        ((AbstractButton)list.get(i)).doClick();
                    }
                } else {
                    ((AbstractButton)((Object)obj)).doClick();
                }
            } else {
                CVFSelector.this.setSelectedItem(null);
            }
        }
    }

    public static class DummyXpcaPanel
    extends XPcaPanel {
    }

    public class dummyPluginPanel
    extends XPcaAutoControlPanel {
        XPcaPanel pan = null;

        public dummyPluginPanel() {
            this.setLayout(new BorderLayout());
        }

        @Override
        public Component add(Component comp) {
            if (comp instanceof XPcaPanel) {
                this.pan = (XPcaPanel)comp;
            }
            return super.add(comp);
        }

        @Override
        public void panelStart() {
            super.panelStart();
            if (this.pan != null) {
                this.pan.setScreen(this.getScreen());
                this.pan.panelStart();
            }
        }

        @Override
        public void panelStop() {
            super.panelStop();
            if (this.pan != null) {
                this.pan.panelStop();
            }
        }

        @Override
        public void setScreen(XPscreen screen) {
            super.setScreen(screen);
            if (this.pan != null) {
                this.pan.setScreen(screen);
            }
        }
    }
}

