/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.laf.AbstractNumberedThumSliderUI;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class CVCineRateSlider
extends JSlider
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    AutoControlPanelSeek panelSeek = null;
    private final String SLIDERUI_NAME = "NumberSlider.uitype";
    private final String skipFrameRateColor = "SkipFrameRate.Color";
    private final String foregroundColor = "foreground.color";
    private AbstractNumberedThumSliderUI sliderUILnfClass = null;
    private int noSkipFrameRate;
    private boolean isCineOn = false;
    BufferedImage im;

    public CVCineRateSlider() {
        this.myinit();
    }

    private void myinit() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.setMaximum(50);
        this.setValue(10);
        this.setMinimum(1);
        this.setToolTipText(res.getString("Cine_Rate_Control_"));
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CVCineRateSlider.this.this_stateChanged(e);
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CVCineRateSlider.this.repaint();
            }
        });
        this.updateUI();
    }

    public CVCineRateSlider(BoundedRangeModel brm) {
        super(brm);
        this.myinit();
    }

    public CVCineRateSlider(int orientation, int min, int max, int value) {
        super(orientation, min, max, value);
        this.myinit();
    }

    public CVCineRateSlider(int min, int max, int value) {
        super(min, max, value);
        this.myinit();
    }

    public CVCineRateSlider(int min, int max) {
        super(min, max);
        this.myinit();
    }

    public CVCineRateSlider(int orientation) {
        super(orientation);
        this.myinit();
    }

    public void setNoSkipFrameRate(int rate) {
        this.noSkipFrameRate = rate;
        this.repaint();
    }

    public void setCineOn(boolean onOff) {
        this.isCineOn = onOff;
        this.repaint();
    }

    @Override
    public void updateUI() {
        if (null == this.sliderUILnfClass) {
            Class sliderClass = LookAndFeelFactory.getClass("NumberSlider.uitype");
            try {
                if (sliderClass != null) {
                    this.sliderUILnfClass = (AbstractNumberedThumSliderUI)sliderClass.getConstructor(JSlider.class).newInstance(this);
                    this.sliderUILnfClass.enableCineSlider(true);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        this.setUI((SliderUI)((Object)this.sliderUILnfClass));
        this.updateLabelUIs();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isCineOn && this.noSkipFrameRate > 0) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle rect = this.getThumbRect();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontMetrics fm = g2.getFontMetrics();
            String valString = "" + this.noSkipFrameRate;
            int sw = fm.stringWidth(valString);
            Rectangle track = this.getTrackRect();
            int x = track.x + (int)((double)(track.width * this.noSkipFrameRate) / (double)(this.getMaximum() - this.getMinimum()));
            Color paintColor = LookAndFeelFactory.getColor("SkipFrameRate.Color", null);
            if (null != paintColor) {
                g2.setColor(paintColor);
            }
            g2.drawString(valString, x - sw / 2, rect.y);
            g2.fillRect(x - 2, rect.y + (rect.height - 4) / 2, 3, 5);
        }
    }

    public Rectangle getTrackRect() {
        if (this.sliderUILnfClass != null) {
            return this.sliderUILnfClass.getTrackRect();
        }
        return null;
    }

    public Rectangle getThumbRect() {
        if (this.sliderUILnfClass != null) {
            return this.sliderUILnfClass.getThumbRect();
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.im == null || this.im.getWidth() != w || this.im.getHeight() != h) {
            this.im = new BufferedImage(w, h, 2);
        }
        Graphics2D g2 = this.im.createGraphics();
        super.paint(g2);
        Rectangle rect = this.getThumbRect();
        Color borderColor = LookAndFeelFactory.getColor("foreground.color", null);
        FontMetrics fm = g2.getFontMetrics();
        String valString = "" + this.getValue();
        int sw = fm.stringWidth(valString);
        g2.setColor(borderColor);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.orientation == 0) {
            g2.drawString(valString, rect.x + (rect.width - sw >> 1) + 1, rect.y);
        } else {
            g2.drawString(valString, rect.x + rect.width + 1, rect.y + rect.height - 1 - (rect.height - fm.getHeight() >> 1));
        }
        g2.dispose();
        g.drawImage(this.im, 0, 0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        JLabel l = new JLabel("" + this.getValue());
        dim.height += l.getPreferredSize().height + 5;
        dim.width += l.getPreferredSize().width + 5;
        return dim;
    }

    public Dimension getMininumSize() {
        return this.getPreferredSize();
    }

    public void setData(DMObject[] objs) {
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
    }

    @Override
    public void setScreen(XPscreen screen) {
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    void this_stateChanged(ChangeEvent e) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwCineRateSlider2>  " + Tid.newTid());
        CineCapable port = (CineCapable)this.panelSeek.getCapable("com.ge.med.idc.CineCapable");
        if (port == null) {
            Tid.popTID();
            return;
        }
        port.setCineRate((int)(1000.0 / (double)this.getValue()));
        Tid.popTID();
    }

    public Integer getCineRate() {
        CineCapable port = (CineCapable)this.panelSeek.getCapable("com.ge.med.idc.CineCapable");
        if (port == null) {
            return null;
        }
        return new Integer(port.getCineRate());
    }
}

