/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.textpage;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.cse.cvf.textpage.UiElement;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class ContentTableModel
extends AbstractTableModel {
    private UiElement[] localRef;
    private DMObject[] localDMObjRef;
    Logger logger = Logger.getLogger(this.getClass().getName());

    public ContentTableModel(UiElement[] elemsTodisplay, DMObject[] toQuery) {
        this.localRef = elemsTodisplay != null ? Arrays.copyOf(elemsTodisplay, elemsTodisplay.length) : new UiElement[0];
        this.localDMObjRef = toQuery != null ? Arrays.copyOf(toQuery, toQuery.length) : new DMObject[0];
    }

    @Override
    public int getColumnCount() {
        return this.localRef.length;
    }

    @Override
    public int getRowCount() {
        return this.localDMObjRef.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object returnValue = null;
        if (this.localRef.length != 0) {
            String formatter = this.localRef[columnIndex].strFormatter;
            if (!formatter.equals("null")) {
                Class c = null;
                try {
                    c = CvUtils.getClass(formatter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Formatter f = null;
                if (c != null) {
                    try {
                        f = (Formatter)c.newInstance();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (f != null) {
                    try {
                        if (this.localDMObjRef.length != 0) {
                            returnValue = f.format(this.localDMObjRef[rowIndex]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.logger.log(Level.WARNING, "Exception in formattor of Text Page table model  message= " + ex.getMessage());
                    }
                }
            } else {
                DMTag tagToQuery = this.localRef[columnIndex].getTag();
                if (tagToQuery != null && this.localDMObjRef.length != 0) {
                    returnValue = this.localDMObjRef[rowIndex].getValue(tagToQuery);
                }
            }
        }
        return returnValue != null ? returnValue : "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        String name = null;
        if (this.localRef.length != 0) {
            name = this.localRef[columnIndex].getName();
        }
        return name;
    }
}

