/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder.helper;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.idc.VolumeDatasetCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class J3DViewportHelper
implements Helper {
    private static final String VIEWTYPE = ".viewType";
    private static final String SUPPORTED_VIEWTYPE = ".supportedViewTypes";
    private static final String CAPABLE = "Capable";
    private static final Logger logger = Logger.getLogger(J3DViewportHelper.class.getName());
    private J3DViewport viewport = null;

    @Override
    public void config(JComponent port, String portName, Properties prop) throws Exception {
        if (port == null || portName == null || portName == "" || prop == null) {
            logger.log(Level.WARNING, "Either viewport or its name or property is null");
            throw new Exception("Either viewport or its name or property is null");
        }
        String[] supportedViewTypes = prop.getProperty(portName + SUPPORTED_VIEWTYPE).split(",");
        String viewType = prop.getProperty(portName + VIEWTYPE);
        if (port instanceof ViewTypeCapable) {
            ((ViewTypeCapable)((Object)port)).setSupportedViewTypes(supportedViewTypes);
            ((ViewTypeCapable)((Object)port)).setViewType(viewType);
        }
        if (port instanceof J3DViewport) {
            this.viewport = (J3DViewport)port;
            this.viewport.putClientProperty("APP_IDENTIFIER", prop.getProperty("APP_IDENTIFIER"));
            int capableCount = Integer.parseInt(CvPropertiesManager.getProperty(CAPABLE, "0"));
            for (int j = 0; j < capableCount; ++j) {
                String capableKeyVal = CvPropertiesManager.getProperty("Capable." + j);
                Capable capable = this.createInstance(capableKeyVal);
                if (capable != null) {
                    this.viewport.setCapable(VolumeDatasetCapable.class.getName(), capable);
                    continue;
                }
                logger.log(Level.INFO, "Capable " + capableKeyVal + " is null.");
            }
        }
    }

    private Capable createInstance(String className) {
        Capable capable = null;
        try {
            Class capableClass = CvUtils.getClass(className);
            Constructor capableCons = capableClass.getConstructor(J3DViewport.class);
            capable = (Capable)capableCons.newInstance(this.viewport);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "Illegal arguments passed for creating Class " + className + " " + e.getLocalizedMessage());
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, "Unable to instantiate Class " + className + " " + e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, "Unable to invoke constructor of Class " + className + " " + e.getLocalizedMessage());
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e.getLocalizedMessage());
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.WARNING, "Unable to find constructor of Class " + className + " " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception creating instance of Class " + className + " " + e.getLocalizedMessage());
        }
        return capable;
    }
}

