/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder.helper;

import com.ge.med.StdAnno.DefaultApStyle;
import com.ge.med.cse.cvf.annotation.XpApdAnnotationGenerator;
import com.ge.med.cse.cvf.annotation.XpCVAnnotation;
import com.ge.med.cse.cvf.annotation.XpCVAnnotationGenerator;
import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class AnnotationHelper
implements Helper {
    private static final Logger logger = Logger.getLogger(AnnotationHelper.class.getName());
    private static final String ACTIVEANNOTATION = "ActiveAnnotation";
    public Properties annotprops = new Properties();
    private static boolean enableActiveAnnot = true;
    private HashMap<String, Map<String, ActiveAnnotationControl>> activeAnnotcontrols = new HashMap();
    private HashMap<String, Properties> activeAnnotmap = new HashMap();
    public String annotGenerator = null;

    @Override
    public void config(JComponent port, String propName, Properties prop) throws Exception {
        if (port == null || propName == null || propName == "" || prop == null) {
            logger.log(Level.WARNING, "Either viewport or property name or property is null");
            throw new Exception("Either viewport or property name or property is null");
        }
        if (port instanceof XpViewport) {
            this.configureAnnotations((XpViewport)port, propName, prop);
        } else {
            logger.log(Level.INFO, "port is not instance of XpViewport.");
        }
    }

    private void configureAnnotations(XpViewport port, String propName, Properties prop) {
        String[] modalities;
        String mods = prop.getProperty("cvf.modalities", "mr,ct,pr,sc");
        if (mods != null && (modalities = mods.split(",")) != null && modalities.length > 0) {
            for (int i = 0; i < modalities.length; ++i) {
                String[] imgTypes;
                String imT = prop.getProperty("cvf.annotation.apstyle." + modalities[i].toLowerCase() + ".imagetype");
                if (imT == null || (imgTypes = imT.split(",")) == null || imgTypes.length <= 0) continue;
                for (int j = 0; j < imgTypes.length; ++j) {
                    String apstyleclass = prop.getProperty("cvf.annotation.apstyle." + modalities[i].toLowerCase(Locale.ENGLISH) + "." + imgTypes[j] + ".apstyleclass");
                    String configclass = prop.getProperty("cvf.annotation.apstyle." + modalities[i].toLowerCase(Locale.ENGLISH) + "." + imgTypes[j] + ".configclass");
                    if (apstyleclass != null && configclass != null) {
                        try {
                            XpCVAnnotation.registerAnnotationConfig(CvUtils.getClass(apstyleclass), configclass);
                            this.annotprops.setProperty(imgTypes[j], apstyleclass);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    String citems = prop.getProperty("cvf.annotation.apstyle." + modalities[i].toLowerCase(Locale.ENGLISH) + "." + imgTypes[j] + ".custom.item");
                    String propKey = imgTypes[j] + ".CUSTOM_ANNOT_ITEMS";
                    this.annotprops.setProperty(propKey, citems);
                    String lfitems = prop.getProperty("cvf.annotation.apstyle." + modalities[i].toLowerCase(Locale.ENGLISH) + "." + imgTypes[j] + ".largefont.item");
                    propKey = imgTypes[j] + ".LARGEFONT_ANNOT_ITEMS";
                    this.annotprops.setProperty(propKey, lfitems);
                    int activeAnnotationCount = Integer.parseInt(prop.getProperty("ActiveAnnotation." + modalities[i].toLowerCase(Locale.ENGLISH) + "." + imgTypes[j], "0"));
                    if (activeAnnotationCount <= 0) continue;
                    Properties aap = new Properties();
                    for (int a = 0; a < activeAnnotationCount; ++a) {
                        String key = "ActiveAnnotation." + modalities[i].toLowerCase(Locale.ENGLISH) + "." + imgTypes[j] + "." + a;
                        String[] activeKeyVal = prop.getProperty(key).split(",");
                        aap.setProperty(activeKeyVal[1], activeKeyVal[0]);
                    }
                    this.activeAnnotmap.put(imgTypes[j], aap);
                }
            }
        }
        XpCVAnnotation.registerAnnotationConfig(DefaultApStyle.class, "com.ge.med.cse.cvf.annotation.XpCvApdAnnotationConfig$Default");
        this.annotGenerator = prop.getProperty("cvf.annotation.generator", XpCVAnnotationGenerator.class.getName());
    }

    private void loadActiveAnnotationControls() {
        if (this.activeAnnotmap != null && this.activeAnnotmap.size() > 0) {
            Iterator<Map.Entry<String, Properties>> it = this.activeAnnotmap.entrySet().iterator();
            while (it.hasNext()) {
                String imagetype = it.next().getKey();
                Properties p = this.activeAnnotmap.get(imagetype);
                HashMap<String, ActiveAnnotationControl> aacs = new HashMap<String, ActiveAnnotationControl>(this.activeAnnotmap.size());
                if (p != null) {
                    for (String string : p.keySet()) {
                        ActiveAnnotationControl aac = (ActiveAnnotationControl)this.createInstance(p.getProperty(string));
                        aacs.put(string, aac);
                    }
                }
                this.activeAnnotcontrols.put(imagetype, aacs);
            }
        }
    }

    public void configActiveAnnotations(XpViewport port, XpDicomObject dicomObj) {
        Map<String, ActiveAnnotationControl> aacs;
        if (!enableActiveAnnot) {
            return;
        }
        this.loadActiveAnnotationControls();
        String imgType = null;
        XpAnnotationGenerator ag = port.getAnnotationGenerator();
        if (ag instanceof XpApdAnnotationGenerator) {
            imgType = ((XpApdAnnotationGenerator)ag).getImageTypeKey(dicomObj);
        }
        if (imgType == null && (imgType = DicomUtils.getModality((XpMedicalImage)((XpCompositePort)port).getFrame())) != null) {
            imgType = imgType.toUpperCase(Locale.ENGLISH);
        }
        if ((aacs = this.activeAnnotcontrols.get(imgType)) != null && aacs.size() > 0) {
            Iterator<Map.Entry<String, ActiveAnnotationControl>> it = aacs.entrySet().iterator();
            while (it.hasNext()) {
                String key = it.next().getKey();
                ActiveAnnotationControl aac = aacs.get(key);
                if (aac == null) continue;
                ((XpCompositePort)port).setActiveAnnotationListener(key, aac, aac.getShortDescription());
                aac.setCapable(port);
            }
        }
    }

    private Object createInstance(String className) {
        try {
            return CvUtils.getClass(className).newInstance();
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, "Unable to instantiate Class " + className + " " + e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception creating instance of Class " + className + " " + e.getLocalizedMessage());
        }
        return null;
    }

    static {
        enableActiveAnnot = CvPropertiesManager.getBoolean("cvf.ActiveAnnotation", true);
    }
}

