/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder;

import com.ge.med.cse.cvf.screenbuilder.PortLoaderBase;
import com.ge.med.cse.cvf.screenbuilder.PropertyPortState;
import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.base.XPscreen;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class PortLoader
implements PortLoaderBase {
    private static final String HelperPackageName = Helper.class.getPackage().getName() + ".";
    private static ClassLoader cl = ClassLoader.getSystemClassLoader();
    private static final String HELPERS = ".helpers";
    private static final String PORT_CLASS = ".portClass";
    private static final String ANNOTATION_CLASS = ".annotationClass";
    private static final String ANNOTATION_PROP = ".annotationProperties";
    private static final String ANNOTATION_GROUP = ".annotationGroup";
    private static final Logger logger = Logger.getLogger(PortLoader.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent loadPort(String name, Properties prop) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String helperLst;
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        JComponent comp = null;
        String type = prop.getProperty(name + PORT_CLASS);
        if (type != null) {
            Class c = CvUtils.getClass(type);
            comp = (JComponent)c.newInstance();
            comp.setName(name);
        } else {
            comp = new XPscreen.EmptyPort();
        }
        if (comp instanceof RowColCapable) {
            ((RowColCapable)((Object)comp)).setRowCol(1, 1);
        }
        if (comp instanceof AnnotCapable) {
            String annotClassName = prop.getProperty(name + ANNOTATION_CLASS);
            String annotPropName = prop.getProperty(name + ANNOTATION_PROP);
            String annotGroupName = prop.getProperty(name + ANNOTATION_GROUP);
            if (annotClassName != null && annotClassName.length() > 0) {
                Properties annotProp = new Properties();
                if (annotPropName != null && annotPropName.length() > 0) {
                    InputStream inStream = cl.getResourceAsStream(annotPropName);
                    try {
                        annotProp.load(inStream);
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "exception while loading the annotation properties", ex);
                        ex.printStackTrace();
                    }
                    finally {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Class annotClass = CvUtils.getClass(annotClassName);
                ((AnnotCapable)((Object)comp)).setAnnotationGenerator(annotClass, annotProp);
                if (annotGroupName != null) {
                    ((AnnotCapable)((Object)comp)).setAnnotationGroup(annotGroupName, true);
                }
            }
        }
        if ((helperLst = prop.getProperty(name + HELPERS)) != null) {
            String[] helpers = helperLst.split(",");
            for (int i = 0; i < helpers.length; ++i) {
                Helper hlp = this.getHelper(helpers[i]);
                if (comp instanceof PropertyPortState) {
                    ((PropertyPortState)((Object)comp)).addHelper(hlp);
                }
                try {
                    hlp.config(comp, name, prop);
                    continue;
                }
                catch (Exception e) {
                    InstantiationException e2 = new InstantiationException("Failed to configure port " + name + " with helper " + helpers[i]);
                    e2.initCause(e);
                    throw e2;
                }
            }
        }
        return comp;
    }

    private Helper getHelper(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String className = name.indexOf(46) < 0 ? HelperPackageName + name : name;
        Class c = CvUtils.getClass(className);
        return (Helper)c.newInstance();
    }
}

