/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.saveimage;

import com.ge.med.cse.cvf.j3d.J3DDefaultPagingViewCalculator;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.saveimage.SaveDialog;
import com.ge.med.cse.cvf.saveimage.XpDicomComposite;
import com.ge.med.cse.cvf.saveimage.XpFillSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveImage;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class XpSaveUtil {
    private static final Logger logger = Logger.getLogger(XpSaveUtil.class.getName());
    public static final SimpleDateFormat DICOM_VR_DA_FORMAT = DicomData.DA_FORMAT_PARSE;
    public static final SimpleDateFormat DICOM_VR_TM_FORMAT = DicomData.TM_FORMAT_PARSE;
    private static Thread saveThread = null;
    private static Map<String, ArrayList<Integer>> reformatSeriesIDMap = new HashMap<String, ArrayList<Integer>>();

    public static Map<String, ArrayList<Integer>> getReformatSeriesIDMap() {
        return reformatSeriesIDMap;
    }

    public static void updateSequence(DicomComposite comp, int group, int element, int itemIndex, tagValue[] tags) {
        if (comp == null || tags == null || tags.length == 0) {
            return;
        }
        Object o = comp.getValue(group, element);
        if (o instanceof DicomData) {
            DicomData seq = (DicomData)o;
            for (int t = 0; t < tags.length; ++t) {
                seq.setValue(tags[t].group, tags[t].element, itemIndex, tags[t].value);
            }
        }
    }

    public static void setReformatSeriesIDMap(Map<String, ArrayList<Integer>> reformatSeriesIDMap) {
        XpSaveUtil.reformatSeriesIDMap = reformatSeriesIDMap;
    }

    public static void saveAsDicom(final XpViewport viewport) {
        System.out.println("XpSaveUtil.saveAsDicom()");
        final SaveDialog saveDialog = new SaveDialog(viewport, "Save Image As Dicom");
        saveDialog.addSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                saveThread = new SaveThread(saveThread){

                    @Override
                    public void run() {
                        super.run();
                        saveDialog.setVisible(false);
                        XpSaveParameters params = new XpSaveParameters();
                        params.seriesDescription = saveDialog.getSeriesDescription();
                        boolean saveStatus = XpSaveUtil.saveFrame(viewport, params);
                        if (!saveStatus) {
                            logger.log(Level.WARNING, "Unable to save image as dicom.");
                        }
                        logger.log(Level.INFO, "Saving complete");
                    }
                };
                saveThread.setPriority(10);
                saveThread.start();
            }
        });
        saveDialog.setVisible(true);
    }

    public static void saveScreenAsDicom(final XPscreen screen) {
        final SaveDialog saveDialog = new SaveDialog(screen, "Save Screen As Dicom");
        saveDialog.addSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                saveThread = new SaveThread(saveThread){

                    @Override
                    public void run() {
                        super.run();
                        saveDialog.setVisible(false);
                        XpSaveParameters params = new XpSaveParameters();
                        params.seriesDescription = saveDialog.getSeriesDescription();
                        XpSaveUtil.saveFrames(screen, params);
                        logger.log(Level.INFO, "Saving complete");
                    }
                };
                saveThread.setPriority(10);
                saveThread.start();
            }
        });
        saveDialog.setVisible(true);
    }

    public static void saveFrames(SelectionCapable frame, XpSaveParameters params) {
        SelectionCapable selcap = frame;
        for (int i = 0; i < selcap.getNumComponents(); ++i) {
            JComponent port = selcap.getViewportComponent(i);
            if (port instanceof SelectionCapable) {
                XpSaveUtil.saveFrames((SelectionCapable)((Object)port), params);
                continue;
            }
            if (!(port instanceof T3DViewport)) continue;
            params.image = null;
            params.imageNum = params.imageNum == -1 ? 1 : ++params.imageNum;
            params.imageThickness = -1.0;
            boolean saveStatus = XpSaveUtil.saveFrame((T3DViewport)port, params);
            if (saveStatus) continue;
            logger.log(Level.WARNING, "Unable to save image as dicom from port [" + i + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFrame(XpViewport vp, XpSaveParameters params) {
        if (vp == null) {
            logger.log(Level.WARNING, "XpViewport is null");
            return false;
        }
        T3DViewport t3dViewport = null;
        if (vp instanceof T3DViewport) {
            t3dViewport = (T3DViewport)vp;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        XjVolumeInfo volume = t3dViewport.getVolume();
        String renderStyle = t3dViewport.getRenderStyle();
        if (osession == null || volume == null || renderStyle == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo or renderStyle is null");
            return false;
        }
        DicomComposite refComp = new DicomComposite();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(volume.getRelatedComposite());
            refComp.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Unable to read the DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to find DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Unable to close the input stream. " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
        }
        String modality = CvUtils.getModality(refComp);
        XpSaveImage.ImageType imageType = null;
        int[] col = t3dViewport.getColorMap();
        if ("ct".equalsIgnoreCase(modality) && (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE")) || renderStyle.equals("VOLUME") || col != null) {
            if (params.seriesNum == -1) {
                params.seriesNum = XpSaveUtil.nextSeriesNumberCT(volume, osession);
            }
            imageType = XpSaveImage.ImageType.SecondaryCapture;
        } else {
            if (params.seriesNum == -1) {
                params.seriesNum = "ct".equalsIgnoreCase(modality) ? XpSaveUtil.nextSeriesNumberCT(volume, osession) : XpSaveUtil.findSeriesNumber(volume, osession, true, t3dViewport.getRenderStyle());
            }
            imageType = XpSaveImage.ImageType.Reformat;
        }
        return XpSaveUtil.doSave(XpSaveImage.SaveType.SaveToDB, imageType, t3dViewport, params);
    }

    public static boolean reformatSave(boolean saveToDB, boolean saveToFile, XpViewport vp, XpSaveParameters params) {
        if (vp == null) {
            logger.log(Level.WARNING, "XpViewport is null");
            return false;
        }
        T3DViewport t3dViewport = null;
        if (vp instanceof T3DViewport) {
            t3dViewport = (T3DViewport)vp;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        XjVolumeInfo volume = t3dViewport.getVolume();
        if (osession == null || volume == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo or renderStyle is null");
            return false;
        }
        XpSaveImage.SaveType saveType = null;
        saveType = saveToDB ? XpSaveImage.SaveType.SaveToDB : XpSaveImage.SaveType.SaveToFile;
        return XpSaveUtil.doSave(saveType, XpSaveImage.ImageType.Reformat, t3dViewport, params);
    }

    public static boolean reformatSave(boolean saveToDB, boolean saveToFile, VavBatchModel model, XpSaveParameters params) {
        if (model == null) {
            logger.log(Level.WARNING, "Model is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        if (osession == null || model.getTargetVolumeModel().getVolume() == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo or renderStyle is null");
            return false;
        }
        XpSaveImage.SaveType saveType = null;
        saveType = saveToDB ? XpSaveImage.SaveType.SaveToDB : XpSaveImage.SaveType.SaveToFile;
        return XpSaveUtil.doSave(saveType, XpSaveImage.ImageType.Reformat, model, params);
    }

    public static boolean secondarySave(XpViewport vp) {
        if (vp == null) {
            logger.log(Level.WARNING, "XpViewport is null");
            return false;
        }
        T3DViewport t3dViewport = null;
        if (vp instanceof T3DViewport) {
            t3dViewport = (T3DViewport)vp;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        XjVolumeInfo volume = t3dViewport.getVolume();
        if (osession == null || volume == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo or renderStyle is null");
            return false;
        }
        XpSaveParameters params = new XpSaveParameters();
        params.seriesNum = XpSaveUtil.findSeriesNumber(volume, osession, false, null);
        return XpSaveUtil.doSave(XpSaveImage.SaveType.SaveToDB, XpSaveImage.ImageType.SecondaryCapture, t3dViewport, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doSave(XpSaveImage.SaveType saveType, XpSaveImage.ImageType imageType, T3DViewport t3dViewport, XpSaveParameters params) {
        XjVolumeInfo volume = t3dViewport.getVolume();
        if (volume == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo is null");
            return false;
        }
        DicomComposite refComp = new DicomComposite();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(volume.getRelatedComposite());
            refComp.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Unable to read the DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to find DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.log(Level.WARNING, "Unable to close the input stream " + e.getLocalizedMessage());
                }
            }
        }
        XpSaveImage save = new XpSaveImage();
        save.setReferenceDicomComposite(refComp);
        XpFillSaveParameters fillSaveParameters = save.createFillSaveParameters(imageType, t3dViewport);
        if (fillSaveParameters != null) {
            boolean fillStatus = fillSaveParameters.fillSaveParameters(params);
            if (!fillStatus) {
                logger.log(Level.WARNING, "Unable to fill the save parameters.");
                return false;
            }
        } else {
            logger.log(Level.WARNING, "Unable to fill the save parameters.");
            return false;
        }
        boolean saveStatus = save.saveImage(saveType, imageType, params);
        if (!saveStatus) {
            logger.log(Level.WARNING, "Unable to save the image.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doSave(XpSaveImage.SaveType saveType, XpSaveImage.ImageType imageType, VavBatchModel model, XpSaveParameters params) {
        XjVolumeModel volumeModel = model.getTargetVolumeModel();
        if (volumeModel == null) {
            logger.log(Level.WARNING, "DMSession or volumeModel is null");
            return false;
        }
        XjVolumeInfo volume = volumeModel.getVolume();
        DicomComposite refComp = new DicomComposite();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(volume.getRelatedComposite());
            refComp.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Unable to read the DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to find DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.log(Level.WARNING, "Unable to close the input stream " + e.getLocalizedMessage());
                }
            }
        }
        XpSaveImage save = new XpSaveImage();
        save.setReferenceDicomComposite(refComp);
        XpFillSaveParameters fillSaveParameters = save.createFillSaveParameters(imageType, model.getTargetPort());
        if (fillSaveParameters != null) {
            boolean fillStatus = fillSaveParameters.fillSaveParameters(params);
            if (!fillStatus) {
                logger.log(Level.WARNING, "Unable to fill the save parameters.");
                return false;
            }
        } else {
            logger.log(Level.WARNING, "Unable to fill the save parameters.");
            return false;
        }
        boolean saveStatus = save.saveImage(saveType, imageType, params);
        if (!saveStatus) {
            logger.log(Level.WARNING, "Unable to save the image.");
            return false;
        }
        return true;
    }

    public static void saveAsSeries(final XpViewport viewport) {
        System.out.println("XpSaveUtil.saveAsSeries()");
        final SaveDialog saveDialog = new SaveDialog(viewport, "Save Images As Series");
        saveDialog.addSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                saveThread = new SaveThread(saveThread){

                    @Override
                    public void run() {
                        super.run();
                        saveDialog.setVisible(false);
                        boolean saveStatus = false;
                        try {
                            saveStatus = XpSaveUtil.saveAsSeries(viewport, saveDialog.getSeriesDescription());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (!saveStatus) {
                            logger.log(Level.WARNING, "Unable to save all images as/in Series.");
                        }
                        logger.log(Level.INFO, "Saving complete");
                    }
                };
                saveThread.setPriority(10);
                saveThread.start();
            }
        });
        saveDialog.setVisible(true);
    }

    private static boolean saveAsSeries(XpViewport vp, String serDesc) throws Exception {
        if (vp == null) {
            logger.log(Level.WARNING, "XpViewport is null");
            return false;
        }
        J3DViewport j3dViewport = null;
        if (vp instanceof J3DViewport) {
            j3dViewport = (J3DViewport)vp;
        }
        if (j3dViewport == null || j3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "J3DViewport or its frame is null");
            return false;
        }
        J3DViewport clonedPort = (J3DViewport)j3dViewport.clone();
        XpSaveParameters params = new XpSaveParameters();
        XjVolumeInfo volume = clonedPort.getVolume();
        params.seriesDescription = serDesc;
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        if (params.seriesNum == -1) {
            params.seriesNum = XpSaveUtil.nextSeriesNumberCT(volume, osession);
        }
        params.seriesDate = new Date().getTime();
        params.seriesUID = XpSaveUtil.getSeriesUID((String)volume.getValue(32, 13), params.seriesNum, osession);
        params.grayScaleInverted = clonedPort.isVideoInverted();
        ViewCalculator vc = clonedPort.getViewCalculator();
        if (vc instanceof J3DDefaultPagingViewCalculator) {
            params.sliceSpacing = ((J3DDefaultPagingViewCalculator)vc).getSpacing();
        }
        boolean saveStatus = false;
        BufferedImage bimg = new BufferedImage(j3dViewport.getWidth(), j3dViewport.getHeight(), 1);
        clonedPort.setPreferredSize(new Dimension(j3dViewport.getWidth(), j3dViewport.getHeight()));
        JFrame jf = new JFrame("offscreen");
        jf.setContentPane(clonedPort);
        jf.pack();
        for (int i = 0; i < clonedPort.getNumFrames(); ++i) {
            clonedPort.setFrameIndex(i);
            clonedPort.forceRenderContents();
            clonedPort.refreshContents();
            Graphics g = bimg.getGraphics();
            clonedPort.paint(g);
            params.imageNum = i + 1;
            saveStatus = XpSaveUtil.doSave(XpSaveImage.SaveType.SaveToDB, XpSaveImage.ImageType.Reformat, clonedPort, params);
            if (saveStatus) continue;
            logger.log(Level.WARNING, "Unable to save image of index " + i + " in a series.");
        }
        clonedPort.dispose();
        jf.dispose();
        return saveStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFrame(boolean saveToDB, boolean saveToFile, XjVolumeInfo volume, XpSaveParameters params, DMSession outputSession) {
        if (volume == null) {
            logger.log(Level.WARNING, "Volume is null");
            return false;
        }
        DicomComposite refComp = new DicomComposite();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(volume.getRelatedComposite());
            refComp.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Unable to read the DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to find DicomComposite file. " + ex.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return XpSaveUtil.saveFrame(saveToDB, saveToFile, refComp, params, outputSession);
    }

    public static boolean saveFrame(boolean saveToDB, boolean saveToFile, DicomComposite refComp, XpSaveParameters params, DMSession outputSession) {
        if (refComp == null) {
            logger.log(Level.WARNING, "Reference composite is null");
            return false;
        }
        params.seriesDate = new Date().getTime();
        if (params.renderStyle.equals("FULLBODY_MIP") || params.renderStyle.equals("FULLBODY_MINIP") || params.renderStyle.equals("FULLBODY_AVERAGE")) {
            XpDicomElement orientationElem = new XpDicomElement(32, 55);
            orientationElem.value = refComp.getString(orientationElem.group, orientationElem.element);
            double[] orientationValues = orientationElem.getDoubleArrayValue();
            params.inputSliceI = new JnVector3d(-orientationValues[0], -orientationValues[1], orientationValues[2]).normalize();
            params.inputSliceJ = new JnVector3d(-orientationValues[3], -orientationValues[4], orientationValues[5]).normalize();
            params.inputSliceN = JnVector3d.cross(params.inputSliceI, params.inputSliceJ);
        }
        XpSaveImage save = new XpSaveImage();
        save.setReferenceDicomComposite(refComp);
        save.setOutputSession(outputSession);
        XpSaveImage.SaveType saveType = null;
        saveType = saveToDB ? XpSaveImage.SaveType.SaveToDB : XpSaveImage.SaveType.SaveToFile;
        boolean saveStatus = save.saveImage(saveType, XpSaveImage.ImageType.Reformat, params);
        if (!saveStatus) {
            logger.log(Level.WARNING, "Unable to save the image.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomComposite createComposite(XpViewport vp, XpSaveParameters params) {
        if (vp == null) {
            logger.log(Level.WARNING, "XpViewport is null");
            return null;
        }
        T3DViewport t3dViewport = null;
        if (vp instanceof T3DViewport) {
            t3dViewport = (T3DViewport)vp;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return null;
        }
        XjVolumeInfo volume = t3dViewport.getVolume();
        String renderStyle = t3dViewport.getRenderStyle();
        DicomComposite refComp = new DicomComposite();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(volume.getRelatedComposite());
            refComp.read(inStream);
        }
        catch (DMException ex) {
            logger.log(Level.WARNING, "Unable to read the reference composite file. " + ex.getLocalizedMessage());
            DicomComposite dicomComposite = null;
            return dicomComposite;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to find reference composite file. " + ex.getLocalizedMessage());
            DicomComposite dicomComposite = null;
            return dicomComposite;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Unable to close the input stream. " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
        }
        String modality = CvUtils.getModality(refComp);
        XpSaveImage.ImageType imageType = null;
        int[] col = t3dViewport.getColorMap();
        imageType = "ct".equalsIgnoreCase(modality) && (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE")) || renderStyle.equals("VOLUME") || col != null ? XpSaveImage.ImageType.SecondaryCapture : XpSaveImage.ImageType.Reformat;
        return XpSaveUtil.createComposite(imageType, refComp, params);
    }

    public static DicomComposite createComposite(XpSaveImage.ImageType imgType, DicomComposite refComp, XpSaveParameters params) {
        if (refComp == null) {
            logger.log(Level.WARNING, "Reference composite is null");
            return null;
        }
        params.seriesDate = new Date().getTime();
        if (params.renderStyle.equals("FULLBODY_MIP") || params.renderStyle.equals("FULLBODY_MINIP") || params.renderStyle.equals("FULLBODY_AVERAGE")) {
            XpDicomElement orientationElem = new XpDicomElement(32, 55);
            orientationElem.value = refComp.getString(orientationElem.group, orientationElem.element);
            double[] orientationValues = orientationElem.getDoubleArrayValue();
            params.inputSliceI = new JnVector3d(-orientationValues[0], -orientationValues[1], orientationValues[2]).normalize();
            params.inputSliceJ = new JnVector3d(-orientationValues[3], -orientationValues[4], orientationValues[5]).normalize();
            params.inputSliceN = JnVector3d.cross(params.inputSliceI, params.inputSliceJ);
        }
        XpSaveImage save = new XpSaveImage();
        save.setReferenceDicomComposite(refComp);
        try {
            XpDicomComposite comp = save.createDicomComposite(imgType, params);
            return comp;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Unable to create DicomComposite.");
            return null;
        }
    }

    public static String getFileSaveDirectory(String seriesUID) {
        return System.getProperty("java.io.tmpdir") + File.separator + "Reformats_" + seriesUID;
    }

    public static String newInstanceUid() {
        UidGenerator uidGen = new UidGenerator();
        uidGen.setBH(CvPropertiesManager.getProperty("SYSTEM_IMPLEMENTATION_UID_PREFIX", uidGen.getBH()));
        return uidGen.newUID();
    }

    public static int findNextAvailableSeriesNumber(DMSession session, String examUID, int rangeBegin, int rangeEnd) {
        if (session == null || examUID == null) {
            throw new IllegalArgumentException("Session or examUID was null");
        }
        DMObject[] exams = session.getRelated("study", new DMQuery("(0x0020, 0x000D) = " + examUID));
        TreeSet<Integer> seriesNums = new TreeSet<Integer>();
        for (int i = 0; i < exams.length; ++i) {
            DMObject[] series = exams[i].getRelated("series");
            for (int j = 0; j < series.length; ++j) {
                Integer seriesNum;
                Object seriesNumObj = series[j].getValue(32, 17);
                if (seriesNumObj == null || (seriesNum = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : new Integer(seriesNumObj.toString().trim())) < rangeBegin || seriesNum > rangeEnd) continue;
                seriesNums.add(seriesNum);
            }
        }
        int seriesNum = rangeBegin;
        Iterator itr = seriesNums.iterator();
        while (itr.hasNext()) {
            int nextInt = (Integer)itr.next();
            if (seriesNum < nextInt) {
                return seriesNum;
            }
            seriesNum = nextInt + 1;
        }
        if (seriesNum > rangeEnd) {
            return rangeEnd;
        }
        return seriesNum;
    }

    public static int findNextAvailableSeriesNumberByType(DMSession session, String examUID, int rangeBegin, int rangeEnd, String imageType) {
        if (session == null || examUID == null) {
            throw new IllegalArgumentException("Session or examUID was null");
        }
        DMObject[] exams = session.getRelated("study", new DMQuery("(0x0020, 0x000D) = " + examUID));
        TreeSet<Integer> seriesNums = new TreeSet<Integer>();
        for (int i = 0; i < exams.length; ++i) {
            DMObject[] series = exams[i].getRelated("series");
            for (int j = 0; j < series.length; ++j) {
                Integer seriesNum;
                String type = DicomUtils.getImageType(series[j], true);
                Object seriesNumObj = series[j].getValue(32, 17);
                if (seriesNumObj == null || (seriesNum = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : new Integer(seriesNumObj.toString().trim())) < rangeBegin || seriesNum > rangeEnd) continue;
                if (type != null && type.equalsIgnoreCase(imageType)) {
                    return seriesNum;
                }
                seriesNums.add(seriesNum);
            }
        }
        int seriesNum = rangeBegin;
        Iterator itr = seriesNums.iterator();
        while (itr.hasNext()) {
            int nextInt = (Integer)itr.next();
            if (seriesNum < nextInt) {
                return seriesNum;
            }
            seriesNum = nextInt + 1;
        }
        if (seriesNum > rangeEnd) {
            return rangeEnd;
        }
        return seriesNum;
    }

    public static String getSeriesUID(String examUID, int seriesNumber, DMSession session) {
        if (examUID == null || session == null) {
            throw new IllegalArgumentException("Session or examUID was null");
        }
        DMObject[] series = session.getRelated("study", new DMQuery("(0x0020, 0x000D) = " + examUID + " AND (0x0020, 0x0011) = " + seriesNumber));
        if (series == null || series.length == 0) {
            return XpSaveUtil.newInstanceUid();
        }
        String serUID = (String)series[0].getValue(32, 14);
        if (serUID == null) {
            serUID = XpSaveUtil.newInstanceUid();
        }
        return serUID;
    }

    public static double[] getDoubleArrayValue(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, "\\");
        double[] doubleArray = new double[tokenizer.countTokens()];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = Double.parseDouble(tokenizer.nextToken());
        }
        return doubleArray;
    }

    public static int getBitsPerPix(DMComposite image) {
        int bitsPerPix = 0;
        String imgType = ((String)image.getValue(40, 4)).trim();
        if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
            bitsPerPix = (Integer)image.getValue(40, 256) == 16 ? 16 : 8;
        } else if (imgType.equals("RGB")) {
            bitsPerPix = 24;
        } else if (imgType.equals("PALETTE COLOR")) {
            bitsPerPix = (Integer)image.getValue(40, 256) == 16 ? 16 : 8;
        }
        return bitsPerPix;
    }

    public static int nextSeriesNumber(XjDicomObject refImage, DMSession session) {
        String examUID = (String)refImage.getValue(32, 13);
        Object seriesNumObj = refImage.getValue(32, 17);
        int se_no = 1;
        if (seriesNumObj != null) {
            se_no = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : Integer.parseInt(seriesNumObj.toString().trim());
        }
        int minSeriesNum = se_no >= 100 ? se_no + 1 : se_no * 100;
        int maxSeriesNum = minSeriesNum - minSeriesNum % 100 + 99;
        return XpSaveUtil.findNextAvailableSeriesNumber(session, examUID, minSeriesNum, maxSeriesNum);
    }

    public static int findSeriesNumber(XjDicomObject refImage, DMSession session, boolean newSeries, String renderStyle) {
        if (newSeries) {
            return XpSaveUtil.nextSeriesNumber(refImage, session);
        }
        String examUID = (String)refImage.getValue(32, 13);
        Object seriesNumObj = refImage.getValue(32, 17);
        int se_no = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : Integer.parseInt(seriesNumObj.toString().trim());
        int minSeriesNum = se_no >= 100 ? se_no + 1 : se_no * 100;
        int maxSeriesNum = minSeriesNum - minSeriesNum % 100 + 99;
        if (renderStyle == null) {
            return XpSaveUtil.findNextAvailableSeriesNumberByType(session, examUID, minSeriesNum, maxSeriesNum, "SSAVE");
        }
        String modality = DicomUtils.getModality(refImage);
        if ("ct".equalsIgnoreCase(modality) && (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE")) || renderStyle.equals("VOLUME")) {
            return XpSaveUtil.findNextAvailableSeriesNumberByType(session, examUID, minSeriesNum, maxSeriesNum, "SSAVE");
        }
        if ("mr".equalsIgnoreCase(modality) && (renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("FULLBODY_AVERAGE"))) {
            return XpSaveUtil.findNextAvailableSeriesNumberByType(session, examUID, minSeriesNum, maxSeriesNum, "PJN");
        }
        return XpSaveUtil.findNextAvailableSeriesNumberByType(session, examUID, minSeriesNum, maxSeriesNum, "REFMT");
    }

    public static int nextSeriesNumberCT(XjDicomObject refImage, DMSession session) {
        System.out.println("XpSaveUtil.nextSeriesNumberCT()");
        String examUID = (String)refImage.getValue(32, 13);
        Object seriesNumObj = refImage.getValue(32, 17);
        int se_no = 1;
        if (seriesNumObj != null) {
            se_no = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : Integer.parseInt(seriesNumObj.toString().trim());
        }
        return XpSaveUtil.findNextAvailableSeriesNumberCT(session, examUID, 601, 699);
    }

    public static synchronized int findNextAvailableSeriesNumberCT(DMSession session, String examUID, int rangeBegin, int rangeEnd) {
        if (session == null || examUID == null) {
            throw new IllegalArgumentException("Session or examUID was null");
        }
        DMObject[] exams = session.getRelated("study", new DMQuery("(0x0020, 0x000D) = " + examUID));
        TreeSet<Integer> seriesNums = new TreeSet<Integer>();
        for (int i = 0; i < exams.length; ++i) {
            DMObject[] series = exams[i].getRelated("series");
            for (int j = 0; j < series.length; ++j) {
                Integer seriesNum;
                Object seriesNumObj = series[j].getValue(32, 17);
                if (seriesNumObj == null || (seriesNum = seriesNumObj instanceof Integer ? (Integer)seriesNumObj : new Integer(seriesNumObj.toString().trim())) < rangeBegin || seriesNum > rangeEnd) continue;
                seriesNums.add(seriesNum);
            }
        }
        if (reformatSeriesIDMap.containsKey(examUID)) {
            if (reformatSeriesIDMap.get(examUID) != null) {
                seriesNums.addAll((Collection)reformatSeriesIDMap.get(examUID));
            }
        } else {
            reformatSeriesIDMap.put(examUID, new ArrayList());
        }
        int seriesNum = rangeBegin;
        Iterator itr = seriesNums.iterator();
        while (itr.hasNext()) {
            int nextInt = (Integer)itr.next();
            if (seriesNum < nextInt) {
                return seriesNum;
            }
            seriesNum = nextInt + 1;
        }
        if (seriesNum > rangeEnd) {
            return rangeEnd;
        }
        reformatSeriesIDMap.get(examUID).add(seriesNum);
        return seriesNum;
    }

    private static class SaveThread
    extends Thread {
        private Thread prev;

        public SaveThread(Thread prev) {
            this.prev = prev;
        }

        @Override
        public void run() {
            if (this.prev != null && this.prev.isAlive()) {
                logger.log(Level.INFO, "Waiting for saving image processing thread to terminate");
                this.prev.interrupt();
                logger.log(Level.INFO, "Done");
            }
        }
    }
}

