/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.saveimage;

import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.saveimage.DicomDecorator;
import com.ge.med.cse.cvf.saveimage.XpDicomComposite;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.tagValue;

public class CTDicomCompositeFiller
implements DicomDecorator {
    private DicomComposite referenceComposite = null;
    private XpSaveParameters saveParams = null;

    @Override
    public void setReferenceComposite(DicomComposite referenceComposite) {
        this.referenceComposite = referenceComposite;
    }

    @Override
    public void setReferenceParameters(XpSaveParameters parsms) {
        this.saveParams = parsms;
    }

    @Override
    public void Decorate(XpDicomComposite xp) {
        xp.setValue(2, 16, "1.2.840.10008.1.2.1");
        xp.setValue(2, 18, DicomUtils.getImplementationClassUID("CT"));
        if (xp.getValue(24, 4144) == null) {
            xp.setValue(24, 4144, "Reformat");
        }
        tagValue tv1 = new tagValue(8, 4432);
        tv1.value = "1.2.840.10008.3.1.2.3.3";
        tagValue tv2 = new tagValue(8, 4437);
        tv2.value = this.saveParams.seriesUID + ".1";
        xp.setSequence(8, 4369, new Object[]{new tagValue[]{tv1, tv2}});
        if (xp.getValue(32, 17) != null) {
            xp.setValue(64, 595, xp.getValue(32, 17).toString());
        }
        xp.setValue(64, 597, "");
        String imageType = "DERIVED\\SECONDARY\\REFORMATTED";
        if (this.saveParams.renderStyle.equals("MAJOR_AXIS_AVERAGE") || this.saveParams.renderStyle.equals("AVERAGE")) {
            imageType = imageType + "\\AVERAGE";
        } else if (this.saveParams.renderStyle.equals("MAJOR_AXIS_MIP") || this.saveParams.renderStyle.equals("MIP")) {
            imageType = imageType + "\\MIP";
        } else if (this.saveParams.renderStyle.equals("MAJOR_AXIS_MINIP") || this.saveParams.renderStyle.equals("MINIP")) {
            imageType = imageType + "\\MINIP";
        } else if (this.saveParams.renderStyle.equals("FULLBODY_MIP")) {
            imageType = imageType + "\\FBMIP";
        } else if (this.saveParams.renderStyle.equals("FULLBODY_MINIP")) {
            imageType = imageType + "\\FBMINIP";
        } else if (this.saveParams.renderStyle.equals("FULLBODY_AVERAGE")) {
            imageType = imageType + "\\FBAVERAGE";
        } else if (this.saveParams.renderStyle.equals("VOLUME")) {
            imageType = "DERIVED\\SECONDARY\\3D";
        }
        xp.setValue(8, 8, imageType);
        xp.setValue(39, 16, "GEMS_IMAG_01");
        xp.setValue(67, 16, "GEMS_PARM_01");
        xp.setValue(25, 16, "GEMS_ACQU_01");
        xp.setValue(69, 16, "GEMS_HELIOS_01");
        xp.setValue(2, 3, xp.getValue(8, 24));
        XpSlice slice = this.saveParams.image.getSlice();
        short planeType = J3DGeomUtils.getPlaneType(slice);
        String sliceLocation = xp.getSliceLocation(slice, planeType);
        xp.setValue(32, 4161, sliceLocation);
        Object obj = xp.getValue(39, 4128);
        boolean copy_tag = false;
        if (obj != null) {
            copy_tag = Boolean.parseBoolean(obj.toString());
        }
        if (copy_tag) {
            xp.removeTag(24, 4433);
        } else {
            xp.removeTag(39, 4127);
        }
        if (this.saveParams.sliceSpacing < 0.0) {
            xp.removeTag(24, 136);
        } else {
            xp.setValue(24, 136, XpDicomComposite.formatDouble(this.saveParams.sliceSpacing));
        }
        xp.removeTag(24, 4882);
        xp.removeTag(25, 4120);
        xp.removeTag(25, 4121);
        xp.setValue(25, 4126, XpDicomComposite.formatDouble((double)slice.height * slice.pixelSizeY));
        xp.removeTag(25, 4286);
        xp.removeTag(33, 4151);
        xp.removeTag(37, 4103);
        xp.removeTag(37, 4121);
        xp.setValue(39, 4161, sliceLocation);
        xp.removeTag(39, 4168);
        xp.removeTag(39, 4169);
        xp.removeTag(39, 4170);
        xp.removeTag(39, 4171);
        xp.removeTag(39, 4172);
        xp.removeTag(39, 4173);
        xp.removeTag(39, 4172);
        xp.removeTag(39, 4173);
        xp.removeTag(8, 4416);
        xp.setValue(39, 4149, new Short(planeType));
        if (planeType == 2) {
            if (J3DGeomUtils.getSliceLocation(slice, planeType) < 0.0) {
                xp.setValue(39, 4160, "I");
            } else {
                xp.setValue(39, 4160, "S");
            }
        } else if (planeType == 4) {
            if (J3DGeomUtils.getSliceLocation(slice, planeType) < 0.0) {
                xp.setValue(39, 4160, "L");
            } else {
                xp.setValue(39, 4160, "R");
            }
        } else if (planeType == 8) {
            if (J3DGeomUtils.getSliceLocation(slice, planeType) < 0.0) {
                xp.setValue(39, 4160, "P");
            } else {
                xp.setValue(39, 4160, "A");
            }
        }
        if (this.saveParams.renderStyle.equals("FULLBODY_MIP") || this.saveParams.renderStyle.equals("FULLBODY_MINIP") || this.saveParams.renderStyle.equals("FULLBODY_AVERAGE")) {
            double[] rotationAngles = new double[3];
            J3DGeomUtils.rotationAnglesBetweenSlices(this.saveParams.inputSliceI, this.saveParams.inputSliceJ, this.saveParams.inputSliceN, slice.I, slice.J, slice.N, rotationAngles);
            xp.setValue(33, 4177, XpDicomComposite.formatDouble(rotationAngles[0]));
            xp.setValue(33, 4178, XpDicomComposite.formatDouble(rotationAngles[1]));
            xp.setValue(33, 4179, XpDicomComposite.formatDouble(rotationAngles[2]));
        }
        if (this.saveParams.renderStyle.equals("FULLBODY_MIP") || this.saveParams.renderStyle.equals("FULLBODY_MINIP") || this.saveParams.renderStyle.equals("FULLBODY_AVERAGE")) {
            xp.setValue(67, 4144, new Short(6));
        } else {
            xp.removeTag(67, 4144);
        }
    }
}

