/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.text.DecimalFormat;
import java.util.ResourceBundle;

public class CvPointRoi
extends XpStatisticsRoi {
    private static ResourceBundle res = CvUtils.getResourceBundle();
    private static final int HOT_SPOT = 5;
    private static Color SELECTED_COLOR = null;
    private static Color UNSELECTED_COLOR = null;
    private static Color HANDLE_COLOR = null;
    private static Color ROILABEL_COLOR = null;
    private static int ROILABEL_X = 0;
    private static int ROILABEL_Y = 0;
    private static Boolean DRAG_BY_ROILABEL = false;
    private transient Point2D containsTemp = new Point2D.Double();
    private static String hsf = null;
    private transient Shape pointshape = null;
    private transient int bounds = 0;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private int width = 0;
    private int height = 0;
    protected Point2D point_ = new Point2D.Double();
    private CPoint ras_pt = new CPoint(2);
    private double value = 0.0;
    private static final DecimalFormat dfe = new DecimalFormat("0.0");

    public CvPointRoi(double x, double y) {
        super(new Rectangle2D.Double(x, y, 0.0, 0.0));
        this.init(new Point2D.Double(x, y));
    }

    public CvPointRoi(double x, double y, double w, double h) {
        super(new Rectangle2D.Double(x, y, w, h));
        this.init(new Point2D.Double(x, y));
    }

    public CvPointRoi(double x, double y, double w, double h, Shape s) {
        super(new Rectangle2D.Double(x, y, w, h));
        this.pointshape = s;
        this.init(new Point2D.Double(x, y));
    }

    public CvPointRoi(double x, double y, Shape s) {
        super(new Rectangle2D.Double(x, y, 0.0, 0.0));
        this.pointshape = s;
        this.init(new Point2D.Double(x, y));
    }

    public CvPointRoi(Point2D pt) {
        this(pt.getX(), pt.getY());
    }

    public CvPointRoi(Point2D pt, Shape s) {
        this(pt.getX(), pt.getY(), s);
    }

    public void setPoint(Point2D pt) {
        if (pt != null) {
            this.point_.setLocation(pt);
            RectangularShape modelShape = (RectangularShape)this.getModelShape();
            modelShape.setFrame(this.point_.getX(), this.point_.getY(), modelShape.getWidth(), modelShape.getHeight());
            this.syncModel();
        }
    }

    private void init(Point2D pt) {
        HandleFactory f = new DefaultHandleFactory();
        if (pt != null) {
            this.point_.setLocation(pt);
            if (hsf != null && (f = CvUtils.createHandleFactory(hsf)) == null) {
                f = new DefaultHandleFactory();
            }
        }
        if (this.bounds == 0) {
            this.bounds = (int)f.getHandleBounds().getWidth();
        }
        if (this.pointshape == null) {
            this.pointshape = f.getPointHandleShape(HandleFactory.HandleStyle.POINTMARKER);
        }
        this.setDragByRoiLabel(DRAG_BY_ROILABEL);
    }

    private static void setPointRoiProperties() {
        hsf = CvPropertiesManager.getProperty("cvf.Handle.Factory");
        HandleFactory f = null;
        if (hsf != null) {
            f = CvUtils.createHandleFactory(hsf);
            if (f == null) {
                f = new DefaultHandleFactory();
            }
        } else {
            f = new DefaultHandleFactory();
        }
        HANDLE_COLOR = f.getHandleColor();
        SELECTED_COLOR = f.getHandleSelectedColor();
        UNSELECTED_COLOR = f.getHandleUnSelectedColor();
        String val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.Color");
        ROILABEL_COLOR = val != null ? CvUtils.getColor(val) : HANDLE_COLOR;
        val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.x");
        if (val != null) {
            ROILABEL_X = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.y")) != null) {
            ROILABEL_Y = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.dragByRoiLabel", "false")) != null) {
            DRAG_BY_ROILABEL = Boolean.valueOf(val);
        }
    }

    @Override
    public Object clone() {
        Rectangle2D rs = (Rectangle2D)this.getModelShape();
        double x = rs.getX();
        double y = rs.getY();
        Point2D.Double pt = new Point2D.Double(x, y);
        CvPointRoi pointRoi = new CvPointRoi(pt);
        this.copyObject(pointRoi);
        return pointRoi;
    }

    @Override
    protected void copyObject(Object o) {
        CvPointRoi aPtroi = (CvPointRoi)o;
        super.copyObject(o);
        aPtroi.setDragByRoiLabel(this.isDragByRoiLabel());
    }

    @Override
    public Shape getDrawShape() {
        return this.pointshape;
    }

    private void updateStats() {
        if (this.getImage() != null) {
            CTransform i2r = this.getImage().getSlice().getImageToRasTransform();
            i2r.transform(new CPoint(this.point_, 0), this.ras_pt);
            this.value = this.getValue(this.point_.getX(), this.point_.getY());
        }
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g) {
        Point2D.Double tmpPoint1 = new Point2D.Double();
        this.getDisplayPoint(this.point_, tmpPoint1);
        double t_x = ((Point2D)tmpPoint1).getX();
        double t_y = ((Point2D)tmpPoint1).getY();
        this.updateStats();
        g.translate(t_x, t_y);
        super.render(vc, g);
        g.translate(-t_x, -t_y);
        Color saveColor = g.getColor();
        if (this.isGrayScaleMode() || XpAppContext.isShadowed()) {
            g.setColor(Color.black);
            g.translate(1, 1);
            g.drawLine((int)t_x, (int)t_y, (int)t_x, (int)t_y);
            g.translate(-1, -1);
        }
        if (this.isGrayScaleMode()) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(this.isSelected() ? XpAppContext.getSelectedColor() : XpAppContext.getUnSelectedColor());
        }
        g.drawLine((int)t_x, (int)t_y, (int)t_x, (int)t_y);
        g.setColor(saveColor);
        this.drawRoiId(g, t_x - (double)this.bounds - 10.0, t_y - 3.0);
    }

    @Override
    protected void drawRoiId(Graphics2D g, double x, double y) {
        Color c = g.getColor();
        if (this.isGrayScaleMode()) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(ROILABEL_COLOR);
        }
        super.drawRoiId(g, x, y, this.isGrayScaleMode());
        g.setColor(c);
    }

    @Override
    public final void dragMouse(CPoint dragV) {
        this.translate(dragV.x, dragV.y);
        RectangularShape modelShape = (RectangularShape)this.getModelShape();
        modelShape.setFrame(this.point_.getX(), this.point_.getY(), modelShape.getWidth(), modelShape.getHeight());
        this.syncModel();
    }

    private void translate(double tx, double ty) {
        Point2D ap = (Point2D)this.point_.clone();
        ap.setLocation(ap.getX() + tx, ap.getY() + ty);
        double x = ap.getX();
        double y = ap.getY();
        if (x < 0.0 || x >= (double)this.width) {
            return;
        }
        if (y < 0.0 || y >= (double)this.height) {
            return;
        }
        this.point_.setLocation(ap);
    }

    @Override
    public final void setImage(XpImage img) {
        super.setImage(img);
        if (img != null) {
            this.rescaleSlope = img.getRescaleSlope();
            this.rescaleIntercept = img.getRescaleIntercept();
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
        }
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        Rectangle2D bounds;
        if (vc == null) {
            return false;
        }
        if (this.isDragByRoiLabel() && (bounds = this.getRoiLabelBounds()) != null && bounds.contains(x, y)) {
            return true;
        }
        this.getDisplayPoint(this.point_, this.containsTemp);
        double xx = this.containsTemp.getX();
        double yy = this.containsTemp.getY();
        return Math.abs(xx - (double)x) <= (double)(this.bounds + 5) && Math.abs(yy - (double)y) <= (double)(this.bounds + 5);
    }

    @Override
    public String createRoiStatLabel(XpPixelStatistics ps) {
        if (ps == null) {
            return "";
        }
        String R2 = "R";
        String A2 = "A";
        String S2 = "S";
        String V = "V";
        XpImage image = this.getImage();
        if (image == null) {
            return null;
        }
        this.updateStats();
        double r = this.ras_pt.x;
        double a = this.ras_pt.y;
        double s = this.ras_pt.z;
        if (r < 0.0) {
            r = -r;
            R2 = "L";
        }
        if (a < 0.0) {
            a = -a;
            A2 = "P";
        }
        if (s < 0.0) {
            s = -s;
            S2 = "I";
        }
        String roiStat = this.getRoiLabel() + ": " + R2 + dfe.format(r) + " " + A2 + dfe.format(a) + " " + S2 + dfe.format(s) + " " + V + dfe.format(this.value);
        return roiStat;
    }

    public double getValue(double x, double y) {
        Raster raster = null;
        double value = 0.0;
        XpImage mi = this.getImage();
        if (mi != null) {
            this.width = mi.getSlice().width;
            RenderedImage ri = mi.getPixelData();
            raster = ri instanceof BufferedImage ? ((BufferedImage)ri).getRaster() : ri.getData();
        }
        if (raster != null) {
            try {
                int ix = (int)x;
                int iy = (int)y;
                DataBuffer db = raster.getDataBuffer();
                if (db instanceof DataBufferUShort) {
                    short[] data = ((DataBufferUShort)db).getData();
                    short val = data[iy * this.width + ix];
                    value = val;
                } else if (db instanceof DataBufferUShort) {
                    short[] data = ((DataBufferUShort)db).getData();
                    value = data[iy * this.width + ix];
                } else if (db instanceof DataBufferByte) {
                    byte[] data = ((DataBufferByte)db).getData();
                    value = data[iy * this.width + ix];
                } else if (db instanceof DataBufferInt) {
                    int[] data = ((DataBufferInt)db).getData();
                    value = data[iy * this.width + ix] & 0xFF;
                }
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                value = 0.0;
            }
        }
        value = this.rescaleSlope * value + this.rescaleIntercept;
        return value;
    }

    public double getValue() {
        return this.value;
    }

    public CPoint getRAS() {
        return this.ras_pt;
    }

    @Override
    public final GSPSGraphic gspsDescription() {
        Point2D[] pts = new Point2D[]{new Point2D.Double(this.point_.getX(), this.point_.getY()), new Point2D.Double(this.point_.getX() + 1.0, this.point_.getY()), new Point2D.Double(this.point_.getX() + 1.0, this.point_.getY() + 1.0), new Point2D.Double(this.point_.getX(), this.point_.getY() + 1.0)};
        RectangularShape rs = (RectangularShape)this.getModelShape();
        XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
        return description;
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        return new PointRoiCreator();
    }

    static {
        CvPointRoi.setPointRoiProperties();
        XpHandle.setHandleColor(HANDLE_COLOR);
        XpAppContext.setSelectedColor(SELECTED_COLOR);
        XpAppContext.setUnSelectedColor(UNSELECTED_COLOR);
        XpAppContext.setShadowed(true);
    }

    static class PointRoiCreator
    extends XpRoiComponentCreator {
        PointRoiCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x, double y) {
            return new CvPointRoi(x, y);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            XpImage img = ((FrameOwner)((Object)((XpVisualComponent)me.getSource()))).getFrame();
            if (!CvUtils.measurementsValid(img)) {
                return;
            }
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            if (mbutton1 != 0) {
                super.mousePressed(me);
            } else {
                XpVisualComponent jc = (XpVisualComponent)me.getSource();
                ROICapable rc = (ROICapable)this.getComponentCapable(jc);
                this.shutdown(rc);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            if (mbutton1 != 0) {
                super.mouseReleased(me);
            } else {
                XpVisualComponent jc = (XpVisualComponent)me.getSource();
                ROICapable rc = (ROICapable)this.getComponentCapable(jc);
                this.shutdown(rc);
            }
        }
    }
}

