/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.CPISerializable;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CvImageGrid
extends XpRoiHandleContainer
implements Replicable,
GrayScaleCapable,
CPISerializable {
    private static final String DOTTEDLINE = "DOTTED";
    private static double GRIDSPACING = 30.0;
    private static double TICKSPACING = 10.0;
    private static double TICKLENGTH = 5.0;
    private static boolean GRIDLINES_ON = true;
    private static String LINESTYLE = "DOTTED";
    private static final DecimalFormat df = new DecimalFormat("0.0");
    private static Shape MOVE_HANDLE_SHAPE = null;
    private static Shape CONTAINMENT_SHAPE = null;
    private static float[] dashPattern = new float[]{2.0f, 1.0f, 2.0f, 1.0f};
    private static BasicStroke dottedStrk = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
    private CPoint imCenterPoint = new CPoint(0);
    private XpHandle moveHandle = null;
    private boolean selected = true;
    private boolean showHandle = false;
    private byte handleCoordSys = 0;
    private Color col = Color.WHITE;
    private boolean first = true;
    private double _centerX = 0.0;
    private double _centerY = 0.0;
    private int _xTextOffset = 0;
    private int _yTextOffset = 0;
    private CPoint[] _polyLine = null;
    private CPoint[] _axis = null;
    private CPoint[] _text = null;
    private CPoint[] _tickLine = null;
    private String[] _textValue = null;
    private CPoint oneImageTick = new CPoint(0);
    private CPoint oneImageGrid = new CPoint(0);
    private CPoint imageTickDelta = new CPoint(0);
    private CPoint oneDispTick = new CPoint(1);
    private CPoint oneDispGrid = new CPoint(1);
    private CPoint dispTickDelta = new CPoint(1);
    private CPoint p1 = new CPoint(1);
    private CPoint p2 = new CPoint(1);
    private CPoint p3 = new CPoint(1);
    private CPoint p4 = new CPoint(1);
    private CPoint disp = new CPoint(1);
    private CPoint imp = new CPoint(0);
    private transient XpImage theImage = null;
    private boolean grayscaleMode = false;
    private static final int HOT_SPOT = 5;

    public CvImageGrid() {
    }

    public CvImageGrid(boolean showHandle, byte coordSys) {
        this.showHandle = showHandle;
        this.handleCoordSys = coordSys;
        if (this.showHandle) {
            this.moveHandle = new XpHandle(this, 0, 16, coordSys);
            this.moveHandle.setShape(MOVE_HANDLE_SHAPE, CONTAINMENT_SHAPE);
            this.moveHandle.setFilled(true);
            this.add(this.moveHandle);
        }
    }

    private static void createHandleShape() {
        String val = CvPropertiesManager.getProperty("cvf.Handle.Factory");
        HandleFactory factory = null;
        if (val != null) {
            factory = CvUtils.createHandleFactory(val);
            if (factory == null) {
                factory = new DefaultHandleFactory();
            }
        } else {
            factory = new DefaultHandleFactory();
        }
        XpHandle.setHandleColor(factory.getHandleColor());
        XpAppContext.setSelectedColor(factory.getHandleSelectedColor());
        XpAppContext.setUnSelectedColor(factory.getHandleUnSelectedColor());
        XpAppContext.setShadowed(true);
        MOVE_HANDLE_SHAPE = factory.getMoveHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
        CONTAINMENT_SHAPE = factory.getContainmentShape();
    }

    @Override
    public void setImage(XpImage image) {
        this.theImage = image;
    }

    @Override
    public XpImage getImage() {
        return this.theImage;
    }

    private void initPaint(XpVisualComponent vc) {
        int i;
        CPoint zero = vc.transform(new CPoint(0, 0, 0, 0), (byte)2);
        double _pixelSizeX = vc.transform(new CPoint(1, 0, 0, 0), (byte)2).sub(zero).length();
        double _pixelSizeY = vc.transform(new CPoint(0, 1, 0, 0), (byte)2).sub(zero).length();
        this._yTextOffset = 0;
        this._xTextOffset = 0;
        int vp_w = vc.getWidth();
        int vp_h = vc.getHeight();
        if (this.first) {
            this._centerX = (double)vc.getWidth() * 0.5;
            this._centerY = (double)vc.getHeight() * 0.5;
            this.disp.setLocation(this._centerX, this._centerY, 0.0);
            vc.transform(this.disp, this.imp, (byte)0);
            this.imCenterPoint.set(this.imp);
            this.first = false;
        } else {
            this.imp.setLocation(this.imCenterPoint.x, this.imCenterPoint.y, this.imCenterPoint.z);
            vc.transform(this.imp, this.disp, (byte)1);
            this._centerX = this.disp.x;
            this._centerY = this.disp.y;
        }
        this.oneImageTick.setLocation(TICKSPACING / _pixelSizeX, TICKSPACING / _pixelSizeY, 0.0);
        vc.transform(this.oneImageTick, this.oneDispTick, (byte)1);
        this.oneImageGrid.setLocation(GRIDSPACING / _pixelSizeX, GRIDSPACING / _pixelSizeY, 0.0);
        vc.transform(this.oneImageGrid, this.oneDispGrid, (byte)1);
        this.imageTickDelta.setLocation(TICKLENGTH / 2.0 / _pixelSizeX, TICKLENGTH / 2.0 / _pixelSizeY, 0.0);
        vc.transform(this.imageTickDelta, this.dispTickDelta, (byte)1);
        CPoint disp_zero = new CPoint(0, 0, 0, 1);
        CPoint ras_zero = new CPoint(2);
        vc.transform(disp_zero, ras_zero, (byte)2);
        CPoint dispx = new CPoint(1, 0, 0, 1);
        CPoint ras1 = new CPoint(2);
        vc.transform(dispx, ras1, (byte)2);
        CPoint dispy = new CPoint(0, 1, 0, 1);
        CPoint ras2 = new CPoint(2);
        vc.transform(dispy, ras2, (byte)2);
        CPoint rasunit_xdir = new CPoint(2);
        rasunit_xdir.sub(ras1, ras_zero);
        rasunit_xdir.normalize();
        vc.transform(rasunit_xdir, dispx, (byte)1);
        CPoint rasunit_ydir = new CPoint(2);
        rasunit_ydir.sub(ras2, ras_zero);
        rasunit_ydir.normalize();
        vc.transform(rasunit_ydir, dispy, (byte)1);
        ras_zero.set(0.0, 0.0, 0.0);
        vc.transform(ras_zero, disp_zero, (byte)1);
        double dx = dispx.sub(disp_zero).length();
        double dy = dispy.sub(disp_zero).length();
        double cmWidth_o = Math.abs(dx * GRIDSPACING);
        double cmHeight_o = Math.abs(dy * GRIDSPACING);
        double cmTHeight = Math.abs(dy * TICKSPACING);
        double cmTWidth = Math.abs(dx * TICKSPACING);
        double tickDeltaX = Math.abs(dx * TICKLENGTH / 2.0);
        double tickDeltaY = Math.abs(dy * TICKLENGTH / 2.0);
        double _zoom = 0.0;
        double zoom = 0.0;
        int _numberOfPolyLines = 0;
        int _numberOfTickLines = 0;
        int _numberOfTexts = 0;
        int _numberOfAxis = 0;
        _zoom = cmWidth_o / this.oneImageGrid.x;
        zoom = _zoom + 0.01 < 1.0 ? 1.0 / (Math.floor(2.0 / _zoom) + 1.0) : Math.floor(_zoom / 4.0) + 1.0;
        double cmWidth = cmWidth_o / zoom;
        int nbOfCmW = (int)Math.floor((double)vp_w / cmWidth);
        double cmHeight = cmHeight_o / zoom;
        int nbOfCmH = (int)Math.floor((double)vp_h / cmHeight);
        int nbOfCmTH = (int)Math.floor((double)vp_h / cmTHeight);
        int nbOfCmTW = (int)Math.floor((double)vp_w / cmTWidth);
        double height_2 = (double)vp_h / 2.0;
        double width_2 = (double)vp_w / 2.0;
        this.initLines(nbOfCmW, nbOfCmH, nbOfCmTW, nbOfCmTH);
        double x = this._centerX;
        double y1 = this._centerY - height_2;
        double y2 = this._centerY + height_2;
        this.p1.setLocation(x, y1, 0.0);
        this.p2.setLocation(x, y2, 0.0);
        this._axis[0] = this.p1;
        this._axis[1] = this.p2;
        ++_numberOfAxis;
        double y = this._centerY;
        double x1 = this._centerX - width_2;
        double x2 = this._centerX + width_2;
        this.p3.setLocation(x1, y, 0.0);
        this.p4.setLocation(x2, y, 0.0);
        this._axis[2] = this.p3;
        this._axis[3] = this.p4;
        ++_numberOfAxis;
        for (i = 1; i <= (int)Math.floor((double)nbOfCmW / 2.0); ++i) {
            x1 = this._centerX + (double)i * cmWidth;
            x2 = this._centerX - (double)i * cmWidth;
            y1 = this._centerY - height_2;
            y2 = this._centerY + height_2;
            this._polyLine[_numberOfPolyLines].setLocation(x1, y1, 0.0);
            this._polyLine[_numberOfPolyLines + 1].setLocation(x1, y2, 0.0);
            _numberOfPolyLines += 2;
            double value = GRIDSPACING * (double)i / (10.0 * zoom);
            this._textValue[_numberOfTexts] = df.format(value);
            this._text[_numberOfTexts].setLocation(this.doubleToint(x1) + this._xTextOffset, this.doubleToint(this._centerY) - this._yTextOffset, 0.0);
            ++_numberOfTexts;
            this._polyLine[_numberOfPolyLines].setLocation(x2, y1, 0.0);
            this._polyLine[_numberOfPolyLines + 1].setLocation(x2, y2, 0.0);
            _numberOfPolyLines += 2;
            double value1 = GRIDSPACING * (double)i / (-10.0 * zoom);
            this._textValue[_numberOfTexts] = df.format(value1);
            this._text[_numberOfTexts].setLocation(this.doubleToint(x2) + this._xTextOffset, this.doubleToint(this._centerY) - this._yTextOffset, 0.0);
            ++_numberOfTexts;
        }
        for (i = 1; i <= (int)Math.floor((double)nbOfCmH / 2.0); ++i) {
            x1 = this._centerX - width_2;
            x2 = this._centerX + width_2;
            y1 = this._centerY + (double)i * cmHeight;
            y2 = this._centerY - (double)i * cmHeight;
            this._polyLine[_numberOfPolyLines].setLocation(x1, y1, 0.0);
            this._polyLine[_numberOfPolyLines + 1].setLocation(x2, y1, 0.0);
            _numberOfPolyLines += 2;
            double value2 = GRIDSPACING * (double)i / (-10.0 * zoom);
            this._textValue[_numberOfTexts] = df.format(value2);
            this._text[_numberOfTexts].setLocation(this.doubleToint(this._centerX) + this._xTextOffset, this.doubleToint(y1) - this._yTextOffset, 0.0);
            ++_numberOfTexts;
            this._polyLine[_numberOfPolyLines].setLocation(x1, y2, 0.0);
            this._polyLine[_numberOfPolyLines + 1].setLocation(x2, y2, 0.0);
            _numberOfPolyLines += 2;
            double value3 = GRIDSPACING * (double)i / (10.0 * zoom);
            this._textValue[_numberOfTexts] = df.format(value3);
            this._text[_numberOfTexts].setLocation(this.doubleToint(this._centerX) + this._xTextOffset, this.doubleToint(y2) - this._yTextOffset, 0.0);
            ++_numberOfTexts;
        }
        for (i = 1; i <= (int)Math.floor((double)nbOfCmTH / 2.0); ++i) {
            x1 = this._centerX - tickDeltaX;
            x2 = this._centerX + tickDeltaX;
            y1 = this._centerY + (double)i * cmTHeight;
            y2 = this._centerY - (double)i * cmTHeight;
            this._tickLine[_numberOfTickLines].setLocation(x1, y1, 0.0);
            this._tickLine[_numberOfTickLines + 1].setLocation(x2, y1, 0.0);
            this._tickLine[_numberOfTickLines += 2].setLocation(x1, y2, 0.0);
            this._tickLine[_numberOfTickLines + 1].setLocation(x2, y2, 0.0);
            _numberOfTickLines += 2;
        }
        for (i = 1; i <= (int)Math.floor((double)nbOfCmTW / 2.0); ++i) {
            y1 = this._centerY - tickDeltaY;
            y2 = this._centerY + tickDeltaY;
            x1 = this._centerX + (double)i * cmTWidth;
            x2 = this._centerX - (double)i * cmTWidth;
            this._tickLine[_numberOfTickLines].setLocation(x1, y1, 0.0);
            this._tickLine[_numberOfTickLines + 1].setLocation(x1, y2, 0.0);
            this._tickLine[_numberOfTickLines += 2].setLocation(x2, y1, 0.0);
            this._tickLine[_numberOfTickLines + 1].setLocation(x2, y2, 0.0);
            _numberOfTickLines += 2;
        }
    }

    public void initLines(int nbOfCmW, int nbOfCmH, int nbOfCmTW, int nbOfCmTH) {
        int i;
        this._polyLine = null;
        this._text = null;
        this._axis = null;
        this._tickLine = null;
        this._polyLine = new CPoint[((int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2) * 2];
        for (i = 0; i < this._polyLine.length; ++i) {
            this._polyLine[i] = new CPoint(1);
        }
        this._axis = new CPoint[4];
        for (i = 0; i < this._axis.length; ++i) {
            this._axis[i] = new CPoint(1);
        }
        this._text = new CPoint[(int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2];
        this._textValue = new String[(int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2];
        for (i = 0; i < this._text.length; ++i) {
            this._text[i] = new CPoint(1);
            this._textValue[i] = new String();
        }
        this._tickLine = new CPoint[((int)(Math.floor((double)nbOfCmTW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmTH / 2.0) * 2.0) + 2) * 2];
        for (i = 0; i < this._tickLine.length; ++i) {
            this._tickLine[i] = new CPoint(1);
        }
    }

    @Override
    public void paintShape(XpVisualComponent vc, Graphics2D g) {
        int i;
        Graphics2D g2 = g;
        if (this.isGrayScaleMode()) {
            g2.setColor(Color.WHITE);
        } else {
            g2.setColor(this.col);
        }
        this.initPaint(vc);
        if (this.isGrayScaleMode() || XpAppContext.isShadowed()) {
            int i2;
            Color prev = g.getColor();
            g.setColor(Color.black);
            g.translate(1, 1);
            if (GRIDLINES_ON) {
                for (i2 = 0; i2 < this._polyLine.length; i2 += 2) {
                    this.drawLine(g2, this._polyLine[i2], this._polyLine[i2 + 1], 0);
                }
            }
            for (i2 = 0; i2 <= this._axis.length - 2; i2 += 2) {
                this.drawLine(g2, this._axis[i2], this._axis[i2 + 1], 0);
            }
            for (i2 = 0; i2 < this._tickLine.length - 2; i2 += 2) {
                this.drawLine(g2, this._tickLine[i2], this._tickLine[i2 + 1], 0);
            }
            for (i2 = 0; i2 < this._text.length; ++i2) {
                g.drawString(this._textValue[i2], (int)this._text[i2].x, (int)this._text[i2].y);
            }
            g.translate(-1, -1);
            g.setColor(prev);
        }
        if (GRIDLINES_ON) {
            for (int i3 = 0; i3 < this._polyLine.length; i3 += 2) {
                this.drawLine(g2, this._polyLine[i3], this._polyLine[i3 + 1], 0);
            }
        }
        for (i = 0; i <= this._axis.length - 2; i += 2) {
            this.drawLine(g2, this._axis[i], this._axis[i + 1], 0);
        }
        for (i = 0; i < this._tickLine.length - 2; i += 2) {
            this.drawLine(g2, this._tickLine[i], this._tickLine[i + 1], 0);
        }
        for (i = 0; i < this._text.length; ++i) {
            g.drawString(this._textValue[i], (int)this._text[i].x, (int)this._text[i].y);
        }
        if (this.showHandle) {
            this.disp.setLocation(this._centerX, this._centerY, 0.0);
            CPoint pt = new CPoint(this.handleCoordSys);
            vc.transform(this.disp, pt, this.handleCoordSys);
            this.setAnchorPoint(pt.x, pt.y, pt.z);
        }
    }

    private int doubleToint(double x) {
        int val = (int)Math.floor(x + 0.5);
        return val;
    }

    public static void setLineStyle(String style) {
        LINESTYLE = style;
    }

    public static void setGridLinesOn(boolean gridON) {
        GRIDLINES_ON = gridON;
    }

    public static void setGridSpacing(double grSpacing) {
        GRIDSPACING = grSpacing;
    }

    public static void setTickSpacing(double tkSpacing) {
        TICKSPACING = tkSpacing;
    }

    public static void setTickLength(double tkLength) {
        TICKLENGTH = tkLength;
    }

    public static String getLineStyle() {
        return LINESTYLE;
    }

    public static boolean getGridLinesOn() {
        return GRIDLINES_ON;
    }

    public static double getGridSpacing() {
        return GRIDSPACING;
    }

    public static double getTickSpacing() {
        return TICKSPACING;
    }

    public static double getTickLength() {
        return TICKLENGTH;
    }

    private void drawLine(Graphics2D g, CPoint p0, CPoint p1, int offset) {
        if (LINESTYLE.equalsIgnoreCase(DOTTEDLINE)) {
            g.setStroke(dottedStrk);
        }
        g.drawLine(offset + (int)p0.x, offset + (int)p0.y, offset + (int)p1.x, offset + (int)p1.y);
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag1, Object source) {
        XpVisualComponent vc = (XpVisualComponent)e.getSource();
        CPoint drag = new CPoint(1);
        vc.transform(drag1, drag, (byte)1);
        CPoint zero = new CPoint(0, 0, 0, drag1.csystem);
        CPoint drag_0 = new CPoint();
        vc.transform(zero, drag_0, (byte)1);
        drag.sub(drag_0);
        double newCenterX = this._centerX + drag.x;
        double newCenterY = this._centerY + drag.y;
        if (newCenterX > 0.0 && newCenterX < (double)vc.getWidth() && newCenterY > 0.0 && newCenterY < (double)vc.getHeight()) {
            double dy1;
            double dx1;
            double dy;
            double dx;
            int i;
            this._centerX = newCenterX;
            this._centerY = newCenterY;
            this.disp.setLocation(this._centerX, this._centerY, 0.0);
            vc.transform(this.disp, this.imCenterPoint, (byte)0);
            double x1 = drag.x;
            double y1 = drag.y;
            for (i = 0; i < this._polyLine.length; i += 2) {
                dx = this._polyLine[i].point2D().getX() + x1;
                dy = this._polyLine[i].point2D().getY() + y1;
                this._polyLine[i].set(dx, dy, 0.0);
                dx1 = this._polyLine[i + 1].point2D().getX() + x1;
                dy1 = this._polyLine[i + 1].point2D().getY() + y1;
                this._polyLine[i + 1].set(dx1, dy1, 0.0);
            }
            for (i = 0; i <= this._axis.length - 2; i += 2) {
                dx = this._axis[i].point2D().getX() + x1;
                dy = this._axis[i].point2D().getY() + y1;
                this._axis[i].set(dx, dy, 0.0);
                dx1 = this._axis[i + 1].point2D().getX() + x1;
                dy1 = this._axis[i + 1].point2D().getY() + y1;
                this._axis[i + 1].set(dx1, dy1, 0.0);
            }
            for (i = 0; i < this._tickLine.length - 2; i += 2) {
                dx = this._tickLine[i].point2D().getX() + x1;
                dy = this._tickLine[i].point2D().getY() + y1;
                this._tickLine[i].set(dx, dy, 0.0);
                dx1 = this._tickLine[i + 1].point2D().getX() + x1;
                dy1 = this._tickLine[i + 1].point2D().getY() + y1;
                this._tickLine[i + 1].set(dx1, dy1, 0.0);
            }
            for (i = 0; i < this._text.length; ++i) {
                dx = this._text[i].point2D().getX() + x1;
                dy = this._text[i].point2D().getY() + y1;
                this._text[i].set(dx, dy, 0.0);
            }
        }
        vc.repaint();
    }

    @Override
    public void anchorPressed(MouseEvent e, Object source) {
        this.setColor(Color.cyan);
    }

    @Override
    public void anchorReleased(MouseEvent e, Object source) {
        this.setColor(Color.white);
    }

    public void setColor(Color c) {
        this.col = c;
    }

    private void setAnchorPoint(double x, double y, double z) {
        this.get(0).setLocation(x, y, z);
    }

    @Override
    public void setSelected(boolean selection) {
        this.selected = selection;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int xx, int yy) {
        return (double)xx >= this._centerX - 5.0 && (double)xx <= this._centerX + 5.0 && (double)yy >= this._centerY - 5.0 && (double)yy <= this._centerY + 5.0;
    }

    public CPoint[] getGridLines() {
        return (CPoint[])this._polyLine.clone();
    }

    public CPoint[] getTickLines() {
        return (CPoint[])this._tickLine.clone();
    }

    @Override
    public Object clone() {
        CvImageGrid ig = new CvImageGrid(this.showHandle, this.handleCoordSys);
        ig.imCenterPoint = this.getCenter();
        ig.first = false;
        return ig;
    }

    public CPoint getCenter() {
        return (CPoint)this.imCenterPoint.clone();
    }

    @Override
    public boolean isGrayScaleMode() {
        return this.grayscaleMode;
    }

    @Override
    public void setGrayScaleMode(boolean g) {
        this.grayscaleMode = g;
    }

    @Override
    public String getCPIInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + this.getClass().getName() + " csystem=\"" + this.handleCoordSys + "\"" + " showHandle=\"" + this.showHandle + "\"" + " imCP_csystem=\"" + this.imCenterPoint.csystem + "\"" + " imCP_x=\"" + this.imCenterPoint.x + "\"" + " imCP_y=\"" + this.imCenterPoint.y + "\"" + " imCP_z=\"" + this.imCenterPoint.z + "\"" + " glOn=\"" + CvImageGrid.getGridLinesOn() + "\"" + " ls=\"" + CvImageGrid.getLineStyle() + "\"" + " gs=\"" + CvImageGrid.getGridSpacing() + "\"" + " ts=\"" + CvImageGrid.getTickSpacing() + "\"" + " tl=\"" + CvImageGrid.getTickLength() + "\"/>");
        return buf.toString();
    }

    public static CvImageGrid createVC(String info) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(info)));
            Element elem = doc.getDocumentElement();
            byte csystem = Byte.parseByte(elem.getAttribute("csystem"));
            boolean showHandle = Boolean.parseBoolean(elem.getAttribute("showHandle"));
            byte imCP_csystem = Byte.parseByte(elem.getAttribute("imCP_csystem"));
            double imCP_x = Double.parseDouble(elem.getAttribute("imCP_x"));
            double imCP_y = Double.parseDouble(elem.getAttribute("imCP_y"));
            double imCP_z = Double.parseDouble(elem.getAttribute("imCP_z"));
            boolean glOn = Boolean.parseBoolean(elem.getAttribute("glOn"));
            String ls = elem.getAttribute("ls");
            double gs = Double.parseDouble(elem.getAttribute("gs"));
            double ts = Double.parseDouble(elem.getAttribute("ts"));
            double tl = Double.parseDouble(elem.getAttribute("tl"));
            System.out.println("creating CvImageGrid(" + csystem + ", " + showHandle + ", " + glOn + "," + ls + "," + gs + "," + ts + "," + tl + ")");
            CvImageGrid grid = new CvImageGrid(showHandle, csystem);
            grid.imCenterPoint = new CPoint(imCP_x, imCP_y, imCP_z, imCP_csystem);
            grid.first = false;
            CvImageGrid.setGridSpacing(gs);
            CvImageGrid.setTickSpacing(ts);
            CvImageGrid.setTickLength(tl);
            CvImageGrid.setLineStyle(ls);
            CvImageGrid.setGridLinesOn(glOn);
            return grid;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        CvImageGrid.createHandleShape();
        XpAppContext.setShadowed(true);
    }
}

