/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.plugins;

import com.ge.med.cse.cvf.plugins.CvPlugInsBuilder;
import com.ge.med.cse.cvf.plugins.CvPlugin;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CvPlugInManager {
    private static HashMap<String, CvPlugin> cachedPlugIn = new HashMap();
    private static HashMap<String, PluginDescriptor> plugInREgistry = new HashMap();
    static final String plugInDirectory = CvPropertiesManager.getProperty("plugins.dir", System.getProperty("user.home") + File.separator + "Unified2D" + File.separator + "plugins");
    static CvPlugInManager instance = new CvPlugInManager();

    public void getPlugins() {
        FilenameFilter filter;
        File allFiles;
        String[] files;
        File pluginsDir;
        boolean ispluginLoad = CvUtils.isPluginLoad();
        if (plugInDirectory != null && ispluginLoad && (pluginsDir = new File(plugInDirectory)).exists() && (files = (allFiles = new File(plugInDirectory)).list(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) != null) {
            for (int i = 0; i < files.length; ++i) {
                String plugInJarpath = plugInDirectory + File.separator + files[i];
                File plugInFile = new File(plugInJarpath);
                if (!CvPlugInsBuilder.validateCvPluginSignature(plugInFile)) continue;
                String countVal = CvPlugInsBuilder.getPluginFileAttribute(plugInFile, "CvPlugin_count", false);
                int count = countVal != null ? Integer.parseInt(countVal) : 1;
                for (int plugin = 0; plugin < count; ++plugin) {
                    String pluginStr = countVal != null ? "_" + plugin : "";
                    String classname = CvPlugInsBuilder.getPluginFileAttribute(plugInFile, "CvPlugin" + pluginStr + "_classname", false);
                    String name = CvPlugInsBuilder.getPluginFileAttribute(plugInFile, "CvPlugin" + pluginStr + "_name", false);
                    if (classname == null || name == null) continue;
                    String iconPath = CvPlugInsBuilder.getPluginFileAttribute(plugInFile, "CvPlugin" + pluginStr + "_iconpath", false);
                    String description = CvPlugInsBuilder.getPluginFileAttribute(plugInFile, "CvPlugin" + pluginStr + "_description", true);
                    String target = CvPlugInsBuilder.getPluginFileAttribute(plugInFile, "CvPlugin" + pluginStr + "_extensions", false);
                    String dependency = CvPlugInsBuilder.getPluginFileAttribute(plugInFile, "CvPlugin" + pluginStr + "_dependency", false);
                    String i18nName = CvPlugInsBuilder.getPluginFileAttribute(plugInFile, "CvPlugin" + pluginStr + "_name", true);
                    PluginDescriptor descriptor = new PluginDescriptor();
                    descriptor.description = description;
                    descriptor.iconPath = iconPath;
                    descriptor.pluginJarFilePlath = plugInFile.getAbsolutePath();
                    descriptor.name = name;
                    descriptor.extensions = target != null ? target.split(",") : null;
                    descriptor.dependency = dependency;
                    descriptor.classname = classname;
                    descriptor.i18Nname = i18nName;
                    plugInREgistry.put(name, descriptor);
                }
            }
        }
    }

    public static String getPluginDirectory() {
        return plugInDirectory;
    }

    private CvPlugInManager() {
    }

    public static CvPlugInManager getInstace() {
        return instance;
    }

    public String[] getPluginNameForExtension(String target) {
        ArrayList<String> answer = new ArrayList<String>();
        Iterator<String> nameIterator = plugInREgistry.keySet().iterator();
        while (nameIterator.hasNext()) {
            PluginDescriptor element = plugInREgistry.get(nameIterator.next());
            if (element.extensions == null || !Arrays.asList(element.extensions).contains(target)) continue;
            answer.add(element.name);
        }
        return answer.toArray(new String[answer.size()]);
    }

    public String getPluigin18NName(String name) {
        if (plugInREgistry.get(name) != null) {
            return CvPlugInManager.plugInREgistry.get((Object)name).i18Nname;
        }
        return null;
    }

    public String getPluginDescription(String name) {
        if (plugInREgistry.get(name) != null) {
            return CvPlugInManager.plugInREgistry.get((Object)name).description;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIconFromPlugin(String name) {
        PluginDescriptor descriptor = plugInREgistry.get(name);
        if (descriptor == null) {
            return null;
        }
        InputStream inStream = null;
        String jarFilePath = descriptor.pluginJarFilePlath;
        File pluginjar = null;
        String iconpath = null;
        try {
            pluginjar = new File(jarFilePath);
            iconpath = descriptor.iconPath;
            if (iconpath == null) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try (JarFile jar = new JarFile(pluginjar);){
            ZipEntry zipEntry = jar.getEntry(iconpath);
            if (zipEntry != null) {
                ImageIcon imgIcon;
                byte[] allByte = new byte[(int)zipEntry.getSize()];
                inStream = jar.getInputStream(zipEntry);
                inStream.read(allByte);
                ImageIcon imageIcon = imgIcon = new ImageIcon(allByte);
                return imageIcon;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public CvPlugin getPluginInstance(String name) {
        boolean isloadPlugins = CvUtils.isPluginLoad();
        if (isloadPlugins) {
            CvPlugin objPlug = cachedPlugIn.get(name);
            if (objPlug == null) {
                long start = System.currentTimeMillis();
                PluginDescriptor descriptor = plugInREgistry.get(name);
                if (descriptor == null) {
                    return null;
                }
                String jarFilePath = descriptor.pluginJarFilePlath;
                if (jarFilePath == null) {
                    return null;
                }
                File jarFile = new File(jarFilePath);
                if (CvPlugInsBuilder.validateCvPluginSignature(jarFile)) {
                    Object obj;
                    CvPlugInsBuilder.loadJarToClassPath(jarFile);
                    String dependency = descriptor.dependency;
                    if (dependency != null && !dependency.equals("")) {
                        String[] alldependency = dependency.split(",");
                        for (int i = 0; i < alldependency.length; ++i) {
                            File dependencyFile = new File(alldependency[i]);
                            if (dependencyFile.exists()) {
                                CvPlugInsBuilder.loadJarToClassPath(new File(alldependency[i]));
                                continue;
                            }
                            CvPlugInsBuilder.loadJarToClassPath(new File(plugInDirectory + File.separator + alldependency[i]));
                        }
                    }
                    if ((obj = CvUtils.createInstance(descriptor.classname)) instanceof CvPlugin) {
                        CvPlugin plugInObj = (CvPlugin)obj;
                        cachedPlugIn.put(name, plugInObj);
                        plugInObj.loadPlugin();
                        System.out.println("CvPlugInManager.getPluginInstance() time to create plugin  =  " + (System.currentTimeMillis() - start));
                        return plugInObj;
                    }
                }
            }
            return objPlug;
        }
        return null;
    }

    public void removePlugin(CvPlugin toRemove) {
        toRemove.unloadPlugin();
        if (cachedPlugIn.containsValue(toRemove)) {
            for (String elem : cachedPlugIn.keySet()) {
                if (!cachedPlugIn.get(elem).equals(toRemove)) continue;
                cachedPlugIn.remove(elem);
                break;
            }
        }
    }

    public void removeAllPlugins() {
        Iterator<String> keys = cachedPlugIn.keySet().iterator();
        while (keys.hasNext()) {
            CvPlugin plugin = cachedPlugIn.get(keys.next());
            plugin.unloadPlugin();
        }
        cachedPlugIn.clear();
    }

    private class PluginDescriptor {
        public String iconPath = "";
        public String description = "";
        public String pluginJarFilePlath = "";
        public String name = "";
        public String[] extensions = null;
        public String dependency = "";
        public String classname = "";
        public String i18Nname = "";

        private PluginDescriptor() {
        }
    }
}

