/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.model;

import com.ge.med.idc.FramePositioningCapable;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class XpRangeModel {
    JSpinner startRange = null;
    JSpinner endRange = null;
    MinRangeModel minModel = new MinRangeModel();
    MaxRangeModel maxModel = new MaxRangeModel();

    public SpinnerNumberModel getMinRangeSpinnerModel(FramePositioningCapable frCap) {
        this.minModel.setMinMax(1, frCap.getNumFrames());
        this.minModel.setValue(new Integer(1));
        return this.minModel;
    }

    public SpinnerNumberModel getMaxRangeSpinnerModel(FramePositioningCapable frCap) {
        this.maxModel.setMinMax(1, frCap.getNumFrames());
        this.maxModel.setValue(new Integer(frCap.getNumFrames()));
        return this.maxModel;
    }

    private class MaxRangeModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = 1L;
        int minimum;
        int maximum;

        MaxRangeModel() {
            this.setValue(new Integer(1));
        }

        public void setMinMax(int min, int max) {
            this.minimum = min;
            this.maximum = max;
            this.setMaximum(new Integer(max));
            this.setMinimum(new Integer(min));
        }

        @Override
        public Object getPreviousValue() {
            Object pre = super.getPreviousValue();
            if (pre == null) {
                return pre;
            }
            int previous = Integer.parseInt(pre.toString());
            int valFromlowerRamge = Integer.parseInt(XpRangeModel.this.minModel.getValue().toString());
            if (previous < this.minimum || previous < valFromlowerRamge) {
                return null;
            }
            return super.getPreviousValue();
        }
    }

    private class MinRangeModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = 1L;
        int minimum;
        int maximum;

        public MinRangeModel() {
            this.setValue(new Integer(1));
        }

        public void setMinMax(int min, int max) {
            this.minimum = min;
            this.maximum = max;
            this.setMaximum(new Integer(max));
            this.setMinimum(new Integer(min));
        }

        @Override
        public Object getNextValue() {
            Object next = super.getNextValue();
            if (next == null) {
                return null;
            }
            int nxt = Integer.parseInt(next.toString());
            int valFromUperRamge = Integer.parseInt(XpRangeModel.this.maxModel.getValue().toString());
            if (nxt > XpRangeModel.this.maxModel.maximum || nxt > valFromUperRamge) {
                return null;
            }
            return super.getNextValue();
        }

        @Override
        public Object getPreviousValue() {
            Object prev = super.getPreviousValue();
            if (prev == null) {
                return null;
            }
            int previous = Integer.parseInt(prev.toString());
            if (previous < 1) {
                return null;
            }
            return super.getPreviousValue();
        }
    }
}

